/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.Constant;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.NarrowableArithmeticNode;
import org.graalvm.compiler.nodes.calc.NotNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(shortName="|")
public final class OrNode
extends BinaryArithmeticNode<ArithmeticOpTable.BinaryOp.Or>
implements Canonicalizable.BinaryCommutative<ValueNode>,
NarrowableArithmeticNode {
    public static final NodeClass<OrNode> TYPE = NodeClass.create(OrNode.class);

    public OrNode(ValueNode x, ValueNode y) {
        super(TYPE, OrNode.getArithmeticOpTable(x).getOr(), x, y);
    }

    private OrNode(ValueNode x, ValueNode y, Stamp forcedStamp) {
        super(TYPE, forcedStamp, x, y);
    }

    public static ValueNode createForSnippet(ValueNode x, ValueNode y, Stamp forcedStamp) {
        return new OrNode(x, y, forcedStamp);
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Or> op = ArithmeticOpTable.forStamp(x.stamp(view)).getOr();
        ConstantNode tryConstantFold = OrNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return OrNode.canonical(null, op, x, y, view);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Or> getOp(ArithmeticOpTable table) {
        return table.getOr();
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        ValueNode ret = super.canonical(tool, forX, forY);
        if (ret != this) {
            return ret;
        }
        return OrNode.canonical(this, this.getOp(forX, forY), forX, forY, view);
    }

    private static ValueNode canonical(OrNode self, ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Or> op, ValueNode forX, ValueNode forY, NodeView view) {
        if (GraphUtil.unproxify(forX) == GraphUtil.unproxify(forY)) {
            return forX;
        }
        if (forX.isConstant() && !forY.isConstant()) {
            return new OrNode(forY, forX);
        }
        Stamp rawXStamp = forX.stamp(view);
        Stamp rawYStamp = forY.stamp(view);
        if (rawXStamp instanceof IntegerStamp && rawYStamp instanceof IntegerStamp) {
            IntegerStamp xStamp = (IntegerStamp)rawXStamp;
            IntegerStamp yStamp = (IntegerStamp)rawYStamp;
            if (((xStamp.downMask() ^ 0xFFFFFFFFFFFFFFFFL) & yStamp.upMask()) == 0L) {
                return forX;
            }
            if (((yStamp.downMask() ^ 0xFFFFFFFFFFFFFFFFL) & xStamp.upMask()) == 0L) {
                return forY;
            }
        }
        if (forY.isConstant()) {
            Constant c = forY.asConstant();
            if (op.isNeutral(c)) {
                return forX;
            }
            return OrNode.reassociateMatchedValues(self != null ? self : (OrNode)new OrNode(forX, forY).maybeCommuteInputs(), ValueNode.isConstantPredicate(), forX, forY, view);
        }
        if (forX instanceof NotNode && forY instanceof NotNode) {
            return new NotNode(AndNode.create(((NotNode)forX).getValue(), ((NotNode)forY).getValue(), view));
        }
        return self != null ? self : new OrNode(forX, forY).maybeCommuteInputs();
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitOr(nodeValueMap.operand(this.getX()), nodeValueMap.operand(this.getY())));
    }
}

