/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.code.CodeUtil;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1)
public final class NarrowNode
extends IntegerConvertNode<ArithmeticOpTable.IntegerConvertOp.Narrow, ArithmeticOpTable.IntegerConvertOp.ZeroExtend> {
    public static final NodeClass<NarrowNode> TYPE = NodeClass.create(NarrowNode.class);

    public NarrowNode(ValueNode input, int resultBits) {
        this(input, PrimitiveStamp.getBits(input.stamp(NodeView.DEFAULT)), resultBits);
        assert (0 < resultBits && resultBits <= PrimitiveStamp.getBits(input.stamp(NodeView.DEFAULT)));
    }

    public NarrowNode(ValueNode input, int inputBits, int resultBits) {
        super(TYPE, BinaryArithmeticNode.getArithmeticOpTable(input).getNarrow(), inputBits, resultBits, input);
    }

    public static ValueNode create(ValueNode input, int resultBits, NodeView view) {
        return NarrowNode.create(input, PrimitiveStamp.getBits(input.stamp(view)), resultBits, view);
    }

    public static ValueNode create(ValueNode input, int inputBits, int resultBits, NodeView view) {
        ArithmeticOpTable.IntegerConvertOp<ArithmeticOpTable.IntegerConvertOp.Narrow> signExtend = ArithmeticOpTable.forStamp(input.stamp(view)).getNarrow();
        ValueNode synonym = NarrowNode.findSynonym(signExtend, input, inputBits, resultBits, signExtend.foldStamp(inputBits, resultBits, input.stamp(view)));
        if (synonym != null) {
            return synonym;
        }
        return new NarrowNode(input, inputBits, resultBits);
    }

    @Override
    protected ArithmeticOpTable.IntegerConvertOp<ArithmeticOpTable.IntegerConvertOp.Narrow> getOp(ArithmeticOpTable table) {
        return table.getNarrow();
    }

    @Override
    protected ArithmeticOpTable.IntegerConvertOp<ArithmeticOpTable.IntegerConvertOp.ZeroExtend> getReverseOp(ArithmeticOpTable table) {
        return table.getZeroExtend();
    }

    @Override
    public boolean isLossless() {
        return NarrowNode.checkLossless(this.getResultBits(), this.getValue());
    }

    public static boolean checkLossless(int bits, ValueNode value) {
        Stamp valueStamp = value.stamp(NodeView.DEFAULT);
        if (bits > 0 && valueStamp instanceof IntegerStamp) {
            long valueUpMask;
            IntegerStamp integerStamp = (IntegerStamp)valueStamp;
            long bitsRangeMin = CodeUtil.minValue((int)bits);
            long bitsRangeMax = CodeUtil.maxValue((int)bits);
            if (bitsRangeMin <= integerStamp.lowerBound() && integerStamp.upperBound() <= bitsRangeMax) {
                return true;
            }
            if (integerStamp.isPositive() && ((valueUpMask = integerStamp.upMask()) & CodeUtil.mask((int)bits)) == valueUpMask) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean preservesOrder(CanonicalCondition cond) {
        switch (cond) {
            case LT: {
                return NarrowNode.checkLossless(this.getResultBits() - 1, this.getValue());
            }
        }
        return NarrowNode.checkLossless(this.getResultBits(), this.getValue());
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        NodeView view = NodeView.from(tool);
        ValueNode ret = super.canonical(tool, forValue);
        if (ret != this) {
            return ret;
        }
        if (forValue instanceof NarrowNode) {
            NarrowNode other = (NarrowNode)forValue;
            return new NarrowNode(other.getValue(), other.getInputBits(), this.getResultBits());
        }
        if (forValue instanceof IntegerConvertNode) {
            IntegerConvertNode other = (IntegerConvertNode)forValue;
            if (other.getValue().hasExactlyOneUsage() && other.hasMoreThanOneUsage()) {
                return this;
            }
            if (this.getResultBits() == other.getInputBits()) {
                return other.getValue();
            }
            if (this.getResultBits() < other.getInputBits()) {
                return new NarrowNode(other.getValue(), other.getInputBits(), this.getResultBits());
            }
            if (other instanceof SignExtendNode) {
                return SignExtendNode.create(other.getValue(), other.getInputBits(), this.getResultBits(), view);
            }
            if (other instanceof ZeroExtendNode) {
                return new ZeroExtendNode(other.getValue(), other.getInputBits(), this.getResultBits(), ((ZeroExtendNode)other).isInputAlwaysPositive());
            }
        } else if (forValue instanceof AndNode) {
            AndNode andNode = (AndNode)forValue;
            IntegerStamp yStamp = (IntegerStamp)andNode.getY().stamp(view);
            IntegerStamp xStamp = (IntegerStamp)andNode.getX().stamp(view);
            long relevantMask = CodeUtil.mask((int)this.getResultBits());
            if ((relevantMask & yStamp.downMask()) == relevantMask) {
                return NarrowNode.create(andNode.getX(), this.getResultBits(), view);
            }
            if ((relevantMask & xStamp.downMask()) == relevantMask) {
                return NarrowNode.create(andNode.getY(), this.getResultBits(), view);
            }
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool nodeValueMap, ArithmeticLIRGeneratorTool gen) {
        nodeValueMap.setResult(this, gen.emitNarrow(nodeValueMap.operand(this.getValue()), this.getResultBits()));
    }

    @Override
    public boolean mayNullCheckSkipConversion() {
        return false;
    }
}

