/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.MinMaxNode;

@NodeInfo(shortName="MIN")
public class MinNode
extends MinMaxNode<ArithmeticOpTable.BinaryOp.Min> {
    public static final NodeClass<MinNode> TYPE = NodeClass.create(MinNode.class);

    protected MinNode(ValueNode x, ValueNode y) {
        super(TYPE, MinNode.getArithmeticOpTable(x).getMin(), x, y);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Min> getOp(ArithmeticOpTable table) {
        return table.getMin();
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Min> op = ArithmeticOpTable.forStamp(x.stamp(view)).getMin();
        Stamp stamp = op.foldStamp(x.stamp(view), y.stamp(view));
        assert (stamp instanceof FloatStamp);
        ConstantNode tryConstantFold = MinNode.tryConstantFold(op, x, y, stamp, view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return new MinNode(x, y).maybeCommuteInputs();
    }
}

