/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PrimitiveConstant;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.type.FloatStamp;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AbstractNormalizeCompareNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.FloatLessThanNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLowerThanNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.options.OptionValues;

@NodeInfo(shortName="<")
public final class IntegerLessThanNode
extends IntegerLowerThanNode {
    public static final NodeClass<IntegerLessThanNode> TYPE = NodeClass.create(IntegerLessThanNode.class);
    private static final LessThanOp OP = new LessThanOp();

    public IntegerLessThanNode(ValueNode x, ValueNode y) {
        super(TYPE, x, y, OP);
        assert (!x.getStackKind().isNumericFloat() && x.getStackKind() != JavaKind.Object);
        assert (!y.getStackKind().isNumericFloat() && y.getStackKind() != JavaKind.Object);
    }

    public static LogicNode create(ValueNode x, ValueNode y, NodeView view) {
        return OP.create(x, y, view);
    }

    public static LogicNode create(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, ValueNode x, ValueNode y, NodeView view) {
        LogicNode value = OP.canonical(constantReflection, metaAccess, options, smallestCompareWidth, OP.getCondition(), false, x, y, view);
        if (value != null) {
            return value;
        }
        return IntegerLessThanNode.create(x, y, view);
    }

    @Override
    public Node canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        NodeView view = NodeView.from(tool);
        LogicNode value = OP.canonical(tool.getConstantReflection(), tool.getMetaAccess(), tool.getOptions(), tool.smallestCompareWidth(), OP.getCondition(), false, forX, forY, view);
        if (value != null) {
            return value;
        }
        return this;
    }

    public static boolean subtractMayUnderflow(long x, long y, long minValue) {
        long r = x - y;
        return ((x ^ y) & (x ^ r)) < 0L || r <= minValue;
    }

    public static boolean subtractMayOverflow(long x, long y, long maxValue) {
        long r = x - y;
        return ((x ^ y) & (x ^ r)) < 0L || r > maxValue;
    }

    @Override
    public TriState implies(boolean thisNegated, LogicNode other) {
        if (!thisNegated) {
            ValueNode otherY;
            ValueNode otherX;
            if (other instanceof IntegerLessThanNode) {
                otherX = ((IntegerLessThanNode)other).getX();
                otherY = ((IntegerLessThanNode)other).getY();
                if (this.getX() == otherY && this.getY() == otherX) {
                    return TriState.FALSE;
                }
            }
            if (other instanceof IntegerEqualsNode) {
                otherX = ((IntegerEqualsNode)other).getX();
                otherY = ((IntegerEqualsNode)other).getY();
                if (this.getX() == otherX && this.getY() == otherY || this.getX() == otherY && this.getY() == otherX) {
                    return TriState.FALSE;
                }
            }
        }
        return super.implies(thisNegated, other);
    }

    public static class LessThanOp
    extends IntegerLowerThanNode.LowerOp {
        @Override
        protected CompareNode duplicateModified(ValueNode newX, ValueNode newY, boolean unorderedIsTrue, NodeView view) {
            if (newX.stamp(view) instanceof FloatStamp && newY.stamp(view) instanceof FloatStamp) {
                return new FloatLessThanNode(newX, newY, unorderedIsTrue);
            }
            if (newX.stamp(view) instanceof IntegerStamp && newY.stamp(view) instanceof IntegerStamp) {
                return new IntegerLessThanNode(newX, newY);
            }
            throw GraalError.shouldNotReachHere();
        }

        @Override
        protected LogicNode optimizeNormalizeCompare(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, Constant constant, AbstractNormalizeCompareNode normalizeNode, boolean mirrored, NodeView view) {
            long cst;
            PrimitiveConstant primitive = (PrimitiveConstant)constant;
            long l = cst = mirrored ? -primitive.asLong() : primitive.asLong();
            if (cst == 0L) {
                return normalizeNode.createLowerComparison(mirrored, constantReflection, metaAccess, options, smallestCompareWidth, view);
            }
            if (cst == 1L) {
                LogicNode compare = normalizeNode.createLowerComparison(!mirrored, constantReflection, metaAccess, options, smallestCompareWidth, view);
                return LogicNegationNode.create(compare);
            }
            if (cst <= -1L) {
                return LogicConstantNode.contradiction();
            }
            assert (cst >= 2L);
            return LogicConstantNode.tautology();
        }

        @Override
        protected LogicNode findSynonym(ValueNode forX, ValueNode forY, NodeView view) {
            LogicNode result = super.findSynonym(forX, forY, view);
            if (result != null) {
                return result;
            }
            if (forX.stamp(view) instanceof IntegerStamp && forY.stamp(view) instanceof IntegerStamp && IntegerStamp.sameSign((IntegerStamp)forX.stamp(view), (IntegerStamp)forY.stamp(view))) {
                return new IntegerBelowNode(forX, forY);
            }
            if (forY.isConstant()) {
                IntegerStamp xStamp;
                AddNode addNode;
                if (forX instanceof SubNode) {
                    SubNode sub = (SubNode)forX;
                    ValueNode xx = null;
                    ValueNode yy = null;
                    boolean negate = false;
                    if (forY.asConstant().isDefaultForKind()) {
                        xx = sub.getX();
                        yy = sub.getY();
                    } else if (forY.isJavaConstant() && forY.asJavaConstant().asLong() == 1L) {
                        xx = sub.getY();
                        yy = sub.getX();
                        negate = true;
                    }
                    if (xx != null) {
                        assert (yy != null);
                        IntegerStamp xStamp2 = (IntegerStamp)sub.getX().stamp(view);
                        IntegerStamp yStamp = (IntegerStamp)sub.getY().stamp(view);
                        long minValue = CodeUtil.minValue((int)xStamp2.getBits());
                        long maxValue = CodeUtil.maxValue((int)xStamp2.getBits());
                        if (!IntegerLessThanNode.subtractMayUnderflow(xStamp2.lowerBound(), yStamp.upperBound(), minValue) && !IntegerLessThanNode.subtractMayOverflow(xStamp2.upperBound(), yStamp.lowerBound(), maxValue)) {
                            LogicNode logic = new IntegerLessThanNode(xx, yy);
                            if (negate) {
                                logic = LogicNegationNode.create(logic);
                            }
                            return logic;
                        }
                    }
                } else if (forX instanceof AddNode && (addNode = (AddNode)forX).getY().isJavaConstant() && !IntegerStamp.addCanOverflow(xStamp = (IntegerStamp)addNode.getX().stamp(view), (IntegerStamp)addNode.getY().stamp(view))) {
                    long xConstant;
                    long minValue = CodeUtil.minValue((int)xStamp.getBits());
                    long maxValue = CodeUtil.maxValue((int)xStamp.getBits());
                    long yConstant = forY.asJavaConstant().asLong();
                    if (!IntegerLessThanNode.subtractMayUnderflow(yConstant, xConstant = addNode.getY().asJavaConstant().asLong(), minValue) && !IntegerLessThanNode.subtractMayOverflow(yConstant, xConstant, maxValue)) {
                        long newConstant = yConstant - xConstant;
                        return IntegerLessThanNode.create(addNode.getX(), ConstantNode.forIntegerStamp(xStamp, newConstant), view);
                    }
                }
            }
            if (forX.stamp(view) instanceof IntegerStamp) {
                assert (forY.stamp(view) instanceof IntegerStamp);
                int bits = ((IntegerStamp)forX.stamp(view)).getBits();
                assert (((IntegerStamp)forY.stamp(view)).getBits() == bits);
                LogicNode logic = LessThanOp.canonicalizeRangeFlip(forX, forY, bits, true, view);
                if (logic != null) {
                    return logic;
                }
            }
            return null;
        }

        @Override
        protected CanonicalCondition getCondition() {
            return CanonicalCondition.LT;
        }

        @Override
        protected IntegerLowerThanNode createNode(ValueNode x, ValueNode y) {
            return new IntegerLessThanNode(x, y);
        }

        @Override
        protected long upperBound(IntegerStamp stamp) {
            return stamp.upperBound();
        }

        @Override
        protected long lowerBound(IntegerStamp stamp) {
            return stamp.lowerBound();
        }

        @Override
        protected int compare(long a, long b) {
            return Long.compare(a, b);
        }

        @Override
        protected long min(long a, long b) {
            return Math.min(a, b);
        }

        @Override
        protected long max(long a, long b) {
            return Math.max(a, b);
        }

        @Override
        protected long cast(long a, int bits) {
            return CodeUtil.signExtend((long)a, (int)bits);
        }

        @Override
        protected long minValue(int bits) {
            return NumUtil.minValue(bits);
        }

        @Override
        protected long maxValue(int bits) {
            return NumUtil.maxValue(bits);
        }

        @Override
        protected IntegerStamp forInteger(int bits, long min, long max) {
            return StampFactory.forInteger(bits, this.cast(min, bits), this.cast(max, bits));
        }
    }
}

