/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.PrimitiveStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ArithmeticOperation;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.BinaryArithmeticNode;
import org.graalvm.compiler.nodes.calc.ConvertNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.UnaryNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.spi.ArithmeticLIRLowerable;
import org.graalvm.compiler.nodes.spi.StampInverter;

@NodeInfo
public abstract class IntegerConvertNode<OP, REV>
extends UnaryNode
implements ArithmeticOperation,
ConvertNode,
ArithmeticLIRLowerable,
StampInverter {
    public static final NodeClass<IntegerConvertNode> TYPE = NodeClass.create(IntegerConvertNode.class);
    protected final int inputBits;
    protected final int resultBits;

    protected IntegerConvertNode(NodeClass<? extends IntegerConvertNode<OP, REV>> c, ArithmeticOpTable.IntegerConvertOp<OP> opForStampComputation, int inputBits, int resultBits, ValueNode input) {
        super(c, opForStampComputation.foldStamp(inputBits, resultBits, input.stamp(NodeView.DEFAULT)), input);
        this.inputBits = inputBits;
        this.resultBits = resultBits;
        assert (PrimitiveStamp.getBits(input.stamp(NodeView.DEFAULT)) == 0 || PrimitiveStamp.getBits(input.stamp(NodeView.DEFAULT)) == inputBits);
    }

    public int getInputBits() {
        return this.inputBits;
    }

    public int getResultBits() {
        return this.resultBits;
    }

    protected abstract ArithmeticOpTable.IntegerConvertOp<OP> getOp(ArithmeticOpTable var1);

    protected abstract ArithmeticOpTable.IntegerConvertOp<REV> getReverseOp(ArithmeticOpTable var1);

    @Override
    public final ArithmeticOpTable.IntegerConvertOp<OP> getArithmeticOp() {
        return this.getOp(BinaryArithmeticNode.getArithmeticOpTable(this.getValue()));
    }

    @Override
    public Constant convert(Constant c, ConstantReflectionProvider constantReflection) {
        return ((ArithmeticOpTable.IntegerConvertOp)this.getArithmeticOp()).foldConstant(this.getInputBits(), this.getResultBits(), c);
    }

    @Override
    public Constant reverse(Constant c, ConstantReflectionProvider constantReflection) {
        ArithmeticOpTable.IntegerConvertOp<REV> reverse = this.getReverseOp(ArithmeticOpTable.forStamp(this.stamp(NodeView.DEFAULT)));
        return reverse.foldConstant(this.getResultBits(), this.getInputBits(), c);
    }

    @Override
    public Stamp foldStamp(Stamp newStamp) {
        assert (newStamp.isCompatible(this.getValue().stamp(NodeView.DEFAULT)));
        return ((ArithmeticOpTable.IntegerConvertOp)this.getArithmeticOp()).foldStamp(this.inputBits, this.resultBits, newStamp);
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forValue) {
        ValueNode synonym = IntegerConvertNode.findSynonym(this.getOp(BinaryArithmeticNode.getArithmeticOpTable(forValue)), forValue, this.inputBits, this.resultBits, this.stamp(NodeView.DEFAULT));
        if (synonym != null) {
            return synonym;
        }
        return this;
    }

    protected static <T> ValueNode findSynonym(ArithmeticOpTable.IntegerConvertOp<T> operation, ValueNode value, int inputBits, int resultBits, Stamp stamp) {
        if (inputBits == resultBits) {
            return value;
        }
        if (value.isConstant()) {
            return ConstantNode.forPrimitive(stamp, operation.foldConstant(inputBits, resultBits, value.asConstant()));
        }
        return null;
    }

    public static ValueNode convert(ValueNode input, Stamp stamp, NodeView view) {
        return IntegerConvertNode.convert(input, stamp, false, view);
    }

    public static ValueNode convert(ValueNode input, Stamp stamp, StructuredGraph graph, NodeView view) {
        ValueNode convert = IntegerConvertNode.convert(input, stamp, false, view);
        if (!convert.isAlive()) {
            assert (!convert.isDeleted());
            convert = graph.addOrUniqueWithInputs(convert);
        }
        return convert;
    }

    public static ValueNode convertUnsigned(ValueNode input, Stamp stamp, NodeView view) {
        return IntegerConvertNode.convert(input, stamp, true, view);
    }

    public static ValueNode convertUnsigned(ValueNode input, Stamp stamp, StructuredGraph graph, NodeView view) {
        ValueNode convert = IntegerConvertNode.convert(input, stamp, true, view);
        if (!convert.isAlive()) {
            assert (!convert.isDeleted());
            convert = graph.addOrUniqueWithInputs(convert);
        }
        return convert;
    }

    public static ValueNode convert(ValueNode input, Stamp stamp, boolean zeroExtend, NodeView view) {
        IntegerStamp fromStamp = (IntegerStamp)input.stamp(view);
        IntegerStamp toStamp = (IntegerStamp)stamp;
        ValueNode result = toStamp.getBits() == fromStamp.getBits() ? input : (toStamp.getBits() < fromStamp.getBits() ? new NarrowNode(input, fromStamp.getBits(), toStamp.getBits()) : (zeroExtend ? ZeroExtendNode.create(input, toStamp.getBits(), view) : SignExtendNode.create(input, toStamp.getBits(), view)));
        IntegerStamp resultStamp = (IntegerStamp)result.stamp(view);
        assert (toStamp.getBits() == resultStamp.getBits());
        return result;
    }

    @Override
    public Stamp invertStamp(Stamp outStamp) {
        return ((ArithmeticOpTable.IntegerConvertOp)this.getArithmeticOp()).invertStamp(this.inputBits, this.resultBits, outStamp);
    }
}

