/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.List;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.meta.Assumptions;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.graph.Edges;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.GraphDecoder;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.KillingBeginNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.MultiKillingBeginNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.IntegerSwitchNode;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.CoreProvidersDelegate;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;

public class SimplifyingGraphDecoder
extends GraphDecoder {
    private static final TimerKey CanonicalizeFixedNode = DebugContext.timer("PartialEvaluation-CanonicalizeFixedNode").doc("Time spent in simplifying fixed nodes.");
    protected final CoreProviders providers;
    protected final boolean canonicalizeReads;
    protected final CanonicalizerTool canonicalizerTool;

    public SimplifyingGraphDecoder(Architecture architecture, StructuredGraph graph, CoreProviders providers, boolean canonicalizeReads) {
        super(architecture, graph);
        this.providers = providers;
        this.canonicalizeReads = canonicalizeReads;
        this.canonicalizerTool = new PECanonicalizerTool(graph.getAssumptions(), graph.getOptions());
    }

    @Override
    protected void cleanupGraph(GraphDecoder.MethodScope methodScope) {
        GraphUtil.normalizeLoops(this.graph);
        super.cleanupGraph(methodScope);
        for (Node node : this.graph.getNewNodes(methodScope.methodStartMark)) {
            if (node instanceof MergeNode) {
                MergeNode mergeNode = (MergeNode)node;
                if (mergeNode.forwardEndCount() != 1) continue;
                this.graph.reduceTrivialMerge(mergeNode);
                continue;
            }
            if (!(node instanceof BeginNode) && !(node instanceof KillingBeginNode) && !(node instanceof MultiKillingBeginNode) || node.predecessor() instanceof ControlSplitNode || !node.hasNoUsages()) continue;
            GraphUtil.unlinkFixedNode((AbstractBeginNode)node);
            node.safeDelete();
        }
        for (Node node : this.graph.getNewNodes(methodScope.methodStartMark)) {
            GraphUtil.tryKillUnused(node);
        }
    }

    @Override
    protected boolean allowLazyPhis() {
        return true;
    }

    @Override
    protected void handleMergeNode(MergeNode merge) {
        for (ValuePhiNode phi : merge.valuePhis()) {
            phi.inferStamp();
        }
    }

    @Override
    protected void handleFixedNode(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, int nodeOrderId, FixedNode node) {
        try (DebugCloseable a = CanonicalizeFixedNode.start(this.debug);){
            Node canonical = this.canonicalizeFixedNode(methodScope, node);
            if (canonical != node) {
                this.handleCanonicalization(loopScope, nodeOrderId, node, canonical);
            }
        }
    }

    protected Node canonicalizeFixedNode(GraphDecoder.MethodScope methodScope, Node node) {
        if (node instanceof LoadFieldNode) {
            LoadFieldNode loadFieldNode = (LoadFieldNode)node;
            return loadFieldNode.canonical(this.canonicalizerTool);
        }
        if (node instanceof FixedGuardNode) {
            FixedGuardNode guard = (FixedGuardNode)node;
            if (guard.getCondition() instanceof LogicConstantNode) {
                LogicConstantNode condition = (LogicConstantNode)guard.getCondition();
                if (condition.getValue() == guard.isNegated()) {
                    DeoptimizeNode deopt = new DeoptimizeNode(guard.getAction(), guard.getReason(), guard.getSpeculation());
                    if (guard.stateBefore() != null) {
                        deopt.setStateBefore(guard.stateBefore());
                    }
                    return deopt;
                }
                return null;
            }
            return node;
        }
        if (node instanceof IfNode) {
            IfNode ifNode = (IfNode)node;
            if (ifNode.condition() instanceof LogicNegationNode) {
                ifNode.eliminateNegation();
            }
            return ifNode;
        }
        if (node instanceof LoadIndexedNode) {
            LoadIndexedNode loadIndexedNode = (LoadIndexedNode)node;
            return loadIndexedNode.canonical(this.canonicalizerTool);
        }
        if (node instanceof ArrayLengthNode) {
            ArrayLengthNode arrayLengthNode = (ArrayLengthNode)node;
            return arrayLengthNode.canonical(this.canonicalizerTool);
        }
        if (node instanceof Canonicalizable) {
            return ((Canonicalizable)((Object)node)).canonical(this.canonicalizerTool);
        }
        return node;
    }

    @Override
    protected boolean earlyCanonicalization(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, int nodeOrderId, FixedNode node) {
        if (node instanceof IfNode && ((IfNode)node).condition() instanceof LogicConstantNode) {
            int survivingIndex;
            IfNode ifNode = (IfNode)node;
            assert (!(ifNode.condition() instanceof LogicNegationNode)) : "Negation of a constant must have been canonicalized before";
            int n = survivingIndex = ((LogicConstantNode)ifNode.condition()).getValue() ? 0 : 1;
            if (Assertions.assertionsEnabled()) {
                Edges edges = ifNode.getNodeClass().getSuccessorEdges();
                assert (edges.getDirectCount() == 2) : "IfNode expected to have 2 direct successors";
                assert (edges.getName(0).equals("trueSuccessor")) : "Unexpected IfNode encoding";
                assert (edges.getName(1).equals("falseSuccessor")) : "Unexpected IfNode encoding";
                assert (edges.getCount() == 2) : "IntegerSwitchNode expected to have 0 indirect successor";
            }
            long successorsByteIndex = methodScope.reader.getByteIndex();
            methodScope.reader.setByteIndex(successorsByteIndex + (long)(survivingIndex * methodScope.orderIdWidth));
            int survivingOrderId = this.readOrderId(methodScope);
            methodScope.reader.setByteIndex(successorsByteIndex + (long)(2 * methodScope.orderIdWidth));
            AbstractBeginNode survivingSuccessor = (AbstractBeginNode)this.makeStubNode(methodScope, loopScope, survivingOrderId);
            this.graph.removeSplit(ifNode, survivingSuccessor);
            return true;
        }
        if (node instanceof IntegerSwitchNode && ((IntegerSwitchNode)node).value().isConstant()) {
            IntegerSwitchNode switchNode = (IntegerSwitchNode)node;
            int value = switchNode.value().asJavaConstant().asInt();
            int survivingIndex = switchNode.successorIndexAtKey(value);
            if (Assertions.assertionsEnabled()) {
                Edges edges = switchNode.getNodeClass().getSuccessorEdges();
                assert (edges.getDirectCount() == 0) : "IntegerSwitchNode expected to have 0 direct successor";
                assert (edges.getCount() == 1) : "IntegerSwitchNode expected to have 1 indirect successor";
                assert (edges.getName(0).equals("successors")) : "Unexpected IntegerSwitchNode encoding";
            }
            int size = methodScope.reader.getSVInt();
            long successorsByteIndex = methodScope.reader.getByteIndex();
            methodScope.reader.setByteIndex(successorsByteIndex + (long)(survivingIndex * methodScope.orderIdWidth));
            int survivingOrderId = this.readOrderId(methodScope);
            methodScope.reader.setByteIndex(successorsByteIndex + (long)(size * methodScope.orderIdWidth));
            AbstractBeginNode survivingSuccessor = (AbstractBeginNode)this.makeStubNode(methodScope, loopScope, survivingOrderId);
            this.graph.removeSplit(switchNode, survivingSuccessor);
            return true;
        }
        return false;
    }

    private static Node canonicalizeFixedNodeToNull(FixedNode node) {
        return new CanonicalizeToNullNode(node.stamp);
    }

    private void handleCanonicalization(GraphDecoder.LoopScope loopScope, int nodeOrderId, FixedNode node, Node c) {
        assert (c != node) : "unnecessary call";
        try (DebugCloseable position = this.graph.withNodeSourcePosition(node);){
            Node canonical;
            Node node2 = canonical = c == null ? SimplifyingGraphDecoder.canonicalizeFixedNodeToNull(node) : c;
            if (!canonical.isAlive()) {
                assert (!canonical.isDeleted());
                if ((canonical = this.graph.addOrUniqueWithInputs(canonical)) instanceof FixedWithNextNode) {
                    this.graph.addBeforeFixed(node, (FixedWithNextNode)canonical);
                } else if (canonical instanceof ControlSinkNode) {
                    FixedWithNextNode predecessor = (FixedWithNextNode)node.predecessor();
                    predecessor.setNext((ControlSinkNode)canonical);
                    List<Node> successorSnapshot = node.successors().snapshot();
                    node.safeDelete();
                    for (Node successor : successorSnapshot) {
                        successor.safeDelete();
                    }
                } else assert (!(canonical instanceof FixedNode));
            }
            if (!node.isDeleted()) {
                GraphUtil.unlinkFixedNode((FixedWithNextNode)node);
                node.replaceAtUsagesAndDelete(canonical);
            }
            assert (this.lookupNode(loopScope, nodeOrderId) == node);
            this.registerNode(loopScope, nodeOrderId, canonical, true, false);
        }
    }

    @Override
    protected Node handleFloatingNodeBeforeAdd(GraphDecoder.MethodScope methodScope, GraphDecoder.LoopScope loopScope, Node node) {
        if (node instanceof ValueNode) {
            ((ValueNode)node).inferStamp();
        }
        if (node instanceof Canonicalizable) {
            try (DebugCloseable context = this.graph.withNodeSourcePosition(node);){
                Node canonical = ((Canonicalizable)((Object)node)).canonical(this.canonicalizerTool);
                if (canonical == null) {
                } else if (canonical != node) {
                    if (!canonical.isAlive()) {
                        assert (!canonical.isDeleted());
                        canonical = this.graph.addOrUniqueWithInputs(canonical);
                    }
                    assert (node.hasNoUsages());
                    Node node2 = canonical;
                    return node2;
                }
            }
        }
        return node;
    }

    @Override
    protected Node addFloatingNode(GraphDecoder.MethodScope methodScope, Node node) {
        return this.graph.addOrUnique(node);
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED, allowedUsageTypes={InputType.Guard, InputType.Anchor})
    static class CanonicalizeToNullNode
    extends FloatingNode
    implements Canonicalizable,
    GuardingNode,
    AnchoringNode {
        public static final NodeClass<CanonicalizeToNullNode> TYPE = NodeClass.create(CanonicalizeToNullNode.class);

        protected CanonicalizeToNullNode(Stamp stamp) {
            super((NodeClass<? extends FloatingNode>)TYPE, stamp);
        }

        @Override
        public Node canonical(CanonicalizerTool tool) {
            return null;
        }
    }

    protected class PECanonicalizerTool
    extends CoreProvidersDelegate
    implements CanonicalizerTool {
        private final Assumptions assumptions;
        private final OptionValues options;

        public PECanonicalizerTool(Assumptions assumptions, OptionValues options) {
            super(SimplifyingGraphDecoder.this.providers);
            this.assumptions = assumptions;
            this.options = options;
        }

        @Override
        public OptionValues getOptions() {
            return this.options;
        }

        @Override
        public boolean canonicalizeReads() {
            return SimplifyingGraphDecoder.this.canonicalizeReads;
        }

        @Override
        public boolean allUsagesAvailable() {
            return false;
        }

        @Override
        public Assumptions getAssumptions() {
            return this.assumptions;
        }

        @Override
        public Integer smallestCompareWidth() {
            return null;
        }

        @Override
        public boolean supportsRounding() {
            return this.getLowerer().supportsRounding();
        }
    }
}

