/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.MemoryMapNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_4, cyclesRationale="Restore frame + ret", sizeRationale="Restore frame + ret")
public final class ReturnNode
extends ControlSinkNode
implements LIRLowerable,
IterableNodeType {
    public static final NodeClass<ReturnNode> TYPE = NodeClass.create(ReturnNode.class);
    @Node.OptionalInput
    ValueNode result;
    @Node.OptionalInput(value=InputType.Extension)
    MemoryMapNode memoryMap;

    public ValueNode result() {
        return this.result;
    }

    public ReturnNode(ValueNode result) {
        this(result, null);
    }

    public ReturnNode(ValueNode result, MemoryMapNode memoryMap) {
        super((NodeClass<? extends ControlSinkNode>)TYPE, StampFactory.forVoid());
        this.result = result;
        this.memoryMap = memoryMap;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        assert (this.verifyReturn(gen.getLIRGeneratorTool().target()));
        if (this.result == null) {
            gen.getLIRGeneratorTool().emitReturn(JavaKind.Void, null);
        } else {
            gen.getLIRGeneratorTool().emitReturn(this.result.getStackKind(), gen.operand(this.result));
        }
    }

    public void setMemoryMap(MemoryMapNode memoryMap) {
        this.updateUsages(this.memoryMap, memoryMap);
        this.memoryMap = memoryMap;
    }

    public MemoryMapNode getMemoryMap() {
        return this.memoryMap;
    }

    private boolean verifyReturn(TargetDescription target) {
        if (this.graph().method() != null) {
            JavaKind actual = this.result == null ? JavaKind.Void : this.result.getStackKind();
            JavaKind expected = this.graph().method().getSignature().getReturnKind().getStackKind();
            if (actual == target.wordJavaKind && expected == JavaKind.Object) {
                return true;
            }
            assert (actual == expected) : "return kind doesn't match: actual " + actual + ", expected: " + expected;
        }
        return true;
    }
}

