/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.CanonicalizerTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_1)
public abstract class PhiNode
extends FloatingNode
implements Canonicalizable {
    public static final NodeClass<PhiNode> TYPE = NodeClass.create(PhiNode.class);
    @Node.Input(value=InputType.Association)
    protected AbstractMergeNode merge;

    protected PhiNode(NodeClass<? extends PhiNode> c, Stamp stamp, AbstractMergeNode merge) {
        super((NodeClass<? extends FloatingNode>)c, stamp);
        this.merge = merge;
    }

    public abstract NodeInputList<ValueNode> values();

    public AbstractMergeNode merge() {
        return this.merge;
    }

    public void setMerge(AbstractMergeNode x) {
        this.updateUsages(this.merge, x);
        this.merge = x;
    }

    @Override
    public boolean verify() {
        this.assertTrue(this.merge() != null, "missing merge", new Object[0]);
        this.assertTrue(this.merge().phiPredecessorCount() == this.valueCount(), "mismatch between merge predecessor count and phi value count: %d != %d", this.merge().phiPredecessorCount(), this.valueCount());
        return super.verify();
    }

    public ValueNode valueAt(int i) {
        return (ValueNode)this.values().get(i);
    }

    public void initializeValueAt(int i, ValueNode x) {
        while (this.values().size() <= i) {
            this.values().add((Object)null);
        }
        this.values().set(i, (Object)x);
    }

    public void setValueAt(int i, ValueNode x) {
        this.values().set(i, (Object)x);
    }

    public void setValueAt(AbstractEndNode end, ValueNode x) {
        this.setValueAt(this.merge().phiPredecessorIndex(end), x);
    }

    public ValueNode valueAt(AbstractEndNode pred) {
        return this.valueAt(this.merge().phiPredecessorIndex(pred));
    }

    public int valueCount() {
        return this.values().size();
    }

    public void clearValues() {
        this.values().clear();
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name) {
            StringBuilder str = new StringBuilder();
            for (int i = 0; i < this.valueCount(); ++i) {
                if (i != 0) {
                    str.append(' ');
                }
                str.append(this.valueAt(i) == null ? "-" : this.valueAt(i).toString(Verbosity.Id));
            }
            String description = this.valueDescription();
            if (description.length() > 0) {
                str.append(", ").append(description);
            }
            return super.toString(Verbosity.Name) + "(" + str + ")";
        }
        return super.toString(verbosity);
    }

    protected String valueDescription() {
        return "";
    }

    public void addInput(ValueNode x) {
        assert (!(x instanceof ValuePhiNode) || ((ValuePhiNode)x).merge() instanceof LoopBeginNode || ((ValuePhiNode)x).merge() != this.merge());
        assert (!(this instanceof ValuePhiNode) || x.stamp(NodeView.DEFAULT).isCompatible(this.stamp(NodeView.DEFAULT)));
        this.values().add((Object)x);
    }

    public void removeInput(int index) {
        this.values().remove(index);
    }

    public NodeIterable<ValueNode> backValues() {
        return this.values().subList(this.merge().forwardEndCount());
    }

    public ValueNode singleValueOrThis() {
        ValueNode singleValue = this.valueAt(0);
        int count = this.valueCount();
        for (int i = 1; i < count; ++i) {
            ValueNode value = this.valueAt(i);
            if (value == this || value == singleValue) continue;
            return this;
        }
        return singleValue;
    }

    public ValueNode singleBackValueOrThis() {
        int valueCount = this.valueCount();
        assert (this.merge() instanceof LoopBeginNode && valueCount >= 2);
        ValueNode singleValue = this.valueAt(1);
        for (int i = 2; i < valueCount; ++i) {
            ValueNode value = this.valueAt(i);
            if (value == singleValue) continue;
            return this;
        }
        return singleValue;
    }

    @Override
    public ValueNode canonical(CanonicalizerTool tool) {
        if (this.isLoopPhi()) {
            ValueNode value;
            int i;
            int valueCount = this.valueCount();
            assert (valueCount >= 2);
            for (i = 1; i < valueCount && (value = this.valueAt(i)) == this; ++i) {
            }
            if (i == valueCount) {
                return this.firstValue();
            }
            boolean onlySelfUsage = true;
            for (Node n : this.usages()) {
                if (n == this) continue;
                onlySelfUsage = false;
                break;
            }
            if (onlySelfUsage) {
                return null;
            }
        }
        return this.singleValueOrThis();
    }

    public ValueNode firstValue() {
        return this.valueAt(0);
    }

    public boolean isLoopPhi() {
        return this.merge() instanceof LoopBeginNode;
    }

    public boolean isDegenerated() {
        for (Node use : this.usages()) {
            if (use == this) continue;
            return false;
        }
        assert (this.isLoopPhi());
        return true;
    }

    public abstract PhiNode duplicateOn(AbstractMergeNode var1);
}

