/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop.phases;

import java.util.Iterator;
import java.util.List;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.loop.phases.LoopPhase;
import org.graalvm.compiler.loop.phases.LoopTransformations;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopPolicies;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.spi.CoreProviders;

public class LoopUnswitchingPhase
extends LoopPhase<LoopPolicies> {
    private static final CounterKey UNSWITCHED = DebugContext.counter("Unswitched");
    private static final CounterKey UNSWITCH_CANDIDATES = DebugContext.counter("UnswitchCandidates");
    private static final CounterKey UNSWITCH_EARLY_REJECTS = DebugContext.counter("UnswitchEarlyRejects");

    public LoopUnswitchingPhase(LoopPolicies policies) {
        super(policies);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        DebugContext debug = graph.getDebug();
        if (graph.hasLoops()) {
            boolean unswitched;
            block0: do {
                unswitched = false;
                LoopsData dataUnswitch = context.getLoopsDataProvider().getLoopsData(graph);
                for (LoopEx loop : dataUnswitch.outerFirst()) {
                    if (this.getPolicies().shouldTryUnswitch(loop)) {
                        List<ControlSplitNode> controlSplits = LoopTransformations.findUnswitchable(loop);
                        if (controlSplits == null) continue;
                        UNSWITCH_CANDIDATES.increment(debug);
                        if (!this.getPolicies().shouldUnswitch(loop, controlSplits)) continue;
                        if (debug.isLogEnabled()) {
                            LoopUnswitchingPhase.logUnswitch(loop, controlSplits);
                        }
                        LoopTransformations.unswitch(loop, controlSplits);
                        debug.dump(4, (Object)graph, "After unswitch %s", controlSplits);
                        UNSWITCHED.increment(debug);
                        unswitched = true;
                        continue block0;
                    }
                    UNSWITCH_EARLY_REJECTS.increment(debug);
                }
            } while (unswitched);
        }
    }

    private static void logUnswitch(LoopEx loop, List<ControlSplitNode> controlSplits) {
        StringBuilder sb = new StringBuilder("Unswitching ");
        sb.append(loop).append(" at ");
        for (ControlSplitNode controlSplit : controlSplits) {
            sb.append(controlSplit).append(" [");
            Iterator it = controlSplit.successors().iterator();
            while (it.hasNext()) {
                sb.append(controlSplit.probability((AbstractBeginNode)it.next()));
                if (!it.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("]");
        }
        loop.entryPoint().getDebug().log("%s", sb);
    }

    @Override
    public float codeSizeIncrease() {
        return 10.0f;
    }
}

