/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop.phases;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.RetryableBailoutException;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.graph.spi.Simplifiable;
import org.graalvm.compiler.graph.spi.SimplifierTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.extended.OpaqueNode;
import org.graalvm.compiler.nodes.extended.SwitchNode;
import org.graalvm.compiler.nodes.loop.CountedLoopInfo;
import org.graalvm.compiler.nodes.loop.DefaultLoopPolicies;
import org.graalvm.compiler.nodes.loop.InductionVariable;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopFragment;
import org.graalvm.compiler.nodes.loop.LoopFragmentInside;
import org.graalvm.compiler.nodes.loop.LoopFragmentWhole;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.nodes.util.IntegerHelper;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.phases.common.util.EconomicSetNodeEventListener;

public abstract class LoopTransformations {
    private LoopTransformations() {
    }

    public static void peel(LoopEx loop) {
        loop.detectCounted();
        loop.inside().duplicate().insertBefore(loop);
        if (loop.isCounted()) {
            loop.loopBegin().setLoopFrequency(loop.loopBegin().profileData().decrementFrequency(1.0));
        }
        loop.loopBegin().incrementPeelings();
    }

    public static void fullUnroll(LoopEx loop, CoreProviders context, CanonicalizerPhase canonicalizer) {
        LoopBeginNode loopBegin = loop.loopBegin();
        StructuredGraph graph = loopBegin.graph();
        int initialNodeCount = graph.getNodeCount();
        SimplifierTool defaultSimplifier = GraphUtil.getDefaultSimplifier(context, canonicalizer.getCanonicalizeReads(), graph.getAssumptions(), graph.getOptions());
        CanonicalizerPhase c = canonicalizer.copyWithoutSimplification();
        EconomicSetNodeEventListener l = new EconomicSetNodeEventListener();
        int peelings = 0;
        try (Graph.NodeEventScope ev = graph.trackNodeEvents(l);){
            while (!loopBegin.isDeleted()) {
                Graph.Mark newNodes = graph.getMark();
                EconomicSetNodeEventListener peeledListener = new EconomicSetNodeEventListener();
                try (Graph.NodeEventScope peeledScope = graph.trackNodeEvents(peeledListener);){
                    LoopTransformations.peel(loop);
                }
                graph.getDebug().dump(5, (Object)graph, "After peeling loop %s", loop);
                c.applyIncremental(graph, context, (Iterable<? extends Node>)peeledListener.getNodes());
                loop.invalidateFragmentsAndIVs();
                for (Node n : graph.getNewNodes(newNodes)) {
                    if (!n.isAlive() || !(n instanceof IfNode) && !(n instanceof SwitchNode) && !(n instanceof FixedGuardNode) && !(n instanceof BeginNode)) continue;
                    Simplifiable s = (Simplifiable)((Object)n);
                    s.simplify(defaultSimplifier);
                    graph.getDebug().dump(5, (Object)graph, "After simplifying if %s", s);
                }
                if (graph.getNodeCount() > initialNodeCount + GraalOptions.MaximumDesiredSize.getValue(graph.getOptions()) * 2 || peelings > DefaultLoopPolicies.Options.FullUnrollMaxIterations.getValue(graph.getOptions())) {
                    throw new RetryableBailoutException("FullUnroll : Graph seems to grow out of proportion");
                }
                ++peelings;
            }
        }
        canonicalizer.applyIncremental(graph, context, (Iterable<? extends Node>)l.getNodes());
    }

    public static void unswitch(LoopEx loop, List<ControlSplitNode> controlSplitNodeSet) {
        ControlSplitNode firstNode = controlSplitNodeSet.iterator().next();
        LoopFragmentWhole originalLoop = loop.whole();
        StructuredGraph graph = firstNode.graph();
        loop.loopBegin().incrementUnswitches();
        ControlSplitNode newControlSplit = (ControlSplitNode)firstNode.copyWithInputs();
        originalLoop.entryPoint().replaceAtPredecessor(newControlSplit);
        Iterator<Position> successors = firstNode.successorPositions().iterator();
        assert (successors.hasNext());
        Position firstPosition = successors.next();
        AbstractBeginNode originalLoopBegin = BeginNode.begin(originalLoop.entryPoint());
        firstPosition.set(newControlSplit, originalLoopBegin);
        originalLoopBegin.setNodeSourcePosition(firstPosition.get(firstNode).getNodeSourcePosition());
        while (successors.hasNext()) {
            Position position = successors.next();
            LoopFragmentWhole duplicateLoop = originalLoop.duplicate();
            AbstractBeginNode newBegin = BeginNode.begin(duplicateLoop.entryPoint());
            newBegin.setNodeSourcePosition(position.get(firstNode).getNodeSourcePosition());
            position.set(newControlSplit, newBegin);
            for (ControlSplitNode controlSplitNode : controlSplitNodeSet) {
                ControlSplitNode duplicatedControlSplit = (ControlSplitNode)duplicateLoop.getDuplicatedNode(controlSplitNode);
                if (!duplicatedControlSplit.isAlive()) continue;
                AbstractBeginNode survivingSuccessor = (AbstractBeginNode)position.get(duplicatedControlSplit);
                survivingSuccessor.replaceAtUsages((Node)newBegin, InputType.Guard);
                graph.removeSplitPropagate(duplicatedControlSplit, survivingSuccessor);
            }
        }
        for (ControlSplitNode controlSplitNode : controlSplitNodeSet) {
            if (!controlSplitNode.isAlive()) continue;
            AbstractBeginNode survivingSuccessor = (AbstractBeginNode)firstPosition.get(controlSplitNode);
            survivingSuccessor.replaceAtUsages((Node)originalLoopBegin, InputType.Guard);
            graph.removeSplitPropagate(controlSplitNode, survivingSuccessor);
        }
    }

    public static void partialUnroll(LoopEx loop, EconomicMap<LoopBeginNode, OpaqueNode> opaqueUnrolledStrides) {
        assert (loop.loopBegin().isMainLoop());
        loop.loopBegin().graph().getDebug().log("LoopPartialUnroll %s", loop);
        LoopFragmentInside newSegment = loop.inside().duplicate();
        newSegment.insertWithinAfter(loop, opaqueUnrolledStrides);
        for (LoopExitNode exit : loop.loopBegin().loopExits()) {
            LoopBeginNode possiblePostLoopBegin;
            if (!exit.next().hasExactlyOneUsage() || !(exit.next().usages().first() instanceof LoopBeginNode) || !(possiblePostLoopBegin = (LoopBeginNode)exit.next().usages().first()).isPostLoop()) continue;
            possiblePostLoopBegin.setLoopFrequency(loop.loopBegin().profileData().copy(loop.loopBegin().getUnrollFactor() - 1));
            break;
        }
    }

    public static PreMainPostResult insertPrePostLoops(LoopEx loop) {
        assert (loop.loopBegin().loopExits().isEmpty() || !loop.loopBegin().graph().hasValueProxies() || loop.counted().getCountedExit() instanceof LoopExitNode) : "Can only unroll loops, if they have exits, if the counted exit is a regular loop exit " + loop;
        StructuredGraph graph = loop.loopBegin().graph();
        graph.getDebug().log("LoopTransformations.insertPrePostLoops %s", loop);
        LoopFragmentWhole preLoop = loop.whole();
        CountedLoopInfo preCounted = loop.counted();
        LoopBeginNode preLoopBegin = loop.loopBegin();
        AbstractBeginNode preLoopExitNode = preCounted.getCountedExit();
        assert (preLoop.nodes().contains(preLoopBegin));
        assert (preLoop.nodes().contains(preLoopExitNode));
        LoopFragmentWhole mainLoop = preLoop.duplicate();
        LoopBeginNode mainLoopBegin = (LoopBeginNode)mainLoop.getDuplicatedNode(preLoopBegin);
        AbstractBeginNode mainLoopExitNode = (AbstractBeginNode)mainLoop.getDuplicatedNode(preLoopExitNode);
        EndNode mainEndNode = LoopTransformations.getBlockEndAfterLoopExit(mainLoopExitNode);
        AbstractMergeNode mainMergeNode = mainEndNode.merge();
        graph.getDebug().dump(5, (Object)graph, "After  duplication of main loop %s", mainLoop);
        LoopFragmentWhole postLoop = preLoop.duplicate();
        LoopBeginNode postLoopBegin = (LoopBeginNode)postLoop.getDuplicatedNode(preLoopBegin);
        AbstractBeginNode postLoopExitNode = (AbstractBeginNode)postLoop.getDuplicatedNode(preLoopExitNode);
        EndNode postEndNode = LoopTransformations.getBlockEndAfterLoopExit(postLoopExitNode);
        AbstractMergeNode postMergeNode = postEndNode.merge();
        graph.getDebug().dump(5, graph, "After post loop duplication");
        preLoopBegin.incrementSplits();
        preLoopBegin.incrementSplits();
        preLoopBegin.setPreLoop();
        mainLoopBegin.setMainLoop();
        postLoopBegin.setPostLoop();
        if (graph.hasValueProxies()) {
            LoopTransformations.cleanupAndDeleteState(mainMergeNode);
            LoopTransformations.cleanupPostDominatingValues(mainLoopBegin, mainMergeNode, postEndNode);
            LoopTransformations.removeStateAndPhis(postMergeNode);
            LoopTransformations.createExitState(preLoopBegin, (LoopExitNode)preLoopExitNode, loop.counted().isInverted(), preLoop);
            LoopTransformations.createExitState(mainLoopBegin, (LoopExitNode)mainLoopExitNode, loop.counted().isInverted(), mainLoop);
        }
        assert (!graph.hasValueProxies() || preLoopExitNode instanceof LoopExitNode) : "Unrolling with proxies requires actual loop exit nodes as counted exits";
        LoopTransformations.rewirePreToMainPhis(preLoopBegin, mainLoop, preLoop, graph.hasValueProxies() ? (LoopExitNode)preLoopExitNode : null, loop.counted().isInverted());
        AbstractEndNode postEntryNode = postLoopBegin.forwardEnd();
        FixedNode continuationNode = mainMergeNode.next();
        AbstractBeginNode mainLandingNode = BeginNode.begin(postEntryNode);
        mainLoopExitNode.setNext(mainLandingNode);
        preLoopExitNode.setNext(mainLoopBegin.forwardEnd());
        assert (!graph.hasValueProxies() || mainLoopExitNode instanceof LoopExitNode) : "Unrolling with proxies requires actual loop exit nodes as counted exits";
        LoopTransformations.processPreLoopPhis(loop, graph.hasValueProxies() ? (LoopExitNode)mainLoopExitNode : null, mainLoop, postLoop);
        graph.getDebug().dump(5, graph, "After processing pre loop phis");
        continuationNode.predecessor().clearSuccessors();
        postLoopExitNode.setNext(continuationNode);
        LoopTransformations.cleanupMerge(postMergeNode, postLoopExitNode);
        LoopTransformations.cleanupMerge(mainMergeNode, mainLandingNode);
        if (graph.hasValueProxies()) {
            loop.resetCounted();
            loop.detectCounted();
            LoopTransformations.updatePreLoopLimit(loop.counted());
        } else {
            LoopTransformations.updatePreLoopLimit(preCounted);
        }
        double originalFrequency = loop.loopBegin().loopFrequency();
        preLoopBegin.setLoopFrequency(ProfileData.LoopFrequencyData.injected(1.0));
        mainLoopBegin.setLoopFrequency(mainLoopBegin.profileData().decrementFrequency(2.0));
        postLoopBegin.setLoopFrequency(ProfileData.LoopFrequencyData.injected(1.0));
        preLoopBegin.setLoopOrigFrequency(originalFrequency);
        mainLoopBegin.setLoopOrigFrequency(originalFrequency);
        postLoopBegin.setLoopOrigFrequency(originalFrequency);
        if (!graph.hasValueProxies()) {
            for (SafepointNode safepoint : preLoop.nodes().filter(SafepointNode.class)) {
                graph.removeFixed(safepoint);
            }
            for (SafepointNode safepoint : postLoop.nodes().filter(SafepointNode.class)) {
                graph.removeFixed(safepoint);
            }
        }
        graph.getDebug().dump(4, (Object)graph, "InsertPrePostLoops %s", loop);
        return new PreMainPostResult(preLoopBegin, mainLoopBegin, postLoopBegin, preLoop, mainLoop, postLoop);
    }

    private static void cleanupPostDominatingValues(LoopBeginNode mainLoopBegin, AbstractMergeNode mainMergeNode, AbstractEndNode postEndNode) {
        for (LoopExitNode exit : mainLoopBegin.loopExits()) {
            for (ProxyNode proxy : exit.proxies()) {
                for (Node usage : proxy.usages().snapshot()) {
                    if (!(usage instanceof PhiNode) || ((PhiNode)usage).merge() != mainMergeNode) continue;
                    assert (usage instanceof PhiNode);
                    PhiNode pUsage = (PhiNode)usage;
                    ValueNode v = pUsage.valueAt(0);
                    assert (v instanceof PhiNode);
                    PhiNode vP = (PhiNode)v;
                    usage.replaceAtUsages(vP.valueAt(postEndNode));
                    usage.safeDelete();
                }
            }
        }
        mainLoopBegin.graph().getDebug().dump(5, mainLoopBegin.graph(), "After fixing post dominating proxy usages");
    }

    private static void rewirePreToMainPhis(LoopBeginNode preLoopBegin, LoopFragment mainLoop, LoopFragment preLoop, LoopExitNode preLoopCountedExit, boolean inverted) {
        for (PhiNode prePhiNode : preLoopBegin.phis()) {
            PhiNode mainPhiNode = (PhiNode)mainLoop.getDuplicatedNode(prePhiNode);
            LoopTransformations.rewirePhi(prePhiNode, mainPhiNode, preLoopCountedExit, preLoop, inverted);
        }
        preLoopBegin.graph().getDebug().dump(5, preLoopBegin.graph(), "After updating value flow from pre loop phi to main loop phi");
    }

    private static void cleanupAndDeleteState(StateSplit statesplit) {
        FrameState fs = statesplit.stateAfter();
        statesplit.setStateAfter(null);
        GraphUtil.killWithUnusedFloatingInputs(fs);
    }

    private static void removeStateAndPhis(AbstractMergeNode merge) {
        LoopTransformations.cleanupAndDeleteState(merge);
        for (PhiNode phi : merge.phis().snapshot()) {
            phi.safeDelete();
        }
        merge.graph().getDebug().dump(5, merge.graph(), "After deleting unused phis");
    }

    private static void createExitState(final LoopBeginNode begin, final LoopExitNode lex, final boolean inverted, final LoopFragment loop) {
        FrameState loopHeaderState = begin.stateAfter().duplicateWithVirtualState();
        loopHeaderState.applyToNonVirtual((VirtualState.NodePositionClosure<? super Node>)new VirtualState.NodePositionClosure<Node>(){

            @Override
            public void apply(Node from, Position p) {
                ValueNode usage = (ValueNode)p.get(from);
                if (begin.isPhiAtMerge(usage)) {
                    PhiNode phi = (PhiNode)usage;
                    ValueNode toProxy = inverted ? phi.singleBackValueOrThis() : phi;
                    ValueNode replacement = loop.contains(toProxy) ? LoopFragmentInside.patchProxyAtPhi((PhiNode)usage, lex, toProxy) : toProxy;
                    p.set(from, replacement);
                }
            }
        });
        lex.setStateAfter(loopHeaderState);
        begin.graph().getDebug().dump(5, begin.graph(), "After proxy-ing phis for exit state");
    }

    private static void cleanupMerge(AbstractMergeNode mergeNode, AbstractBeginNode landingNode) {
        for (EndNode end : mergeNode.cfgPredecessors().snapshot()) {
            mergeNode.removeEnd(end);
            end.safeDelete();
        }
        mergeNode.getDebug().dump(5, (Object)mergeNode.graph(), "After cleaning up merge %s", mergeNode);
        mergeNode.prepareDelete(landingNode);
        mergeNode.safeDelete();
    }

    private static void rewirePhi(PhiNode currentPhi, PhiNode outGoingPhi, LoopExitNode exitToProxy, LoopFragment loopToProxy, boolean inverted) {
        if (currentPhi.graph().hasValueProxies()) {
            ValueNode set = null;
            ValueNode toProxy = inverted ? currentPhi.singleBackValueOrThis() : currentPhi;
            set = loopToProxy.contains(toProxy) ? LoopFragmentInside.patchProxyAtPhi(currentPhi, exitToProxy, toProxy) : toProxy;
            assert (set != null);
            outGoingPhi.setValueAt(0, set);
        } else {
            outGoingPhi.setValueAt(0, (ValueNode)currentPhi);
        }
    }

    private static void processPreLoopPhis(LoopEx preLoop, LoopExitNode mainLoopCountedExit, LoopFragmentWhole mainLoop, LoopFragmentWhole postLoop) {
        LoopBeginNode preLoopBegin = preLoop.loopBegin();
        StructuredGraph graph = preLoopBegin.graph();
        for (PhiNode prePhiNode : preLoopBegin.phis()) {
            PhiNode postPhiNode = (PhiNode)postLoop.getDuplicatedNode(prePhiNode);
            PhiNode mainPhiNode = (PhiNode)mainLoop.getDuplicatedNode(prePhiNode);
            LoopTransformations.rewirePhi(mainPhiNode, postPhiNode, mainLoopCountedExit, mainLoop, preLoop.counted().isInverted());
            if (graph.hasValueProxies()) continue;
            for (Node usage : prePhiNode.usages().snapshot()) {
                if (usage == mainPhiNode || !preLoop.isOutsideLoop(usage)) continue;
                usage.replaceFirstInput(prePhiNode, postPhiNode);
            }
            for (Node node : preLoop.inside().nodes()) {
                for (Node externalUsage : node.usages().snapshot()) {
                    if (!preLoop.isOutsideLoop(externalUsage)) continue;
                    Object postUsage = postLoop.getDuplicatedNode(node);
                    assert (postUsage != null);
                    externalUsage.replaceFirstInput(node, (Node)postUsage);
                }
            }
        }
    }

    private static EndNode getBlockEndAfterLoopExit(AbstractBeginNode exit) {
        FixedNode node = exit.next();
        return LoopTransformations.getBlockEnd(node);
    }

    private static EndNode getBlockEnd(FixedNode node) {
        FixedNode curNode = node;
        while (curNode instanceof FixedWithNextNode) {
            curNode = ((FixedWithNextNode)curNode).next();
        }
        return (EndNode)curNode;
    }

    private static void updatePreLoopLimit(CountedLoopInfo preCounted) {
        ValueNode newLimit = AddNode.add(preCounted.getStart(), preCounted.getCounter().strideNode(), NodeView.DEFAULT);
        ValueNode ub = preCounted.getLimit();
        IntegerHelper helper = preCounted.getCounterIntegerHelper();
        LogicNode entryCheck = preCounted.getDirection() == InductionVariable.Direction.Up ? helper.createCompareNode(newLimit, ub, NodeView.DEFAULT) : helper.createCompareNode(ub, newLimit, NodeView.DEFAULT);
        newLimit = ConditionalNode.create(entryCheck, newLimit, ub, NodeView.DEFAULT);
        CompareNode compareNode = (CompareNode)preCounted.getLimitTest().condition();
        compareNode.replaceFirstInput(ub, compareNode.graph().addOrUniqueWithInputs(newLimit));
    }

    public static List<ControlSplitNode> findUnswitchable(LoopEx loop) {
        ArrayList<IfNode> controls = null;
        ValueNode invariantValue = null;
        for (IfNode ifNode : loop.whole().nodes().filter(IfNode.class)) {
            if (!loop.isOutsideLoop(ifNode.condition())) continue;
            if (controls == null) {
                invariantValue = ifNode.condition();
                controls = new ArrayList<IfNode>();
                controls.add(ifNode);
                continue;
            }
            if (ifNode.condition() != invariantValue) continue;
            controls.add(ifNode);
        }
        if (controls == null) {
            SwitchNode firstSwitch = null;
            for (SwitchNode switchNode : loop.whole().nodes().filter(SwitchNode.class)) {
                if (switchNode.successors().count() <= 1 || !loop.isOutsideLoop(switchNode.value())) continue;
                if (controls == null) {
                    firstSwitch = switchNode;
                    invariantValue = switchNode.value();
                    controls = new ArrayList();
                    controls.add((IfNode)((Object)switchNode));
                    continue;
                }
                if (switchNode.value() != invariantValue) continue;
                assert (firstSwitch != null);
                if (!firstSwitch.structureEquals(switchNode)) continue;
                controls.add((IfNode)((Object)switchNode));
            }
        }
        return controls;
    }

    public static boolean isUnrollableLoop(LoopEx loop) {
        if (!loop.isCounted() || !loop.counted().getCounter().isConstantStride() || !loop.loop().getChildren().isEmpty() || loop.loopBegin().loopEnds().count() != 1 || loop.loopBegin().loopExits().count() > 1 || loop.counted().isInverted()) {
            return false;
        }
        assert (loop.counted().getDirection() != null);
        LoopBeginNode loopBegin = loop.loopBegin();
        LogicNode condition = loop.counted().getLimitTest().condition();
        if (!(condition instanceof CompareNode)) {
            return false;
        }
        if (((CompareNode)condition).condition() == CanonicalCondition.EQ) {
            condition.getDebug().log(3, "isUnrollableLoop %s condition unsupported %s ", (Object)loopBegin, (Object)((CompareNode)condition).condition());
            return false;
        }
        long stride = loop.counted().getCounter().constantStride();
        try {
            Math.addExact(stride, stride);
        }
        catch (ArithmeticException ae) {
            condition.getDebug().log(3, "isUnrollableLoop %s doubling the stride overflows %d", (Object)loopBegin, (Object)stride);
            return false;
        }
        if (!loop.canDuplicateLoop()) {
            return false;
        }
        if (loopBegin.isMainLoop() || loopBegin.isSimpleLoop()) {
            if (loop.loop().getBlocks().size() < 3) {
                return true;
            }
            condition.getDebug().log(3, "isUnrollableLoop %s too large to unroll %s ", (Object)loopBegin, loop.loop().getBlocks().size());
        }
        return false;
    }

    public static class PreMainPostResult {
        private final LoopBeginNode preLoop;
        private final LoopBeginNode mainLoop;
        private final LoopBeginNode postLoop;
        private final LoopFragment preLoopFragment;
        private final LoopFragment mainLoopFragment;
        private final LoopFragment postLoopFragment;

        public PreMainPostResult(LoopBeginNode preLoop, LoopBeginNode mainLoop, LoopBeginNode postLoop, LoopFragment preLoopFragment, LoopFragment mainLoopFragment, LoopFragment postLoopFragment) {
            this.preLoop = preLoop;
            this.mainLoop = mainLoop;
            this.postLoop = postLoop;
            this.preLoopFragment = preLoopFragment;
            this.mainLoopFragment = mainLoopFragment;
            this.postLoopFragment = postLoopFragment;
        }

        public LoopFragment getPreLoopFragment() {
            return this.preLoopFragment;
        }

        public LoopFragment getMainLoopFragment() {
            return this.mainLoopFragment;
        }

        public LoopFragment getPostLoopFragment() {
            return this.postLoopFragment;
        }

        public LoopBeginNode getMainLoop() {
            return this.mainLoop;
        }

        public LoopBeginNode getPostLoop() {
            return this.postLoop;
        }

        public LoopBeginNode getPreLoop() {
            return this.preLoop;
        }
    }
}

