/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop.phases;

import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.loop.phases.LoopPhase;
import org.graalvm.compiler.loop.phases.LoopTransformations;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopPolicies;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.spi.CoreProviders;

public class LoopPeelingPhase
extends LoopPhase<LoopPolicies> {
    public static final CounterKey PEELED = DebugContext.counter("Peeled");

    public LoopPeelingPhase(LoopPolicies policies) {
        super(policies);
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        DebugContext debug = graph.getDebug();
        if (graph.hasLoops()) {
            LoopsData data = context.getLoopsDataProvider().getLoopsData(graph);
            try (DebugContext.Scope s = debug.scope((Object)"peeling", data.getCFG());){
                for (LoopEx loop : data.outerFirst()) {
                    if (!loop.canDuplicateLoop() || loop.loopBegin().getLoopEndCount() <= 0 || !LoopPolicies.Options.PeelALot.getValue(graph.getOptions()).booleanValue() && !this.getPolicies().shouldPeel(loop, data.getCFG(), context)) continue;
                    debug.log("Peeling %s", loop);
                    PEELED.increment(debug);
                    LoopTransformations.peel(loop);
                    debug.dump(4, (Object)graph, "Peeling %s", loop);
                }
                data.deleteUnusedNodes();
            }
            catch (Throwable t) {
                throw debug.handle(t);
            }
        }
    }

    @Override
    public float codeSizeIncrease() {
        return 10.0f;
    }
}

