/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop.phases;

import java.util.Iterator;
import java.util.List;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.DeoptimizationAction;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.spi.SimplifierTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StaticDeoptimizingNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.common.DeadCodeEliminationPhase;
import org.graalvm.compiler.phases.common.LazyValue;

public class ConvertDeoptimizeToGuardPhase
extends BasePhase<CoreProviders> {
    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        Throwable throwable;
        DebugCloseable closable;
        assert (graph.hasValueProxies()) : "ConvertDeoptimizeToGuardPhase always creates proxies";
        assert (!graph.getGuardsStage().areFrameStatesAtDeopts()) : graph.getGuardsStage();
        LazyValue<LoopsData> lazyLoops = new LazyValue<LoopsData>(() -> context.getLoopsDataProvider().getLoopsData(graph));
        for (DeoptimizeNode d : graph.getNodes(DeoptimizeNode.TYPE)) {
            assert (d.isAlive());
            if (d.getAction() == DeoptimizationAction.None) continue;
            closable = d.withNodeSourcePosition();
            throwable = null;
            try {
                ConvertDeoptimizeToGuardPhase.propagateFixed(d, d, context, lazyLoops);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (closable == null) continue;
                if (throwable != null) {
                    try {
                        closable.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                closable.close();
            }
        }
        if (context != null) {
            for (FixedGuardNode fixedGuard : graph.getNodes(FixedGuardNode.TYPE)) {
                closable = fixedGuard.withNodeSourcePosition();
                throwable = null;
                try {
                    ConvertDeoptimizeToGuardPhase.trySplitFixedGuard(fixedGuard, context, lazyLoops);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (closable == null) continue;
                    if (throwable != null) {
                        try {
                            closable.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                        continue;
                    }
                    closable.close();
                }
            }
        }
        new DeadCodeEliminationPhase(DeadCodeEliminationPhase.Optionality.Optional).apply(graph);
    }

    private static void trySplitFixedGuard(FixedGuardNode fixedGuard, CoreProviders context, LazyValue<LoopsData> lazyLoops) {
        LogicNode condition = fixedGuard.condition();
        if (condition instanceof CompareNode) {
            ValuePhiNode xPhi;
            CompareNode compare = (CompareNode)condition;
            ValueNode x = compare.getX();
            ValuePhiNode valuePhiNode = xPhi = x instanceof ValuePhiNode ? (ValuePhiNode)x : null;
            if (x instanceof ConstantNode || xPhi != null) {
                ValuePhiNode yPhi;
                ValueNode y = compare.getY();
                ValuePhiNode valuePhiNode2 = yPhi = y instanceof ValuePhiNode ? (ValuePhiNode)y : null;
                if (y instanceof ConstantNode || yPhi != null) {
                    ConvertDeoptimizeToGuardPhase.processFixedGuardAndPhis(fixedGuard, context, compare, x, xPhi, y, yPhi, lazyLoops);
                }
            }
        }
    }

    private static void processFixedGuardAndPhis(FixedGuardNode fixedGuard, CoreProviders context, CompareNode compare, ValueNode x, ValuePhiNode xPhi, ValueNode y, ValuePhiNode yPhi, LazyValue<LoopsData> lazyLoops) {
        AbstractBeginNode pred = AbstractBeginNode.prevBegin(fixedGuard);
        if (pred instanceof AbstractMergeNode) {
            AbstractMergeNode merge = (AbstractMergeNode)pred;
            if (xPhi != null && xPhi.merge() != merge) {
                return;
            }
            if (yPhi != null && yPhi.merge() != merge) {
                return;
            }
            ConvertDeoptimizeToGuardPhase.processFixedGuardAndMerge(fixedGuard, context, compare, x, xPhi, y, yPhi, merge, lazyLoops);
        }
    }

    private static void processFixedGuardAndMerge(FixedGuardNode fixedGuard, CoreProviders context, CompareNode compare, ValueNode x, ValuePhiNode xPhi, ValueNode y, ValuePhiNode yPhi, AbstractMergeNode merge, LazyValue<LoopsData> lazyLoops) {
        AbstractEndNode mergePredecessor;
        List mergePredecessors = merge.cfgPredecessors().snapshot();
        Iterator iterator = mergePredecessors.iterator();
        while (iterator.hasNext() && (mergePredecessor = (AbstractEndNode)iterator.next()).isAlive()) {
            Constant xs = xPhi == null ? x.asConstant() : xPhi.valueAt(mergePredecessor).asConstant();
            Constant ys = yPhi == null ? y.asConstant() : yPhi.valueAt(mergePredecessor).asConstant();
            if (xs == null || ys == null || compare.condition().foldCondition(xs, ys, context.getConstantReflection(), compare.unorderedIsTrue()) != fixedGuard.isNegated()) continue;
            DebugCloseable position = fixedGuard.withNodeSourcePosition();
            Throwable throwable = null;
            try {
                ConvertDeoptimizeToGuardPhase.propagateFixed(mergePredecessor, fixedGuard, context, lazyLoops);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (position == null) continue;
                if (throwable != null) {
                    try {
                        position.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                position.close();
            }
        }
    }

    private static void propagateFixed(FixedNode from, StaticDeoptimizingNode deopt, CoreProviders providers, LazyValue<LoopsData> lazyLoops) {
        for (Node current = from; current != null; current = current.predecessor()) {
            if (GraalOptions.GuardPriorities.getValue(from.getOptions()).booleanValue() && current instanceof FixedGuardNode) {
                FixedGuardNode otherGuard = (FixedGuardNode)current;
                if (!otherGuard.computePriority().isHigherPriorityThan(deopt.computePriority())) continue;
                ConvertDeoptimizeToGuardPhase.moveAsDeoptAfter(otherGuard, deopt);
                return;
            }
            if (!(current instanceof AbstractBeginNode)) continue;
            if (current instanceof AbstractMergeNode) {
                AbstractMergeNode mergeNode = (AbstractMergeNode)current;
                FixedNode next = mergeNode.next();
                while (mergeNode.isAlive()) {
                    AbstractEndNode end = (AbstractEndNode)mergeNode.forwardEnds().first();
                    ConvertDeoptimizeToGuardPhase.propagateFixed(end, deopt, providers, lazyLoops);
                }
                if (next.isAlive()) {
                    ConvertDeoptimizeToGuardPhase.propagateFixed(next, deopt, providers, lazyLoops);
                }
                return;
            }
            if (current.predecessor() instanceof IfNode) {
                AbstractBeginNode begin = (AbstractBeginNode)current;
                IfNode ifNode = (IfNode)current.predecessor();
                if (ConvertDeoptimizeToGuardPhase.isOsrLoopExit(begin) || ConvertDeoptimizeToGuardPhase.isCountedLoopExit(ifNode, lazyLoops)) {
                    ConvertDeoptimizeToGuardPhase.moveAsDeoptAfter(begin, deopt);
                } else {
                    try (DebugCloseable closable = ifNode.withNodeSourcePosition();){
                        StructuredGraph graph = ifNode.graph();
                        LogicNode conditionNode = ifNode.condition();
                        boolean negateGuardCondition = current == ifNode.trueSuccessor();
                        NodeSourcePosition survivingSuccessorPosition = negateGuardCondition ? ifNode.falseSuccessor().getNodeSourcePosition() : ifNode.trueSuccessor().getNodeSourcePosition();
                        FixedGuardNode guard = graph.add(new FixedGuardNode(conditionNode, deopt.getReason(), deopt.getAction(), deopt.getSpeculation(), negateGuardCondition, survivingSuccessorPosition));
                        FixedWithNextNode pred = (FixedWithNextNode)ifNode.predecessor();
                        AbstractBeginNode survivingSuccessor = negateGuardCondition ? ifNode.falseSuccessor() : ifNode.trueSuccessor();
                        graph.removeSplitPropagate(ifNode, survivingSuccessor);
                        ValueNode newGuard = guard;
                        if (survivingSuccessor instanceof LoopExitNode) {
                            newGuard = ProxyNode.forGuard(guard, (LoopExitNode)survivingSuccessor);
                        }
                        survivingSuccessor.replaceAtUsages((Node)newGuard, InputType.Guard);
                        graph.getDebug().log("Converting deopt on %-5s branch of %s to guard for remaining branch %s.", negateGuardCondition, (Object)ifNode, (Object)survivingSuccessor);
                        FixedNode next = pred.next();
                        pred.setNext(guard);
                        guard.setNext(next);
                        assert (providers != null);
                        SimplifierTool simplifierTool = GraphUtil.getDefaultSimplifier(providers, false, graph.getAssumptions(), graph.getOptions());
                        survivingSuccessor.simplify(simplifierTool);
                    }
                }
                return;
            }
            if (current.predecessor() != null && !(current.predecessor() instanceof ControlSplitNode)) continue;
            assert (current.predecessor() != null || current instanceof StartNode && current == ((AbstractBeginNode)current).graph().start());
            ConvertDeoptimizeToGuardPhase.moveAsDeoptAfter((AbstractBeginNode)current, deopt);
            return;
        }
    }

    private static void moveAsDeoptAfter(FixedWithNextNode node, StaticDeoptimizingNode deopt) {
        try (DebugCloseable position = deopt.asNode().withNodeSourcePosition();){
            FixedNode next = node.next();
            if (next != deopt.asNode()) {
                node.setNext(node.graph().add(new DeoptimizeNode(deopt.getAction(), deopt.getReason(), deopt.getSpeculation())));
                GraphUtil.killCFG(next);
            }
        }
    }

    private static boolean isOsrLoopExit(AbstractBeginNode node) {
        if (!(node instanceof LoopExitNode)) {
            return false;
        }
        return ((LoopExitNode)node).loopBegin().isOsrLoop();
    }

    private static boolean isCountedLoopExit(IfNode ifNode, LazyValue<LoopsData> lazyLoops) {
        LoopEx loopEx;
        LoopsData loopsData = lazyLoops.get();
        Loop<Block> loop = loopsData.getCFG().getNodeToBlock().get(ifNode).getLoop();
        if (loop != null && (loopEx = loopsData.loop(loop)).detectCounted()) {
            return ifNode == loopEx.counted().getLimitTest();
        }
        return false;
    }
}

