/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.stackslotalloc;

import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.ValueProcedure;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.framemap.FrameMapBuilderTool;
import org.graalvm.compiler.lir.framemap.SimpleVirtualStackSlot;
import org.graalvm.compiler.lir.framemap.VirtualStackSlotRange;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.AllocationPhase;
import org.graalvm.compiler.lir.stackslotalloc.StackSlotAllocatorUtil;

public class SimpleStackSlotAllocator
extends AllocationPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, AllocationPhase.AllocationContext context) {
        this.allocateStackSlots((FrameMapBuilderTool)lirGenRes.getFrameMapBuilder(), lirGenRes);
        lirGenRes.buildFrameMap();
    }

    public void allocateStackSlots(FrameMapBuilderTool builder, LIRGenerationResult res) {
        DebugContext debug = res.getLIR().getDebug();
        StackSlot[] mapping = new StackSlot[builder.getNumberOfStackSlots()];
        boolean allocatedFramesizeEnabled = StackSlotAllocatorUtil.allocatedFramesize.isEnabled(debug);
        long currentFrameSize = allocatedFramesizeEnabled ? (long)builder.getFrameMap().currentFrameSize() : 0L;
        for (VirtualStackSlot virtualSlot : builder.getStackSlots()) {
            StackSlot slot;
            if (virtualSlot instanceof SimpleVirtualStackSlot) {
                slot = this.mapSimpleVirtualStackSlot(builder, (SimpleVirtualStackSlot)virtualSlot);
                StackSlotAllocatorUtil.virtualFramesize.add(debug, builder.getFrameMap().spillSlotSize(virtualSlot.getValueKind()));
            } else if (virtualSlot instanceof VirtualStackSlotRange) {
                VirtualStackSlotRange slotRange = (VirtualStackSlotRange)virtualSlot;
                slot = this.mapVirtualStackSlotRange(builder, slotRange);
                StackSlotAllocatorUtil.virtualFramesize.add(debug, builder.getFrameMap().spillSlotRangeSize(slotRange.getSlots()));
            } else {
                throw GraalError.shouldNotReachHere("Unknown VirtualStackSlot: " + (Object)((Object)virtualSlot));
            }
            StackSlotAllocatorUtil.allocatedSlots.increment(debug);
            mapping[virtualSlot.getId()] = slot;
        }
        this.updateLIR(res, mapping);
        if (allocatedFramesizeEnabled) {
            StackSlotAllocatorUtil.allocatedFramesize.add(debug, (long)builder.getFrameMap().currentFrameSize() - currentFrameSize);
        }
    }

    protected void updateLIR(LIRGenerationResult res, StackSlot[] mapping) {
        DebugContext debug = res.getLIR().getDebug();
        try (DebugContext.Scope scope = debug.scope("StackSlotMappingLIR");){
            ValueProcedure updateProc = (value, mode, flags) -> {
                if (LIRValueUtil.isVirtualStackSlot(value)) {
                    StackSlot stackSlot = mapping[LIRValueUtil.asVirtualStackSlot(value).getId()];
                    debug.log("map %s -> %s", (Object)value, (Object)stackSlot);
                    return stackSlot;
                }
                return value;
            };
            for (AbstractBlockBase block : res.getLIR().getControlFlowGraph().getBlocks()) {
                try (Indent indent0 = debug.logAndIndent("block: %s", block);){
                    for (LIRInstruction inst : res.getLIR().getLIRforBlock(block)) {
                        Indent indent1 = debug.logAndIndent("Inst: %d: %s", inst.id(), (Object)inst);
                        Throwable throwable = null;
                        try {
                            inst.forEachAlive(updateProc);
                            inst.forEachInput(updateProc);
                            inst.forEachOutput(updateProc);
                            inst.forEachTemp(updateProc);
                            inst.forEachState(updateProc);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (indent1 == null) continue;
                            if (throwable != null) {
                                try {
                                    indent1.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            indent1.close();
                        }
                    }
                }
            }
        }
    }

    protected StackSlot mapSimpleVirtualStackSlot(FrameMapBuilderTool builder, SimpleVirtualStackSlot virtualStackSlot) {
        return builder.getFrameMap().allocateSpillSlot(virtualStackSlot.getValueKind());
    }

    protected StackSlot mapVirtualStackSlotRange(FrameMapBuilderTool builder, VirtualStackSlotRange virtualStackSlot) {
        return builder.getFrameMap().allocateStackSlots(virtualStackSlot.getSlots());
    }
}

