/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.asm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.DebugInfo;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.code.site.Call;
import jdk.vm.ci.code.site.ConstantReference;
import jdk.vm.ci.code.site.DataSectionReference;
import jdk.vm.ci.code.site.Infopoint;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.code.site.Reference;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.VMConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.asm.AbstractAddress;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.code.CompilationResult;
import org.graalvm.compiler.code.DataSection;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.type.DataPointerConstant;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.lir.ImplicitLIRFrameState;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionVerifier;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.asm.DataBuilder;
import org.graalvm.compiler.lir.asm.FrameContext;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalServices;

public class CompilationResultBuilder {
    private static final List<LIRInstructionVerifier> LIR_INSTRUCTION_VERIFIERS = new ArrayList<LIRInstructionVerifier>();
    public final Assembler asm;
    public final DataBuilder dataBuilder;
    public final CompilationResult compilationResult;
    public final Register uncompressedNullRegister;
    public final TargetDescription target;
    public final CodeGenProviders providers;
    public final CodeCacheProvider codeCache;
    public final ForeignCallsProvider foreignCalls;
    public final FrameMap frameMap;
    protected LIR lir;
    protected int currentBlockIndex;
    public final FrameContext frameContext;
    private List<ExceptionInfo> exceptionInfoList;
    private List<PendingImplicitException> pendingImplicitExceptionList;
    private final OptionValues options;
    private final DebugContext debug;
    private final EconomicMap<Constant, DataSection.Data> dataCache;
    private Consumer<LIRInstruction> beforeOp;
    private Consumer<LIRInstruction> afterOp;
    private EconomicMap<Label, Integer> labelBindLirPositions;
    private EconomicMap<LIRInstruction, Integer> lirPositions;
    private boolean conservativeLabelOffsets = false;
    private boolean needsMHDeoptHandler = false;
    private CallContext currentCallContext;

    public final boolean mustReplaceWithUncompressedNullRegister(JavaConstant nullConstant) {
        return !this.uncompressedNullRegister.equals((Object)Register.None) && JavaConstant.NULL_POINTER.equals(nullConstant);
    }

    public CompilationResultBuilder(CodeGenProviders providers, FrameMap frameMap, Assembler asm, DataBuilder dataBuilder, FrameContext frameContext, OptionValues options, DebugContext debug, CompilationResult compilationResult, Register uncompressedNullRegister) {
        this(providers, frameMap, asm, dataBuilder, frameContext, options, debug, compilationResult, uncompressedNullRegister, (EconomicMap<Constant, DataSection.Data>)EconomicMap.create((Equivalence)Equivalence.DEFAULT));
    }

    public CompilationResultBuilder(CodeGenProviders providers, FrameMap frameMap, Assembler asm, DataBuilder dataBuilder, FrameContext frameContext, OptionValues options, DebugContext debug, CompilationResult compilationResult, Register uncompressedNullRegister, EconomicMap<Constant, DataSection.Data> dataCache) {
        this.target = providers.getCodeCache().getTarget();
        this.providers = providers;
        this.codeCache = providers.getCodeCache();
        this.foreignCalls = providers.getForeignCalls();
        this.frameMap = frameMap;
        this.asm = asm;
        this.dataBuilder = dataBuilder;
        this.compilationResult = compilationResult;
        this.uncompressedNullRegister = uncompressedNullRegister;
        this.frameContext = frameContext;
        this.options = options;
        this.debug = debug;
        assert (frameContext != null);
        this.dataCache = dataCache;
    }

    public void setTotalFrameSize(int frameSize) {
        this.compilationResult.setTotalFrameSize(frameSize);
    }

    public void setMaxInterpreterFrameSize(int maxInterpreterFrameSize) {
        this.compilationResult.setMaxInterpreterFrameSize(maxInterpreterFrameSize);
    }

    public CompilationResult.CodeMark recordMark(CompilationResult.MarkId id) {
        CompilationResult.CodeMark mark = this.compilationResult.recordMark(this.asm.position(), id);
        if (this.currentCallContext != null) {
            this.currentCallContext.recordMark(mark);
        }
        return mark;
    }

    public void blockComment(String s) {
        this.compilationResult.addAnnotation(new CompilationResult.CodeComment(this.asm.position(), s));
    }

    public void finish() {
        int position = this.asm.position();
        this.compilationResult.setTargetCode(this.asm.close(false), position);
        if (this.exceptionInfoList != null) {
            for (ExceptionInfo ei : this.exceptionInfoList) {
                int codeOffset = ei.codeOffset;
                this.compilationResult.recordExceptionHandler(codeOffset, ei.exceptionEdge.label().position());
            }
        }
        this.closeCompilationResult();
    }

    protected void closeCompilationResult() {
        this.compilationResult.close();
    }

    public void recordExceptionHandlers(int pcOffset, LIRFrameState info) {
        if (info != null && info.exceptionEdge != null) {
            if (this.exceptionInfoList == null) {
                this.exceptionInfoList = new ArrayList<ExceptionInfo>(4);
            }
            this.exceptionInfoList.add(new ExceptionInfo(pcOffset, info.exceptionEdge));
        }
    }

    public void recordImplicitException(int pcOffset, LIRFrameState info) {
        if (GraalServices.supportsArbitraryImplicitException() && info instanceof ImplicitLIRFrameState) {
            if (this.pendingImplicitExceptionList == null) {
                this.pendingImplicitExceptionList = new ArrayList<PendingImplicitException>(4);
            }
            this.pendingImplicitExceptionList.add(new PendingImplicitException(pcOffset, (ImplicitLIRFrameState)info));
        } else {
            this.recordImplicitException(pcOffset, pcOffset, info);
        }
    }

    public void recordImplicitException(int pcOffset, int dispatchOffset, LIRFrameState info) {
        this.compilationResult.recordImplicitException(pcOffset, dispatchOffset, info.debugInfo());
        assert (info.exceptionEdge == null);
    }

    public boolean isImplicitExceptionExist(int pcOffset) {
        List<Infopoint> infopoints = this.compilationResult.getInfopoints();
        for (Infopoint infopoint : infopoints) {
            if (infopoint.pcOffset != pcOffset || infopoint.reason != InfopointReason.IMPLICIT_EXCEPTION) continue;
            return true;
        }
        if (this.pendingImplicitExceptionList != null) {
            for (PendingImplicitException pendingImplicitException : this.pendingImplicitExceptionList) {
                if (pendingImplicitException.codeOffset != pcOffset) continue;
                return true;
            }
        }
        return false;
    }

    public void recordDirectCall(int posBefore, int posAfter, InvokeTarget callTarget, LIRFrameState info) {
        DebugInfo debugInfo = info != null ? info.debugInfo() : null;
        Call call = this.compilationResult.recordCall(posBefore, posAfter - posBefore, callTarget, debugInfo, true);
        if (this.currentCallContext != null) {
            this.currentCallContext.recordCall(call);
        }
    }

    public void recordIndirectCall(int posBefore, int posAfter, InvokeTarget callTarget, LIRFrameState info) {
        DebugInfo debugInfo = info != null ? info.debugInfo() : null;
        this.compilationResult.recordCall(posBefore, posAfter - posBefore, callTarget, debugInfo, false);
    }

    public void recordInfopoint(int pos, LIRFrameState info, InfopointReason reason) {
        DebugInfo debugInfo = info.debugInfo();
        this.recordInfopoint(pos, debugInfo, reason);
    }

    public void recordInfopoint(int pos, DebugInfo debugInfo, InfopointReason reason) {
        this.compilationResult.recordInfopoint(pos, debugInfo, reason);
    }

    public void recordSourceMapping(int pcOffset, int endPcOffset, NodeSourcePosition sourcePosition) {
        this.compilationResult.recordSourceMapping(pcOffset, endPcOffset, sourcePosition);
    }

    public void recordInlineDataInCode(Constant data) {
        assert (data != null);
        int pos = this.asm.position();
        this.debug.log("Inline data in code: pos = %d, data = %s", pos, (Object)data);
        if (data instanceof VMConstant) {
            this.compilationResult.recordDataPatch(pos, (Reference)new ConstantReference((VMConstant)data));
        }
    }

    public void recordInlineDataInCodeWithNote(Constant data, Object note) {
        assert (data != null);
        int pos = this.asm.position();
        this.debug.log("Inline data in code: pos = %d, data = %s, note = %s", (Object)pos, (Object)data, note);
        if (data instanceof VMConstant) {
            this.compilationResult.recordDataPatchWithNote(pos, (Reference)new ConstantReference((VMConstant)data), note);
        }
    }

    public AbstractAddress recordDataSectionReference(DataSection.Data data) {
        assert (data != null);
        DataSectionReference reference = this.compilationResult.getDataSection().insertData(data);
        int instructionStart = this.asm.position();
        this.compilationResult.recordDataPatch(instructionStart, (Reference)reference);
        return this.asm.getPlaceholder(instructionStart);
    }

    public AbstractAddress recordDataReferenceInCode(DataPointerConstant constant) {
        return this.recordDataReferenceInCode((Constant)constant, constant.getAlignment());
    }

    public AbstractAddress recordDataReferenceInCode(Constant constant, int alignment) {
        assert (constant != null);
        this.debug.log("Constant reference in code: pos = %d, data = %s", this.asm.position(), (Object)constant);
        DataSection.Data data = this.createDataItem(constant);
        data.updateAlignment(alignment);
        return this.recordDataSectionReference(data);
    }

    public AbstractAddress recordDataReferenceInCode(DataSection.Data data, int alignment) {
        assert (data != null);
        data.updateAlignment(alignment);
        return this.recordDataSectionReference(data);
    }

    public DataSection.Data createDataItem(Constant constant) {
        DataSection.Data data = (DataSection.Data)this.dataCache.get((Object)constant);
        if (data == null) {
            data = this.dataBuilder.createDataItem(constant);
            this.dataCache.put((Object)constant, (Object)data);
        }
        return data;
    }

    public AbstractAddress recordDataReferenceInCode(byte[] data, int alignment) {
        assert (data != null);
        if (this.debug.isLogEnabled()) {
            this.debug.log("Data reference in code: pos = %d, data = %s", this.asm.position(), (Object)Arrays.toString(data));
        }
        return this.recordDataSectionReference(new DataSection.RawData(data, alignment));
    }

    public int asIntConst(Value value) {
        assert (LIRValueUtil.isJavaConstant(value) && LIRValueUtil.asJavaConstant(value).getJavaKind().isNumericInteger());
        JavaConstant constant = LIRValueUtil.asJavaConstant(value);
        long c = constant.asLong();
        if (!NumUtil.isInt(c)) {
            throw GraalError.shouldNotReachHere();
        }
        return (int)c;
    }

    public float asFloatConst(Value value) {
        assert (LIRValueUtil.isJavaConstant(value) && LIRValueUtil.asJavaConstant(value).getJavaKind() == JavaKind.Float);
        JavaConstant constant = LIRValueUtil.asJavaConstant(value);
        return constant.asFloat();
    }

    public long asLongConst(Value value) {
        assert (LIRValueUtil.isJavaConstant(value) && LIRValueUtil.asJavaConstant(value).getJavaKind() == JavaKind.Long);
        JavaConstant constant = LIRValueUtil.asJavaConstant(value);
        return constant.asLong();
    }

    public double asDoubleConst(Value value) {
        assert (LIRValueUtil.isJavaConstant(value) && LIRValueUtil.asJavaConstant(value).getJavaKind() == JavaKind.Double);
        JavaConstant constant = LIRValueUtil.asJavaConstant(value);
        return constant.asDouble();
    }

    public AbstractAddress asFloatConstRef(JavaConstant value) {
        return this.asFloatConstRef(value, 4);
    }

    public AbstractAddress asFloatConstRef(JavaConstant value, int alignment) {
        assert (value.getJavaKind() == JavaKind.Float);
        return this.recordDataReferenceInCode((Constant)value, alignment);
    }

    public AbstractAddress asDoubleConstRef(JavaConstant value) {
        return this.asDoubleConstRef(value, 8);
    }

    public AbstractAddress asDoubleConstRef(JavaConstant value, int alignment) {
        assert (value.getJavaKind() == JavaKind.Double);
        return this.recordDataReferenceInCode((Constant)value, alignment);
    }

    public AbstractAddress asLongConstRef(JavaConstant value) {
        assert (value.getJavaKind() == JavaKind.Long);
        return this.recordDataReferenceInCode((Constant)value, 8);
    }

    public AbstractAddress asObjectConstRef(JavaConstant value) {
        assert (value.getJavaKind() == JavaKind.Object);
        return this.recordDataReferenceInCode((Constant)value, 8);
    }

    public AbstractAddress asByteAddr(Value value) {
        assert (value.getPlatformKind().getSizeInBytes() >= JavaKind.Byte.getByteCount());
        return this.asAddress(value);
    }

    public AbstractAddress asShortAddr(Value value) {
        assert (value.getPlatformKind().getSizeInBytes() >= JavaKind.Short.getByteCount());
        return this.asAddress(value);
    }

    public AbstractAddress asIntAddr(Value value) {
        assert (value.getPlatformKind().getSizeInBytes() >= JavaKind.Int.getByteCount());
        return this.asAddress(value);
    }

    public AbstractAddress asLongAddr(Value value) {
        assert (value.getPlatformKind().getSizeInBytes() >= JavaKind.Long.getByteCount());
        return this.asAddress(value);
    }

    public AbstractAddress asFloatAddr(Value value) {
        assert (value.getPlatformKind().getSizeInBytes() >= JavaKind.Float.getByteCount());
        return this.asAddress(value);
    }

    public AbstractAddress asDoubleAddr(Value value) {
        assert (value.getPlatformKind().getSizeInBytes() >= JavaKind.Double.getByteCount());
        return this.asAddress(value);
    }

    public AbstractAddress asAddress(Value value) {
        assert (ValueUtil.isStackSlot((Value)value));
        StackSlot slot = ValueUtil.asStackSlot((Value)value);
        int size = slot.getPlatformKind().getSizeInBytes() * 8;
        return this.asm.makeAddress(size, this.frameMap.getRegisterConfig().getFrameRegister(), this.frameMap.offsetForStackSlot(slot));
    }

    public boolean isSuccessorEdge(LabelRef edge) {
        assert (this.lir != null);
        AbstractBlockBase<?>[] order = this.lir.codeEmittingOrder();
        assert (order[this.currentBlockIndex] == edge.getSourceBlock());
        AbstractBlockBase<?> nextBlock = LIR.getNextBlock(order, this.currentBlockIndex);
        return nextBlock == edge.getTargetBlock();
    }

    public void emit(LIR lir) {
        assert (this.lir == null);
        assert (this.currentBlockIndex == 0);
        this.lir = lir;
        this.currentBlockIndex = 0;
        this.frameContext.enter(this);
        for (AbstractBlockBase<?> b : lir.codeEmittingOrder()) {
            assert (b == null && lir.codeEmittingOrder()[this.currentBlockIndex] == null || lir.codeEmittingOrder()[this.currentBlockIndex].equals(b));
            this.emitBlock(b);
            ++this.currentBlockIndex;
        }
        this.lir = null;
        this.currentBlockIndex = 0;
    }

    private void emitBlock(AbstractBlockBase<?> block) {
        boolean emitComment;
        if (block == null) {
            return;
        }
        boolean bl = emitComment = this.debug.isDumpEnabled(1) || Options.PrintLIRWithAssembly.getValue(this.getOptions()) != false;
        if (emitComment) {
            this.blockComment(String.format("block B%d %s", block.getId(), block.getLoop()));
        }
        for (LIRInstruction op : this.lir.getLIRforBlock(block)) {
            if (emitComment) {
                this.blockComment(String.format("%d %s", op.id(), op));
            }
            try {
                if (this.beforeOp != null) {
                    this.beforeOp.accept(op);
                }
                this.emitOp(op);
                if (this.afterOp == null) continue;
                this.afterOp.accept(op);
            }
            catch (GraalError e) {
                throw e.addContext("lir instruction", block + "@" + op.id() + " " + op.getClass().getName() + " " + op + "\n" + Arrays.toString(this.lir.codeEmittingOrder()));
            }
        }
    }

    private void emitOp(LIRInstruction op) {
        try {
            int start = this.asm.position();
            op.emitCode(this);
            if (op.getPosition() != null) {
                this.recordSourceMapping(start, this.asm.position(), op.getPosition());
            }
            if (LIR_INSTRUCTION_VERIFIERS.size() > 0 && start < this.asm.position()) {
                int end = this.asm.position();
                for (CompilationResult.CodeAnnotation codeAnnotation : this.compilationResult.getCodeAnnotations()) {
                    int jumpTableStart;
                    if (!(codeAnnotation instanceof CompilationResult.JumpTable) || (jumpTableStart = codeAnnotation.getPosition()) < start || jumpTableStart >= end) continue;
                    end = jumpTableStart;
                }
                byte[] emittedCode = this.asm.copy(start, end);
                for (LIRInstructionVerifier verifier : LIR_INSTRUCTION_VERIFIERS) {
                    verifier.verify(op, emittedCode);
                }
            }
        }
        catch (BailoutException e) {
            throw e;
        }
        catch (AssertionError t) {
            throw new GraalError((Throwable)((Object)t));
        }
        catch (RuntimeException t) {
            throw new GraalError(t);
        }
    }

    public void resetForEmittingCode() {
        this.asm.reset();
        this.compilationResult.resetForEmittingCode();
        if (this.exceptionInfoList != null) {
            this.exceptionInfoList.clear();
        }
        if (this.pendingImplicitExceptionList != null) {
            this.pendingImplicitExceptionList.clear();
        }
        if (this.dataCache != null) {
            this.dataCache.clear();
        }
        this.lir = null;
        this.currentBlockIndex = 0;
    }

    public void setOpCallback(Consumer<LIRInstruction> beforeOp, Consumer<LIRInstruction> afterOp) {
        this.beforeOp = beforeOp;
        this.afterOp = afterOp;
    }

    public OptionValues getOptions() {
        return this.options;
    }

    public void buildLabelOffsets(LIR generatedLIR) {
        this.labelBindLirPositions = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        this.lirPositions = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        int instructionPosition = 0;
        for (AbstractBlockBase<?> block : generatedLIR.codeEmittingOrder()) {
            if (block == null) continue;
            for (LIRInstruction op : generatedLIR.getLIRforBlock(block)) {
                Label label;
                if (op instanceof StandardOp.LabelHoldingOp && (label = ((StandardOp.LabelHoldingOp)((Object)op)).getLabel()) != null) {
                    this.labelBindLirPositions.put((Object)label, (Object)instructionPosition);
                }
                this.lirPositions.put((Object)op, (Object)instructionPosition);
                ++instructionPosition;
            }
        }
    }

    public boolean labelWithinRange(LIRInstruction instruction, Label label, int disp) {
        if (this.conservativeLabelOffsets) {
            return false;
        }
        Integer labelPosition = (Integer)this.labelBindLirPositions.get((Object)label);
        Integer instructionPosition = (Integer)this.lirPositions.get((Object)instruction);
        boolean result = labelPosition != null && instructionPosition != null ? Math.abs(labelPosition - instructionPosition) < disp : false;
        return result;
    }

    public void setConservativeLabelRanges() {
        this.conservativeLabelOffsets = true;
    }

    public final boolean needsClearUpperVectorRegisters() {
        for (AbstractBlockBase<?> block : this.lir.codeEmittingOrder()) {
            if (block == null) continue;
            for (LIRInstruction op : this.lir.getLIRforBlock(block)) {
                if (!op.needsClearUpperVectorRegisters()) continue;
                return true;
            }
        }
        return false;
    }

    public CallContext openCallContext(boolean direct) {
        if (this.currentCallContext != null) {
            throw GraalError.shouldNotReachHere("Call context already open");
        }
        if (this.compilationResult.isImmutablePIC() && direct) {
            this.currentCallContext = new CallContext();
        }
        return this.currentCallContext;
    }

    public void setNeedsMHDeoptHandler() {
        this.needsMHDeoptHandler = true;
    }

    public boolean needsMHDeoptHandler() {
        return this.needsMHDeoptHandler;
    }

    public List<PendingImplicitException> getPendingImplicitExceptionList() {
        return this.pendingImplicitExceptionList;
    }

    static {
        for (LIRInstructionVerifier verifier : GraalServices.load(LIRInstructionVerifier.class)) {
            if (!verifier.isEnabled()) continue;
            LIR_INSTRUCTION_VERIFIERS.add(verifier);
        }
    }

    public final class CallContext
    implements AutoCloseable {
        private CompilationResult.CodeMark mark;
        private Call call;

        @Override
        public void close() {
            CompilationResultBuilder.this.currentCallContext = null;
            CompilationResultBuilder.this.compilationResult.recordCallContext(this.mark, this.call);
        }

        void recordCall(Call c) {
            assert (this.call == null) : "Recording call twice";
            this.call = c;
        }

        void recordMark(CompilationResult.CodeMark m) {
            assert (this.mark == null) : "Recording mark twice";
            this.mark = m;
        }
    }

    public static class PendingImplicitException {
        public final int codeOffset;
        public final ImplicitLIRFrameState state;

        PendingImplicitException(int pcOffset, ImplicitLIRFrameState state) {
            this.codeOffset = pcOffset;
            this.state = state;
        }
    }

    private static class ExceptionInfo {
        public final int codeOffset;
        public final LabelRef exceptionEdge;

        ExceptionInfo(int pcOffset, LabelRef exceptionEdge) {
            this.codeOffset = pcOffset;
            this.exceptionEdge = exceptionEdge;
        }
    }

    public static class Options {
        @Option(help={"Include the LIR as comments with the final assembly."}, type=OptionType.Debug)
        public static final OptionKey<Boolean> PrintLIRWithAssembly = new OptionKey<Boolean>(false);
    }
}

