/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra.ssa;

import java.util.Arrays;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.alloc.lsra.Interval;
import org.graalvm.compiler.lir.alloc.lsra.LinearScan;
import org.graalvm.compiler.lir.alloc.lsra.MoveResolver;
import org.graalvm.compiler.lir.framemap.FrameMap;
import org.graalvm.compiler.lir.framemap.FrameMapBuilderTool;

public final class SSAMoveResolver
extends MoveResolver {
    private static final int STACK_SLOT_IN_CALLER_FRAME_IDX = -1;
    private int[] stackBlocked;
    private final int firstVirtualStackIndex;

    public SSAMoveResolver(LinearScan allocator) {
        super(allocator);
        FrameMapBuilderTool frameMapBuilderTool = (FrameMapBuilderTool)allocator.getFrameMapBuilder();
        FrameMap frameMap = frameMapBuilderTool.getFrameMap();
        this.stackBlocked = new int[frameMapBuilderTool.getNumberOfStackSlots()];
        this.firstVirtualStackIndex = !frameMap.frameNeedsAllocating() ? 0 : frameMap.currentFrameSize() + 1;
    }

    @Override
    public boolean checkEmpty() {
        for (int i = 0; i < this.stackBlocked.length; ++i) {
            assert (this.stackBlocked[i] == 0) : "stack map must be empty before and after processing";
        }
        return super.checkEmpty();
    }

    @Override
    protected void checkMultipleReads() {
    }

    @Override
    protected void verifyStackSlotMapping() {
    }

    @Override
    protected boolean areMultipleReadsAllowed() {
        return true;
    }

    @Override
    protected boolean mightBeBlocked(Value location) {
        if (super.mightBeBlocked(location)) {
            return true;
        }
        return LIRValueUtil.isStackSlotValue(location);
    }

    private int getStackArrayIndex(Value stackSlotValue) {
        if (ValueUtil.isStackSlot((Value)stackSlotValue)) {
            return this.getStackArrayIndex(ValueUtil.asStackSlot((Value)stackSlotValue));
        }
        if (LIRValueUtil.isVirtualStackSlot(stackSlotValue)) {
            return this.getStackArrayIndex(LIRValueUtil.asVirtualStackSlot(stackSlotValue));
        }
        throw GraalError.shouldNotReachHere("value is not a stack slot: " + stackSlotValue);
    }

    private int getStackArrayIndex(StackSlot stackSlot) {
        int stackIdx;
        if (stackSlot.isInCallerFrame()) {
            stackIdx = -1;
        } else {
            assert (stackSlot.getRawAddFrameSize()) : "Unexpected stack slot: " + stackSlot;
            int offset = -stackSlot.getRawOffset();
            assert (0 <= offset && offset < this.firstVirtualStackIndex) : String.format("Wrong stack slot offset: %d (first virtual stack slot index: %d", offset, this.firstVirtualStackIndex);
            stackIdx = offset;
        }
        return stackIdx;
    }

    private int getStackArrayIndex(VirtualStackSlot virtualStackSlot) {
        return this.firstVirtualStackIndex + virtualStackSlot.getId();
    }

    @Override
    protected void setValueBlocked(Value location, int direction) {
        assert (direction == 1 || direction == -1) : "out of bounds";
        if (LIRValueUtil.isStackSlotValue(location)) {
            int stackIdx = this.getStackArrayIndex(location);
            if (stackIdx == -1) {
                return;
            }
            if (stackIdx >= this.stackBlocked.length) {
                this.stackBlocked = Arrays.copyOf(this.stackBlocked, stackIdx + 1);
            }
            int n = stackIdx;
            this.stackBlocked[n] = this.stackBlocked[n] + direction;
        } else {
            super.setValueBlocked(location, direction);
        }
    }

    @Override
    protected int valueBlocked(Value location) {
        if (LIRValueUtil.isStackSlotValue(location)) {
            int stackIdx = this.getStackArrayIndex(location);
            if (stackIdx == -1) {
                return 1;
            }
            if (stackIdx >= this.stackBlocked.length) {
                return 0;
            }
            return this.stackBlocked[stackIdx];
        }
        return super.valueBlocked(location);
    }

    @Override
    protected LIRInstruction createMove(AllocatableValue fromOpr, AllocatableValue toOpr, AllocatableValue fromLocation, AllocatableValue toLocation) {
        if (LIRValueUtil.isStackSlotValue((Value)toLocation) && LIRValueUtil.isStackSlotValue((Value)fromLocation)) {
            return this.getAllocator().getSpillMoveFactory().createStackMove(toOpr, fromOpr);
        }
        return super.createMove(fromOpr, toOpr, fromLocation, toLocation);
    }

    @Override
    protected void breakCycle(int spillCandidate) {
        if (spillCandidate != -1) {
            super.breakCycle(spillCandidate);
            return;
        }
        assert (this.mappingFromSize() > 1);
        int stackSpillCandidate = 0;
        Interval fromInterval = this.getMappingFrom(stackSpillCandidate);
        VirtualStackSlot spillSlot = this.getAllocator().getFrameMapBuilder().allocateSpillSlot(fromInterval.kind());
        this.spillInterval(stackSpillCandidate, fromInterval, spillSlot);
    }
}

