/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra;

import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.AllocationPhase;
import org.graalvm.compiler.lir.phases.LIRPhase;

abstract class LinearScanAllocationPhase {
    LinearScanAllocationPhase() {
    }

    final CharSequence getName() {
        return LIRPhase.createName(this.getClass());
    }

    public final String toString() {
        return this.getName().toString();
    }

    public final void apply(TargetDescription target, LIRGenerationResult lirGenRes, AllocationPhase.AllocationContext context) {
        this.apply(target, lirGenRes, context, true);
    }

    public final void apply(TargetDescription target, LIRGenerationResult lirGenRes, AllocationPhase.AllocationContext context, boolean dumpLIR) {
        DebugContext debug = lirGenRes.getLIR().getDebug();
        CharSequence name = this.getName();
        try (DebugContext.Scope s = debug.scope((Object)name, this);
             DebugContext.CompilerPhaseScope cps = debug.enterCompilerPhase(name);){
            this.run(target, lirGenRes, context);
            if (dumpLIR && debug.isDumpEnabled(3)) {
                debug.dump(3, (Object)lirGenRes.getLIR(), "After %s", name);
            }
        }
        catch (Throwable e) {
            throw debug.handle(e);
        }
    }

    protected abstract void run(TargetDescription var1, LIRGenerationResult var2, AllocationPhase.AllocationContext var3);
}

