/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AArch64Compare {
    public static void gpCompare(AArch64MacroAssembler masm, Value x, Value y) {
        int size = x.getPlatformKind().getSizeInBytes() * 8;
        if (ValueUtil.isRegister((Value)y)) {
            masm.cmp(size, ValueUtil.asRegister((Value)x), ValueUtil.asRegister((Value)y));
        } else {
            JavaConstant constant = LIRValueUtil.asJavaConstant(y);
            if (constant.isDefaultForKind()) {
                masm.cmp(size, ValueUtil.asRegister((Value)x), 0);
            } else {
                int maskedValue;
                long longValue = constant.asLong();
                assert (NumUtil.isInt(longValue));
                switch (constant.getJavaKind()) {
                    case Boolean: 
                    case Byte: {
                        maskedValue = (int)(longValue & 0xFFL);
                        break;
                    }
                    case Char: 
                    case Short: {
                        maskedValue = (int)(longValue & 0xFFFFL);
                        break;
                    }
                    case Int: 
                    case Long: {
                        maskedValue = (int)longValue;
                        break;
                    }
                    default: {
                        throw GraalError.shouldNotReachHere();
                    }
                }
                masm.cmp(size, ValueUtil.asRegister((Value)x), maskedValue);
            }
        }
    }

    public static class ASIMDFloatCompareOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<ASIMDFloatCompareOp> TYPE = LIRInstructionClass.create(ASIMDFloatCompareOp.class);
        @Opcode
        private final Condition condition;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue y;

        public ASIMDFloatCompareOp(Condition condition, AllocatableValue result, AllocatableValue x, AllocatableValue y) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            assert (x.getPlatformKind() == y.getPlatformKind()) : x.getPlatformKind() + " " + y.getPlatformKind();
            this.condition = condition;
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind());
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register left = ValueUtil.asRegister((Value)this.x);
            Register right = ValueUtil.asRegister((Value)this.y);
            switch (this.condition) {
                case EQ: {
                    masm.neon.fcmeqVVV(size, eSize, dst, left, right);
                    break;
                }
                case NE: {
                    masm.neon.fcmeqVVV(size, eSize, dst, left, right);
                    masm.neon.mvnVV(size, dst, dst);
                    break;
                }
                case LT: {
                    masm.neon.fcmgtVVV(size, eSize, dst, right, left);
                    break;
                }
                case LE: {
                    masm.neon.fcmgeVVV(size, eSize, dst, right, left);
                    break;
                }
                case GT: {
                    masm.neon.fcmgtVVV(size, eSize, dst, left, right);
                    break;
                }
                case GE: {
                    masm.neon.fcmgeVVV(size, eSize, dst, left, right);
                    break;
                }
                default: {
                    throw GraalError.unimplemented();
                }
            }
        }
    }

    public static class ASIMDCompareOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<ASIMDCompareOp> TYPE = LIRInstructionClass.create(ASIMDCompareOp.class);
        @Opcode
        private final Condition condition;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue y;

        public ASIMDCompareOp(Condition condition, AllocatableValue result, AllocatableValue x, AllocatableValue y) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            assert (x.getPlatformKind() == y.getPlatformKind()) : x.getPlatformKind() + " " + y.getPlatformKind();
            this.condition = condition;
            this.result = result;
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.result.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize eSize = AArch64ASIMDAssembler.ElementSize.fromKind(this.result.getPlatformKind());
            Register dst = ValueUtil.asRegister((Value)this.result);
            Register left = ValueUtil.asRegister((Value)this.x);
            Register right = ValueUtil.asRegister((Value)this.y);
            switch (this.condition) {
                case EQ: {
                    masm.neon.cmeqVVV(size, eSize, dst, left, right);
                    break;
                }
                case NE: {
                    masm.neon.cmeqVVV(size, eSize, dst, left, right);
                    masm.neon.mvnVV(size, dst, dst);
                    break;
                }
                case LT: {
                    masm.neon.cmgtVVV(size, eSize, dst, right, left);
                    break;
                }
                case LE: {
                    masm.neon.cmgeVVV(size, eSize, dst, right, left);
                    break;
                }
                case GT: {
                    masm.neon.cmgtVVV(size, eSize, dst, left, right);
                    break;
                }
                case GE: {
                    masm.neon.cmgeVVV(size, eSize, dst, left, right);
                    break;
                }
                case BT: {
                    masm.neon.cmhiVVV(size, eSize, dst, right, left);
                    break;
                }
                case BE: {
                    masm.neon.cmhsVVV(size, eSize, dst, right, left);
                    break;
                }
                case AT: {
                    masm.neon.cmhiVVV(size, eSize, dst, left, right);
                    break;
                }
                case AE: {
                    masm.neon.cmhsVVV(size, eSize, dst, left, right);
                    break;
                }
                default: {
                    throw GraalError.unimplemented();
                }
            }
        }
    }

    public static class FloatCompareOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<FloatCompareOp> TYPE = LIRInstructionClass.create(FloatCompareOp.class);
        @LIRInstruction.Use
        protected Value x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
        protected Value y;
        private final Condition condition;
        private final boolean unorderedIsTrue;

        public FloatCompareOp(Value x, Value y, Condition condition, boolean unorderedIsTrue) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            assert (!LIRValueUtil.isJavaConstant(y) || FloatCompareOp.isFloatCmpConstant(y, condition, unorderedIsTrue));
            this.x = x;
            this.y = y;
            this.condition = condition;
            this.unorderedIsTrue = unorderedIsTrue;
        }

        public static boolean isFloatCmpConstant(Value val, Condition condition, boolean unorderedIsTrue) {
            if (!(condition == Condition.EQ && unorderedIsTrue || condition == Condition.NE && !unorderedIsTrue)) {
                return false;
            }
            return LIRValueUtil.isJavaConstant(val) && LIRValueUtil.asJavaConstant(val).isDefaultForKind();
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            assert (ValueUtil.isRegister((Value)this.x));
            int size = this.x.getPlatformKind().getSizeInBytes() * 8;
            if (ValueUtil.isRegister((Value)this.y)) {
                masm.fcmp(size, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y));
                if (this.condition == Condition.EQ && this.unorderedIsTrue) {
                    int nzcv = 4;
                    masm.fccmp(size, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y), nzcv, AArch64Assembler.ConditionFlag.VC);
                } else if (this.condition == Condition.NE && !this.unorderedIsTrue) {
                    int nzcv = 4;
                    masm.fccmp(size, ValueUtil.asRegister((Value)this.x), ValueUtil.asRegister((Value)this.y), nzcv, AArch64Assembler.ConditionFlag.VC);
                }
            } else {
                masm.fcmpZero(size, ValueUtil.asRegister((Value)this.x));
            }
        }

        @Override
        public void verify() {
            assert (this.x.getPlatformKind().equals(this.y.getPlatformKind())) : "a: " + this.x + " b: " + this.y;
        }
    }

    public static class CompareOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<CompareOp> TYPE = LIRInstructionClass.create(CompareOp.class);
        @LIRInstruction.Use
        protected Value x;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
        protected Value y;

        public CompareOp(Value x, Value y) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            assert (x.getPlatformKind() == y.getPlatformKind()) : x.getPlatformKind() + " " + y.getPlatformKind();
            this.x = x;
            this.y = y;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64Compare.gpCompare(masm, this.x, this.y);
        }
    }
}

