/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64Compare;
import org.graalvm.compiler.lir.aarch64.AArch64LIRFlags;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AArch64AtomicMove {

    @Opcode(value="ATOMIC_READ_AND_WRITE")
    public static final class AtomicReadAndWriteOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<AtomicReadAndWriteOp> TYPE = LIRInstructionClass.create(AtomicReadAndWriteOp.class);
        private final AArch64Kind accessKind;
        @LIRInstruction.Def
        protected AllocatableValue resultValue;
        @LIRInstruction.Alive
        protected AllocatableValue addressValue;
        @LIRInstruction.Alive
        protected AllocatableValue newValue;
        @LIRInstruction.Temp
        protected AllocatableValue scratchValue;

        public AtomicReadAndWriteOp(AArch64Kind kind, AllocatableValue result, AllocatableValue address, AllocatableValue newValue, AllocatableValue scratch) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.accessKind = kind;
            this.resultValue = result;
            this.addressValue = address;
            this.newValue = newValue;
            this.scratchValue = scratch;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            assert (this.accessKind.isInteger());
            int memAccessSize = this.accessKind.getSizeInBytes() * 8;
            Register address = ValueUtil.asRegister((Value)this.addressValue);
            Register value = ValueUtil.asRegister((Value)this.newValue);
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            if (AArch64LIRFlags.useLSE(masm.target.arch)) {
                masm.swp(memAccessSize, value, result, address, true, true);
            } else {
                Register scratch = ValueUtil.asRegister((Value)this.scratchValue);
                Label retry = new Label();
                masm.bind(retry);
                masm.loadExclusive(memAccessSize, result, address, false);
                masm.storeExclusive(memAccessSize, scratch, value, address, true);
                masm.cbnz(32, scratch, retry);
                masm.dmb(AArch64Assembler.BarrierKind.ANY_ANY);
            }
        }
    }

    @Opcode(value="ATOMIC_READ_AND_ADD")
    public static final class AtomicReadAndAddLSEOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<AtomicReadAndAddLSEOp> TYPE = LIRInstructionClass.create(AtomicReadAndAddLSEOp.class);
        private final AArch64Kind accessKind;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue resultValue;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue addressValue;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue deltaValue;

        public AtomicReadAndAddLSEOp(AArch64Kind kind, AllocatableValue result, AllocatableValue address, AllocatableValue delta) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.accessKind = kind;
            this.resultValue = result;
            this.addressValue = address;
            this.deltaValue = delta;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            assert (this.accessKind.isInteger());
            int memAccessSize = this.accessKind.getSizeInBytes() * 8;
            Register address = ValueUtil.asRegister((Value)this.addressValue);
            Register delta = ValueUtil.asRegister((Value)this.deltaValue);
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            masm.ldadd(memAccessSize, delta, result, address, true, true);
        }
    }

    @Opcode(value="ATOMIC_READ_AND_ADD")
    public static final class AtomicReadAndAddOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<AtomicReadAndAddOp> TYPE = LIRInstructionClass.create(AtomicReadAndAddOp.class);
        private final AArch64Kind accessKind;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue resultValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue addressValue;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
        protected Value deltaValue;

        public AtomicReadAndAddOp(AArch64Kind kind, AllocatableValue result, AllocatableValue address, Value delta) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.accessKind = kind;
            this.resultValue = result;
            this.addressValue = address;
            this.deltaValue = delta;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            assert (this.accessKind.isInteger());
            int memAccessSize = this.accessKind.getSizeInBytes() * 8;
            int addSize = Math.max(memAccessSize, 32);
            Register address = ValueUtil.asRegister((Value)this.addressValue);
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            Label retry = new Label();
            masm.bind(retry);
            masm.loadExclusive(memAccessSize, result, address, false);
            try (AArch64MacroAssembler.ScratchRegister scratchRegister1 = masm.getScratchRegister();){
                Register scratch1 = scratchRegister1.getRegister();
                if (LIRValueUtil.isConstantValue(this.deltaValue)) {
                    long delta = LIRValueUtil.asConstantValue(this.deltaValue).getJavaConstant().asLong();
                    masm.add(addSize, scratch1, result, delta);
                } else {
                    masm.add(addSize, scratch1, result, ValueUtil.asRegister((Value)this.deltaValue));
                }
                try (AArch64MacroAssembler.ScratchRegister scratchRegister2 = masm.getScratchRegister();){
                    Register scratch2 = scratchRegister2.getRegister();
                    masm.storeExclusive(memAccessSize, scratch2, scratch1, address, true);
                    masm.cbnz(32, scratch2, retry);
                }
            }
            masm.dmb(AArch64Assembler.BarrierKind.ANY_ANY);
        }
    }

    @Opcode(value="CAS")
    public static class CompareAndSwapOp
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<CompareAndSwapOp> TYPE = LIRInstructionClass.create(CompareAndSwapOp.class);
        private final AArch64Kind accessKind;
        private final MemoryOrderMode memoryOrder;
        @LIRInstruction.Def
        protected AllocatableValue resultValue;
        @LIRInstruction.Alive
        protected Value expectedValue;
        @LIRInstruction.Alive
        protected AllocatableValue newValue;
        @LIRInstruction.Alive
        protected AllocatableValue addressValue;
        @LIRInstruction.Temp
        protected AllocatableValue scratchValue;

        public CompareAndSwapOp(AArch64Kind accessKind, AllocatableValue result, Value expectedValue, AllocatableValue newValue, AllocatableValue addressValue, AllocatableValue scratch, MemoryOrderMode memoryOrder) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.accessKind = accessKind;
            this.resultValue = result;
            this.expectedValue = expectedValue;
            this.newValue = newValue;
            this.addressValue = addressValue;
            this.scratchValue = scratch;
            this.memoryOrder = memoryOrder;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            boolean release;
            assert (this.accessKind.isInteger());
            int memAccessSize = this.accessKind.getSizeInBytes() * 8;
            Register address = ValueUtil.asRegister((Value)this.addressValue);
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            Register newVal = ValueUtil.asRegister((Value)this.newValue);
            Register expected = ValueUtil.asRegister((Value)this.expectedValue);
            boolean acquire = (this.memoryOrder.postWriteBarriers & 0xC) != 0 || (this.memoryOrder.postReadBarriers & 3) != 0;
            boolean bl = release = (this.memoryOrder.preWriteBarriers & 0xA) != 0 || (this.memoryOrder.preReadBarriers & 5) != 0;
            if (AArch64LIRFlags.useLSE(masm.target.arch)) {
                masm.mov(Math.max(memAccessSize, 32), result, expected);
                masm.cas(memAccessSize, result, newVal, address, acquire, release);
                AArch64Compare.gpCompare(masm, (Value)this.resultValue, this.expectedValue);
            } else {
                if (release) {
                    masm.dmb(AArch64Assembler.BarrierKind.ANY_ANY);
                }
                Register scratch = ValueUtil.asRegister((Value)this.scratchValue);
                Label retry = new Label();
                Label fail = new Label();
                masm.bind(retry);
                masm.loadExclusive(memAccessSize, result, address, acquire);
                AArch64Compare.gpCompare(masm, (Value)this.resultValue, this.expectedValue);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, fail);
                masm.storeExclusive(memAccessSize, scratch, newVal, address, release);
                masm.cbnz(32, scratch, retry);
                masm.bind(fail);
            }
        }
    }
}

