/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="ARRAY_EQUALS")
public final class AArch64ArrayEqualsOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64ArrayEqualsOp> TYPE = LIRInstructionClass.create(AArch64ArrayEqualsOp.class);
    private final JavaKind kind;
    private final int array1BaseOffset;
    private final int array2BaseOffset;
    private final int arrayIndexScale;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value array1Value;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value array2Value;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value lengthValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp3;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp4;
    private static final int VECTOR_SIZE = 8;

    public AArch64ArrayEqualsOp(LIRGeneratorTool tool, JavaKind kind, int array1BaseOffset, int array2BaseOffset, Value result, Value array1, Value array2, Value length, boolean directPointers) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        assert (!kind.isNumericFloat()) : "Float arrays comparison (bitwise_equal || both_NaN) isn't supported";
        this.kind = kind;
        this.array1BaseOffset = directPointers ? 0 : array1BaseOffset;
        this.array2BaseOffset = directPointers ? 0 : array2BaseOffset;
        this.arrayIndexScale = tool.getProviders().getMetaAccess().getArrayIndexScale(kind);
        this.resultValue = result;
        this.array1Value = array1;
        this.array2Value = array2;
        this.lengthValue = length;
        this.temp1 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
        this.temp2 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
        this.temp3 = tool.newVariable(LIRKind.value(tool.target().arch.getWordKind()));
        this.temp4 = tool.newVariable(LIRKind.value(tool.target().arch.getWordKind()));
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register array1 = ValueUtil.asRegister((Value)this.temp1);
        Register array2 = ValueUtil.asRegister((Value)this.temp2);
        Register length = ValueUtil.asRegister((Value)this.temp3);
        Label breakLabel = new Label();
        try (AArch64MacroAssembler.ScratchRegister sc1 = masm.getScratchRegister();){
            Register rscratch1 = sc1.getRegister();
            masm.loadAddress(array1, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, ValueUtil.asRegister((Value)this.array1Value), this.array1BaseOffset));
            masm.loadAddress(array2, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, ValueUtil.asRegister((Value)this.array2Value), this.array2BaseOffset));
            masm.mov(rscratch1, this.arrayIndexScale);
            masm.smaddl(length, ValueUtil.asRegister((Value)this.lengthValue), rscratch1, AArch64.zr);
            masm.mov(64, result, length);
            this.emit8ByteCompare(crb, masm, result, array1, array2, length, breakLabel, rscratch1);
            this.emitTailCompares(masm, result, array1, array2, breakLabel, rscratch1);
            masm.bind(breakLabel);
            masm.cmp(64, rscratch1, AArch64.zr);
            masm.cset(this.resultValue.getPlatformKind().getSizeInBytes() * 8, result, AArch64Assembler.ConditionFlag.EQ);
        }
    }

    private void emit8ByteCompare(CompilationResultBuilder crb, AArch64MacroAssembler masm, Register result, Register array1, Register array2, Register length, Label breakLabel, Register rscratch1) {
        Label loop = new Label();
        Label compareTail = new Label();
        Register temp = ValueUtil.asRegister((Value)this.temp4);
        masm.and(64, result, result, 7L);
        masm.ands(64, length, length, -8L);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, compareTail);
        masm.loadAddress(array1, AArch64Address.createRegisterOffsetAddress(array1, length, false));
        masm.loadAddress(array2, AArch64Address.createRegisterOffsetAddress(array2, length, false));
        masm.sub(64, length, AArch64.zr, length);
        masm.align(crb.target.wordSize * 2);
        masm.bind(loop);
        masm.ldr(64, temp, AArch64Address.createRegisterOffsetAddress(array1, length, false));
        masm.ldr(64, rscratch1, AArch64Address.createRegisterOffsetAddress(array2, length, false));
        masm.eor(64, rscratch1, temp, rscratch1);
        masm.cbnz(64, rscratch1, breakLabel);
        masm.add(64, length, length, 8);
        masm.cbnz(64, length, loop);
        masm.cbz(64, result, breakLabel);
        masm.loadAddress(array1, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, array1, -8));
        masm.loadAddress(array2, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, array2, -8));
        masm.ldr(64, temp, AArch64Address.createRegisterOffsetAddress(array1, result, false));
        masm.ldr(64, rscratch1, AArch64Address.createRegisterOffsetAddress(array2, result, false));
        masm.eor(64, rscratch1, temp, rscratch1);
        masm.jmp(breakLabel);
        masm.bind(compareTail);
    }

    private void emitTailCompares(AArch64MacroAssembler masm, Register result, Register array1, Register array2, Label breakLabel, Register rscratch1) {
        Label compare2Bytes = new Label();
        Label compare1Byte = new Label();
        Label end = new Label();
        Register temp = ValueUtil.asRegister((Value)this.temp4);
        if (this.kind.getByteCount() <= 4) {
            masm.ands(32, AArch64.zr, result, 4L);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, compare2Bytes);
            masm.ldr(32, temp, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, array1, 4));
            masm.ldr(32, rscratch1, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, array2, 4));
            masm.eor(32, rscratch1, temp, rscratch1);
            masm.cbnz(32, rscratch1, breakLabel);
            if (this.kind.getByteCount() <= 2) {
                masm.bind(compare2Bytes);
                masm.ands(32, AArch64.zr, result, 2L);
                masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, compare1Byte);
                masm.ldr(16, temp, AArch64Address.createImmediateAddress(16, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, array1, 2));
                masm.ldr(16, rscratch1, AArch64Address.createImmediateAddress(16, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, array2, 2));
                masm.eor(32, rscratch1, temp, rscratch1);
                masm.cbnz(32, rscratch1, breakLabel);
                if (this.kind.getByteCount() <= 1) {
                    masm.bind(compare1Byte);
                    masm.ands(32, AArch64.zr, result, 1L);
                    masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, end);
                    masm.ldr(8, temp, AArch64Address.createBaseRegisterOnlyAddress(array1));
                    masm.ldr(8, rscratch1, AArch64Address.createBaseRegisterOnlyAddress(array2));
                    masm.eor(32, rscratch1, temp, rscratch1);
                    masm.cbnz(32, rscratch1, breakLabel);
                } else {
                    masm.bind(compare1Byte);
                }
            } else {
                masm.bind(compare2Bytes);
            }
        }
        masm.bind(end);
        masm.mov(64, rscratch1, AArch64.zr);
    }
}

