/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;

@Opcode(value="ARRAY_COMPARE_TO")
public final class AArch64ArrayCompareToOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64ArrayCompareToOp> TYPE = LIRInstructionClass.create(AArch64ArrayCompareToOp.class);
    private final JavaKind kind1;
    private final JavaKind kind2;
    private final int array1BaseOffset;
    private final int array2BaseOffset;
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected Value resultValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value array1Value;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    protected Value array2Value;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value length1Value;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value length2Value;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value length1ValueTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value length2ValueTemp;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp1;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp2;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp3;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp4;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp5;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    protected Value temp6;

    public AArch64ArrayCompareToOp(LIRGeneratorTool tool, JavaKind kind1, JavaKind kind2, int array1BaseOffset, int array2BaseOffset, Value result, Value array1, Value array2, Value length1, Value length2) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.kind1 = kind1;
        this.kind2 = kind2;
        this.array1BaseOffset = array1BaseOffset;
        this.array2BaseOffset = array2BaseOffset;
        this.resultValue = result;
        this.array1Value = array1;
        this.array2Value = array2;
        this.length1Value = length1;
        this.length2Value = length2;
        this.length1ValueTemp = length1;
        this.length2ValueTemp = length2;
        this.temp1 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
        this.temp2 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
        this.temp3 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
        this.temp4 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
        this.temp5 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
        this.temp6 = tool.newVariable(LIRKind.unknownReference(tool.target().arch.getWordKind()));
    }

    @Override
    protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register result = ValueUtil.asRegister((Value)this.resultValue);
        Register length1 = ValueUtil.asRegister((Value)this.length1Value);
        Register length2 = ValueUtil.asRegister((Value)this.length2Value);
        Register array1 = ValueUtil.asRegister((Value)this.temp1);
        Register array2 = ValueUtil.asRegister((Value)this.temp2);
        Register length = ValueUtil.asRegister((Value)this.temp3);
        Register temp = ValueUtil.asRegister((Value)this.temp4);
        Register tailCount = ValueUtil.asRegister((Value)this.temp5);
        Register vecCount = ValueUtil.asRegister((Value)this.temp6);
        Label BREAK_LABEL = new Label();
        Label STRING_DIFFER_LABEL = new Label();
        Label LENGTH_DIFFER_LABEL = new Label();
        Label MAIN_LOOP_LABEL = new Label();
        Label COMPARE_SHORT_LABEL = new Label();
        boolean isLL = this.kind1 == this.kind2 && this.kind1 == JavaKind.Byte;
        boolean isUU = this.kind1 == this.kind2 && this.kind1 == JavaKind.Char;
        boolean isLU = this.kind1 != this.kind2 && this.kind1 == JavaKind.Byte;
        boolean isUL = this.kind1 != this.kind2 && this.kind1 == JavaKind.Char;
        int CHAR_SIZE_BYTES = 1;
        int VECTOR_SIZE_BYTES = 8;
        int VECTOR_COUNT_BYTES = 8;
        if (!isLL) {
            CHAR_SIZE_BYTES = 2;
        }
        if (isLU || isUL) {
            VECTOR_COUNT_BYTES = 4;
        }
        masm.loadAddress(array1, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, ValueUtil.asRegister((Value)this.array1Value), this.array1BaseOffset));
        masm.loadAddress(array2, AArch64Address.createImmediateAddress(64, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, ValueUtil.asRegister((Value)this.array2Value), this.array2BaseOffset));
        if (isLU || isUL) {
            masm.lshr(64, length2, length2, 1L);
        }
        if (isUU) {
            masm.lshr(64, length1, length1, 1L);
            masm.lshr(64, length2, length2, 1L);
        }
        masm.cmp(64, length1, length2);
        masm.cmov(64, length, length1, length2, AArch64Assembler.ConditionFlag.LT);
        masm.cbz(64, length, LENGTH_DIFFER_LABEL);
        if (!isLL) {
            masm.shl(64, length, length, 1L);
        }
        masm.mov(64, vecCount, AArch64.zr);
        masm.and(64, tailCount, length, VECTOR_SIZE_BYTES - 1);
        masm.ands(64, length, length, ~(VECTOR_SIZE_BYTES - 1));
        masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, COMPARE_SHORT_LABEL);
        if (isLU || isUL) {
            masm.lshr(64, length, length, 1L);
        }
        masm.bind(MAIN_LOOP_LABEL);
        if (isLU || isUL) {
            masm.ldr(32, result, AArch64Address.createRegisterOffsetAddress(array1, vecCount, false));
            masm.ubfm(64, temp, result, 0, 7);
            masm.lshr(64, result, result, 8L);
            masm.bfm(64, temp, result, 48, 7);
            masm.lshr(64, result, result, 8L);
            masm.bfm(64, temp, result, 32, 7);
            masm.lshr(64, result, result, 8L);
            masm.bfm(64, temp, result, 16, 7);
            masm.shl(64, result, vecCount, 1L);
            masm.ldr(64, result, AArch64Address.createRegisterOffsetAddress(array2, result, false));
        } else {
            masm.ldr(64, temp, AArch64Address.createRegisterOffsetAddress(array1, vecCount, false));
            masm.ldr(64, result, AArch64Address.createRegisterOffsetAddress(array2, vecCount, false));
        }
        masm.eor(64, result, temp, result);
        masm.cbnz(64, result, STRING_DIFFER_LABEL);
        masm.add(64, vecCount, vecCount, VECTOR_COUNT_BYTES);
        masm.cmp(64, vecCount, length);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.LT, MAIN_LOOP_LABEL);
        masm.cbz(64, tailCount, LENGTH_DIFFER_LABEL);
        masm.loadAddress(array1, AArch64Address.createRegisterOffsetAddress(array1, length, false));
        if (isLU || isUL) {
            masm.shl(64, length, length, 1L);
        }
        masm.loadAddress(array2, AArch64Address.createRegisterOffsetAddress(array2, length, false));
        masm.bind(COMPARE_SHORT_LABEL);
        for (int i = 0; i < VECTOR_SIZE_BYTES; i += CHAR_SIZE_BYTES) {
            int transferSize;
            if (isLU || isUL) {
                masm.ldr(8, temp, AArch64Address.createImmediateAddress(8, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, array1, i / 2));
            } else {
                transferSize = 8 * CHAR_SIZE_BYTES;
                masm.ldr(transferSize, temp, AArch64Address.createImmediateAddress(transferSize, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, array1, i));
            }
            transferSize = 8 * CHAR_SIZE_BYTES;
            masm.ldr(transferSize, result, AArch64Address.createImmediateAddress(transferSize, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, array2, i));
            if (isUL) {
                masm.subs(64, result, result, temp);
            } else {
                masm.subs(64, result, temp, result);
            }
            masm.branchConditionally(AArch64Assembler.ConditionFlag.NE, BREAK_LABEL);
            masm.subs(64, tailCount, tailCount, CHAR_SIZE_BYTES);
            masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, LENGTH_DIFFER_LABEL);
        }
        masm.bind(STRING_DIFFER_LABEL);
        masm.rbit(64, tailCount, result);
        masm.clz(64, vecCount, tailCount);
        masm.and(64, vecCount, vecCount, ~(8 * CHAR_SIZE_BYTES - 1));
        masm.eor(64, result, temp, result);
        masm.ashr(64, result, result, vecCount);
        masm.ashr(64, temp, temp, vecCount);
        masm.and(64, result, result, 65535 >>> 16 - 8 * CHAR_SIZE_BYTES);
        masm.and(64, temp, temp, 65535 >>> 16 - 8 * CHAR_SIZE_BYTES);
        if (isUL) {
            masm.sub(64, result, result, temp);
        } else {
            masm.sub(64, result, temp, result);
        }
        masm.branchConditionally(AArch64Assembler.ConditionFlag.AL, BREAK_LABEL);
        masm.bind(LENGTH_DIFFER_LABEL);
        if (isUL) {
            masm.sub(64, result, length2, length1);
        } else {
            masm.sub(64, result, length1, length2);
        }
        masm.bind(BREAK_LABEL);
    }
}

