/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import java.util.Arrays;
import java.util.Comparator;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public abstract class SwitchStrategy {
    public final double[] keyProbabilities;
    private double averageEffort = -1.0;
    private EffortClosure effortClosure;

    public SwitchStrategy(double[] keyProbabilities) {
        assert (keyProbabilities.length >= 2);
        this.keyProbabilities = keyProbabilities;
    }

    public abstract Constant[] getKeyConstants();

    public double getAverageEffort() {
        assert (this.averageEffort >= 0.0) : "average effort was not calculated yet for this strategy";
        return this.averageEffort;
    }

    protected void registerEffort(int rangeStart, int rangeEnd, int depth) {
        if (this.effortClosure != null) {
            int i = rangeStart;
            while (i <= rangeEnd) {
                int[] nArray = this.effortClosure.keyEfforts;
                int n = i;
                nArray[n] = nArray[n] + depth;
                int[] nArray2 = this.effortClosure.keyCounts;
                int n2 = i++;
                nArray2[n2] = nArray2[n2] + 1;
            }
        }
    }

    protected void registerDefaultEffort(int depth) {
        if (this.effortClosure != null) {
            EffortClosure effortClosure = this.effortClosure;
            effortClosure.defaultEffort = effortClosure.defaultEffort + depth;
            this.effortClosure.defaultCount++;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[avgEffort=" + this.averageEffort + "]";
    }

    public abstract void run(SwitchClosure var1);

    private static SwitchStrategy[] getStrategies(double[] keyProbabilities, JavaConstant[] keyConstants, LabelRef[] keyTargets) {
        SwitchStrategy[] strategies;
        SwitchStrategy[] switchStrategyArray = strategies = new SwitchStrategy[]{new SequentialStrategy(keyProbabilities, (Constant[])keyConstants), new RangesStrategy(keyProbabilities, keyConstants), new BinaryStrategy(keyProbabilities, keyConstants)};
        int n = switchStrategyArray.length;
        for (int i = 0; i < n; ++i) {
            SwitchStrategy strategy;
            SwitchStrategy switchStrategy = strategy = switchStrategyArray[i];
            switchStrategy.getClass();
            strategy.effortClosure = switchStrategy.new EffortClosure(keyTargets);
            strategy.run(strategy.effortClosure);
            strategy.averageEffort = strategy.effortClosure.getAverageEffort();
            strategy.effortClosure = null;
        }
        return strategies;
    }

    public static SwitchStrategy getBestStrategy(double[] keyProbabilities, JavaConstant[] keyConstants, LabelRef[] keyTargets) {
        SwitchStrategy[] strategies = SwitchStrategy.getStrategies(keyProbabilities, keyConstants, keyTargets);
        double bestEffort = 2.147483647E9;
        SwitchStrategy bestStrategy = null;
        for (SwitchStrategy strategy : strategies) {
            if (!(strategy.getAverageEffort() < bestEffort)) continue;
            bestEffort = strategy.getAverageEffort();
            bestStrategy = strategy;
        }
        return bestStrategy;
    }

    public static class BinaryStrategy
    extends PrimitiveStrategy {
        private static final double MIN_PROBABILITY = 1.0E-5;
        private final double[] probabilitySums;

        public BinaryStrategy(double[] keyProbabilities, JavaConstant[] keyConstants) {
            super(keyProbabilities, keyConstants);
            this.probabilitySums = new double[keyProbabilities.length + 1];
            double sum = 0.0;
            for (int i = 0; i < keyConstants.length; ++i) {
                this.probabilitySums[i + 1] = sum += Math.max(keyProbabilities[i], 1.0E-5);
            }
        }

        @Override
        public void run(SwitchClosure closure) {
            this.recurseBinarySwitch(closure, 0, this.keyConstants.length - 1, 0);
        }

        private void recurseBinarySwitch(SwitchClosure closure, int left, int right, int startDepth) {
            boolean rightBorder;
            assert (startDepth < this.keyConstants.length * 3) : "runaway recursion in binary switch";
            int depth = startDepth;
            boolean leftBorder = left == 0;
            boolean bl = rightBorder = right == this.keyConstants.length - 1;
            if (left + 1 == right) {
                if (leftBorder || rightBorder || this.keyConstants[right].asLong() + 1L != this.keyConstants[right + 1].asLong() || this.keyConstants[left].asLong() + 1L != this.keyConstants[right].asLong()) {
                    closure.conditionalJump(left, Condition.EQ, false);
                    this.registerEffort(left, left, ++depth);
                    closure.conditionalJumpOrDefault(right, Condition.EQ, rightBorder);
                    this.registerEffort(right, right, ++depth);
                    this.registerDefaultEffort(depth);
                } else {
                    closure.conditionalJump(left, Condition.EQ, false);
                    this.registerEffort(left, left, ++depth);
                    closure.conditionalJump(right, null, false);
                    this.registerEffort(right, right, depth);
                }
                return;
            }
            double probabilityStart = this.probabilitySums[left];
            double probabilityMiddle = (probabilityStart + this.probabilitySums[right + 1]) / 2.0;
            assert (probabilityMiddle >= probabilityStart);
            int middle = left;
            while (this.getSliceEnd(closure, middle + 1) < right && this.probabilitySums[this.getSliceEnd(closure, middle + 1)] < probabilityMiddle) {
                middle = this.getSliceEnd(closure, middle + 1);
            }
            middle = this.getSliceEnd(closure, middle);
            assert (middle < this.keyConstants.length - 1);
            if (this.getSliceEnd(closure, left) == middle) {
                if (left == 0) {
                    closure.conditionalJump(0, Condition.LT, true);
                    this.registerDefaultEffort(++depth);
                }
                closure.conditionalJump(middle, Condition.LE, false);
                this.registerEffort(left, middle, ++depth);
                if (middle + 1 == right) {
                    closure.conditionalJumpOrDefault(right, Condition.EQ, rightBorder);
                    this.registerEffort(right, right, ++depth);
                    this.registerDefaultEffort(depth);
                } else {
                    if (this.keyConstants[middle].asLong() + 1L != this.keyConstants[middle + 1].asLong()) {
                        closure.conditionalJump(middle + 1, Condition.LT, true);
                        this.registerDefaultEffort(++depth);
                    }
                    if (this.getSliceEnd(closure, middle + 1) == right) {
                        if (right == this.keyConstants.length - 1 || this.keyConstants[right].asLong() + 1L != this.keyConstants[right + 1].asLong()) {
                            closure.conditionalJumpOrDefault(right, Condition.LE, rightBorder);
                            this.registerEffort(middle + 1, right, ++depth);
                            this.registerDefaultEffort(depth);
                        } else {
                            closure.conditionalJump(middle + 1, null, false);
                            this.registerEffort(middle + 1, right, depth);
                        }
                    } else {
                        this.recurseBinarySwitch(closure, middle + 1, right, depth);
                    }
                }
            } else if (this.getSliceEnd(closure, middle + 1) == right) {
                if (rightBorder || this.keyConstants[right].asLong() + 1L != this.keyConstants[right + 1].asLong()) {
                    closure.conditionalJump(right, Condition.GT, true);
                    this.registerDefaultEffort(++depth);
                }
                closure.conditionalJump(middle + 1, Condition.GE, false);
                this.registerEffort(middle + 1, right, ++depth);
                this.recurseBinarySwitch(closure, left, middle, depth);
            } else {
                Label label = closure.conditionalJump(middle + 1, Condition.GE);
                this.recurseBinarySwitch(closure, left, middle, ++depth);
                closure.bind(label);
                this.recurseBinarySwitch(closure, middle + 1, right, depth);
            }
        }
    }

    public static class RangesStrategy
    extends PrimitiveStrategy {
        private final Integer[] indexes;

        public RangesStrategy(final double[] keyProbabilities, JavaConstant[] keyConstants) {
            super(keyProbabilities, keyConstants);
            int keyCount = keyConstants.length;
            this.indexes = new Integer[keyCount];
            for (int i = 0; i < keyCount; ++i) {
                this.indexes[i] = i;
            }
            Arrays.sort(this.indexes, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return keyProbabilities[o1] < keyProbabilities[o2] ? 1 : (keyProbabilities[o1] > keyProbabilities[o2] ? -1 : 0);
                }
            });
        }

        @Override
        public void run(SwitchClosure closure) {
            int depth = 0;
            closure.conditionalJump(0, Condition.LT, true);
            this.registerDefaultEffort(++depth);
            int rangeStart = 0;
            int rangeEnd = this.getSliceEnd(closure, rangeStart);
            while (rangeEnd != this.keyConstants.length - 1) {
                if (rangeStart == rangeEnd) {
                    closure.conditionalJump(rangeStart, Condition.EQ, false);
                    this.registerEffort(rangeStart, rangeEnd, ++depth);
                } else {
                    if (rangeStart == 0 || this.keyConstants[rangeStart - 1].asLong() + 1L != this.keyConstants[rangeStart].asLong()) {
                        closure.conditionalJump(rangeStart, Condition.LT, true);
                        this.registerDefaultEffort(++depth);
                    }
                    closure.conditionalJump(rangeEnd, Condition.LE, false);
                    this.registerEffort(rangeStart, rangeEnd, ++depth);
                }
                rangeStart = rangeEnd + 1;
                rangeEnd = this.getSliceEnd(closure, rangeStart);
            }
            if (rangeStart == rangeEnd) {
                closure.conditionalJumpOrDefault(rangeStart, Condition.EQ, true);
                this.registerEffort(rangeStart, rangeEnd, ++depth);
                this.registerDefaultEffort(depth);
            } else {
                if (rangeStart == 0 || this.keyConstants[rangeStart - 1].asLong() + 1L != this.keyConstants[rangeStart].asLong()) {
                    closure.conditionalJump(rangeStart, Condition.LT, true);
                    this.registerDefaultEffort(++depth);
                }
                closure.conditionalJumpOrDefault(rangeEnd, Condition.LE, true);
                this.registerEffort(rangeStart, rangeEnd, ++depth);
                this.registerDefaultEffort(depth);
            }
        }
    }

    private static abstract class PrimitiveStrategy
    extends SwitchStrategy {
        protected final JavaConstant[] keyConstants;

        protected PrimitiveStrategy(double[] keyProbabilities, JavaConstant[] keyConstants) {
            super(keyProbabilities);
            assert (keyProbabilities.length == keyConstants.length);
            this.keyConstants = keyConstants;
        }

        public JavaConstant[] getKeyConstants() {
            return this.keyConstants;
        }

        protected int getSliceEnd(SwitchClosure closure, int pos) {
            int slice;
            for (slice = pos; slice < this.keyConstants.length - 1 && this.keyConstants[slice + 1].asLong() == this.keyConstants[slice].asLong() + 1L && closure.isSameTarget(slice, slice + 1); ++slice) {
            }
            return slice;
        }
    }

    public static class SequentialStrategy
    extends SwitchStrategy {
        private final Integer[] indexes;
        private final Constant[] keyConstants;

        public SequentialStrategy(final double[] keyProbabilities, Constant[] keyConstants) {
            super(keyProbabilities);
            assert (keyProbabilities.length == keyConstants.length);
            this.keyConstants = keyConstants;
            int keyCount = keyConstants.length;
            this.indexes = new Integer[keyCount];
            for (int i = 0; i < keyCount; ++i) {
                this.indexes[i] = i;
            }
            Arrays.sort(this.indexes, new Comparator<Integer>(){

                @Override
                public int compare(Integer o1, Integer o2) {
                    return keyProbabilities[o1] < keyProbabilities[o2] ? 1 : (keyProbabilities[o1] > keyProbabilities[o2] ? -1 : 0);
                }
            });
        }

        @Override
        public Constant[] getKeyConstants() {
            return this.keyConstants;
        }

        @Override
        public void run(SwitchClosure closure) {
            for (int i = 0; i < this.keyConstants.length - 1; ++i) {
                closure.conditionalJump(this.indexes[i], Condition.EQ, false);
                this.registerEffort(this.indexes[i], this.indexes[i], i + 1);
            }
            closure.conditionalJumpOrDefault(this.indexes[this.keyConstants.length - 1], Condition.EQ, true);
            this.registerEffort(this.indexes[this.keyConstants.length - 1], this.indexes[this.keyConstants.length - 1], this.keyConstants.length);
            this.registerDefaultEffort(this.keyConstants.length);
        }
    }

    private class EffortClosure
    implements SwitchClosure {
        private int defaultEffort;
        private int defaultCount;
        private final int[] keyEfforts;
        private final int[] keyCounts;
        private final LabelRef[] keyTargets;

        EffortClosure(LabelRef[] keyTargets) {
            this.keyEfforts = new int[SwitchStrategy.this.keyProbabilities.length];
            this.keyCounts = new int[SwitchStrategy.this.keyProbabilities.length];
            this.keyTargets = keyTargets;
        }

        @Override
        public void conditionalJump(int index, Condition condition, boolean defaultTarget) {
        }

        @Override
        public void conditionalJumpOrDefault(int index, Condition condition, boolean canFallThrough) {
        }

        @Override
        public Label conditionalJump(int index, Condition condition) {
            return null;
        }

        @Override
        public void bind(Label label) {
        }

        @Override
        public boolean isSameTarget(int index1, int index2) {
            return this.keyTargets[index1] == this.keyTargets[index2];
        }

        public double getAverageEffort() {
            double defaultProbability = 1.0;
            double effort = 0.0;
            for (int i = 0; i < SwitchStrategy.this.keyProbabilities.length; ++i) {
                effort += (double)this.keyEfforts[i] * SwitchStrategy.this.keyProbabilities[i] / (double)this.keyCounts[i];
                defaultProbability -= SwitchStrategy.this.keyProbabilities[i];
            }
            return effort + (double)this.defaultEffort * defaultProbability / (double)this.defaultCount;
        }
    }

    public static abstract class BaseSwitchClosure
    implements SwitchClosure {
        private final CompilationResultBuilder crb;
        private final Assembler masm;
        private final LabelRef[] keyTargets;
        private final LabelRef defaultTarget;

        public BaseSwitchClosure(CompilationResultBuilder crb, Assembler masm, LabelRef[] keyTargets, LabelRef defaultTarget) {
            this.crb = crb;
            this.masm = masm;
            this.keyTargets = keyTargets;
            this.defaultTarget = defaultTarget;
        }

        protected abstract void conditionalJump(int var1, Condition var2, Label var3);

        @Override
        public void conditionalJump(int index, Condition condition, boolean targetDefault) {
            Label target;
            Label label = target = targetDefault ? this.defaultTarget.label() : this.keyTargets[index].label();
            if (condition == null) {
                this.masm.jmp(target);
            } else {
                this.conditionalJump(index, condition, target);
            }
        }

        @Override
        public void conditionalJumpOrDefault(int index, Condition condition, boolean canFallThrough) {
            if (canFallThrough && this.crb.isSuccessorEdge(this.defaultTarget)) {
                this.conditionalJump(index, condition, this.keyTargets[index].label());
            } else if (canFallThrough && this.crb.isSuccessorEdge(this.keyTargets[index])) {
                this.conditionalJump(index, condition.negate(), this.defaultTarget.label());
            } else {
                this.conditionalJump(index, condition, this.keyTargets[index].label());
                this.masm.jmp(this.defaultTarget.label());
            }
        }

        @Override
        public Label conditionalJump(int index, Condition condition) {
            Label label = new Label();
            this.conditionalJump(index, condition, label);
            return label;
        }

        @Override
        public void bind(Label label) {
            this.masm.bind(label);
        }

        @Override
        public boolean isSameTarget(int index1, int index2) {
            return this.keyTargets[index1] == this.keyTargets[index2];
        }
    }

    private static interface SwitchClosure {
        public void conditionalJump(int var1, Condition var2, boolean var3);

        public void conditionalJumpOrDefault(int var1, Condition var2, boolean var3);

        public Label conditionalJump(int var1, Condition var2);

        public void bind(Label var1);

        public boolean isSameTarget(int var1, int var2);
    }
}

