/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.java;

import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.phases.Phase;
import org.graalvm.compiler.phases.graph.ReentrantNodeIterator;

public final class ComputeLoopFrequenciesClosure
extends ReentrantNodeIterator.NodeIteratorClosure<ProfileData.BranchProbabilityData> {
    private static final ComputeLoopFrequenciesClosure INSTANCE = new ComputeLoopFrequenciesClosure();
    private static final ProfileData.BranchProbabilityData ZERO = ProfileData.BranchProbabilityData.create(0.0, ProfileData.ProfileSource.UNKNOWN);
    private static final ProfileData.BranchProbabilityData ONE = ProfileData.BranchProbabilityData.create(1.0, ProfileData.ProfileSource.UNKNOWN);
    public static final ComputeLoopFrequencyPhase PHASE_INSTANCE = new ComputeLoopFrequencyPhase();

    private ComputeLoopFrequenciesClosure() {
    }

    private static ProfileData.BranchProbabilityData add(ProfileData.BranchProbabilityData x, ProfileData.BranchProbabilityData y) {
        double p = x.getDesignatedSuccessorProbability() + y.getDesignatedSuccessorProbability();
        return ProfileData.BranchProbabilityData.create(p, x.getProfileSource().combine(y.getProfileSource()));
    }

    private static ProfileData.BranchProbabilityData scale(ProfileData.BranchProbabilityData x, double scaleFactor) {
        return ComputeLoopFrequenciesClosure.scaleAndCombine(x, scaleFactor, x.getProfileSource());
    }

    private static ProfileData.BranchProbabilityData scaleAndCombine(ProfileData.BranchProbabilityData x, double scaleFactor, ProfileData.ProfileSource otherSource) {
        double p = ControlFlowGraph.multiplyRelativeFrequencies(x.getDesignatedSuccessorProbability(), scaleFactor);
        return ProfileData.BranchProbabilityData.create(p, x.getProfileSource().combine(otherSource));
    }

    @Override
    protected ProfileData.BranchProbabilityData processNode(FixedNode node, ProfileData.BranchProbabilityData currentState) {
        return currentState;
    }

    @Override
    protected ProfileData.BranchProbabilityData merge(AbstractMergeNode merge, List<ProfileData.BranchProbabilityData> states) {
        ProfileData.BranchProbabilityData result = ZERO;
        for (ProfileData.BranchProbabilityData s : states) {
            result = ComputeLoopFrequenciesClosure.add(result, s);
        }
        return result;
    }

    @Override
    protected ProfileData.BranchProbabilityData afterSplit(AbstractBeginNode node, ProfileData.BranchProbabilityData oldState) {
        ControlSplitNode split = (ControlSplitNode)node.predecessor();
        return ComputeLoopFrequenciesClosure.scaleAndCombine(oldState, split.probability(node), split.getProfileData().getProfileSource());
    }

    @Override
    protected EconomicMap<LoopExitNode, ProfileData.BranchProbabilityData> processLoop(LoopBeginNode loop, ProfileData.BranchProbabilityData initialState) {
        EconomicMap exitStates = ReentrantNodeIterator.processLoop(this, (LoopBeginNode)loop, ComputeLoopFrequenciesClosure.ONE).exitStates;
        ProfileData.BranchProbabilityData exitState = ZERO;
        for (ProfileData.BranchProbabilityData e : exitStates.getValues()) {
            exitState = ComputeLoopFrequenciesClosure.add(exitState, e);
        }
        double exitRelativeFrequency = exitState.getDesignatedSuccessorProbability();
        exitRelativeFrequency = Math.min(1.0, exitRelativeFrequency);
        exitRelativeFrequency = Math.max(3.054936363499605E-151, exitRelativeFrequency);
        double loopFrequency = 1.0 / exitRelativeFrequency;
        loop.setLoopFrequency(ProfileData.LoopFrequencyData.create(loopFrequency, exitState.getProfileSource()));
        double adjustmentFactor = initialState.getDesignatedSuccessorProbability() * loopFrequency;
        exitStates.replaceAll((exitNode, state) -> ComputeLoopFrequenciesClosure.scale(state, adjustmentFactor));
        return exitStates;
    }

    public static void compute(StructuredGraph graph) {
        if (graph.hasLoops()) {
            ReentrantNodeIterator.apply(INSTANCE, graph.start(), ONE);
        }
    }

    public static class ComputeLoopFrequencyPhase
    extends Phase {
        @Override
        protected void run(StructuredGraph graph) {
            ComputeLoopFrequenciesClosure.compute(graph);
        }
    }
}

