/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.List;
import java.util.function.Supplier;
import jdk.vm.ci.code.BailoutException;
import jdk.vm.ci.code.BytecodeFrame;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.site.InfopointReason;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.RawConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.TriState;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.bytecode.Bytecode;
import org.graalvm.compiler.bytecode.BytecodeDisassembler;
import org.graalvm.compiler.bytecode.BytecodeLookupSwitch;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.bytecode.BytecodeStream;
import org.graalvm.compiler.bytecode.BytecodeSwitch;
import org.graalvm.compiler.bytecode.BytecodeTableSwitch;
import org.graalvm.compiler.bytecode.Bytecodes;
import org.graalvm.compiler.bytecode.Bytes;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecodeProvider;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.RetryableBailoutException;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.core.common.util.Util;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.DebugOptions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.debug.MethodFilter;
import org.graalvm.compiler.debug.TTY;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.java.BciBlockMapping;
import org.graalvm.compiler.java.BytecodeParserOptions;
import org.graalvm.compiler.java.ComputeLoopFrequenciesClosure;
import org.graalvm.compiler.java.FrameStateBuilder;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.java.JsrNotSupportedBailout;
import org.graalvm.compiler.java.JsrScope;
import org.graalvm.compiler.java.LocalLiveness;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.BeginNode;
import org.graalvm.compiler.nodes.BeginStateSplitNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.EntryMarkerNode;
import org.graalvm.compiler.nodes.EntryProxyNode;
import org.graalvm.compiler.nodes.FieldLocationIdentity;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.InliningLog;
import org.graalvm.compiler.nodes.Invokable;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.PluginReplacementNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StartNode;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.UnwindNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.WithExceptionNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.FloatConvertNode;
import org.graalvm.compiler.nodes.calc.FloatDivNode;
import org.graalvm.compiler.nodes.calc.FloatNormalizeCompareNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.IntegerNormalizeCompareNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.MulNode;
import org.graalvm.compiler.nodes.calc.NarrowNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.calc.OrNode;
import org.graalvm.compiler.nodes.calc.RemNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.SignedDivNode;
import org.graalvm.compiler.nodes.calc.SignedRemNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.calc.ZeroExtendNode;
import org.graalvm.compiler.nodes.extended.AnchoringNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.BytecodeExceptionNode;
import org.graalvm.compiler.nodes.extended.ForeignCall;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.extended.IntegerSwitchNode;
import org.graalvm.compiler.nodes.extended.LoadArrayComponentHubNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.extended.MembarNode;
import org.graalvm.compiler.nodes.extended.StateSplitProxyNode;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InlineInvokePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.graphbuilderconf.InvokeDynamicPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.ProfilingPlugin;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.ExceptionObjectNode;
import org.graalvm.compiler.nodes.java.FinalFieldBarrierNode;
import org.graalvm.compiler.nodes.java.InstanceOfDynamicNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.java.LoadIndexedNode;
import org.graalvm.compiler.nodes.java.MethodCallTargetNode;
import org.graalvm.compiler.nodes.java.MonitorEnterNode;
import org.graalvm.compiler.nodes.java.MonitorExitNode;
import org.graalvm.compiler.nodes.java.MonitorIdNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.NewInstanceNode;
import org.graalvm.compiler.nodes.java.NewMultiArrayNode;
import org.graalvm.compiler.nodes.java.RegisterFinalizerNode;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.nodes.java.StoreIndexedNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.spi.StampProvider;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.util.ValueMergeUtil;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.serviceprovider.SpeculationReasonGroup;

public class BytecodeParser
implements GraphBuilderContext {
    public static final int TRACELEVEL_INSTRUCTIONS = 1;
    public static final int TRACELEVEL_STATE = 2;
    public static final int TRACELEVEL_BLOCKMAP = 3;
    public static final CounterKey BytecodesParsed = DebugContext.counter("BytecodesParsed");
    protected static final CounterKey EXPLICIT_EXCEPTIONS = DebugContext.counter("ExplicitExceptions");
    private boolean bciCanBeDuplicated = false;
    private final GraphBuilderPhase.Instance graphBuilderInstance;
    protected final StructuredGraph graph;
    protected final OptionValues options;
    protected final DebugContext debug;
    private BciBlockMapping blockMap;
    private LocalLiveness liveness;
    protected final int entryBCI;
    private final BytecodeParser parent;
    private LineNumberTable lnt;
    private int previousLineNumber;
    private int currentLineNumber;
    private ValueNode methodSynchronizedObject;
    private List<ReturnToCallerData> returnDataList;
    private ValueNode unwindValue;
    private FixedWithNextNode beforeUnwindNode;
    protected FixedWithNextNode lastInstr;
    private boolean controlFlowSplit;
    private final InvocationPlugins.InvocationPluginReceiver invocationPluginReceiver = new InvocationPlugins.InvocationPluginReceiver(this);
    private FixedWithNextNode[] firstInstructionArray;
    private FrameStateBuilder[] entryStateArray;
    private boolean finalBarrierRequired;
    private ValueNode originalReceiver;
    private final boolean eagerInitializing;
    private final boolean uninitializedIsError;
    private final int traceLevel;
    private CurrentInvoke currentInvoke;
    protected FrameStateBuilder frameState;
    protected BciBlockMapping.BciBlock currentBlock;
    protected final BytecodeStream stream;
    protected final GraphBuilderConfiguration graphBuilderConfig;
    protected final ResolvedJavaMethod method;
    protected final Bytecode code;
    protected final BytecodeProvider bytecodeProvider;
    protected final ProfilingInfo profilingInfo;
    protected final OptimisticOptimizations optimisticOpts;
    protected final ConstantPool constantPool;
    protected final CoreProviders providers;
    protected final IntrinsicContext intrinsicContext;
    private boolean forceInliningEverything;
    private static final InlineInvokePlugin.InlineInfo SUCCESSFULLY_INLINED = InlineInvokePlugin.InlineInfo.createStandardInlineInfo(null);
    private static final int ACCESSOR_BYTECODE_LENGTH = 5;
    private static final SpeculationReasonGroup FALLBACK_TYPECHECK = new SpeculationReasonGroup("FallbackTypeCheck", ResolvedJavaMethod.class, Integer.TYPE);
    public static final CounterKey fallBackSpeculationTaken = DebugContext.counter("BytecodeParser_FallBackSpeculation_Taken");
    public static final CounterKey fallBackSpeculationNotTaken = DebugContext.counter("BytecodeParser_FallBackSpeculation_NotTaken");
    private static final int SWITCH_DEOPT_UNSEEN = -2;
    private static final int SWITCH_DEOPT_SEEN = -1;
    private boolean firstTraceEmitted;

    protected BytecodeParser(GraphBuilderPhase.Instance graphBuilderInstance, StructuredGraph graph, BytecodeParser parent, ResolvedJavaMethod method, int entryBCI, IntrinsicContext intrinsicContext) {
        int level;
        this.bytecodeProvider = intrinsicContext == null ? new ResolvedJavaMethodBytecodeProvider() : intrinsicContext.getBytecodeProvider();
        this.code = this.bytecodeProvider.getBytecode(method);
        this.method = this.code.getMethod();
        this.graphBuilderInstance = graphBuilderInstance;
        this.graph = graph;
        this.options = graph.getOptions();
        this.debug = graph.getDebug();
        this.graphBuilderConfig = graphBuilderInstance.graphBuilderConfig;
        this.optimisticOpts = graphBuilderInstance.optimisticOpts;
        this.providers = graphBuilderInstance.providers;
        assert (this.code.getCode() != null) : method;
        this.stream = new BytecodeStream(this.code.getCode());
        this.profilingInfo = graph.useProfilingInfo() ? this.code.getProfilingInfo() : null;
        this.constantPool = this.code.getConstantPool();
        this.intrinsicContext = intrinsicContext;
        this.entryBCI = entryBCI;
        this.parent = parent;
        ClassInitializationPlugin classInitializationPlugin = this.graphBuilderConfig.getPlugins().getClassInitializationPlugin();
        if (classInitializationPlugin != null && this.graphBuilderConfig.eagerResolving() && classInitializationPlugin.supportsLazyInitialization(this.constantPool)) {
            this.eagerInitializing = false;
            this.uninitializedIsError = false;
        } else {
            this.eagerInitializing = this.graphBuilderConfig.eagerResolving();
            this.uninitializedIsError = this.graphBuilderConfig.unresolvedIsError();
        }
        assert (this.code.getCode() != null) : "method must contain bytecodes: " + method;
        if (this.graphBuilderConfig.insertFullInfopoints() && !this.parsingIntrinsic()) {
            this.lnt = this.code.getLineNumberTable();
            this.previousLineNumber = -1;
        }
        assert (!GraalOptions.TrackNodeSourcePosition.getValue(this.options).booleanValue() || graph.trackNodeSourcePosition());
        if (this.graphBuilderConfig.trackNodeSourcePosition() || parent != null && parent.graph.trackNodeSourcePosition()) {
            graph.setTrackNodeSourcePosition();
        }
        this.traceLevel = (level = BytecodeParserOptions.TraceBytecodeParserLevel.getValue(this.options).intValue()) != 0 ? this.refineTraceLevel(level) : 0;
    }

    protected boolean insideTryBlock() {
        BytecodeParser cur = this;
        while (cur != null) {
            if (cur.currentBlock.exceptionDispatchBlock() != null) {
                return true;
            }
            cur = cur.parent;
        }
        return false;
    }

    private int refineTraceLevel(int level) {
        MethodFilter filter;
        String filterValue;
        ResolvedJavaMethod tmethod = this.graph.method();
        if (tmethod == null) {
            tmethod = this.method;
        }
        if ((filterValue = DebugOptions.MethodFilter.getValue(this.options)) != null && !(filter = MethodFilter.parse(filterValue)).matches((JavaMethod)tmethod)) {
            return 0;
        }
        return level;
    }

    protected GraphBuilderPhase.Instance getGraphBuilderInstance() {
        return this.graphBuilderInstance;
    }

    public ValueNode getUnwindValue() {
        return this.unwindValue;
    }

    public FixedWithNextNode getBeforeUnwindNode() {
        return this.beforeUnwindNode;
    }

    protected void buildRootMethod() {
        FrameStateBuilder startFrameState = new FrameStateBuilder(this, this.code, this.graph, this.graphBuilderConfig.retainLocalVariables());
        startFrameState.initializeForMethodStart(this.graph.getAssumptions(), this.graphBuilderConfig.eagerResolving() || this.intrinsicContext != null, this.graphBuilderConfig.getPlugins());
        try (IntrinsicScope s = this.intrinsicContext != null ? new IntrinsicScope(this) : null;){
            this.build(this.graph.start(), startFrameState);
        }
        this.cleanupFinalGraph();
        ComputeLoopFrequenciesClosure.compute(this.graph);
    }

    protected void build(FixedWithNextNode startInstruction, FrameStateBuilder startFrameState) {
        if (GraalOptions.PrintProfilingInformation.getValue(this.options).booleanValue() && this.profilingInfo != null) {
            TTY.println("Profiling info for " + this.method.format("%H.%n(%p)"));
            TTY.println(Util.indent(this.profilingInfo.toString(this.method, CodeUtil.NEW_LINE), "  "));
        }
        try (Indent indent = this.debug.logAndIndent("build graph for %s", this.method);){
            BciBlockMapping.BciBlock[] blocks;
            BciBlockMapping newMapping;
            if (this.bytecodeProvider.shouldRecordMethodDependencies()) {
                assert (this.getParent() != null || this.method.equals(this.graph.method()));
                this.graph.recordMethod(this.method);
            }
            this.blockMap = newMapping = BciBlockMapping.create(this.stream, this.code, this.options, this.graph.getDebug());
            this.firstInstructionArray = new FixedWithNextNode[this.blockMap.getBlockCount()];
            this.entryStateArray = new FrameStateBuilder[this.blockMap.getBlockCount()];
            if (!this.method.isStatic()) {
                this.originalReceiver = startFrameState.loadLocal(0, JavaKind.Object);
            }
            assert (this.computeKindVerification(startFrameState));
            try (DebugContext.Scope s = this.debug.scope("LivenessAnalysis");){
                int maxLocals = this.method.getMaxLocals();
                this.liveness = LocalLiveness.compute(this.debug, this.stream, this.blockMap.getBlocks(), maxLocals, this.blockMap.getLoopCount());
            }
            catch (Throwable e) {
                throw this.debug.handle(e);
            }
            this.lastInstr = startInstruction;
            this.setCurrentFrameState(startFrameState);
            this.stream.setBCI(0);
            BciBlockMapping.BciBlock startBlock = this.blockMap.getStartBlock();
            if (this.parent == null) {
                StartNode startNode = this.graph.start();
                if (this.method.isSynchronized()) {
                    assert (!this.parsingIntrinsic());
                    startNode.setStateAfter(this.createFrameState(-2, startNode));
                } else if (!this.parsingIntrinsic()) {
                    if (this.graph.method() == null || !this.graph.method().isJavaLangObjectInit()) {
                        this.frameState.clearNonLiveLocals(startBlock, this.liveness, true);
                    }
                    assert (this.bci() == 0);
                    startNode.setStateAfter(this.createFrameState(this.bci(), startNode));
                } else if (startNode.stateAfter() == null) {
                    FrameState stateAfterStart = this.createStateAfterStartOfReplacementGraph();
                    startNode.setStateAfter(stateAfterStart);
                }
            }
            BciBlockMapping.BciBlock[] bciBlockArray = null;
            try (DebugCloseable context = this.openNodeContext();){
                ProfilingPlugin profilingPlugin;
                if (this.method.isSynchronized()) {
                    this.finishPrepare(this.lastInstr, -2, this.frameState);
                    this.methodSynchronizedObject = this.synchronizedObject(this.frameState, this.method);
                    this.frameState.clearNonLiveLocals(startBlock, this.liveness, true);
                    assert (this.bci() == 0);
                    this.genMonitorEnter(this.methodSynchronizedObject, this.bci());
                }
                if ((profilingPlugin = this.graphBuilderConfig.getPlugins().getProfilingPlugin()) != null && profilingPlugin.shouldProfile(this, this.method)) {
                    FrameState stateBefore = this.createCurrentFrameState();
                    profilingPlugin.profileInvoke(this, this.method, stateBefore);
                }
                this.finishPrepare(this.lastInstr, 0, this.frameState);
                this.genInfoPointNode(InfopointReason.METHOD_START, null);
            }
            catch (Throwable object) {
                bciBlockArray = object;
                throw object;
            }
            this.currentBlock = this.blockMap.getStartBlock();
            this.setEntryState(startBlock, this.frameState);
            if (startBlock.isLoopHeader()) {
                this.appendGoto(startBlock);
            } else {
                this.setFirstInstruction(startBlock, this.lastInstr);
            }
            for (BciBlockMapping.BciBlock block : blocks = this.blockMap.getBlocks()) {
                this.processBlock(block);
            }
        }
    }

    private boolean computeKindVerification(FrameStateBuilder startFrameState) {
        if (this.blockMap.hasJsrBytecodes) {
            startFrameState.disableKindVerification();
        }
        for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
            if (!plugin.canChangeStackKind(this)) continue;
            startFrameState.disableKindVerification();
        }
        return true;
    }

    protected void finishPrepare(FixedWithNextNode instruction, int bci, FrameStateBuilder state) {
    }

    protected void cleanupFinalGraph() {
        GraphUtil.normalizeLoops(this.graph);
        for (ParameterNode param : this.graph.getNodes(ParameterNode.TYPE)) {
            if (!param.hasNoUsages()) continue;
            assert (param.inputs().isEmpty());
            param.safeDelete();
        }
        for (BeginNode beginNode : this.graph.getNodes(BeginNode.TYPE)) {
            Node predecessor = beginNode.predecessor();
            if (predecessor instanceof ControlSplitNode || beginNode.hasUsages()) continue;
            GraphUtil.unlinkFixedNode(beginNode);
            beginNode.safeDelete();
        }
        if (this.graph.isOSR() && this.getParent() == null && this.graph.getNodes(EntryMarkerNode.TYPE).isEmpty()) {
            throw new RetryableBailoutException("OSR entry point wasn't parsed");
        }
    }

    private FrameState createStateAfterStartOfReplacementGraph() {
        assert (this.parent == null);
        assert (this.frameState.getMethod().equals(this.intrinsicContext.getIntrinsicMethod()));
        assert (this.bci() == 0);
        assert (this.frameState.stackSize() == 0);
        FrameState stateAfterStart = this.intrinsicContext.isPostParseInlined() ? this.graph.add(new FrameState(-2)) : this.frameState.createInitialIntrinsicFrameState(this.intrinsicContext.getOriginalMethod());
        return stateAfterStart;
    }

    protected void handleUnresolvedLoadConstant(JavaType type) {
        assert (!this.graphBuilderConfig.unresolvedIsError());
        DeoptimizeNode deopt = this.append(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.Unresolved));
        deopt.updateNodeSourcePosition(() -> this.createBytecodePosition());
    }

    protected void handleUnresolvedCheckCast(JavaType type, ValueNode object) {
        assert (!this.graphBuilderConfig.unresolvedIsError());
        this.append(new FixedGuardNode(this.graph.addOrUniqueWithInputs(IsNullNode.create(object)), DeoptimizationReason.Unresolved, DeoptimizationAction.InvalidateRecompile));
        this.frameState.push(JavaKind.Object, this.appendConstant(JavaConstant.NULL_POINTER));
    }

    protected void handleUnresolvedInstanceOf(JavaType type, ValueNode object) {
        assert (!this.graphBuilderConfig.unresolvedIsError());
        AbstractBeginNode successor = this.graph.add(new BeginNode());
        DeoptimizeNode deopt = this.graph.add(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.Unresolved));
        deopt.updateNodeSourcePosition(() -> this.createBytecodePosition());
        this.append(new IfNode(this.graph.addOrUniqueWithInputs(IsNullNode.create(object)), (FixedNode)successor, deopt, BranchProbabilityNode.ALWAYS_TAKEN_PROFILE));
        this.lastInstr = successor;
        this.frameState.push(JavaKind.Int, this.appendConstant((JavaConstant)JavaConstant.INT_0));
    }

    protected void handleUnresolvedNewInstance(JavaType type) {
        assert (!this.graphBuilderConfig.unresolvedIsError());
        DeoptimizeNode deopt = this.append(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.Unresolved));
        deopt.updateNodeSourcePosition(() -> this.createBytecodePosition());
    }

    protected void handleIllegalNewInstance(JavaType type) {
        assert (!this.graphBuilderConfig.unresolvedIsError());
        DeoptimizeNode deopt = this.append(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.Unresolved));
        deopt.updateNodeSourcePosition(() -> this.createBytecodePosition());
    }

    protected void handleUnresolvedNewObjectArray(JavaType type, ValueNode length) {
        assert (!this.graphBuilderConfig.unresolvedIsError());
        DeoptimizeNode deopt = this.append(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.Unresolved));
        deopt.updateNodeSourcePosition(() -> this.createBytecodePosition());
    }

    protected void handleUnresolvedNewMultiArray(JavaType type, ValueNode[] dims) {
        assert (!this.graphBuilderConfig.unresolvedIsError());
        DeoptimizeNode deopt = this.append(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.Unresolved));
        deopt.updateNodeSourcePosition(() -> this.createBytecodePosition());
    }

    protected void handleUnresolvedLoadField(JavaField field, ValueNode receiver) {
        assert (!this.graphBuilderConfig.unresolvedIsError());
        DeoptimizeNode deopt = this.append(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.Unresolved));
        deopt.updateNodeSourcePosition(() -> this.createBytecodePosition());
    }

    protected void handleUnresolvedStoreField(JavaField field, ValueNode value, ValueNode receiver) {
        assert (!this.graphBuilderConfig.unresolvedIsError());
        DeoptimizeNode deopt = this.append(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.Unresolved));
        deopt.updateNodeSourcePosition(() -> this.createBytecodePosition());
    }

    protected void handleUnresolvedExceptionType(JavaType type) {
        assert (!this.graphBuilderConfig.unresolvedIsError());
        DeoptimizeNode deopt = this.append(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.Unresolved));
        deopt.updateNodeSourcePosition(() -> this.createBytecodePosition());
    }

    protected void handleUnresolvedInvoke(JavaMethod javaMethod, CallTargetNode.InvokeKind invokeKind) {
        assert (!this.graphBuilderConfig.unresolvedIsError());
        DeoptimizeNode deopt = this.append(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.Unresolved));
        deopt.updateNodeSourcePosition(() -> this.createBytecodePosition());
    }

    private AbstractBeginNode handleException(ValueNode exceptionObject, int bci, boolean deoptimizeOnly) {
        AbstractBeginNode dispatchBegin;
        FixedWithNextNode currentLastInstr = this.lastInstr;
        assert (bci == -2 || bci == this.bci()) : "invalid bci";
        this.debug.log("Creating exception dispatch edges at %d, exception object=%s, exception seen=%s", (Object)bci, (Object)exceptionObject, (Object)(this.profilingInfo == null ? "" : this.profilingInfo.getExceptionSeen(bci)));
        FrameStateBuilder dispatchState = this.frameState.copy();
        dispatchState.clearStack();
        if (exceptionObject == null) {
            ExceptionObjectNode newExceptionObject = this.graph.add(new ExceptionObjectNode(this.getMetaAccess()));
            dispatchState.push(JavaKind.Object, newExceptionObject);
            dispatchState.setRethrowException(true);
            newExceptionObject.setStateAfter(dispatchState.create(bci, newExceptionObject));
            dispatchBegin = newExceptionObject;
        } else {
            dispatchBegin = this.graph.add(new BeginNode());
            dispatchState.push(JavaKind.Object, exceptionObject);
            dispatchState.setRethrowException(true);
        }
        this.controlFlowSplit = true;
        FixedWithNextNode afterExceptionLoaded = this.processInstruction(dispatchBegin, dispatchState);
        if (deoptimizeOnly) {
            DeoptimizeNode deoptimizeNode = this.graph.add(new DeoptimizeNode(DeoptimizationAction.None, DeoptimizationReason.TransferToInterpreter));
            afterExceptionLoaded.setNext(BeginNode.begin(deoptimizeNode));
        } else {
            this.createHandleExceptionTarget(afterExceptionLoaded, bci, dispatchState);
        }
        assert (currentLastInstr == this.lastInstr);
        return dispatchBegin;
    }

    protected void createHandleExceptionTarget(FixedWithNextNode afterExceptionLoaded, int bci, FrameStateBuilder dispatchState) {
        FixedWithNextNode afterInstrumentation = afterExceptionLoaded;
        for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
            afterInstrumentation = plugin.instrumentExceptionDispatch(this.graph, afterInstrumentation, () -> dispatchState.create(bci, this.getNonIntrinsicAncestor(), false, null, null));
            assert (afterInstrumentation.next() == null) : "exception dispatch instrumentation will be linked to dispatch block";
        }
        BciBlockMapping.BciBlock dispatchBlock = this.currentBlock.exceptionDispatchBlock();
        if (bci != this.currentBlock.endBci || dispatchBlock == null) {
            dispatchBlock = this.blockMap.getUnwindBlock();
        }
        FixedNode target = this.createTarget(dispatchBlock, dispatchState);
        afterInstrumentation.setNext(target);
    }

    protected ValueNode genLoadIndexed(ValueNode array, ValueNode index, GuardingNode boundsCheck, JavaKind kind) {
        return LoadIndexedNode.create(this.graph.getAssumptions(), array, index, boundsCheck, kind, this.getMetaAccess(), this.getConstantReflection());
    }

    protected void genStoreIndexed(ValueNode array, ValueNode index, GuardingNode boundsCheck, GuardingNode storeCheck, JavaKind kind, ValueNode value) {
        this.add(new StoreIndexedNode(array, index, boundsCheck, storeCheck, kind, value));
    }

    protected ValueNode genIntegerAdd(ValueNode x, ValueNode y) {
        return AddNode.create(x, y, NodeView.DEFAULT);
    }

    protected ValueNode genIntegerSub(ValueNode x, ValueNode y) {
        return SubNode.create(x, y, NodeView.DEFAULT);
    }

    protected ValueNode genIntegerMul(ValueNode x, ValueNode y) {
        return MulNode.create(x, y, NodeView.DEFAULT);
    }

    protected ValueNode genFloatAdd(ValueNode x, ValueNode y) {
        return AddNode.create(x, y, NodeView.DEFAULT);
    }

    protected ValueNode genFloatSub(ValueNode x, ValueNode y) {
        return SubNode.create(x, y, NodeView.DEFAULT);
    }

    protected ValueNode genFloatMul(ValueNode x, ValueNode y) {
        return MulNode.create(x, y, NodeView.DEFAULT);
    }

    protected ValueNode genFloatDiv(ValueNode x, ValueNode y) {
        return FloatDivNode.create(x, y, NodeView.DEFAULT);
    }

    protected ValueNode genFloatRem(ValueNode x, ValueNode y) {
        return RemNode.create(x, y, NodeView.DEFAULT);
    }

    protected ValueNode genIntegerDiv(ValueNode x, ValueNode y, GuardingNode zeroCheck) {
        return SignedDivNode.create(x, y, zeroCheck, NodeView.DEFAULT);
    }

    protected ValueNode genIntegerRem(ValueNode x, ValueNode y, GuardingNode zeroCheck) {
        return SignedRemNode.create(x, y, zeroCheck, NodeView.DEFAULT);
    }

    protected ValueNode genNegateOp(ValueNode x) {
        return NegateNode.create(x, NodeView.DEFAULT);
    }

    protected ValueNode genLeftShift(ValueNode x, ValueNode y) {
        return LeftShiftNode.create(x, y, NodeView.DEFAULT);
    }

    protected ValueNode genRightShift(ValueNode x, ValueNode y) {
        return RightShiftNode.create(x, y, NodeView.DEFAULT);
    }

    protected ValueNode genUnsignedRightShift(ValueNode x, ValueNode y) {
        return UnsignedRightShiftNode.create(x, y, NodeView.DEFAULT);
    }

    protected ValueNode genAnd(ValueNode x, ValueNode y) {
        return AndNode.create(x, y, NodeView.DEFAULT);
    }

    protected ValueNode genOr(ValueNode x, ValueNode y) {
        return OrNode.create(x, y, NodeView.DEFAULT);
    }

    protected ValueNode genXor(ValueNode x, ValueNode y) {
        return XorNode.create(x, y, NodeView.DEFAULT);
    }

    protected ValueNode genNormalizeCompare(ValueNode x, ValueNode y, boolean isUnorderedLess) {
        return FloatNormalizeCompareNode.create(x, y, isUnorderedLess, JavaKind.Int, this.getConstantReflection());
    }

    protected ValueNode genIntegerNormalizeCompare(ValueNode x, ValueNode y) {
        return IntegerNormalizeCompareNode.create(x, y, false, JavaKind.Int, this.getConstantReflection());
    }

    protected ValueNode genFloatConvert(FloatConvert op, ValueNode input) {
        return FloatConvertNode.create(op, input, NodeView.DEFAULT);
    }

    protected ValueNode genNarrow(ValueNode input, int bitCount) {
        return NarrowNode.create(input, bitCount, NodeView.DEFAULT);
    }

    protected ValueNode genSignExtend(ValueNode input, int bitCount) {
        return SignExtendNode.create(input, bitCount, NodeView.DEFAULT);
    }

    protected ValueNode genZeroExtend(ValueNode input, int bitCount) {
        return ZeroExtendNode.create(input, bitCount, NodeView.DEFAULT);
    }

    protected void genGoto() {
        ProfilingPlugin profilingPlugin = this.graphBuilderConfig.getPlugins().getProfilingPlugin();
        if (profilingPlugin != null && profilingPlugin.shouldProfile(this, this.method)) {
            FrameState stateBefore = this.createCurrentFrameState();
            int targetBci = this.currentBlock.getSuccessor((int)0).startBci;
            profilingPlugin.profileGoto(this, this.method, this.bci(), targetBci, stateBefore);
        }
        this.appendGoto(this.currentBlock.getSuccessor(0));
        assert (this.currentBlock.numNormalSuccessors() == 1);
    }

    protected LogicNode genObjectEquals(ValueNode x, ValueNode y) {
        return ObjectEqualsNode.create(this.getConstantReflection(), this.getMetaAccess(), this.options, x, y, NodeView.DEFAULT);
    }

    protected LogicNode genIntegerEquals(ValueNode x, ValueNode y) {
        return IntegerEqualsNode.create(this.getConstantReflection(), this.getMetaAccess(), this.options, null, x, y, NodeView.DEFAULT);
    }

    protected LogicNode genIntegerLessThan(ValueNode x, ValueNode y) {
        return IntegerLessThanNode.create(this.getConstantReflection(), this.getMetaAccess(), this.options, null, x, y, NodeView.DEFAULT);
    }

    protected ValueNode genUnique(ValueNode x) {
        return this.graph.addOrUniqueWithInputs(x);
    }

    protected LogicNode genUnique(LogicNode x) {
        return this.graph.addOrUniqueWithInputs(x);
    }

    protected ValueNode genIfNode(LogicNode condition, FixedNode trueSuccessor, FixedNode falseSuccessor, ProfileData.BranchProbabilityData profileData) {
        return new IfNode(condition, trueSuccessor, falseSuccessor, profileData);
    }

    protected void genThrow() {
        this.genInfoPointNode(InfopointReason.BYTECODE_POSITION, null);
        ValueNode exception = this.maybeEmitExplicitNullCheck(this.frameState.pop(JavaKind.Object));
        if (!StampTool.isPointerNonNull(exception.stamp(NodeView.DEFAULT))) {
            FixedGuardNode nullCheck = this.append(new FixedGuardNode(this.graph.addOrUniqueWithInputs(IsNullNode.create(exception)), DeoptimizationReason.NullCheckException, DeoptimizationAction.InvalidateReprofile, true));
            exception = this.graph.maybeAddOrUnique(PiNode.create(exception, exception.stamp(NodeView.DEFAULT).join(StampFactory.objectNonNull()), nullCheck));
        }
        this.lastInstr.setNext(this.handleException(exception, this.bci(), false));
    }

    protected LogicNode createInstanceOf(TypeReference type, ValueNode object) {
        return InstanceOfNode.create(type, object);
    }

    protected AnchoringNode createAnchor(JavaTypeProfile profile) {
        if (profile == null || profile.getNotRecordedProbability() > 0.0) {
            return null;
        }
        return BeginNode.prevBegin(this.lastInstr);
    }

    protected LogicNode createInstanceOf(TypeReference type, ValueNode object, JavaTypeProfile profile) {
        return InstanceOfNode.create(type, object, profile, this.createAnchor(profile));
    }

    protected LogicNode createInstanceOfAllowNull(TypeReference type, ValueNode object, JavaTypeProfile profile) {
        return InstanceOfNode.createAllowNull(type, object, profile, this.createAnchor(profile));
    }

    protected ValueNode genConditional(ValueNode x) {
        return ConditionalNode.create((LogicNode)x, NodeView.DEFAULT);
    }

    protected ValueNode genLoadField(ValueNode receiver, ResolvedJavaField field) {
        StampPair stamp = this.graphBuilderConfig.getPlugins().getOverridingStamp(this, field.getType(), false);
        if (stamp == null) {
            return LoadFieldNode.create(this.getConstantFieldProvider(), this.getConstantReflection(), this.getMetaAccess(), this.getOptions(), this.getAssumptions(), receiver, field, false, false);
        }
        return LoadFieldNode.createOverrideStamp(this.getConstantFieldProvider(), this.getConstantReflection(), this.getMetaAccess(), this.getOptions(), stamp, receiver, field, false, false);
    }

    protected StateSplitProxyNode genVolatileFieldReadProxy(ValueNode fieldRead) {
        return new StateSplitProxyNode(fieldRead);
    }

    public ValueNode maybeEmitExplicitNullCheck(ValueNode receiver) {
        if (StampTool.isPointerNonNull(receiver.stamp(NodeView.DEFAULT)) || !this.needsExplicitNullCheckException(receiver)) {
            return receiver;
        }
        LogicNode condition = this.genUnique(IsNullNode.create(receiver));
        AbstractBeginNode passingSuccessor = this.emitBytecodeExceptionCheck(condition, false, BytecodeExceptionNode.BytecodeExceptionKind.NULL_POINTER, new ValueNode[0]);
        return this.genUnique(PiNode.create(receiver, StampFactory.objectNonNull(), passingSuccessor));
    }

    protected GuardingNode maybeEmitExplicitBoundsCheck(ValueNode receiver, ValueNode index) {
        if (!this.needsExplicitBoundsCheckException(receiver, index)) {
            return null;
        }
        ValueNode length = this.append(this.genArrayLength(receiver));
        LogicNode condition = this.genUnique(IntegerBelowNode.create(this.getConstantReflection(), this.getMetaAccess(), this.options, null, index, length, NodeView.DEFAULT));
        return this.emitBytecodeExceptionCheck(condition, true, BytecodeExceptionNode.BytecodeExceptionKind.OUT_OF_BOUNDS, index, length);
    }

    protected GuardingNode maybeEmitExplicitStoreCheck(ValueNode array, JavaKind elementKind, ValueNode value) {
        if (elementKind != JavaKind.Object || StampTool.isPointerAlwaysNull(value) || !this.needsExplicitStoreCheckException(array, value)) {
            return null;
        }
        ValueNode arrayClass = this.genUnique(LoadHubNode.create(array, this.getStampProvider(), this.getMetaAccess(), this.getConstantReflection()));
        ValueNode componentHub = this.append(LoadArrayComponentHubNode.create(arrayClass, this.getStampProvider(), this.getMetaAccess(), this.getConstantReflection()));
        LogicNode condition = this.genUnique(InstanceOfDynamicNode.create(this.graph.getAssumptions(), this.getConstantReflection(), componentHub, value, true));
        return this.emitBytecodeExceptionCheck(condition, true, BytecodeExceptionNode.BytecodeExceptionKind.ARRAY_STORE, value);
    }

    protected GuardingNode maybeEmitExplicitDivisionByZeroCheck(ValueNode y) {
        if (!((IntegerStamp)y.stamp(NodeView.DEFAULT)).contains(0L) || !this.needsExplicitDivisionByZeroException(y)) {
            return null;
        }
        ConstantNode zero = ConstantNode.defaultForKind(y.getStackKind(), this.graph);
        LogicNode condition = this.genUnique(IntegerEqualsNode.create(this.getConstantReflection(), this.getMetaAccess(), this.options, null, y, zero, NodeView.DEFAULT));
        return this.emitBytecodeExceptionCheck(condition, false, BytecodeExceptionNode.BytecodeExceptionKind.DIVISION_BY_ZERO, new ValueNode[0]);
    }

    @Override
    public AbstractBeginNode emitBytecodeExceptionCheck(LogicNode condition, boolean passingOnTrue, BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, ValueNode ... arguments) {
        AbstractBeginNode result = GraphBuilderContext.super.emitBytecodeExceptionCheck(condition, passingOnTrue, exceptionKind, arguments);
        if (result != null) {
            EXPLICIT_EXCEPTIONS.increment(this.debug);
        }
        return result;
    }

    protected ValueNode genArrayLength(ValueNode x) {
        ValueNode array = this.maybeEmitExplicitNullCheck(x);
        return ArrayLengthNode.create(array, this.getConstantReflection());
    }

    protected void genStoreField(ValueNode receiver, ResolvedJavaField field, ValueNode value) {
        StoreFieldNode storeFieldNode = new StoreFieldNode(receiver, field, this.maskSubWordValue(value, field.getJavaKind()));
        this.append(storeFieldNode);
        storeFieldNode.setStateAfter(this.createFrameState(this.stream.nextBCI(), storeFieldNode));
    }

    private static boolean callTargetIsResolved(JavaMethod target) {
        if (target instanceof ResolvedJavaMethod) {
            ResolvedJavaMethod resolvedTarget = (ResolvedJavaMethod)target;
            ResolvedJavaType resolvedType = resolvedTarget.getDeclaringClass();
            return resolvedType.isInterface() || resolvedType.isLinked();
        }
        return false;
    }

    protected boolean typeIsResolved(JavaType type) {
        return type instanceof ResolvedJavaType;
    }

    protected void genInvokeStatic(int cpi, int opcode) {
        JavaMethod target = this.lookupMethod(cpi, opcode);
        assert (!this.uninitializedIsError || target instanceof ResolvedJavaMethod && ((ResolvedJavaMethod)target).getDeclaringClass().isInitialized()) : target;
        this.genInvokeStatic(target);
    }

    void genInvokeStatic(JavaMethod target) {
        if (BytecodeParser.callTargetIsResolved(target)) {
            ValueNode[] args;
            Invoke invoke;
            ResolvedJavaMethod resolvedTarget = (ResolvedJavaMethod)target;
            ResolvedJavaType holder = resolvedTarget.getDeclaringClass();
            this.maybeEagerlyInitialize(holder);
            ClassInitializationPlugin classInitializationPlugin = this.graphBuilderConfig.getPlugins().getClassInitializationPlugin();
            if (!holder.isInitialized() && classInitializationPlugin == null) {
                this.handleUnresolvedInvoke(target, CallTargetNode.InvokeKind.Static);
                return;
            }
            ValueNode[] classInit = new ValueNode[]{null};
            if (classInitializationPlugin != null) {
                classInitializationPlugin.apply(this, resolvedTarget.getDeclaringClass(), this::createCurrentFrameState, classInit);
            }
            if ((invoke = this.appendInvoke(CallTargetNode.InvokeKind.Static, resolvedTarget, args = this.frameState.popArguments(resolvedTarget.getSignature().getParameterCount(false)))) != null && classInit[0] != null) {
                invoke.setClassInit(classInit[0]);
            }
        } else {
            this.handleUnresolvedInvoke(target, CallTargetNode.InvokeKind.Static);
        }
    }

    private FrameState createCurrentFrameState() {
        return this.frameState.create(this.bci(), this.getNonIntrinsicAncestor(), false, null, null);
    }

    protected void genInvokeInterface(int cpi, int opcode) {
        JavaMethod target = this.lookupMethod(cpi, opcode);
        JavaType referencedType = this.lookupReferencedTypeInPool(cpi, opcode);
        this.genInvokeInterface(referencedType, target);
    }

    protected void genInvokeInterface(JavaType referencedType, JavaMethod target) {
        if (BytecodeParser.callTargetIsResolved(target) && (referencedType == null || referencedType instanceof ResolvedJavaType)) {
            ValueNode[] args = this.frameState.popArguments(target.getSignature().getParameterCount(true));
            Invoke invoke = this.appendInvoke(CallTargetNode.InvokeKind.Interface, (ResolvedJavaMethod)target, args);
            if (invoke != null) {
                invoke.callTarget().setReferencedType((ResolvedJavaType)referencedType);
            }
        } else {
            this.handleUnresolvedInvoke(target, CallTargetNode.InvokeKind.Interface);
        }
    }

    protected void genInvokeDynamic(int cpi, int opcode) {
        JavaMethod target = this.lookupMethod(cpi, opcode);
        this.genInvokeDynamic(target);
    }

    void genInvokeDynamic(JavaMethod target) {
        if (!(target instanceof ResolvedJavaMethod) || !this.genDynamicInvokeHelper((ResolvedJavaMethod)target, this.stream.readCPI4(), 186)) {
            this.handleUnresolvedInvoke(target, CallTargetNode.InvokeKind.Static);
        }
    }

    protected void genInvokeVirtual(int cpi, int opcode) {
        JavaMethod target = this.lookupMethod(cpi, opcode);
        if (BytecodeParser.callTargetIsResolved(target)) {
            this.genInvokeVirtual((ResolvedJavaMethod)target);
        } else {
            this.handleUnresolvedInvoke(target, CallTargetNode.InvokeKind.Virtual);
        }
    }

    protected void genInvokeVirtual(ResolvedJavaMethod resolvedTarget) {
        char cpi = this.stream.readCPI();
        if (this.genDynamicInvokeHelper(resolvedTarget, cpi, 182)) {
            return;
        }
        ValueNode[] args = this.frameState.popArguments(resolvedTarget.getSignature().getParameterCount(true));
        this.appendInvoke(CallTargetNode.InvokeKind.Virtual, resolvedTarget, args);
    }

    private boolean genDynamicInvokeHelper(ResolvedJavaMethod target, int cpi, int opcode) {
        assert (opcode == 186 || opcode == 182);
        InvokeDynamicPlugin invokeDynamicPlugin = this.graphBuilderConfig.getPlugins().getInvokeDynamicPlugin();
        if (opcode == 182 && invokeDynamicPlugin != null && !invokeDynamicPlugin.isResolvedDynamicInvoke(this, cpi, opcode)) {
            return false;
        }
        if (GraalOptions.GeneratePIC.getValue(this.options).booleanValue() && (invokeDynamicPlugin == null || !invokeDynamicPlugin.supportsDynamicInvoke(this, cpi, opcode))) {
            this.append(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.Unresolved));
            return true;
        }
        JavaConstant appendix = this.constantPool.lookupAppendix(cpi, opcode);
        ValueNode appendixNode = null;
        if (appendix != null) {
            if (invokeDynamicPlugin != null) {
                invokeDynamicPlugin.recordDynamicMethod(this, cpi, opcode, target);
                FrameState stateBefore = this.createCurrentFrameState();
                appendixNode = invokeDynamicPlugin.genAppendixNode(this, cpi, opcode, appendix, stateBefore);
            } else {
                appendixNode = ConstantNode.forConstant(appendix, this.getMetaAccess(), this.graph);
            }
            this.frameState.push(JavaKind.Object, appendixNode);
        } else if (GraalOptions.GeneratePIC.getValue(this.options).booleanValue()) {
            this.append(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.Unresolved));
            return true;
        }
        boolean hasReceiver = opcode == 186 ? false : !target.isStatic();
        ValueNode[] args = this.frameState.popArguments(target.getSignature().getParameterCount(hasReceiver));
        if (hasReceiver) {
            this.appendInvoke(CallTargetNode.InvokeKind.Virtual, target, args);
        } else {
            this.appendInvoke(CallTargetNode.InvokeKind.Static, target, args);
        }
        return true;
    }

    protected void genInvokeSpecial(int cpi, int opcode) {
        JavaMethod target = this.lookupMethod(cpi, opcode);
        this.genInvokeSpecial(target);
    }

    void genInvokeSpecial(JavaMethod target) {
        if (BytecodeParser.callTargetIsResolved(target)) {
            assert (target != null);
            assert (target.getSignature() != null);
            ValueNode[] args = this.frameState.popArguments(target.getSignature().getParameterCount(true));
            this.appendInvoke(CallTargetNode.InvokeKind.Special, (ResolvedJavaMethod)target, args);
        } else {
            this.handleUnresolvedInvoke(target, CallTargetNode.InvokeKind.Special);
        }
    }

    @Override
    public CallTargetNode.InvokeKind getInvokeKind() {
        return this.currentInvoke == null ? null : this.currentInvoke.kind;
    }

    @Override
    public JavaType getInvokeReturnType() {
        return this.currentInvoke == null ? null : this.currentInvoke.returnType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Invoke handleReplacedInvoke(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, boolean inlineEverything) {
        boolean previous = this.forceInliningEverything;
        this.forceInliningEverything = previous || inlineEverything;
        try {
            this.setBciCanBeDuplicated(true);
            Invoke invoke = this.appendInvoke(invokeKind, targetMethod, args);
            return invoke;
        }
        finally {
            this.setBciCanBeDuplicated(false);
            this.forceInliningEverything = previous;
        }
    }

    @Override
    public void handleReplacedInvoke(CallTargetNode callTarget, JavaKind resultType) {
        BytecodeParser intrinsicCallSiteParser = this.getNonIntrinsicAncestor();
        ExceptionEdgeAction exceptionEdgeAction = intrinsicCallSiteParser == null ? this.getActionForInvokeExceptionEdge(null) : intrinsicCallSiteParser.getActionForInvokeExceptionEdge(null);
        this.createNonInlinedInvoke(exceptionEdgeAction, this.bci(), callTarget, resultType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Invoke appendInvoke(CallTargetNode.InvokeKind initialInvokeKind, ResolvedJavaMethod initialTargetMethod, ValueNode[] args) {
        ResolvedJavaType contextType;
        ResolvedJavaMethod specialCallTarget;
        ResolvedJavaMethod targetMethod = initialTargetMethod;
        CallTargetNode.InvokeKind invokeKind = initialInvokeKind;
        if (initialInvokeKind.isIndirect() && (specialCallTarget = MethodCallTargetNode.findSpecialCallTarget(initialInvokeKind, args[0], initialTargetMethod, contextType = this.frameState.getMethod().getDeclaringClass())) != null) {
            invokeKind = CallTargetNode.InvokeKind.Special;
            targetMethod = specialCallTarget;
        }
        JavaKind resultType = targetMethod.getSignature().getReturnKind();
        if (!this.parsingIntrinsic() && GraalOptions.DeoptALot.getValue(this.options).booleanValue()) {
            this.append(new DeoptimizeNode(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint));
            this.frameState.pushReturn(resultType, ConstantNode.defaultForKind(resultType, this.graph));
            return null;
        }
        JavaType returnType = this.maybeEagerlyResolve(targetMethod.getSignature().getReturnType(this.method.getDeclaringClass()), targetMethod.getDeclaringClass());
        if (invokeKind.hasReceiver()) {
            args[0] = this.maybeEmitExplicitNullCheck(args[0]);
        }
        if (initialInvokeKind == CallTargetNode.InvokeKind.Special && !targetMethod.isConstructor()) {
            this.emitCheckForInvokeSuperSpecial(args);
        } else if (initialInvokeKind == CallTargetNode.InvokeKind.Interface && targetMethod.isPrivate()) {
            this.emitCheckForDeclaringClassChange(targetMethod.getDeclaringClass(), args);
        }
        InlineInvokePlugin.InlineInfo inlineInfo = null;
        try {
            this.currentInvoke = new CurrentInvoke(args, invokeKind, returnType);
            if (this.tryNodePluginForInvocation(args, targetMethod)) {
                if (BytecodeParserOptions.TraceParserPlugins.getValue(this.options).booleanValue()) {
                    this.traceWithContext("used node plugin for %s", targetMethod.format("%h.%n(%p)"));
                }
                Invoke invoke = null;
                return invoke;
            }
            if (invokeKind.hasReceiver() && args[0].isNullConstant()) {
                this.append(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.NullCheckException));
                Invoke invoke = null;
                return invoke;
            }
            if (invokeKind.isDirect()) {
                if (this.tryInvocationPlugin(invokeKind, args, targetMethod, resultType)) {
                    if (BytecodeParserOptions.TraceParserPlugins.getValue(this.options).booleanValue()) {
                        this.traceWithContext("used invocation plugin for %s", targetMethod.format("%h.%n(%p)"));
                    }
                    Invoke invoke = null;
                    return invoke;
                }
                inlineInfo = this.tryInline(args, targetMethod);
                if (inlineInfo == SUCCESSFULLY_INLINED) {
                    Invoke invoke = null;
                    return invoke;
                }
            }
        }
        finally {
            this.currentInvoke = null;
        }
        int invokeBci = this.bci();
        JavaTypeProfile profile = this.getProfileForInvoke(invokeKind);
        ExceptionEdgeAction edgeAction = this.getActionForInvokeExceptionEdge(inlineInfo);
        boolean partialIntrinsicExit = false;
        if (this.intrinsicContext != null && this.intrinsicContext.isCallToOriginal(targetMethod)) {
            partialIntrinsicExit = true;
            ResolvedJavaMethod originalMethod = this.intrinsicContext.getOriginalMethod();
            BytecodeParser intrinsicCallSiteParser = this.getNonIntrinsicAncestor();
            if (intrinsicCallSiteParser != null) {
                invokeBci = intrinsicCallSiteParser.bci();
                profile = intrinsicCallSiteParser.getProfileForInvoke(invokeKind);
                edgeAction = intrinsicCallSiteParser.getActionForInvokeExceptionEdge(inlineInfo);
            } else {
                assert (this.intrinsicContext.isPostParseInlined());
                invokeBci = -5;
                profile = null;
                edgeAction = this.getReplacements().isSnippet(this.graph.method()) ? ExceptionEdgeAction.OMIT : ExceptionEdgeAction.INCLUDE_AND_HANDLE;
            }
            invokeKind = originalMethod.isStatic() ? CallTargetNode.InvokeKind.Static : CallTargetNode.InvokeKind.Special;
            Signature sig = originalMethod.getSignature();
            returnType = sig.getReturnType(this.method.getDeclaringClass());
            resultType = sig.getReturnKind();
            assert (this.intrinsicContext.allowPartialIntrinsicArgumentMismatch() || BytecodeParser.checkPartialIntrinsicExit(intrinsicCallSiteParser == null ? null : intrinsicCallSiteParser.currentInvoke.args, args));
            targetMethod = originalMethod;
        }
        Invoke invoke = this.createNonInlinedInvoke(edgeAction, invokeBci, args, targetMethod, invokeKind, resultType, returnType, profile);
        this.graph.getInliningLog().addDecision(invoke, false, "GraphBuilderPhase", null, null, "bytecode parser did not replace invoke", new Object[0]);
        if (partialIntrinsicExit) {
            invoke.setInlineControl(Invoke.InlineControl.BytecodesOnly);
        }
        return invoke;
    }

    private void emitCheckForDeclaringClassChange(ResolvedJavaType declaringClass, ValueNode[] args) {
        ValueNode receiver = args[0];
        TypeReference checkedType = TypeReference.createTrusted(this.graph.getAssumptions(), declaringClass);
        LogicNode condition = this.genUnique(this.createInstanceOf(checkedType, receiver, null));
        FixedGuardNode fixedGuard = this.append(new FixedGuardNode(condition, DeoptimizationReason.ClassCastException, DeoptimizationAction.None, false));
        args[0] = this.append(PiNode.create(receiver, StampFactory.object(checkedType, true), fixedGuard));
    }

    protected void emitCheckForInvokeSuperSpecial(ValueNode[] args) {
        ResolvedJavaType callingClass = this.method.getDeclaringClass();
        if (callingClass.getHostClass() != null) {
            callingClass = callingClass.getHostClass();
        }
        if (callingClass.isInterface()) {
            ValueNode receiver = args[0];
            TypeReference checkedType = TypeReference.createTrusted(this.graph.getAssumptions(), callingClass);
            LogicNode condition = this.genUnique(this.createInstanceOf(checkedType, receiver, null));
            FixedGuardNode fixedGuard = this.append(new FixedGuardNode(condition, DeoptimizationReason.ClassCastException, DeoptimizationAction.None, false));
            args[0] = this.append(PiNode.create(receiver, StampFactory.object(checkedType, true), fixedGuard));
        }
    }

    protected JavaTypeProfile getProfileForInvoke(CallTargetNode.InvokeKind invokeKind) {
        if (invokeKind.isIndirect() && this.profilingInfo != null && this.optimisticOpts.useTypeCheckHints(this.getOptions())) {
            return this.profilingInfo.getTypeProfile(this.bci());
        }
        return null;
    }

    private static boolean checkPartialIntrinsicExit(ValueNode[] originalArgs, ValueNode[] recursiveArgs) {
        if (originalArgs != null) {
            for (int i = 0; i < originalArgs.length; ++i) {
                ValueNode arg = GraphUtil.unproxify(recursiveArgs[i]);
                ValueNode icArg = GraphUtil.unproxify(originalArgs[i]);
                assert (arg == icArg) : String.format("argument %d of call denoting partial intrinsic exit should be %s, not %s", i, icArg, arg);
            }
        } else {
            for (int i = 0; i < recursiveArgs.length; ++i) {
                ValueNode arg = GraphUtil.unproxify(recursiveArgs[i]);
                assert (arg instanceof ParameterNode && ((ParameterNode)arg).index() == i) : String.format("argument %d of call denoting partial intrinsic exit should be a %s with index %d, not %s", i, ParameterNode.class.getSimpleName(), i, arg);
            }
        }
        return true;
    }

    protected Invoke createNonInlinedInvoke(ExceptionEdgeAction exceptionEdge, int invokeBci, ValueNode[] invokeArgs, ResolvedJavaMethod targetMethod, CallTargetNode.InvokeKind invokeKind, JavaKind resultType, JavaType returnType, JavaTypeProfile profile) {
        StampPair returnStamp = this.graphBuilderConfig.getPlugins().getOverridingStamp(this, returnType, false);
        if (returnStamp == null) {
            returnStamp = StampFactory.forDeclaredType(this.graph.getAssumptions(), returnType, false);
        }
        MethodCallTargetNode callTarget = this.graph.add(this.createMethodCallTarget(invokeKind, targetMethod, invokeArgs, returnStamp, profile));
        Invoke invoke = this.createNonInlinedInvoke(exceptionEdge, invokeBci, callTarget, resultType);
        for (InlineInvokePlugin plugin : this.graphBuilderConfig.getPlugins().getInlineInvokePlugins()) {
            plugin.notifyNotInlined(this, targetMethod, invoke);
        }
        return invoke;
    }

    protected Invoke createNonInlinedInvoke(ExceptionEdgeAction exceptionEdge, int invokeBci, CallTargetNode callTarget, JavaKind resultType) {
        if (exceptionEdge == ExceptionEdgeAction.OMIT) {
            return this.createInvoke(invokeBci, callTarget, resultType);
        }
        return this.createInvokeWithException(invokeBci, callTarget, resultType, exceptionEdge);
    }

    protected ExceptionEdgeAction getActionForInvokeExceptionEdge(InlineInvokePlugin.InlineInfo lastInlineInfo) {
        TriState exceptionSeen;
        if (lastInlineInfo == InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_WITH_EXCEPTION) {
            return ExceptionEdgeAction.INCLUDE_AND_HANDLE;
        }
        if (lastInlineInfo == InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_NO_EXCEPTION) {
            return ExceptionEdgeAction.OMIT;
        }
        if (lastInlineInfo == InlineInvokePlugin.InlineInfo.DO_NOT_INLINE_DEOPTIMIZE_ON_EXCEPTION) {
            return ExceptionEdgeAction.INCLUDE_AND_DEOPTIMIZE;
        }
        if (this.graphBuilderConfig.getBytecodeExceptionMode() == GraphBuilderConfiguration.BytecodeExceptionMode.CheckAll) {
            return ExceptionEdgeAction.INCLUDE_AND_HANDLE;
        }
        if (this.graphBuilderConfig.getBytecodeExceptionMode() == GraphBuilderConfiguration.BytecodeExceptionMode.ExplicitOnly) {
            return ExceptionEdgeAction.INCLUDE_AND_HANDLE;
        }
        if (this.graphBuilderConfig.getBytecodeExceptionMode() == GraphBuilderConfiguration.BytecodeExceptionMode.OmitAll) {
            return ExceptionEdgeAction.OMIT;
        }
        assert (this.graphBuilderConfig.getBytecodeExceptionMode() == GraphBuilderConfiguration.BytecodeExceptionMode.Profile);
        if (!GraalOptions.StressInvokeWithExceptionNode.getValue(this.options).booleanValue() && this.optimisticOpts.useExceptionProbability(this.getOptions()) && this.profilingInfo != null && (exceptionSeen = this.profilingInfo.getExceptionSeen(this.bci())) == TriState.FALSE) {
            return ExceptionEdgeAction.OMIT;
        }
        return ExceptionEdgeAction.INCLUDE_AND_HANDLE;
    }

    @Override
    public void replacePlugin(GeneratedInvocationPlugin plugin, ResolvedJavaMethod targetMethod, ValueNode[] args, PluginReplacementNode.ReplacementFunction replacementFunction) {
        assert (replacementFunction != null);
        JavaType returnType = this.maybeEagerlyResolve(targetMethod.getSignature().getReturnType(this.method.getDeclaringClass()), targetMethod.getDeclaringClass());
        StampPair returnStamp = this.getReplacements().getGraphBuilderPlugins().getOverridingStamp(this, returnType, false);
        if (returnStamp == null) {
            returnStamp = StampFactory.forDeclaredType(this.getAssumptions(), returnType, false);
        }
        PluginReplacementNode node = new PluginReplacementNode(returnStamp.getTrustedStamp(), args, replacementFunction, plugin.getClass().getSimpleName());
        if (returnType.getJavaKind() == JavaKind.Void) {
            this.add(node);
        } else {
            this.addPush(returnType.getJavaKind(), node);
        }
    }

    protected boolean tryInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType) {
        InvocationPlugin plugin = this.graphBuilderConfig.getPlugins().getInvocationPlugins().lookupInvocation(targetMethod);
        if (plugin != null) {
            if (this.intrinsicContext != null && this.intrinsicContext.isCallToOriginal(targetMethod)) {
                return false;
            }
            if (this.applyInvocationPlugin(invokeKind, args, targetMethod, resultType, plugin)) {
                return !plugin.isDecorator();
            }
        }
        return false;
    }

    protected boolean applyInvocationPlugin(CallTargetNode.InvokeKind invokeKind, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType, InvocationPlugin plugin) {
        InvocationPlugins.InvocationPluginReceiver pluginReceiver = this.invocationPluginReceiver.init(targetMethod, args);
        assert (invokeKind.isDirect()) : "Cannot apply invocation plugin on an indirect call site.";
        InvocationPluginAssertions assertions = Assertions.assertionsEnabled() ? new InvocationPluginAssertions(plugin, args, targetMethod, resultType) : null;
        try (DebugCloseable context = this.openNodeContext(targetMethod);){
            if (plugin.execute(this, targetMethod, pluginReceiver, args)) {
                assert (assertions.check(true));
                boolean bl = true;
                return bl;
            }
            assert (assertions.check(false));
        }
        return false;
    }

    private boolean tryNodePluginForInvocation(ValueNode[] args, ResolvedJavaMethod targetMethod) {
        for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
            if (!plugin.handleInvoke(this, targetMethod, args)) continue;
            return true;
        }
        return false;
    }

    private InlineInvokePlugin.InlineInfo tryInline(ValueNode[] args, ResolvedJavaMethod targetMethod) {
        boolean canBeInlined;
        boolean bl = canBeInlined = this.forceInliningEverything || this.parsingIntrinsic() || targetMethod.canBeInlined();
        if (!canBeInlined) {
            return null;
        }
        if (this.forceInliningEverything) {
            if (this.inline(targetMethod, targetMethod, null, args)) {
                return SUCCESSFULLY_INLINED;
            }
            return null;
        }
        for (InlineInvokePlugin plugin : this.graphBuilderConfig.getPlugins().getInlineInvokePlugins()) {
            InlineInvokePlugin.InlineInfo inlineInfo = plugin.shouldInlineInvoke(this, targetMethod, args);
            if (inlineInfo == null) continue;
            if (inlineInfo.allowsInlining()) {
                if (this.inline(targetMethod, inlineInfo.getMethodToInline(), inlineInfo.getIntrinsicBytecodeProvider(), args)) {
                    return SUCCESSFULLY_INLINED;
                }
                inlineInfo = null;
            }
            return inlineInfo;
        }
        if (this.parsingIntrinsic() && this.inline(targetMethod, targetMethod, this.bytecodeProvider, args)) {
            return SUCCESSFULLY_INLINED;
        }
        return null;
    }

    private boolean tryFastInlineAccessor(ValueNode[] args, ResolvedJavaMethod targetMethod) {
        int b4;
        byte[] bytecode = targetMethod.getCode();
        if (bytecode != null && bytecode.length == 5 && Bytes.beU1(bytecode, 0) == 42 && Bytes.beU1(bytecode, 1) == 180 && (b4 = Bytes.beU1(bytecode, 4)) >= 172 && b4 <= 176) {
            int cpi = Bytes.beU2(bytecode, 2);
            JavaField field = targetMethod.getConstantPool().lookupField(cpi, targetMethod, 180);
            if (field instanceof ResolvedJavaField) {
                ValueNode receiver = this.invocationPluginReceiver.init(targetMethod, args).get();
                ResolvedJavaField resolvedField = (ResolvedJavaField)field;
                try (DebugCloseable context = this.openNodeContext(targetMethod, 1);){
                    this.genGetField(resolvedField, receiver);
                    this.notifyBeforeInline(targetMethod);
                    String reason = "inline accessor method (bytecode parsing)";
                    this.printInlining(targetMethod, targetMethod, true, reason);
                    if (GraalOptions.TraceInlining.getValue(this.options).booleanValue() || this.debug.hasCompilationListener()) {
                        InliningLog.PlaceholderInvokable invoke = new InliningLog.PlaceholderInvokable(this.method, targetMethod, this.bci());
                        this.graph.getInliningLog().addDecision(invoke, true, "GraphBuilderPhase", null, null, reason, new Object[0]);
                    }
                    this.notifyAfterInline(targetMethod);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean intrinsify(ResolvedJavaMethod targetMethod, StructuredGraph substituteGraph, InvocationPlugin.Receiver receiver, ValueNode[] args) {
        if (receiver != null) {
            receiver.get();
        }
        WithExceptionNode withException = null;
        boolean insertExceptionEdge = false;
        FixedWithNextNode replacee = this.lastInstr;
        try (DebugContext.Scope a = this.debug.scope((Object)"instantiate", substituteGraph);){
            StartNode entryPointNode = substituteGraph.start();
            FixedNode firstCFGNode = entryPointNode.next();
            StructuredGraph replaceeGraph = replacee.graph();
            Graph.Mark mark = replaceeGraph.getMark();
            try (IntrinsicScope inlineScope = new IntrinsicScope(this, targetMethod, args);){
                EconomicMap replacementsMap = EconomicMap.create((Equivalence)Equivalence.IDENTITY);
                for (ParameterNode param : substituteGraph.getNodes(ParameterNode.TYPE)) {
                    replacementsMap.put((Object)param, (Object)args[param.index()]);
                }
                replacementsMap.put((Object)entryPointNode, (Object)AbstractBeginNode.prevBegin(replacee));
                this.debug.dump(4, (Object)replaceeGraph, "Before inlining method substitution %s", substituteGraph.method());
                UnmodifiableEconomicMap<Node, Node> duplicates = BytecodeParser.inlineMethodSubstitution(replaceeGraph, substituteGraph, (EconomicMap<Node, Node>)replacementsMap);
                FixedNode firstCFGNodeDuplicate = (FixedNode)duplicates.get((Object)firstCFGNode);
                replacee.setNext(firstCFGNodeDuplicate);
                this.debug.dump(4, (Object)replaceeGraph, "After inlining method substitution %s", substituteGraph.method());
                for (Node node : this.graph.getNewNodes(mark)) {
                    ForeignCall call;
                    if (node instanceof Invoke) {
                        Invoke invoke = (Invoke)((Object)node);
                        if (invoke.bci() == -5) {
                            invoke.setBci(this.bci());
                        }
                    } else if (node instanceof ForeignCall && (call = (ForeignCall)((Object)node)).bci() == -5) {
                        call.setBci(this.bci());
                        if (call.stateAfter() != null && call.stateAfter().bci == -6) {
                            call.setStateAfter(inlineScope.stateBefore);
                        }
                    }
                    if (!(node instanceof WithExceptionNode)) continue;
                    assert (withException == null) : "at most one exception edge expected";
                    withException = (WithExceptionNode)node;
                    BytecodeParser intrinsicCallSiteParser = this.getNonIntrinsicAncestor();
                    if (intrinsicCallSiteParser != null && intrinsicCallSiteParser.getActionForInvokeExceptionEdge(null) == ExceptionEdgeAction.OMIT) {
                        withException.replaceWithNonThrowing();
                        continue;
                    }
                    insertExceptionEdge = true;
                    withException.killExceptionEdge();
                }
                ArrayList<ReturnToCallerData> calleeReturnDataList = new ArrayList<ReturnToCallerData>();
                for (ReturnNode n : substituteGraph.getNodes(ReturnNode.TYPE)) {
                    ReturnNode returnNode = (ReturnNode)duplicates.get((Object)n);
                    FixedWithNextNode predecessor = (FixedWithNextNode)returnNode.predecessor();
                    calleeReturnDataList.add(new ReturnToCallerData(returnNode.result(), predecessor));
                    predecessor.setNext(null);
                    returnNode.safeDelete();
                }
                this.processCalleeReturn(targetMethod, inlineScope, calleeReturnDataList);
            }
            if (insertExceptionEdge) {
                AbstractBeginNode exceptionEdge = this.handleException(null, this.bci(), false);
                withException.setExceptionEdge(exceptionEdge);
            }
            this.debug.dump(4, replaceeGraph, "After lowering %s with %s", replacee, this);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            throw this.debug.handle(t);
        }
    }

    private static UnmodifiableEconomicMap<Node, Node> inlineMethodSubstitution(StructuredGraph replaceeGraph, StructuredGraph snippet, EconomicMap<Node, Node> replacementsMap) {
        try (InliningLog.UpdateScope scope = replaceeGraph.getInliningLog().openUpdateScope((oldNode, newNode) -> {
            InliningLog log = replaceeGraph.getInliningLog();
            if (oldNode == null) {
                log.trackNewCallsite((Invokable)newNode);
            }
        });){
            StartNode entryPointNode = snippet.start();
            ArrayList<Node> nodes = new ArrayList<Node>(snippet.getNodeCount());
            for (Node node : snippet.getNodes()) {
                if (node == entryPointNode || node == entryPointNode.stateAfter()) continue;
                nodes.add(node);
            }
            UnmodifiableEconomicMap<Node, Node> duplicates = replaceeGraph.addDuplicates(nodes, (Graph)snippet, snippet.getNodeCount(), replacementsMap);
            if (scope != null) {
                replaceeGraph.getInliningLog().addLog(duplicates, snippet.getInliningLog());
            }
            UnmodifiableEconomicMap<Node, Node> unmodifiableEconomicMap = duplicates;
            return unmodifiableEconomicMap;
        }
    }

    @Override
    public boolean intrinsify(BytecodeProvider intrinsicBytecodeProvider, ResolvedJavaMethod targetMethod, ResolvedJavaMethod substitute, InvocationPlugin.Receiver receiver, ValueNode[] args) {
        if (receiver != null) {
            receiver.get();
        }
        boolean res = this.inline(targetMethod, substitute, intrinsicBytecodeProvider, args);
        assert (res) : "failed to inline " + substitute;
        return res;
    }

    private boolean inline(ResolvedJavaMethod targetMethod, ResolvedJavaMethod inlinedMethod, BytecodeProvider intrinsicBytecodeProvider, ValueNode[] args) {
        try (InliningLog.RootScope scope = this.graph.getInliningLog().openRootScope(this.method, targetMethod, this.bci());){
            boolean isIntrinsic;
            boolean logInliningDecision;
            IntrinsicContext intrinsic = this.intrinsicContext;
            if (intrinsic == null && !this.graphBuilderConfig.insertFullInfopoints() && targetMethod.equals(inlinedMethod) && (targetMethod.getModifiers() & 0x28) == 0 && this.tryFastInlineAccessor(args, targetMethod)) {
                boolean bl = true;
                return bl;
            }
            Invokable logInliningInvokable = scope != null ? scope.getInvoke() : (this.debug.hasCompilationListener() ? new InliningLog.PlaceholderInvokable(this.method, targetMethod, this.bci()) : null);
            boolean bl = logInliningDecision = logInliningInvokable != null;
            if (intrinsic != null && intrinsic.isCallToOriginal(targetMethod)) {
                if (intrinsic.isCompilationRoot()) {
                    this.append(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.RuntimeConstraint));
                    this.printInlining(targetMethod, inlinedMethod, true, "compilation root (bytecode parsing)");
                    if (logInliningDecision) {
                        this.graph.getInliningLog().addDecision(logInliningInvokable, true, "GraphBuilderPhase", null, null, "compilation root", new Object[0]);
                    }
                    boolean bl2 = true;
                    return bl2;
                }
                if (intrinsic.getOriginalMethod().isNative()) {
                    this.printInlining(targetMethod, inlinedMethod, false, "native method (bytecode parsing)");
                    if (logInliningDecision) {
                        this.graph.getInliningLog().addDecision(logInliningInvokable, false, "GraphBuilderPhase", null, null, "native method", new Object[0]);
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                if (this.canInlinePartialIntrinsicExit()) {
                    this.notifyBeforeInline(inlinedMethod);
                    this.printInlining(targetMethod, inlinedMethod, true, "partial intrinsic exit (bytecode parsing)");
                    if (logInliningDecision) {
                        this.graph.getInliningLog().addDecision(logInliningInvokable, true, "GraphBuilderPhase", null, null, "partial intrinsic exit", new Object[0]);
                    }
                    this.parseAndInlineCallee(intrinsic.getOriginalMethod(), args, null);
                    this.notifyAfterInline(inlinedMethod);
                    boolean bl4 = true;
                    return bl4;
                }
                this.printInlining(targetMethod, inlinedMethod, false, "partial intrinsic exit (bytecode parsing)");
                if (logInliningDecision) {
                    this.graph.getInliningLog().addDecision(logInliningInvokable, false, "GraphBuilderPhase", null, null, "partial intrinsic exit", new Object[0]);
                }
                boolean bl5 = false;
                return bl5;
            }
            boolean bl6 = isIntrinsic = intrinsicBytecodeProvider != null;
            if (intrinsic == null && isIntrinsic) {
                assert (!inlinedMethod.equals(targetMethod));
                intrinsic = new IntrinsicContext(targetMethod, inlinedMethod, intrinsicBytecodeProvider, IntrinsicContext.CompilationContext.INLINE_DURING_PARSING);
            }
            if (inlinedMethod.hasBytecodes()) {
                this.notifyBeforeInline(inlinedMethod);
                this.printInlining(targetMethod, inlinedMethod, true, "inline method (bytecode parsing)");
                if (logInliningDecision) {
                    this.graph.getInliningLog().addDecision(logInliningInvokable, true, "GraphBuilderPhase", null, null, "inline method", new Object[0]);
                }
            } else {
                this.printInlining(targetMethod, inlinedMethod, false, "no bytecodes (abstract or native) (bytecode parsing)");
                if (logInliningDecision) {
                    this.graph.getInliningLog().addDecision(logInliningInvokable, false, "GraphBuilderPhase", null, null, "no bytecodes (abstract or native)", new Object[0]);
                }
                boolean bl7 = false;
                return bl7;
            }
            this.parseAndInlineCallee(inlinedMethod, args, intrinsic);
            this.notifyAfterInline(inlinedMethod);
            boolean bl8 = true;
            return bl8;
        }
    }

    protected final void notifyBeforeInline(ResolvedJavaMethod inlinedMethod) {
        for (InlineInvokePlugin plugin : this.graphBuilderConfig.getPlugins().getInlineInvokePlugins()) {
            plugin.notifyBeforeInline(inlinedMethod);
        }
    }

    protected final void notifyAfterInline(ResolvedJavaMethod inlinedMethod) {
        for (InlineInvokePlugin plugin : this.graphBuilderConfig.getPlugins().getInlineInvokePlugins()) {
            plugin.notifyAfterInline(inlinedMethod);
        }
    }

    protected boolean canInlinePartialIntrinsicExit() {
        assert (!Services.IS_IN_NATIVE_IMAGE);
        return BytecodeParserOptions.InlinePartialIntrinsicExitDuringParsing.getValue(this.options) != false && !Services.IS_BUILDING_NATIVE_IMAGE && this.method.getAnnotation(Snippet.class) == null;
    }

    private void printInlining(ResolvedJavaMethod targetMethod, ResolvedJavaMethod inlinedMethod, boolean success, String msg) {
        if (success && (BytecodeParserOptions.TraceInlineDuringParsing.getValue(this.options).booleanValue() || BytecodeParserOptions.TraceParserPlugins.getValue(this.options).booleanValue())) {
            if (targetMethod.equals(inlinedMethod)) {
                this.traceWithContext("inlining call to %s", inlinedMethod.format("%h.%n(%p)"));
            } else {
                this.traceWithContext("inlining call to %s as intrinsic for %s", inlinedMethod.format("%h.%n(%p)"), targetMethod.format("%h.%n(%p)"));
            }
        }
        if (GraalOptions.HotSpotPrintInlining.getValue(this.options).booleanValue()) {
            if (targetMethod.equals(inlinedMethod)) {
                Util.printInlining(inlinedMethod, this.bci(), this.getDepth(), success, "%s", msg);
            } else {
                Util.printInlining(inlinedMethod, this.bci(), this.getDepth(), success, "%s intrinsic for %s", msg, targetMethod.format("%h.%n(%p)"));
            }
        }
    }

    protected void traceWithContext(String format, Object ... args) {
        StackTraceElement where = this.code.asStackTraceElement(this.bci());
        String s = String.format("%s%s (%s:%d) %s", BytecodeParser.nSpaces(this.getDepth()), this.method.isConstructor() ? this.method.format("%h.%n") : this.method.getName(), where.getFileName(), where.getLineNumber(), String.format(format, args));
        TTY.println(s);
    }

    protected RuntimeException throwParserError(Throwable e) {
        if (e instanceof BytecodeParserError) {
            throw (BytecodeParserError)e;
        }
        BytecodeParser bp = this;
        BytecodeParserError res = new BytecodeParserError(e);
        while (bp != null) {
            res.addContext("parsing " + bp.code.asStackTraceElement(bp.bci()));
            bp = bp.parent;
        }
        throw res;
    }

    protected void parseAndInlineCallee(ResolvedJavaMethod targetMethod, ValueNode[] args, IntrinsicContext calleeIntrinsicContext) {
        FixedWithNextNode calleeBeforeUnwindNode = null;
        ValueNode calleeUnwindValue = null;
        try (IntrinsicScope s = this.parsingIntrinsic() ? null : (calleeIntrinsicContext != null ? new IntrinsicScope(this, targetMethod, args) : new InliningScope(this, targetMethod, args));){
            BytecodeParser parser = this.graphBuilderInstance.createBytecodeParser(this.graph, this, targetMethod, -1, calleeIntrinsicContext);
            boolean targetIsSubstitution = this.parsingIntrinsic();
            FrameStateBuilder startFrameState = new FrameStateBuilder(parser, parser.code, this.graph, this.graphBuilderConfig.retainLocalVariables() && !targetIsSubstitution);
            if (!targetMethod.isStatic()) {
                args[0] = this.nullCheckedValue(args[0]);
            }
            startFrameState.initializeFromArgumentsArray(args);
            parser.build(this.lastInstr, startFrameState);
            List<ReturnToCallerData> calleeReturnDataList = parser.returnDataList;
            if (parser.frameState.isAfterSideEffect() && this.parsingIntrinsic()) {
                for (StateSplit sideEffect : parser.frameState.sideEffects()) {
                    this.frameState.addSideEffect(sideEffect);
                }
            }
            this.processCalleeReturn(targetMethod, s, calleeReturnDataList);
            calleeBeforeUnwindNode = parser.getBeforeUnwindNode();
            if (calleeBeforeUnwindNode != null) {
                calleeUnwindValue = parser.getUnwindValue();
                assert (calleeUnwindValue != null);
            }
        }
        if (calleeBeforeUnwindNode != null) {
            calleeBeforeUnwindNode.setNext(this.handleException(calleeUnwindValue, this.bci(), false));
        }
    }

    private ValueNode processCalleeReturn(ResolvedJavaMethod targetMethod, InliningScope inliningScope, List<ReturnToCallerData> calleeReturnDataList) {
        if (calleeReturnDataList != null) {
            ValueNode calleeReturnValue;
            MergeNode returnMergeNode = null;
            if (inliningScope != null) {
                inliningScope.returnDataList = calleeReturnDataList;
            }
            if (calleeReturnDataList.size() == 1) {
                ReturnToCallerData singleReturnData = calleeReturnDataList.get(0);
                this.lastInstr = singleReturnData.beforeReturnNode;
                calleeReturnValue = singleReturnData.returnValue;
            } else {
                assert (calleeReturnDataList.size() > 1);
                returnMergeNode = this.graph.add(new MergeNode());
                calleeReturnValue = ValueMergeUtil.mergeValueProducers(returnMergeNode, calleeReturnDataList, returnData -> returnData.beforeReturnNode, returnData -> returnData.returnValue);
            }
            if (calleeReturnValue != null) {
                this.frameState.push(targetMethod.getSignature().getReturnKind().getStackKind(), calleeReturnValue);
            }
            if (returnMergeNode != null) {
                returnMergeNode.setStateAfter(this.createFrameState(this.stream.nextBCI(), returnMergeNode));
                this.lastInstr = this.processInstruction(returnMergeNode, this.frameState);
            }
            return calleeReturnValue;
        }
        this.lastInstr = null;
        return null;
    }

    public MethodCallTargetNode createMethodCallTarget(CallTargetNode.InvokeKind invokeKind, ResolvedJavaMethod targetMethod, ValueNode[] args, StampPair returnStamp, JavaTypeProfile profile) {
        return new MethodCallTargetNode(invokeKind, targetMethod, args, returnStamp, profile);
    }

    protected InvokeNode createInvoke(int invokeBci, CallTargetNode callTarget, JavaKind resultType) {
        InvokeNode invoke = this.append(new InvokeNode(callTarget, invokeBci));
        this.frameState.pushReturn(resultType, invoke);
        invoke.setStateAfter(this.createFrameState(this.stream.nextBCI(), invoke));
        return invoke;
    }

    protected InvokeWithExceptionNode createInvokeWithException(int invokeBci, CallTargetNode callTarget, JavaKind resultType, ExceptionEdgeAction exceptionEdgeAction) {
        if (this.currentBlock != null && this.stream.nextBCI() > this.currentBlock.endBci) {
            this.frameState.clearNonLiveLocals(this.currentBlock, this.liveness, false);
        }
        AbstractBeginNode exceptionEdge = this.handleException(null, this.bci(), exceptionEdgeAction == ExceptionEdgeAction.INCLUDE_AND_DEOPTIMIZE);
        InvokeWithExceptionNode invoke = this.append(new InvokeWithExceptionNode(callTarget, exceptionEdge, invokeBci));
        this.frameState.pushReturn(resultType, invoke);
        invoke.setStateAfter(this.createFrameState(this.stream.nextBCI(), invoke));
        return invoke;
    }

    protected void genReturn(ValueNode returnVal, JavaKind returnKind) {
        if (this.parsingIntrinsic() && returnVal != null && returnVal instanceof StateSplit) {
            StateSplit stateSplit = (StateSplit)((Object)returnVal);
            FrameState stateAfter = stateSplit.stateAfter();
            if (stateSplit.hasSideEffect()) {
                assert (stateSplit != null);
                if (stateAfter.bci == -3) {
                    FrameState state;
                    assert (stateAfter.hasExactlyOneUsage());
                    assert (stateAfter.usages().first() == stateSplit);
                    if (returnVal.getStackKind() == JavaKind.Illegal) {
                        assert (stateSplit instanceof Invoke);
                        ResolvedJavaMethod targetMethod = ((Invoke)stateSplit).getTargetMethod();
                        if (!Services.IS_IN_NATIVE_IMAGE) assert (targetMethod != null && (targetMethod.getAnnotation(Fold.class) != null || targetMethod.getAnnotation(Node.NodeIntrinsic.class) != null));
                        state = new FrameState(-3);
                    } else {
                        state = new FrameState(-3, returnVal);
                    }
                    stateAfter.replaceAtUsages(this.graph.add(state));
                    GraphUtil.killWithUnusedFloatingInputs(stateAfter);
                } else assert (!BytecodeFrame.isPlaceholderBci((int)stateAfter.bci) || this.intrinsicContext.isDeferredInvoke(stateSplit));
            } else assert (stateAfter == null);
        }
        ValueNode realReturnVal = this.processReturnValue(returnVal, returnKind);
        this.frameState.setRethrowException(false);
        this.frameState.clearStack();
        this.beforeReturn(realReturnVal, returnKind);
        if (this.parent == null) {
            this.append(new ReturnNode(realReturnVal));
        } else {
            if (this.returnDataList == null) {
                this.returnDataList = new ArrayList<ReturnToCallerData>();
            }
            this.returnDataList.add(new ReturnToCallerData(realReturnVal, this.lastInstr));
            this.lastInstr = null;
        }
    }

    private ValueNode processReturnValue(ValueNode value, JavaKind kind) {
        JavaKind returnKind = this.method.getSignature().getReturnKind();
        if (kind != returnKind) {
            assert (returnKind.isNumericInteger() && returnKind.getStackKind() == JavaKind.Int);
            IntegerStamp stamp = (IntegerStamp)value.stamp(NodeView.DEFAULT);
            if (stamp.lowerBound() < returnKind.getMinValue() || returnKind.getMaxValue() < stamp.upperBound()) {
                return this.maskSubWordValue(value, returnKind);
            }
        }
        return value;
    }

    private void beforeReturn(ValueNode x, JavaKind kind) {
        if (this.graph.method() != null && this.graph.method().isJavaLangObjectInit()) {
            ValueNode receiver = this.graph.start().stateAfter().localAt(0);
            assert (receiver != null && receiver.getStackKind() == JavaKind.Object);
            if (RegisterFinalizerNode.mayHaveFinalizer(receiver, this.graph.getAssumptions())) {
                RegisterFinalizerNode regFin = new RegisterFinalizerNode(receiver);
                this.append(regFin);
                regFin.setStateAfter(this.graph.start().stateAfter());
            }
        }
        this.genInfoPointNode(InfopointReason.METHOD_END, x);
        if (this.finalBarrierRequired) {
            assert (this.originalReceiver != null);
            this.append(new FinalFieldBarrierNode(this.entryBCI == -1 ? this.originalReceiver : null));
        }
        this.synchronizedEpilogue(-3, x, kind);
        if (this.method.isSynchronized()) {
            this.finishPrepare(this.lastInstr, -3, this.frameState);
        }
    }

    protected MonitorEnterNode createMonitorEnterNode(ValueNode x, MonitorIdNode monitorId) {
        return new MonitorEnterNode(x, monitorId);
    }

    protected void genMonitorEnter(ValueNode x, int bci) {
        MonitorIdNode monitorId = this.graph.add(new MonitorIdNode(this.frameState.lockDepth(true)));
        ValueNode object = this.maybeEmitExplicitNullCheck(x);
        MonitorEnterNode monitorEnter = this.append(this.createMonitorEnterNode(object, monitorId));
        this.frameState.pushLock(object, monitorId);
        monitorEnter.setStateAfter(this.createFrameState(bci, monitorEnter));
    }

    protected void genMonitorExit(ValueNode x, ValueNode escapedValue, int bci) {
        ValueNode originalX;
        if (this.frameState.lockDepth(false) == 0) {
            throw this.bailout("unbalanced monitors: too many exits");
        }
        MonitorIdNode monitorId = this.frameState.peekMonitorId();
        ValueNode lockedObject = this.frameState.popLock();
        ValueNode originalLockedObject = GraphUtil.originalValue(lockedObject, false);
        if (originalLockedObject != (originalX = GraphUtil.originalValue(x, false))) {
            throw this.bailout(String.format("unbalanced monitors: mismatch at monitorexit, %s != %s", originalLockedObject, originalX));
        }
        MonitorExitNode monitorExit = this.append(new MonitorExitNode(lockedObject, monitorId, escapedValue));
        monitorExit.setStateAfter(this.createFrameState(bci, monitorExit));
    }

    protected void genJsr(int dest) {
        BciBlockMapping.BciBlock successor = this.currentBlock.getJsrSuccessor();
        assert (successor.startBci == dest) : successor.startBci + " != " + dest + " @" + this.bci();
        JsrScope scope = this.currentBlock.getJsrScope();
        int nextBci = this.getStream().nextBCI();
        if (!successor.getJsrScope().pop().equals(scope)) {
            throw new JsrNotSupportedBailout("unstructured control flow (internal limitation)");
        }
        if (successor.getJsrScope().nextReturnAddress() != nextBci) {
            throw new JsrNotSupportedBailout("unstructured control flow (internal limitation)");
        }
        ConstantNode nextBciNode = this.getJsrConstant(nextBci);
        this.frameState.push(JavaKind.Object, nextBciNode);
        this.appendGoto(successor);
    }

    protected void genRet(int localIndex) {
        BciBlockMapping.BciBlock successor = this.currentBlock.getRetSuccessor();
        ValueNode local = this.frameState.loadLocal(localIndex, JavaKind.Object);
        JsrScope scope = this.currentBlock.getJsrScope();
        int retAddress = scope.nextReturnAddress();
        ConstantNode returnBciNode = this.getJsrConstant(retAddress);
        LogicNode guard = IntegerEqualsNode.create(this.getConstantReflection(), this.getMetaAccess(), this.options, null, local, returnBciNode, NodeView.DEFAULT);
        if (!guard.isTautology()) {
            throw new JsrNotSupportedBailout("cannot statically decide jsr return address " + local);
        }
        if (!successor.getJsrScope().equals(scope.pop())) {
            throw new JsrNotSupportedBailout("unstructured control flow (ret leaves more than one scope)");
        }
        this.appendGoto(successor);
    }

    private ConstantNode getJsrConstant(long bci) {
        RawConstant nextBciConstant = new RawConstant(bci);
        Stamp nextBciStamp = StampFactory.forConstant((JavaConstant)nextBciConstant);
        ConstantNode nextBciNode = new ConstantNode((Constant)nextBciConstant, nextBciStamp);
        return this.graph.unique(nextBciNode);
    }

    protected void genIntegerSwitch(ValueNode value, ArrayList<BciBlockMapping.BciBlock> actualSuccessors, int[] keys, double[] keyProbabilities, int[] keySuccessors, ProfileData.ProfileSource profileSource) {
        if (value.isConstant()) {
            JavaConstant constant = (JavaConstant)value.asConstant();
            int constantValue = constant.asInt();
            for (int i = 0; i < keys.length; ++i) {
                if (keys[i] != constantValue) continue;
                this.appendGoto(actualSuccessors.get(keySuccessors[i]));
                return;
            }
            this.appendGoto(actualSuccessors.get(keySuccessors[keys.length]));
        } else {
            this.controlFlowSplit = true;
            double[] successorProbabilities = BytecodeParser.successorProbabilites(actualSuccessors.size(), keySuccessors, keyProbabilities);
            IntegerSwitchNode switchNode = this.append(new IntegerSwitchNode(value, actualSuccessors.size(), keys, keySuccessors, ProfileData.SwitchProbabilityData.create(keyProbabilities, profileSource)));
            for (int i = 0; i < actualSuccessors.size(); ++i) {
                switchNode.setBlockSuccessor(i, this.createBlockTarget(successorProbabilities[i], actualSuccessors.get(i), this.frameState));
            }
        }
    }

    private static double[] successorProbabilites(int successorCount, int[] keySuccessors, double[] keyProbabilities) {
        double[] probability = new double[successorCount];
        for (int i = 0; i < keySuccessors.length; ++i) {
            int n = keySuccessors[i];
            probability[n] = probability[n] + keyProbabilities[i];
        }
        return probability;
    }

    protected ConstantNode appendConstant(JavaConstant constant) {
        assert (constant != null);
        return ConstantNode.forConstant(constant, this.getMetaAccess(), this.graph);
    }

    @Override
    public <T extends ValueNode> T append(T v) {
        assert (!this.graph.trackNodeSourcePosition() || this.graph.currentNodeSourcePosition() != null || this.currentBlock == this.blockMap.getUnwindBlock() || this.currentBlock instanceof BciBlockMapping.ExceptionDispatchBlock);
        if (v.graph() != null) {
            return v;
        }
        T added = this.graph.addOrUniqueWithInputs(v);
        if (added == v) {
            this.updateLastInstruction(v);
        }
        return added;
    }

    private <T extends ValueNode> void updateLastInstruction(T v) {
        if (v instanceof FixedNode) {
            FixedNode fixedNode = (FixedNode)v;
            if (this.lastInstr != null) {
                this.lastInstr.setNext(fixedNode);
            }
            if (fixedNode instanceof FixedWithNextNode) {
                FixedWithNextNode fixedWithNextNode = (FixedWithNextNode)fixedNode;
                assert (fixedWithNextNode.next() == null) : "cannot append instruction to instruction which isn't end";
                this.lastInstr = fixedWithNextNode;
            } else {
                this.lastInstr = fixedNode instanceof WithExceptionNode ? this.updateWithExceptionNode((WithExceptionNode)fixedNode) : null;
            }
        }
    }

    private AbstractBeginNode updateWithExceptionNode(WithExceptionNode withExceptionNode) {
        if (withExceptionNode.exceptionEdge() == null) {
            AbstractBeginNode exceptionEdge = this.handleException(null, this.bci(), false);
            withExceptionNode.setExceptionEdge(exceptionEdge);
        }
        assert (withExceptionNode.next() == null) : "new WithExceptionNode with existing next";
        AbstractBeginNode nextBegin = this.graph.add(withExceptionNode.createNextBegin());
        withExceptionNode.setNext(nextBegin);
        return nextBegin;
    }

    protected void clearNonLiveLocalsAtLoopExitCreation(BciBlockMapping.BciBlock block, FrameStateBuilder state) {
        state.clearNonLiveLocals(block, this.liveness, true);
    }

    private Target checkLoopExit(Target target, BciBlockMapping.BciBlock targetBlock) {
        long exits;
        if (this.currentBlock != null && (exits = this.currentBlock.loops & (targetBlock.loops ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            LoopExitNode firstLoopExit = null;
            FixedWithNextNode lastLoopExit = null;
            int pos = 0;
            ArrayList<BciBlockMapping.BciBlock> exitLoops = new ArrayList<BciBlockMapping.BciBlock>(Long.bitCount(exits));
            do {
                long lMask;
                if ((exits & (lMask = 1L << pos)) != 0L) {
                    exitLoops.add(this.blockMap.getLoopHeader(pos));
                    exits &= lMask ^ 0xFFFFFFFFFFFFFFFFL;
                }
                ++pos;
            } while (exits != 0L);
            Collections.sort(exitLoops, new Comparator<BciBlockMapping.BciBlock>(){

                @Override
                public int compare(BciBlockMapping.BciBlock o1, BciBlockMapping.BciBlock o2) {
                    return Long.bitCount(o2.loops) - Long.bitCount(o1.loops);
                }
            });
            int bci = targetBlock.startBci;
            if (targetBlock instanceof BciBlockMapping.ExceptionDispatchBlock) {
                bci = ((BciBlockMapping.ExceptionDispatchBlock)targetBlock).deoptBci;
            }
            FrameStateBuilder newState = target.state.copy();
            if (targetBlock != this.blockMap.getUnwindBlock() && !(targetBlock instanceof BciBlockMapping.ExceptionDispatchBlock)) {
                newState.setRethrowException(false);
            }
            this.clearNonLiveLocalsAtLoopExitCreation(targetBlock, newState);
            for (BciBlockMapping.BciBlock loop : exitLoops) {
                LoopBeginNode loopBegin = (LoopBeginNode)this.getFirstInstruction(loop);
                LoopExitNode loopExit = this.graph.add(new LoopExitNode(loopBegin));
                if (lastLoopExit != null) {
                    lastLoopExit.setNext(loopExit);
                }
                if (firstLoopExit == null) {
                    firstLoopExit = loopExit;
                }
                lastLoopExit = loopExit;
                this.debug.log("Target %s Exits %s, scanning framestates...", (Object)targetBlock, (Object)loop);
                newState.insertLoopProxies(loopExit, this.getEntryState(loop));
                loopExit.setStateAfter(newState.create(bci, loopExit));
            }
            assert (lastLoopExit != null);
            if (target.originalEntry == null) {
                lastLoopExit.setNext(target.entry);
                return new Target(firstLoopExit, newState, target.entry);
            }
            target.originalEntry.replaceAtPredecessor(firstLoopExit);
            lastLoopExit.setNext(target.originalEntry);
            return new Target(target.entry, newState, target.originalEntry);
        }
        return target;
    }

    private Target checkUnwind(FixedNode target, BciBlockMapping.BciBlock targetBlock, FrameStateBuilder state) {
        if (targetBlock != this.blockMap.getUnwindBlock()) {
            return new Target(target, state);
        }
        FrameStateBuilder newState = state;
        newState = newState.copy();
        newState.setRethrowException(false);
        if (!this.method.isSynchronized()) {
            return new Target(target, newState);
        }
        FixedWithNextNode originalLast = this.lastInstr;
        FrameStateBuilder originalState = this.frameState;
        BeginNode holder = new BeginNode();
        this.lastInstr = this.graph.add(holder);
        this.frameState = newState;
        assert (this.frameState.stackSize() == 1);
        ValueNode exception = this.frameState.peekObject();
        this.synchronizedEpilogue(-4, exception, JavaKind.Void);
        this.lastInstr.setNext(target);
        this.lastInstr = originalLast;
        this.frameState = originalState;
        FixedNode result = holder.next();
        holder.setNext(null);
        holder.safeDelete();
        return new Target(result, newState, target);
    }

    private FrameStateBuilder getEntryState(BciBlockMapping.BciBlock block) {
        return this.entryStateArray[block.id];
    }

    private void setEntryState(BciBlockMapping.BciBlock block, FrameStateBuilder entryState) {
        this.entryStateArray[block.id] = entryState;
    }

    private void setFirstInstruction(BciBlockMapping.BciBlock block, FixedWithNextNode firstInstruction) {
        this.firstInstructionArray[block.id] = firstInstruction;
    }

    private FixedWithNextNode getFirstInstruction(BciBlockMapping.BciBlock block) {
        return this.firstInstructionArray[block.id];
    }

    protected void clearNonLiveLocalsAtTargetCreation(BciBlockMapping.BciBlock block, FrameStateBuilder state) {
        state.clearNonLiveLocals(block, this.liveness, true);
    }

    private FixedNode createTarget(double probability, BciBlockMapping.BciBlock block, FrameStateBuilder stateAfter) {
        assert (probability >= 0.0 && probability <= 1.01) : probability;
        if (this.isNeverExecutedCode(probability)) {
            return this.graph.add(new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.UnreachedCode));
        }
        assert (block != null);
        return this.createTarget(block, stateAfter);
    }

    private FixedNode createTarget(BciBlockMapping.BciBlock block, FrameStateBuilder state) {
        return this.createTarget(block, state, false, false);
    }

    private FixedNode createTarget(BciBlockMapping.BciBlock block, FrameStateBuilder state, boolean canReuseInstruction, boolean canReuseState) {
        assert (block != null && state != null);
        assert (!block.isExceptionEntry() || state.stackSize() == 1);
        try (DebugCloseable context = this.openNodeContext(state, block.startBci);){
            if (this.getFirstInstruction(block) == null) {
                if (!(!canReuseInstruction || block.getPredecessorCount() != 1 && this.controlFlowSplit || block.isLoopHeader() || (this.currentBlock.loops & (block.loops ^ 0xFFFFFFFFFFFFFFFFL)) != 0L || this.currentBlock.getJsrScope() != block.getJsrScope())) {
                    this.setFirstInstruction(block, this.lastInstr);
                    this.lastInstr = null;
                } else {
                    this.setFirstInstruction(block, this.graph.add(new BeginNode()));
                }
                Target target = this.checkUnwind(this.getFirstInstruction(block), block, state);
                target = this.checkLoopExit(target, block);
                FixedNode result = target.entry;
                FrameStateBuilder currentEntryState = target.state == state ? (canReuseState ? state : state.copy()) : target.state;
                this.setEntryState(block, currentEntryState);
                this.clearNonLiveLocalsAtTargetCreation(block, currentEntryState);
                this.debug.log("createTarget %s: first visit, result: %s", (Object)block, (Object)result);
                FixedNode fixedNode = result;
                return fixedNode;
            }
            if (this.getFirstInstruction(block) instanceof LoopBeginNode) {
                assert (block.isLoopHeader() && this.currentBlock.getId() >= block.getId()) : "must be backward branch";
                LoopBeginNode loopBegin = (LoopBeginNode)this.getFirstInstruction(block);
                LoopEndNode loopEnd = this.graph.add(new LoopEndNode(loopBegin));
                Target target = this.checkLoopExit(new Target(loopEnd, state), block);
                FixedNode result = target.entry;
                this.getEntryState(block).merge(loopBegin, target.state);
                this.debug.log("createTarget %s: merging backward branch to loop header %s, result: %s", block, (Object)loopBegin, (Object)result);
                FixedNode fixedNode = result;
                return fixedNode;
            }
            assert (this.currentBlock == null || this.currentBlock.getId() < block.getId()) : "must not be backward branch";
            assert (this.getFirstInstruction(block).next() == null) : "bytecodes already parsed for block";
            if (this.getFirstInstruction(block) instanceof AbstractBeginNode && !(this.getFirstInstruction(block) instanceof AbstractMergeNode)) {
                AbstractBeginNode beginNode = (AbstractBeginNode)this.getFirstInstruction(block);
                EndNode end = this.graph.add(new EndNode());
                AbstractMergeNode mergeNode = this.graph.add(new MergeNode());
                FixedNode next = beginNode.next();
                if (beginNode.predecessor() instanceof ControlSplitNode) {
                    beginNode.setNext(end);
                } else {
                    beginNode.replaceAtPredecessor(end);
                    beginNode.safeDelete();
                }
                mergeNode.addForwardEnd(end);
                mergeNode.setNext(next);
                this.setFirstInstruction(block, mergeNode);
            }
            AbstractMergeNode mergeNode = (AbstractMergeNode)this.getFirstInstruction(block);
            EndNode newEnd = this.graph.add(new EndNode());
            Target target = this.checkLoopExit(this.checkUnwind(newEnd, block, state), block);
            FixedNode result = target.entry;
            this.getEntryState(block).merge(mergeNode, target.state);
            mergeNode.addForwardEnd(newEnd);
            this.debug.log("createTarget %s: merging state, result: %s", (Object)block, (Object)result);
            FixedNode fixedNode = result;
            return fixedNode;
        }
    }

    private AbstractBeginNode createBlockTarget(double probability, BciBlockMapping.BciBlock block, FrameStateBuilder stateAfter) {
        FixedNode target = this.createTarget(probability, block, stateAfter);
        AbstractBeginNode begin = BeginNode.begin(target);
        assert (!(target instanceof DeoptimizeNode) || !(begin instanceof BeginStateSplitNode) || ((BeginStateSplitNode)begin).stateAfter() == null) : "We are not allowed to set the stateAfter of the begin node, because we have to deoptimize to a bci _before_ the actual if, so that the interpreter can update the profiling information.";
        return begin;
    }

    private ValueNode synchronizedObject(FrameStateBuilder state, ResolvedJavaMethod target) {
        if (target.isStatic()) {
            return this.appendConstant(this.getConstantReflection().asJavaClass(target.getDeclaringClass()));
        }
        return state.loadLocal(0, JavaKind.Object);
    }

    protected void processBlock(BciBlockMapping.BciBlock block) {
        FixedWithNextNode firstInstruction = this.getFirstInstruction(block);
        if (firstInstruction == null) {
            this.debug.log("Ignoring block %s", block);
            return;
        }
        try (Indent indent = this.debug.logAndIndent("Parsing block %s  firstInstruction: %s  loopHeader: %b", (Object)block, (Object)firstInstruction, (Object)block.isLoopHeader());){
            this.lastInstr = firstInstruction;
            this.frameState = this.getEntryState(block);
            this.setCurrentFrameState(this.frameState);
            this.currentBlock = block;
            if (block != this.blockMap.getUnwindBlock() && !(block instanceof BciBlockMapping.ExceptionDispatchBlock)) {
                this.frameState.setRethrowException(false);
            }
            if (firstInstruction instanceof AbstractMergeNode) {
                this.setMergeStateAfter(block, firstInstruction);
            }
            if (block == this.blockMap.getUnwindBlock()) {
                this.handleUnwindBlock((BciBlockMapping.ExceptionDispatchBlock)block);
            } else if (block instanceof BciBlockMapping.ExceptionDispatchBlock) {
                this.createExceptionDispatch((BciBlockMapping.ExceptionDispatchBlock)block);
            } else {
                this.iterateBytecodesForBlock(block);
            }
        }
    }

    private void handleUnwindBlock(BciBlockMapping.ExceptionDispatchBlock block) {
        if (this.frameState.lockDepth(false) != 0) {
            throw this.bailout("unbalanced monitors: too few exits exiting frame");
        }
        assert (!this.frameState.rethrowException());
        this.finishPrepare(this.lastInstr, block.deoptBci, this.frameState);
        if (this.parent == null) {
            this.createUnwind();
        } else {
            this.unwindValue = this.frameState.pop(JavaKind.Object);
            this.beforeUnwindNode = this.lastInstr;
        }
    }

    private void setMergeStateAfter(BciBlockMapping.BciBlock block, FixedWithNextNode firstInstruction) {
        AbstractMergeNode abstractMergeNode = (AbstractMergeNode)firstInstruction;
        if (abstractMergeNode.stateAfter() == null) {
            int bci = block.startBci;
            if (block instanceof BciBlockMapping.ExceptionDispatchBlock) {
                bci = ((BciBlockMapping.ExceptionDispatchBlock)block).deoptBci;
            }
            abstractMergeNode.setStateAfter(this.createFrameState(bci, abstractMergeNode));
        }
    }

    private void createUnwind() {
        assert (this.frameState.stackSize() == 1) : this.frameState;
        try (DebugCloseable context = this.openNodeContext(this.frameState, -1);){
            ValueNode exception = this.frameState.pop(JavaKind.Object);
            this.append(new UnwindNode(exception));
        }
    }

    private void synchronizedEpilogue(int bci, ValueNode currentReturnValue, JavaKind currentReturnValueKind) {
        try (DebugCloseable context = this.openNodeContext(this.frameState, bci);){
            if (this.method.isSynchronized()) {
                if (currentReturnValueKind != JavaKind.Void) {
                    this.frameState.push(currentReturnValueKind, currentReturnValue);
                }
                this.genMonitorExit(this.methodSynchronizedObject, currentReturnValue, bci);
                assert (!this.frameState.rethrowException());
            }
            if (this.frameState.lockDepth(false) != 0) {
                throw this.bailout("unbalanced monitors: too few exits exiting frame");
            }
        }
    }

    private void createExceptionDispatch(BciBlockMapping.ExceptionDispatchBlock block) {
        block26: {
            try (DebugCloseable context = this.openNodeContext(this.frameState, -4);){
                this.processInstruction(this.lastInstr);
                assert (this.frameState.stackSize() == 1) : this.frameState;
                if (block.handler.isCatchAll()) {
                    assert (block.getSuccessorCount() == 1);
                    this.appendGoto(block.getSuccessor(0));
                    return;
                }
                JavaType catchType = block.handler.getCatchType();
                if (this.graphBuilderConfig.eagerResolving()) {
                    catchType = this.lookupType(block.handler.catchTypeCPI(), 193);
                }
                if (this.typeIsResolved(catchType)) {
                    TypeReference checkedCatchType = TypeReference.createTrusted(this.graph.getAssumptions(), (ResolvedJavaType)catchType);
                    if (this.graphBuilderConfig.getSkippedExceptionTypes() != null) {
                        for (ResolvedJavaType skippedType : this.graphBuilderConfig.getSkippedExceptionTypes()) {
                            if (!skippedType.isAssignableFrom(checkedCatchType.getType())) continue;
                            BciBlockMapping.BciBlock nextBlock = block.getSuccessorCount() == 1 ? this.blockMap.getUnwindBlock() : block.getSuccessor(1);
                            ValueNode exception = this.frameState.stack[0];
                            FixedNode trueSuccessor = this.graph.add(new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.UnreachedCode));
                            FixedNode nextDispatch = this.createTarget(nextBlock, this.frameState);
                            this.append(new IfNode(this.graph.addOrUniqueWithInputs(this.createInstanceOf(checkedCatchType, exception)), trueSuccessor, nextDispatch, BranchProbabilityNode.DEOPT_PROFILE));
                            return;
                        }
                    }
                    BciBlockMapping.BciBlock nextBlock = block.getSuccessorCount() == 1 ? this.blockMap.getUnwindBlock() : block.getSuccessor(1);
                    ValueNode exception = this.frameState.stack[0];
                    BeginNode piNodeAnchor = this.graph.add(new BeginNode());
                    ObjectStamp checkedStamp = StampFactory.objectNonNull(checkedCatchType);
                    PiNode piNode = this.graph.addWithoutUnique(new PiNode(exception, (Stamp)checkedStamp));
                    this.frameState.pop(JavaKind.Object);
                    this.frameState.push(JavaKind.Object, piNode);
                    FixedNode catchSuccessor = this.createTarget(block.getSuccessor(0), this.frameState);
                    this.frameState.pop(JavaKind.Object);
                    this.frameState.push(JavaKind.Object, exception);
                    FixedNode nextDispatch = this.createTarget(nextBlock, this.frameState);
                    piNodeAnchor.setNext(catchSuccessor);
                    IfNode ifNode = this.append(new IfNode(this.graph.unique(this.createInstanceOf(checkedCatchType, exception)), (FixedNode)piNodeAnchor, nextDispatch, ProfileData.BranchProbabilityData.unknown()));
                    assert (ifNode.trueSuccessor() == piNodeAnchor);
                    piNode.setGuard(ifNode.trueSuccessor());
                    break block26;
                }
                this.handleUnresolvedExceptionType(catchType);
            }
        }
    }

    private void appendGoto(BciBlockMapping.BciBlock successor) {
        FixedNode targetInstr = this.createTarget(successor, this.frameState, true, true);
        if (this.lastInstr != null && this.lastInstr != targetInstr) {
            this.lastInstr.setNext(targetInstr);
        }
    }

    protected void iterateBytecodesForBlock(BciBlockMapping.BciBlock block) {
        if (block.isLoopHeader()) {
            this.controlFlowSplit = true;
            LoopBeginNode loopBegin = this.appendLoopBegin(this.lastInstr, block.startBci);
            this.lastInstr = loopBegin;
            this.frameState.insertLoopPhis(this.liveness, block.loopId, loopBegin, this.forceLoopPhis() || this.graphBuilderConfig.replaceLocalsWithConstants(), this.stampFromValueForForcedPhis());
            loopBegin.setStateAfter(this.createFrameState(block.startBci, loopBegin));
            this.setFirstInstruction(block, loopBegin);
            this.setEntryState(block, this.frameState.copy());
            this.debug.log("  created loop header %s", loopBegin);
        } else if (this.lastInstr instanceof MergeNode) {
            this.frameState.inferPhiStamps((AbstractMergeNode)this.lastInstr);
        }
        assert (this.lastInstr.next() == null) : "instructions already appended at block " + block;
        this.debug.log("  frameState: %s", this.frameState);
        this.processInstruction(this.lastInstr);
        int endBCI = this.stream.endBCI();
        this.stream.setBCI(block.startBci);
        int bci = block.startBci;
        BytecodesParsed.add(this.debug, block.endBci - bci);
        if (this.graphBuilderConfig.insertFullInfopoints()) {
            this.previousLineNumber = -1;
        }
        while (bci < endBCI) {
            try (DebugCloseable context = this.openNodeContext();){
                if (this.graphBuilderConfig.insertFullInfopoints() && !this.parsingIntrinsic()) {
                    int n = this.currentLineNumber = this.lnt != null ? this.lnt.getLineNumber(bci) : -1;
                    if (this.currentLineNumber != this.previousLineNumber) {
                        this.genInfoPointNode(InfopointReason.BYTECODE_POSITION, null);
                        this.previousLineNumber = this.currentLineNumber;
                    }
                }
                int opcode = this.stream.currentBC();
                if (this.traceLevel != 0) {
                    this.traceInstruction(bci, opcode, bci == block.startBci);
                }
                if (this.parent == null && bci == this.entryBCI) {
                    if (block.getJsrScope() != JsrScope.EMPTY_SCOPE) {
                        throw new JsrNotSupportedBailout("OSR into a JSR scope is not supported");
                    }
                    EntryMarkerNode x = this.append(new EntryMarkerNode());
                    this.frameState.insertProxies(value -> this.graph.unique(new EntryProxyNode((ValueNode)value, x)));
                    x.setStateAfter(this.createFrameState(bci, x));
                }
                this.processBytecode(bci, opcode);
            }
            catch (BailoutException e) {
                throw e;
            }
            catch (Throwable e) {
                throw this.throwParserError(e);
            }
            if (this.lastInstr == null || this.lastInstr.next() != null) break;
            this.stream.next();
            bci = this.stream.currentBCI();
            assert (block == this.currentBlock);
            assert (this.checkLastInstruction());
            this.processInstruction(this.lastInstr);
            if (bci >= endBCI || bci <= block.endBci) continue;
            assert (!block.getSuccessor(0).isExceptionEntry());
            assert (block.numNormalSuccessors() == 1);
            this.appendGoto(block.getSuccessor(0));
            break;
        }
    }

    private DebugCloseable openNodeContext(FrameStateBuilder state, int startBci) {
        if (this.graph.trackNodeSourcePosition()) {
            return this.graph.withNodeSourcePosition(state.createBytecodePosition(startBci));
        }
        return null;
    }

    private DebugCloseable openNodeContext(ResolvedJavaMethod targetMethod) {
        return this.openNodeContext(targetMethod, -1);
    }

    private DebugCloseable openNodeContext(ResolvedJavaMethod targetMethod, int bci) {
        if (this.graph.trackNodeSourcePosition()) {
            return this.graph.withNodeSourcePosition(new NodeSourcePosition(this.createBytecodePosition(), targetMethod, bci));
        }
        return null;
    }

    private DebugCloseable openNodeContext() {
        return this.openNodeContext(this.frameState, this.bci());
    }

    protected boolean forceLoopPhis() {
        return this.graph.isOSR();
    }

    protected boolean stampFromValueForForcedPhis() {
        return false;
    }

    protected boolean checkLastInstruction() {
        StateSplit stateSplit;
        if (!(this.lastInstr instanceof BeginNode) && this.lastInstr instanceof StateSplit && (stateSplit = (StateSplit)((Object)this.lastInstr)).hasSideEffect()) assert (stateSplit.stateAfter() != null) : "side effect " + this.lastInstr + " requires a non-null stateAfter";
        return true;
    }

    protected boolean disableLoopSafepoint() {
        return this.parsingIntrinsic();
    }

    private LoopBeginNode appendLoopBegin(FixedWithNextNode fixedWithNext, int startBci) {
        try (DebugCloseable context = this.openNodeContext(this.frameState, startBci);){
            EndNode preLoopEnd = this.graph.add(new EndNode());
            LoopBeginNode loopBegin = this.graph.add(new LoopBeginNode());
            if (this.disableLoopSafepoint()) {
                loopBegin.disableSafepoint();
            }
            fixedWithNext.setNext(preLoopEnd);
            loopBegin.addForwardEnd(preLoopEnd);
            LoopBeginNode loopBeginNode = loopBegin;
            return loopBeginNode;
        }
    }

    protected FixedWithNextNode processInstruction(FixedWithNextNode instr, FrameStateBuilder state) {
        return instr;
    }

    private void genInfoPointNode(InfopointReason reason, ValueNode escapedReturnValue) {
        if (!this.parsingIntrinsic() && this.graphBuilderConfig.insertFullInfopoints()) {
            this.append(new FullInfopointNode(reason, this.createFrameState(this.bci(), null), escapedReturnValue));
        }
    }

    protected void genIf(ValueNode x, Condition cond, ValueNode y) {
        BciBlockMapping.BciBlock falseBlock;
        assert (x.getStackKind() == y.getStackKind());
        assert (this.currentBlock.getSuccessorCount() == 2);
        BciBlockMapping.BciBlock trueBlock = this.currentBlock.getSuccessor(0);
        if (trueBlock == (falseBlock = this.currentBlock.getSuccessor(1))) {
            this.appendGoto(trueBlock);
            return;
        }
        ValueNode a = x;
        ValueNode b = y;
        BciBlockMapping.BciBlock trueSuccessor = trueBlock;
        BciBlockMapping.BciBlock falseSuccessor = falseBlock;
        Condition.CanonicalizedCondition canonicalizedCondition = cond.canonicalize();
        if (canonicalizedCondition.mustMirror()) {
            a = y;
            b = x;
        }
        if (canonicalizedCondition.mustNegate()) {
            trueSuccessor = falseBlock;
            falseSuccessor = trueBlock;
        }
        LogicNode condition = this.createLogicNode(canonicalizedCondition.getCanonicalCondition(), a, b);
        ProfileData.BranchProbabilityData profileData = null;
        if (condition instanceof IntegerEqualsNode) {
            profileData = this.extractInjectedProbability((IntegerEqualsNode)condition);
        }
        if (profileData == null) {
            profileData = this.getProfileData(canonicalizedCondition.mustNegate());
        }
        this.genIf(condition, trueSuccessor, falseSuccessor, profileData);
    }

    protected ProfileData.BranchProbabilityData getProfileData(boolean negate) {
        if (this.profilingInfo == null) {
            return ProfileData.BranchProbabilityData.unknown();
        }
        assert (this.assertAtIfBytecode());
        double probability = this.profilingInfo.getBranchTakenProbability(this.bci());
        if (probability < 0.0) {
            assert (probability == -1.0) : "invalid probability";
            this.debug.log("missing probability in %s at bci %d", (Object)this.code, this.bci());
            return ProfileData.BranchProbabilityData.unknown();
        }
        probability = this.clampProbability(probability);
        ProfileData.ProfileSource source = this.profilingInfo.isMature() ? ProfileData.ProfileSource.PROFILED : ProfileData.ProfileSource.UNKNOWN;
        ProfileData.BranchProbabilityData profileData = ProfileData.BranchProbabilityData.create(probability, source);
        if (negate && this.shouldComplementProbability()) {
            profileData = profileData.negated();
        }
        return profileData;
    }

    private ProfileData.BranchProbabilityData extractInjectedProbability(IntegerEqualsNode condition) {
        IntegerEqualsNode equalsNode = condition;
        BranchProbabilityNode probabilityNode = null;
        ValueNode other = null;
        if (equalsNode.getX() instanceof BranchProbabilityNode) {
            probabilityNode = (BranchProbabilityNode)equalsNode.getX();
            other = equalsNode.getY();
        } else if (equalsNode.getY() instanceof BranchProbabilityNode) {
            probabilityNode = (BranchProbabilityNode)equalsNode.getY();
            other = equalsNode.getX();
        }
        if (probabilityNode != null && probabilityNode.getProbability().isConstant() && other != null && other.isConstant()) {
            double probabilityValue = this.clampProbability(probabilityNode.getProbability().asJavaConstant().asDouble());
            ProfileData.BranchProbabilityData injectedProbability = ProfileData.BranchProbabilityData.injected(probabilityValue);
            return other.asJavaConstant().asInt() == 0 ? injectedProbability.negated() : injectedProbability;
        }
        return null;
    }

    protected void genIf(LogicNode conditionInput, BciBlockMapping.BciBlock trueBlockInput, BciBlockMapping.BciBlock falseBlockInput, ProfileData.BranchProbabilityData originalProfileData) {
        BciBlockMapping.BciBlock trueBlock = trueBlockInput;
        BciBlockMapping.BciBlock falseBlock = falseBlockInput;
        LogicNode condition = conditionInput;
        ProfileData.BranchProbabilityData profileData = originalProfileData;
        FrameState stateBefore = null;
        ProfilingPlugin profilingPlugin = this.graphBuilderConfig.getPlugins().getProfilingPlugin();
        if (profilingPlugin != null && profilingPlugin.shouldProfile(this, this.method)) {
            stateBefore = this.createCurrentFrameState();
        }
        if (condition instanceof LogicNegationNode) {
            LogicNegationNode logicNegationNode = (LogicNegationNode)condition;
            BciBlockMapping.BciBlock tmpBlock = trueBlock;
            trueBlock = falseBlock;
            falseBlock = tmpBlock;
            if (this.shouldComplementProbability()) {
                profileData = profileData.negated();
            }
            condition = logicNegationNode.getValue();
        }
        if (condition instanceof LogicConstantNode) {
            this.genConstantTargetIf(trueBlock, falseBlock, condition);
        } else {
            CompareNode compareNode;
            int falseBlockInt;
            if (condition.graph() == null) {
                condition = this.genUnique(condition);
            }
            BciBlockMapping.BciBlock deoptBlock = null;
            BciBlockMapping.BciBlock noDeoptBlock = null;
            if (this.isNeverExecutedCode(profileData.getDesignatedSuccessorProbability())) {
                deoptBlock = trueBlock;
                noDeoptBlock = falseBlock;
            } else if (this.isNeverExecutedCode(profileData.getNegatedProbability())) {
                deoptBlock = falseBlock;
                noDeoptBlock = trueBlock;
            }
            if (deoptBlock != null) {
                boolean negated;
                NodeSourcePosition currentPosition = this.graph.currentNodeSourcePosition();
                NodeSourcePosition survivingSuccessorPosition = null;
                if (this.graph.trackNodeSourcePosition()) {
                    survivingSuccessorPosition = new NodeSourcePosition(currentPosition.getCaller(), currentPosition.getMethod(), noDeoptBlock.startBci);
                }
                boolean bl = negated = deoptBlock == trueBlock;
                if (!this.isPotentialCountedLoopExit(condition, deoptBlock)) {
                    if (profilingPlugin != null && profilingPlugin.shouldProfile(this, this.method)) {
                        profilingPlugin.profileGoto(this, this.method, this.bci(), noDeoptBlock.startBci, stateBefore);
                    }
                    this.append(new FixedGuardNode(condition, DeoptimizationReason.UnreachedCode, DeoptimizationAction.InvalidateReprofile, negated, survivingSuccessorPosition));
                    this.appendGoto(noDeoptBlock);
                } else {
                    this.controlFlowSplit = true;
                    FixedNode noDeoptSuccessor = this.createTarget(noDeoptBlock, this.frameState, false, true);
                    DeoptimizeNode deopt = this.graph.add(new DeoptimizeNode(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.UnreachedCode));
                    ProfileData.BranchProbabilityData calculatedProbability = ProfileData.BranchProbabilityData.injected(1.0, negated);
                    AbstractBeginNode deoptSuccessor = BeginNode.begin(deopt);
                    ValueNode ifNode = this.genIfNode(condition, negated ? deoptSuccessor : noDeoptSuccessor, negated ? noDeoptSuccessor : deoptSuccessor, calculatedProbability);
                    this.postProcessIfNode(ifNode);
                    this.append(ifNode);
                }
                return;
            }
            if (profilingPlugin != null && profilingPlugin.shouldProfile(this, this.method)) {
                profilingPlugin.profileIf(this, this.method, this.bci(), condition, trueBlock.startBci, falseBlock.startBci, stateBefore);
            }
            int oldBci = this.stream.currentBCI();
            int trueBlockInt = this.checkPositiveIntConstantPushed(trueBlock);
            if (trueBlockInt != -1 && (falseBlockInt = this.checkPositiveIntConstantPushed(falseBlock)) != -1 && this.tryGenConditionalForIf(trueBlock, falseBlock, condition, oldBci, trueBlockInt, falseBlockInt)) {
                return;
            }
            this.controlFlowSplit = true;
            FixedNode falseSuccessor = this.createTarget(falseBlock, this.frameState, false, false);
            FixedNode trueSuccessor = this.createTarget(trueBlock, this.frameState, false, true);
            if (this.graphBuilderConfig.replaceLocalsWithConstants() && condition instanceof CompareNode && (compareNode = (CompareNode)condition).condition() == CanonicalCondition.EQ) {
                ValueNode constantNode = null;
                ValueNode nonConstantNode = null;
                if (compareNode.getX() instanceof ConstantNode) {
                    constantNode = compareNode.getX();
                    nonConstantNode = compareNode.getY();
                } else if (compareNode.getY() instanceof ConstantNode) {
                    constantNode = compareNode.getY();
                    nonConstantNode = compareNode.getX();
                }
                if (constantNode != null && nonConstantNode != null) {
                    this.getEntryState(trueBlock).replaceValue(nonConstantNode, constantNode);
                }
            }
            ValueNode ifNode = this.genIfNode(condition, trueSuccessor, falseSuccessor, profileData);
            this.postProcessIfNode(ifNode);
            this.append(ifNode);
        }
    }

    public boolean isPotentialCountedLoopExit(LogicNode condition, BciBlockMapping.BciBlock target) {
        long exits;
        if (this.currentBlock != null && (exits = this.currentBlock.loops & (target.loops ^ 0xFFFFFFFFFFFFFFFFL)) != 0L) {
            return condition instanceof CompareNode;
        }
        return false;
    }

    protected boolean shouldComplementProbability() {
        return true;
    }

    protected void postProcessIfNode(ValueNode node) {
    }

    private boolean tryGenConditionalForIf(BciBlockMapping.BciBlock trueBlock, BciBlockMapping.BciBlock falseBlock, LogicNode condition, int oldBci, int trueBlockInt, int falseBlockInt) {
        if (this.gotoOrFallThroughAfterConstant(trueBlock) && this.gotoOrFallThroughAfterConstant(falseBlock) && trueBlock.getSuccessor(0) == falseBlock.getSuccessor(0)) {
            this.genConditionalForIf(trueBlock, condition, oldBci, trueBlockInt, falseBlockInt, false);
            return true;
        }
        if (this.parent != null && this.returnAfterConstant(trueBlock) && this.returnAfterConstant(falseBlock)) {
            this.genConditionalForIf(trueBlock, condition, oldBci, trueBlockInt, falseBlockInt, true);
            return true;
        }
        return false;
    }

    private void genConditionalForIf(BciBlockMapping.BciBlock trueBlock, LogicNode condition, int oldBci, int trueBlockInt, int falseBlockInt, boolean genReturn) {
        ConstantNode falseValue;
        ConstantNode trueValue = this.graph.unique(ConstantNode.forInt(trueBlockInt));
        ValueNode conditionalNode = ConditionalNode.create(condition, trueValue, falseValue = this.graph.unique(ConstantNode.forInt(falseBlockInt)), NodeView.DEFAULT);
        if (conditionalNode.graph() == null) {
            conditionalNode = this.graph.addOrUniqueWithInputs(conditionalNode);
        }
        if (genReturn) {
            JavaKind returnKind = this.method.getSignature().getReturnKind().getStackKind();
            this.genReturn(conditionalNode, returnKind);
        } else {
            this.frameState.push(JavaKind.Int, conditionalNode);
            this.appendGoto(trueBlock.getSuccessor(0));
            this.stream.setBCI(oldBci);
        }
    }

    private LogicNode createLogicNode(CanonicalCondition cond, ValueNode a, ValueNode b) {
        assert (!a.getStackKind().isNumericFloat());
        switch (cond) {
            case EQ: {
                if (a.getStackKind() == JavaKind.Object) {
                    return this.genObjectEquals(a, b);
                }
                return this.genIntegerEquals(a, b);
            }
            case LT: {
                assert (a.getStackKind() != JavaKind.Object);
                return this.genIntegerLessThan(a, b);
            }
        }
        throw GraalError.shouldNotReachHere("Unexpected condition: " + (Object)((Object)cond));
    }

    private void genConstantTargetIf(BciBlockMapping.BciBlock trueBlock, BciBlockMapping.BciBlock falseBlock, LogicNode condition) {
        int startBci;
        int targetAtStart;
        LogicConstantNode constantLogicNode = (LogicConstantNode)condition;
        boolean value = constantLogicNode.getValue();
        BciBlockMapping.BciBlock nextBlock = falseBlock;
        if (value) {
            nextBlock = trueBlock;
        }
        if ((targetAtStart = this.stream.readUByte(startBci = nextBlock.startBci)) == 167 && nextBlock.getPredecessorCount() == 1) {
            BciBlockMapping.BciBlock successorBlock = nextBlock.successors.get(0);
            ProfilingPlugin profilingPlugin = this.graphBuilderConfig.getPlugins().getProfilingPlugin();
            if (profilingPlugin != null && profilingPlugin.shouldProfile(this, this.method)) {
                FrameState stateBefore = this.createCurrentFrameState();
                profilingPlugin.profileGoto(this, this.method, this.bci(), successorBlock.startBci, stateBefore);
            }
            this.appendGoto(successorBlock);
            assert (nextBlock.numNormalSuccessors() == 1);
        } else {
            ProfilingPlugin profilingPlugin = this.graphBuilderConfig.getPlugins().getProfilingPlugin();
            if (profilingPlugin != null && profilingPlugin.shouldProfile(this, this.method)) {
                FrameState stateBefore = this.createCurrentFrameState();
                profilingPlugin.profileGoto(this, this.method, this.bci(), nextBlock.startBci, stateBefore);
            }
            this.appendGoto(nextBlock);
        }
    }

    private int checkPositiveIntConstantPushed(BciBlockMapping.BciBlock block) {
        this.stream.setBCI(block.startBci);
        int currentBC = this.stream.currentBC();
        if (currentBC >= 3 && currentBC <= 8) {
            int constValue = currentBC - 3;
            return constValue;
        }
        return -1;
    }

    private boolean gotoOrFallThroughAfterConstant(BciBlockMapping.BciBlock block) {
        this.stream.setBCI(block.startBci);
        int currentBCI = this.stream.nextBCI();
        this.stream.setBCI(currentBCI);
        int currentBC = this.stream.currentBC();
        return this.stream.currentBCI() > block.endBci || currentBC == 167 || currentBC == 200;
    }

    private boolean returnAfterConstant(BciBlockMapping.BciBlock block) {
        this.stream.setBCI(block.startBci);
        int currentBCI = this.stream.nextBCI();
        this.stream.setBCI(currentBCI);
        int currentBC = this.stream.currentBC();
        return currentBC == 172;
    }

    @Override
    public StampProvider getStampProvider() {
        return this.providers.getStampProvider();
    }

    @Override
    public MetaAccessProvider getMetaAccess() {
        return this.providers.getMetaAccess();
    }

    @Override
    public Replacements getReplacements() {
        return this.providers.getReplacements();
    }

    @Override
    public void push(JavaKind slotKind, ValueNode value) {
        assert (value.isAlive());
        this.frameState.push(slotKind, value);
    }

    @Override
    public ValueNode pop(JavaKind slotKind) {
        return this.frameState.pop(slotKind);
    }

    @Override
    public ConstantReflectionProvider getConstantReflection() {
        return this.providers.getConstantReflection();
    }

    @Override
    public ConstantFieldProvider getConstantFieldProvider() {
        return this.providers.getConstantFieldProvider();
    }

    @Override
    public StructuredGraph getGraph() {
        return this.graph;
    }

    @Override
    public BytecodeParser getParent() {
        return this.parent;
    }

    @Override
    public IntrinsicContext getIntrinsic() {
        return this.intrinsicContext;
    }

    public String toString() {
        Formatter fmt = new Formatter();
        BytecodeParser bp = this;
        String indent = "";
        while (bp != null) {
            if (bp != this) {
                fmt.format("%n%s", indent);
            }
            fmt.format("%s [bci: %d, intrinsic: %s]", bp.code.asStackTraceElement(bp.bci()), bp.bci(), bp.parsingIntrinsic());
            fmt.format("%n%s", new BytecodeDisassembler().disassemble(bp.code, bp.bci(), bp.bci() + 10));
            bp = bp.parent;
            indent = indent + " ";
        }
        return fmt.toString();
    }

    @Override
    public BailoutException bailout(String string) {
        FrameState currentFrameState = this.createFrameState(this.bci(), null);
        StackTraceElement[] elements = GraphUtil.approxSourceStackTraceElement(currentFrameState);
        PermanentBailoutException bailout = new PermanentBailoutException(string);
        throw GraphUtil.createBailoutException(string, (Throwable)((Object)bailout), elements);
    }

    private FrameState createFrameState(int bci, StateSplit forStateSplit) {
        assert (!(forStateSplit instanceof BytecodeExceptionNode));
        if (this.currentBlock != null && bci > this.currentBlock.endBci) {
            this.frameState.clearNonLiveLocals(this.currentBlock, this.liveness, false);
        }
        return this.frameState.create(bci, forStateSplit);
    }

    private FrameState createBytecodeExceptionFrameState(int bci, BytecodeExceptionNode bytecodeException) {
        FrameStateBuilder copy = this.frameState.copy();
        copy.clearStack();
        if (this.currentBlock != null) {
            copy.clearNonLiveLocals(this.currentBlock, this.liveness, false);
        }
        copy.setRethrowException(true);
        copy.push(JavaKind.Object, bytecodeException);
        return copy.create(bci, bytecodeException);
    }

    @Override
    public void setStateAfter(StateSplit sideEffect) {
        assert (sideEffect.hasSideEffect() || sideEffect instanceof AbstractMergeNode);
        FrameState stateAfter = this.createFrameState(this.stream.nextBCI(), sideEffect);
        sideEffect.setStateAfter(stateAfter);
    }

    protected NodeSourcePosition createBytecodePosition() {
        NodeSourcePosition bytecodePosition = this.frameState.createBytecodePosition(this.bci());
        return bytecodePosition;
    }

    public void setCurrentFrameState(FrameStateBuilder frameState) {
        this.frameState = frameState;
    }

    protected final BytecodeStream getStream() {
        return this.stream;
    }

    @Override
    public int bci() {
        return this.stream.currentBCI();
    }

    public void setBciCanBeDuplicated(boolean bciCanBeDuplicated) {
        this.bciCanBeDuplicated = bciCanBeDuplicated;
    }

    @Override
    public boolean bciCanBeDuplicated() {
        return this.bciCanBeDuplicated || !this.blockMap.bciUnique();
    }

    public void loadLocal(int index, JavaKind kind) {
        ValueNode value = this.frameState.loadLocal(index, kind);
        this.frameState.push(kind, value);
    }

    public void loadLocalObject(int index) {
        ValueNode value = this.frameState.loadLocal(index, JavaKind.Object);
        int nextBCI = this.stream.nextBCI();
        int nextBC = this.stream.readUByte(nextBCI);
        if (nextBCI <= this.currentBlock.endBci && nextBC == 180) {
            this.stream.next();
            try (DebugCloseable ignored = this.openNodeContext();){
                this.genGetField(this.stream.readCPI(), 180, value);
            }
        } else {
            this.frameState.push(JavaKind.Object, value);
        }
    }

    public void storeLocal(JavaKind kind, int index) {
        ValueNode value = this.frameState.pop(kind);
        this.frameState.storeLocal(index, kind, value);
    }

    protected void genLoadConstant(int cpi, int opcode) {
        Object con = this.lookupConstant(cpi, opcode);
        if (con instanceof JavaType) {
            JavaType type = (JavaType)con;
            if (this.typeIsResolved(type)) {
                this.frameState.push(JavaKind.Object, this.appendConstant(this.getConstantReflection().asJavaClass((ResolvedJavaType)type)));
            } else {
                this.handleUnresolvedLoadConstant(type);
            }
        } else if (con instanceof JavaConstant) {
            JavaConstant constant = (JavaConstant)con;
            this.frameState.push(constant.getJavaKind(), this.appendConstant(constant));
        } else {
            throw new Error("lookupConstant returned an object of incorrect type");
        }
    }

    private JavaKind refineComponentType(ValueNode array, JavaKind kind) {
        JavaType componentType;
        ResolvedJavaType type;
        if (kind == JavaKind.Byte && (type = array.stamp(NodeView.DEFAULT).javaType(this.getMetaAccess())).isArray() && (componentType = type.getComponentType()) != null) {
            JavaKind refinedKind = componentType.getJavaKind();
            assert (refinedKind == JavaKind.Byte || refinedKind == JavaKind.Boolean);
            return refinedKind;
        }
        return kind;
    }

    private void genLoadIndexed(JavaKind kind) {
        ValueNode index = this.frameState.pop(JavaKind.Int);
        ValueNode array = this.frameState.pop(JavaKind.Object);
        array = this.maybeEmitExplicitNullCheck(array);
        GuardingNode boundsCheck = this.maybeEmitExplicitBoundsCheck(array, index);
        for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
            if (!plugin.handleLoadIndexed(this, array, index, boundsCheck, kind)) continue;
            return;
        }
        JavaKind actualKind = this.refineComponentType(array, kind);
        this.frameState.push(actualKind, this.append(this.genLoadIndexed(array, index, boundsCheck, actualKind)));
    }

    private void genStoreIndexed(JavaKind kind) {
        ValueNode value = this.frameState.pop(kind);
        ValueNode index = this.frameState.pop(JavaKind.Int);
        ValueNode array = this.frameState.pop(JavaKind.Object);
        array = this.maybeEmitExplicitNullCheck(array);
        GuardingNode boundsCheck = this.maybeEmitExplicitBoundsCheck(array, index);
        GuardingNode storeCheck = this.maybeEmitExplicitStoreCheck(array, kind, value);
        for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
            if (!plugin.handleStoreIndexed(this, array, index, boundsCheck, storeCheck, kind, value)) continue;
            return;
        }
        JavaKind actualKind = this.refineComponentType(array, kind);
        this.genStoreIndexed(array, index, boundsCheck, storeCheck, actualKind, this.maskSubWordValue(value, actualKind));
    }

    private void genArithmeticOp(JavaKind kind, int opcode) {
        ValueNode v;
        ValueNode y = this.frameState.pop(kind);
        ValueNode x = this.frameState.pop(kind);
        switch (opcode) {
            case 96: 
            case 97: {
                v = this.genIntegerAdd(x, y);
                break;
            }
            case 98: 
            case 99: {
                v = this.genFloatAdd(x, y);
                break;
            }
            case 100: 
            case 101: {
                v = this.genIntegerSub(x, y);
                break;
            }
            case 102: 
            case 103: {
                v = this.genFloatSub(x, y);
                break;
            }
            case 104: 
            case 105: {
                v = this.genIntegerMul(x, y);
                break;
            }
            case 106: 
            case 107: {
                v = this.genFloatMul(x, y);
                break;
            }
            case 110: 
            case 111: {
                v = this.genFloatDiv(x, y);
                break;
            }
            case 114: 
            case 115: {
                v = this.genFloatRem(x, y);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        this.frameState.push(kind, this.append(v));
    }

    private void genIntegerDivOp(JavaKind kind, int opcode) {
        ValueNode v;
        ValueNode y = this.frameState.pop(kind);
        ValueNode x = this.frameState.pop(kind);
        GuardingNode zeroCheck = this.maybeEmitExplicitDivisionByZeroCheck(y);
        switch (opcode) {
            case 108: 
            case 109: {
                v = this.genIntegerDiv(x, y, zeroCheck);
                break;
            }
            case 112: 
            case 113: {
                v = this.genIntegerRem(x, y, zeroCheck);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        this.frameState.push(kind, this.append(v));
    }

    private void genNegateOp(JavaKind kind) {
        ValueNode x = this.frameState.pop(kind);
        this.frameState.push(kind, this.append(this.genNegateOp(x)));
    }

    private void genShiftOp(JavaKind kind, int opcode) {
        ValueNode v;
        ValueNode s = this.frameState.pop(JavaKind.Int);
        ValueNode x = this.frameState.pop(kind);
        switch (opcode) {
            case 120: 
            case 121: {
                v = this.genLeftShift(x, s);
                break;
            }
            case 122: 
            case 123: {
                v = this.genRightShift(x, s);
                break;
            }
            case 124: 
            case 125: {
                v = this.genUnsignedRightShift(x, s);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        this.frameState.push(kind, this.append(v));
    }

    private void genLogicOp(JavaKind kind, int opcode) {
        ValueNode v;
        ValueNode y = this.frameState.pop(kind);
        ValueNode x = this.frameState.pop(kind);
        switch (opcode) {
            case 126: 
            case 127: {
                v = this.genAnd(x, y);
                break;
            }
            case 128: 
            case 129: {
                v = this.genOr(x, y);
                break;
            }
            case 130: 
            case 131: {
                v = this.genXor(x, y);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        this.frameState.push(kind, this.append(v));
    }

    private void genFloatCompareOp(JavaKind kind, boolean isUnorderedLess) {
        ValueNode y = this.frameState.pop(kind);
        ValueNode x = this.frameState.pop(kind);
        this.frameState.push(JavaKind.Int, this.append(this.genNormalizeCompare(x, y, isUnorderedLess)));
    }

    private void genIntegerCompareOp(JavaKind kind) {
        ValueNode y = this.frameState.pop(kind);
        ValueNode x = this.frameState.pop(kind);
        this.frameState.push(JavaKind.Int, this.append(this.genIntegerNormalizeCompare(x, y)));
    }

    private void genFloatConvert(FloatConvert op, JavaKind from, JavaKind to) {
        ValueNode input = this.frameState.pop(from);
        this.frameState.push(to, this.append(this.genFloatConvert(op, input)));
    }

    private void genSignExtend(JavaKind from, JavaKind to) {
        ValueNode input = this.frameState.pop(from);
        if (from != from.getStackKind()) {
            input = this.append(this.genNarrow(input, from.getBitCount()));
        }
        this.frameState.push(to, this.append(this.genSignExtend(input, to.getBitCount())));
    }

    private void genZeroExtend(JavaKind from, JavaKind to) {
        ValueNode input = this.frameState.pop(from);
        if (from != from.getStackKind()) {
            input = this.append(this.genNarrow(input, from.getBitCount()));
        }
        this.frameState.push(to, this.append(this.genZeroExtend(input, to.getBitCount())));
    }

    private void genNarrow(JavaKind from, JavaKind to) {
        ValueNode input = this.frameState.pop(from);
        this.frameState.push(to, this.append(this.genNarrow(input, to.getBitCount())));
    }

    private void genIncrement() {
        int index = this.getStream().readLocalIndex();
        int delta = this.getStream().readIncrement();
        ValueNode x = this.frameState.loadLocal(index, JavaKind.Int);
        ConstantNode y = this.appendConstant((JavaConstant)JavaConstant.forInt((int)delta));
        this.frameState.storeLocal(index, JavaKind.Int, this.append(this.genIntegerAdd(x, y)));
    }

    private void genIfZero(Condition cond) {
        ConstantNode y = this.appendConstant((JavaConstant)JavaConstant.INT_0);
        ValueNode x = this.frameState.pop(JavaKind.Int);
        this.genIf(x, cond, y);
    }

    private void genIfNull(Condition cond) {
        ConstantNode y = this.appendConstant(JavaConstant.NULL_POINTER);
        ValueNode x = this.frameState.pop(JavaKind.Object);
        this.genIf(x, cond, y);
    }

    private void genIfSame(JavaKind kind, Condition cond) {
        ValueNode y = this.frameState.pop(kind);
        ValueNode x = this.frameState.pop(kind);
        this.genIf(x, cond, y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize(ResolvedJavaType resolvedType) {
        Class<BytecodeParser> clazz = BytecodeParser.class;
        synchronized (BytecodeParser.class) {
            resolvedType.initialize();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected JavaType lookupType(int cpi, int bytecode) {
        this.maybeEagerlyResolve(cpi, bytecode);
        JavaType result = this.constantPool.lookupType(cpi, bytecode);
        assert (!this.graphBuilderConfig.unresolvedIsError() || result instanceof ResolvedJavaType);
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private String unresolvedMethodAssertionMessage(JavaMethod result) {
        String className;
        String message = result.format("%H.%n(%P)%R");
        if (JavaVersionUtil.JAVA_SPEC > 8) return message;
        JavaType declaringClass = result.getDeclaringClass();
        switch (className = declaringClass.getName()) {
            case "Ljava/nio/ByteBuffer;": 
            case "Ljava/nio/ShortBuffer;": 
            case "Ljava/nio/CharBuffer;": 
            case "Ljava/nio/IntBuffer;": 
            case "Ljava/nio/LongBuffer;": 
            case "Ljava/nio/FloatBuffer;": 
            case "Ljava/nio/DoubleBuffer;": 
            case "Ljava/nio/MappedByteBuffer;": {
                switch (result.getName()) {
                    case "position": 
                    case "limit": 
                    case "mark": 
                    case "reset": 
                    case "clear": 
                    case "flip": 
                    case "rewind": {
                        String returnType = result.getSignature().getReturnType(null).toJavaName();
                        if (!returnType.equals(declaringClass.toJavaName())) return message;
                        return message + String.format(" [Probably cause: %s was compiled with javac from JDK 9+ using `-target 8` and `-source 8` options. See https://bugs.openjdk.java.net/browse/JDK-4774077 for details.]", this.method.getDeclaringClass().toClassName());
                    }
                }
                return message;
            }
        }
        return message;
    }

    private JavaMethod lookupMethod(int cpi, int opcode) {
        this.maybeEagerlyResolve(cpi, opcode);
        JavaMethod result = this.lookupMethodInPool(cpi, opcode);
        assert (!this.graphBuilderConfig.unresolvedIsError() || result instanceof ResolvedJavaMethod) : this.unresolvedMethodAssertionMessage(result);
        return result;
    }

    protected JavaMethod lookupMethodInPool(int cpi, int opcode) {
        return this.constantPool.lookupMethod(cpi, opcode);
    }

    protected JavaType lookupReferencedTypeInPool(int cpi, int opcode) {
        if (GraalServices.hasLookupReferencedType()) {
            return GraalServices.lookupReferencedType(this.constantPool, cpi, opcode);
        }
        return null;
    }

    protected JavaField lookupField(int cpi, int opcode) {
        this.maybeEagerlyResolve(cpi, opcode);
        JavaField result = this.constantPool.lookupField(cpi, this.method, opcode);
        return this.lookupField(result);
    }

    protected JavaField lookupField(JavaField result) {
        ResolvedJavaType declaringClass;
        assert (!this.graphBuilderConfig.unresolvedIsError() || result instanceof ResolvedJavaField) : "Not resolved: " + result;
        if ((this.parsingIntrinsic() || this.eagerInitializing) && result instanceof ResolvedJavaField && !(declaringClass = ((ResolvedJavaField)result).getDeclaringClass()).isInitialized()) {
            assert (!this.eagerInitializing || declaringClass.isInterface()) : "Declaring class not initialized but not an interface? " + declaringClass;
            BytecodeParser.initialize(declaringClass);
        }
        assert (!this.uninitializedIsError || result instanceof ResolvedJavaField && ((ResolvedJavaField)result).getDeclaringClass().isInitialized()) : result;
        return result;
    }

    private Object lookupConstant(int cpi, int opcode) {
        this.maybeEagerlyResolve(cpi, opcode);
        Object result = this.constantPool.lookupConstant(cpi);
        assert (!this.graphBuilderConfig.unresolvedIsError() || !(result instanceof JavaType) || result instanceof ResolvedJavaType) : result;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void maybeEagerlyResolve(int cpi, int bytecode) {
        if (this.intrinsicContext != null) {
            this.constantPool.loadReferencedType(cpi, bytecode);
        } else if (this.graphBuilderConfig.eagerResolving()) {
            Object lock = this.loadReferenceTypeLock();
            if (lock != null) {
                Object object = lock;
                synchronized (object) {
                    this.loadReferenceType(cpi, bytecode);
                }
            } else {
                this.loadReferenceType(cpi, bytecode);
            }
        }
    }

    protected Object loadReferenceTypeLock() {
        return BytecodeParser.class;
    }

    private void loadReferenceType(int cpi, int bytecode) {
        ClassInitializationPlugin classInitializationPlugin = this.graphBuilderConfig.getPlugins().getClassInitializationPlugin();
        if (classInitializationPlugin != null) {
            classInitializationPlugin.loadReferencedType(this, this.constantPool, cpi, bytecode);
        } else {
            this.constantPool.loadReferencedType(cpi, bytecode);
        }
    }

    protected JavaType maybeEagerlyResolve(JavaType type, ResolvedJavaType accessingClass) {
        if (this.graphBuilderConfig.eagerResolving() || this.parsingIntrinsic()) {
            return type.resolve(accessingClass);
        }
        return type;
    }

    protected void maybeEagerlyInitialize(ResolvedJavaType resolvedType) {
        if (!resolvedType.isInitialized() && this.eagerInitializing) {
            BytecodeParser.initialize(resolvedType);
        }
    }

    private JavaTypeProfile getProfileForTypeCheck(TypeReference type) {
        if (this.parsingIntrinsic() || this.profilingInfo == null || !this.optimisticOpts.useTypeCheckHints(this.getOptions()) || type.isExact()) {
            return null;
        }
        return this.profilingInfo.getTypeProfile(this.bci());
    }

    private void genCheckCast(int cpi) {
        JavaType type = this.lookupType(cpi, 192);
        ValueNode object = this.frameState.pop(JavaKind.Object);
        this.genCheckCast(type, object);
    }

    protected void genCheckCast(JavaType type, ValueNode object) {
        if (this.typeIsResolved(type)) {
            this.genCheckCast((ResolvedJavaType)type, object);
        } else {
            this.handleUnresolvedCheckCast(type, object);
        }
    }

    private SpeculationLog.Speculation mayUseTypeProfile() {
        SpeculationLog speculationLog = this.graph.getSpeculationLog();
        SpeculationLog.Speculation speculation = null;
        if (speculationLog != null) {
            SpeculationLog.SpeculationReason speculationReason = FALLBACK_TYPECHECK.createSpeculationReason(this.getMethod(), this.bci());
            if (speculationLog.maySpeculate(speculationReason)) {
                speculation = speculationLog.speculate(speculationReason);
                fallBackSpeculationTaken.increment(this.debug);
            } else {
                fallBackSpeculationNotTaken.increment(this.debug);
            }
        }
        return speculation;
    }

    protected void genCheckCast(ResolvedJavaType resolvedType, ValueNode objectIn) {
        SpeculationLog.Speculation speculation;
        ValueNode object = objectIn;
        TypeReference checkedType = TypeReference.createTrusted(this.graph.getAssumptions(), resolvedType);
        JavaTypeProfile profile = this.getProfileForTypeCheck(checkedType);
        for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
            if (!plugin.handleCheckCast(this, object, checkedType.getType(), profile)) continue;
            return;
        }
        ValueNode castNode = null;
        if (profile != null && profile.getNullSeen().isFalse() && (speculation = this.mayUseTypeProfile()) != null) {
            object = this.nullCheckedValue(object);
            ResolvedJavaType singleType = profile.asSingleType();
            if (singleType != null && checkedType.getType().isAssignableFrom(singleType)) {
                LogicNode typeCheck = this.append(this.createInstanceOf(TypeReference.createExactTrusted(singleType), object, profile));
                if (typeCheck.isTautology()) {
                    castNode = object;
                } else {
                    FixedGuardNode fixedGuard = this.append(new FixedGuardNode(typeCheck, DeoptimizationReason.TypeCheckedInliningViolated, DeoptimizationAction.InvalidateReprofile, speculation, false));
                    castNode = this.append(PiNode.create(object, StampFactory.objectNonNull(TypeReference.createExactTrusted(singleType)), fixedGuard));
                }
            }
        }
        boolean nonNull = ((ObjectStamp)object.stamp(NodeView.DEFAULT)).nonNull();
        if (castNode == null) {
            LogicNode condition = this.genUnique(this.createInstanceOfAllowNull(checkedType, object, null));
            if (condition.isTautology()) {
                castNode = object;
            } else {
                GuardingNode guard;
                if (this.needsExplicitClassCastException(object)) {
                    ConstantNode clazz = ConstantNode.forConstant(this.getConstantReflection().asJavaClass(resolvedType), this.getMetaAccess(), this.graph);
                    guard = this.emitBytecodeExceptionCheck(condition, true, BytecodeExceptionNode.BytecodeExceptionKind.CLASS_CAST, object, clazz);
                } else {
                    guard = this.append(new FixedGuardNode(condition, DeoptimizationReason.ClassCastException, DeoptimizationAction.InvalidateReprofile, false));
                }
                castNode = this.append(PiNode.create(object, StampFactory.object(checkedType, nonNull), guard.asNode()));
            }
        }
        this.frameState.push(JavaKind.Object, castNode);
    }

    private void genInstanceOf(int cpi) {
        JavaType type = this.lookupType(cpi, 193);
        ValueNode object = this.frameState.pop(JavaKind.Object);
        this.genInstanceOf(type, object);
    }

    protected void genInstanceOf(JavaType type, ValueNode object) {
        if (this.typeIsResolved(type)) {
            this.genInstanceOf((ResolvedJavaType)type, object);
        } else {
            this.handleUnresolvedInstanceOf(type, object);
        }
    }

    protected void genInstanceOf(ResolvedJavaType resolvedType, ValueNode objectIn) {
        ValueNode object = objectIn;
        TypeReference checkedType = TypeReference.createTrusted(this.graph.getAssumptions(), resolvedType);
        JavaTypeProfile profile = this.getProfileForTypeCheck(checkedType);
        for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
            if (!plugin.handleInstanceOf(this, object, checkedType.getType(), profile)) continue;
            return;
        }
        LogicNode instanceOfNode = null;
        if (profile != null && profile.getNullSeen().isFalse()) {
            object = this.nullCheckedValue(object);
            boolean createGuard = true;
            ResolvedJavaType singleType = profile.asSingleType();
            if (singleType != null) {
                LogicNode typeCheck = this.append(this.createInstanceOf(TypeReference.createExactTrusted(singleType), object, profile));
                if (!typeCheck.isTautology()) {
                    SpeculationLog.Speculation speculation = this.mayUseTypeProfile();
                    if (speculation == null) {
                        createGuard = false;
                    }
                    if (createGuard) {
                        this.append(new FixedGuardNode(typeCheck, DeoptimizationReason.TypeCheckedInliningViolated, DeoptimizationAction.InvalidateReprofile, speculation, false));
                    }
                }
                if (createGuard) {
                    instanceOfNode = LogicConstantNode.forBoolean(checkedType.getType().isAssignableFrom(singleType));
                }
            }
        }
        if (instanceOfNode == null) {
            instanceOfNode = this.createInstanceOf(checkedType, object, null);
        }
        LogicNode logicNode = this.genUnique(instanceOfNode);
        int next = this.getStream().nextBCI();
        int value = this.getStream().readUByte(next);
        if (next <= this.currentBlock.endBci && (value == 153 || value == 154)) {
            this.getStream().next();
            try (DebugCloseable context = this.openNodeContext();){
                BciBlockMapping.BciBlock firstSucc = this.currentBlock.getSuccessor(0);
                BciBlockMapping.BciBlock secondSucc = this.currentBlock.getSuccessor(1);
                if (firstSucc != secondSucc) {
                    boolean negate;
                    boolean bl = negate = value != 154;
                    if (negate) {
                        BciBlockMapping.BciBlock tmp = firstSucc;
                        firstSucc = secondSucc;
                        secondSucc = tmp;
                    }
                    this.genIf(instanceOfNode, firstSucc, secondSucc, this.getProfileData(negate));
                }
                this.appendGoto(firstSucc);
            }
        } else {
            this.frameState.push(JavaKind.Int, this.append(this.genConditional(logicNode)));
        }
    }

    protected void genNewInstance(int cpi) {
        JavaType type = this.lookupType(cpi, 187);
        this.genNewInstance(type);
    }

    protected void genNewInstance(JavaType type) {
        if (this.typeIsResolved(type)) {
            this.genNewInstance((ResolvedJavaType)type);
        } else {
            this.handleUnresolvedNewInstance(type);
        }
    }

    protected void genNewInstance(ResolvedJavaType resolvedType) {
        if (resolvedType.isAbstract() || resolvedType.isInterface()) {
            this.handleIllegalNewInstance((JavaType)resolvedType);
            return;
        }
        this.maybeEagerlyInitialize(resolvedType);
        ClassInitializationPlugin classInitializationPlugin = this.graphBuilderConfig.getPlugins().getClassInitializationPlugin();
        if (!resolvedType.isInitialized() && classInitializationPlugin == null) {
            this.handleIllegalNewInstance((JavaType)resolvedType);
            return;
        }
        for (ResolvedJavaType exceptionType : this.graphBuilderConfig.getSkippedExceptionTypes()) {
            if (!exceptionType.isAssignableFrom(resolvedType)) continue;
            this.append(new DeoptimizeNode(DeoptimizationAction.InvalidateRecompile, DeoptimizationReason.RuntimeConstraint));
            return;
        }
        if (classInitializationPlugin != null) {
            classInitializationPlugin.apply(this, resolvedType, this::createCurrentFrameState);
        }
        for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
            if (!plugin.handleNewInstance(this, resolvedType)) continue;
            return;
        }
        this.frameState.push(JavaKind.Object, this.append(new NewInstanceNode(resolvedType, true)));
    }

    private static Class<?> arrayTypeCodeToClass(int code) {
        switch (code) {
            case 4: {
                return Boolean.TYPE;
            }
            case 5: {
                return Character.TYPE;
            }
            case 6: {
                return Float.TYPE;
            }
            case 7: {
                return Double.TYPE;
            }
            case 8: {
                return Byte.TYPE;
            }
            case 9: {
                return Short.TYPE;
            }
            case 10: {
                return Integer.TYPE;
            }
            case 11: {
                return Long.TYPE;
            }
        }
        throw new IllegalArgumentException("unknown array type code: " + code);
    }

    private void genNewPrimitiveArray(int typeCode) {
        ResolvedJavaType elementType = this.getMetaAccess().lookupJavaType(BytecodeParser.arrayTypeCodeToClass(typeCode));
        ValueNode length = this.frameState.pop(JavaKind.Int);
        for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
            if (!plugin.handleNewArray(this, elementType, length)) continue;
            return;
        }
        this.frameState.push(JavaKind.Object, this.append(new NewArrayNode(elementType, length, true)));
    }

    private void genNewObjectArray(int cpi) {
        JavaType type = this.lookupType(cpi, 189);
        this.genNewObjectArray(type);
    }

    private void genNewObjectArray(JavaType type) {
        if (this.typeIsResolved(type)) {
            this.genNewObjectArray((ResolvedJavaType)type);
        } else {
            ValueNode length = this.frameState.pop(JavaKind.Int);
            this.handleUnresolvedNewObjectArray(type, length);
        }
    }

    private void genNewObjectArray(ResolvedJavaType resolvedType) {
        ClassInitializationPlugin classInitializationPlugin = this.graphBuilderConfig.getPlugins().getClassInitializationPlugin();
        if (classInitializationPlugin != null) {
            classInitializationPlugin.apply(this, resolvedType.getArrayClass(), this::createCurrentFrameState);
        }
        ValueNode length = this.frameState.pop(JavaKind.Int);
        for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
            if (!plugin.handleNewArray(this, resolvedType, length)) continue;
            return;
        }
        this.frameState.push(JavaKind.Object, this.append(new NewArrayNode(resolvedType, length, true)));
    }

    private void genNewMultiArray(int cpi) {
        JavaType type = this.lookupType(cpi, 197);
        int rank = this.getStream().readUByte(this.bci() + 3);
        ValueNode[] dims = new ValueNode[rank];
        this.genNewMultiArray(type, rank, dims);
    }

    private void genNewMultiArray(JavaType type, int rank, ValueNode[] dims) {
        if (this.typeIsResolved(type)) {
            this.genNewMultiArray((ResolvedJavaType)type, rank, dims);
        } else {
            for (int i = rank - 1; i >= 0; --i) {
                dims[i] = this.frameState.pop(JavaKind.Int);
            }
            this.handleUnresolvedNewMultiArray(type, dims);
        }
    }

    private void genNewMultiArray(ResolvedJavaType resolvedType, int rank, ValueNode[] dims) {
        ClassInitializationPlugin classInitializationPlugin = this.graphBuilderConfig.getPlugins().getClassInitializationPlugin();
        if (classInitializationPlugin != null) {
            classInitializationPlugin.apply(this, resolvedType, this::createCurrentFrameState);
        }
        for (int i = rank - 1; i >= 0; --i) {
            dims[i] = this.frameState.pop(JavaKind.Int);
        }
        for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
            if (!plugin.handleNewMultiArray(this, resolvedType, dims)) continue;
            return;
        }
        this.frameState.push(JavaKind.Object, this.append(new NewMultiArrayNode(resolvedType, dims)));
    }

    protected void genGetField(int cpi, int opcode) {
        this.genGetField(cpi, opcode, this.frameState.pop(JavaKind.Object));
    }

    protected void genGetField(int cpi, int opcode, ValueNode receiverInput) {
        JavaField field = this.lookupField(cpi, opcode);
        this.genGetField(field, receiverInput);
    }

    private void genGetField(JavaField field, ValueNode receiverInput) {
        if (field instanceof ResolvedJavaField) {
            ValueNode receiver = this.maybeEmitExplicitNullCheck(receiverInput);
            ResolvedJavaField resolvedField = (ResolvedJavaField)field;
            this.genGetField(resolvedField, receiver);
        } else {
            this.handleUnresolvedLoadField(field, receiverInput);
        }
    }

    private void genGetField(ResolvedJavaField resolvedField, ValueNode receiver) {
        if (!this.parsingIntrinsic() && GraalOptions.GeneratePIC.getValue(this.getOptions()).booleanValue()) {
            this.graph.recordField(resolvedField);
        }
        for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
            if (!plugin.handleLoadField(this, receiver, resolvedField)) continue;
            return;
        }
        ValueNode fieldRead = this.append(this.genLoadField(receiver, resolvedField));
        if (resolvedField.getDeclaringClass().getName().equals("Ljava/lang/ref/Reference;") && resolvedField.getName().equals("referent")) {
            FieldLocationIdentity referentIdentity = new FieldLocationIdentity(resolvedField);
            this.append(new MembarNode(0, referentIdentity));
        }
        JavaKind fieldKind = resolvedField.getJavaKind();
        this.pushLoadField(resolvedField, fieldRead, fieldKind);
    }

    protected boolean needsExplicitNullCheckException(ValueNode object) {
        return this.needsExplicitException();
    }

    protected boolean needsExplicitBoundsCheckException(ValueNode array, ValueNode index) {
        return this.needsExplicitException();
    }

    protected boolean needsExplicitClassCastException(ValueNode object) {
        return this.needsExplicitException();
    }

    protected boolean needsExplicitStoreCheckException(ValueNode array, ValueNode value) {
        return this.needsExplicitException();
    }

    protected boolean needsExplicitDivisionByZeroException(ValueNode y) {
        return this.needsExplicitException();
    }

    @Override
    public boolean needsExplicitException() {
        GraphBuilderConfiguration.BytecodeExceptionMode exceptionMode = this.graphBuilderConfig.getBytecodeExceptionMode();
        if (exceptionMode == GraphBuilderConfiguration.BytecodeExceptionMode.CheckAll || GraalOptions.StressExplicitExceptionCode.getValue(this.options).booleanValue()) {
            return true;
        }
        if (exceptionMode == GraphBuilderConfiguration.BytecodeExceptionMode.Profile && this.profilingInfo != null) {
            return this.profilingInfo.getExceptionSeen(this.bci()) == TriState.TRUE;
        }
        return false;
    }

    @Override
    public AbstractBeginNode genExplicitExceptionEdge(BytecodeExceptionNode.BytecodeExceptionKind exceptionKind, ValueNode ... exceptionArguments) {
        BytecodeExceptionNode exceptionNode = this.graph.add(new BytecodeExceptionNode(this.getMetaAccess(), exceptionKind, exceptionArguments));
        exceptionNode.setStateAfter(this.createBytecodeExceptionFrameState(this.bci(), exceptionNode));
        AbstractBeginNode exceptionDispatch = this.handleException(exceptionNode, this.bci(), false);
        exceptionNode.setNext(exceptionDispatch);
        return BeginNode.begin(exceptionNode);
    }

    protected void genPutField(int cpi, int opcode) {
        JavaField field = this.lookupField(cpi, opcode);
        this.genPutField(field);
    }

    protected void genPutField(JavaField field) {
        this.genPutField(field, this.frameState.pop(field.getJavaKind()));
    }

    private void genPutField(JavaField field, ValueNode value) {
        ValueNode receiverInput = this.frameState.pop(JavaKind.Object);
        if (field instanceof ResolvedJavaField) {
            ValueNode receiver = this.maybeEmitExplicitNullCheck(receiverInput);
            ResolvedJavaField resolvedField = (ResolvedJavaField)field;
            if (!this.parsingIntrinsic() && GraalOptions.GeneratePIC.getValue(this.getOptions()).booleanValue()) {
                this.graph.recordField(resolvedField);
            }
            for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
                if (!plugin.handleStoreField(this, receiver, resolvedField, value)) continue;
                return;
            }
            if (resolvedField.isFinal() && this.method.isConstructor()) {
                this.finalBarrierRequired = true;
            }
            this.genStoreField(receiver, resolvedField, value);
        } else {
            this.handleUnresolvedStoreField(field, value, receiverInput);
        }
    }

    protected void genGetStatic(int cpi, int opcode) {
        JavaField field = this.lookupField(cpi, opcode);
        this.genGetStatic(field);
    }

    private void genGetStatic(JavaField field) {
        ResolvedJavaField resolvedField = this.resolveStaticFieldAccess(field, null);
        if (resolvedField == null) {
            return;
        }
        if (!this.parsingIntrinsic() && GraalOptions.GeneratePIC.getValue(this.getOptions()).booleanValue()) {
            this.graph.recordField(resolvedField);
        }
        if (resolvedField.isSynthetic() && resolvedField.getName().startsWith("$assertionsDisabled")) {
            if (this.parsingIntrinsic()) {
                throw new GraalError("Cannot use an assertion within the context of an intrinsic: " + resolvedField);
            }
            if (this.graphBuilderConfig.omitAssertions()) {
                this.frameState.push(field.getJavaKind(), ConstantNode.forBoolean(true, this.graph));
                return;
            }
        }
        ResolvedJavaType holder = resolvedField.getDeclaringClass();
        ClassInitializationPlugin classInitializationPlugin = this.graphBuilderConfig.getPlugins().getClassInitializationPlugin();
        if (classInitializationPlugin != null) {
            classInitializationPlugin.apply(this, holder, this::createCurrentFrameState);
        }
        for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
            if (!plugin.handleLoadStaticField(this, resolvedField)) continue;
            return;
        }
        ValueNode fieldRead = this.append(this.genLoadField(null, resolvedField));
        JavaKind fieldKind = resolvedField.getJavaKind();
        this.pushLoadField(resolvedField, fieldRead, fieldKind);
    }

    private void pushLoadField(ResolvedJavaField resolvedField, ValueNode fieldRead, JavaKind fieldKind) {
        if (resolvedField.isVolatile() && fieldRead instanceof LoadFieldNode) {
            StateSplitProxyNode readProxy = this.append(this.genVolatileFieldReadProxy(fieldRead));
            this.frameState.push(fieldKind, readProxy);
            readProxy.setStateAfter(this.frameState.create(this.stream.nextBCI(), readProxy));
        } else {
            this.frameState.push(fieldKind, fieldRead);
        }
    }

    private ResolvedJavaField resolveStaticFieldAccess(JavaField field, ValueNode value) {
        if (field instanceof ResolvedJavaField) {
            ResolvedJavaField resolvedField = (ResolvedJavaField)field;
            ResolvedJavaType resolvedType = resolvedField.getDeclaringClass();
            this.maybeEagerlyInitialize(resolvedType);
            if (resolvedType.isInitialized() || this.graphBuilderConfig.getPlugins().getClassInitializationPlugin() != null) {
                return resolvedField;
            }
            if (!resolvedType.isInterface() && resolvedType.isAssignableFrom(this.method.getDeclaringClass()) && (this.method.isClassInitializer() || this.method.isConstructor())) {
                return resolvedField;
            }
        }
        if (value == null) {
            this.handleUnresolvedLoadField(field, null);
        } else {
            this.handleUnresolvedStoreField(field, value, null);
        }
        return null;
    }

    protected void genPutStatic(int cpi, int opcode) {
        JavaField field = this.lookupField(cpi, opcode);
        this.genPutStatic(field);
    }

    protected void genPutStatic(JavaField field) {
        int stackSizeBefore = this.frameState.stackSize();
        ValueNode value = this.frameState.pop(field.getJavaKind());
        ResolvedJavaField resolvedField = this.resolveStaticFieldAccess(field, value);
        if (resolvedField == null) {
            return;
        }
        if (!this.parsingIntrinsic() && GraalOptions.GeneratePIC.getValue(this.getOptions()).booleanValue()) {
            this.graph.recordField(resolvedField);
        }
        ClassInitializationPlugin classInitializationPlugin = this.graphBuilderConfig.getPlugins().getClassInitializationPlugin();
        ResolvedJavaType holder = resolvedField.getDeclaringClass();
        if (classInitializationPlugin != null) {
            Supplier<FrameState> stateBefore = () -> {
                JavaKind[] pushedSlotKinds = new JavaKind[]{field.getJavaKind()};
                ValueNode[] pushedValues = new ValueNode[]{value};
                FrameState fs = this.frameState.create(this.bci(), this.getNonIntrinsicAncestor(), false, pushedSlotKinds, pushedValues);
                assert (stackSizeBefore == fs.stackSize());
                return fs;
            };
            classInitializationPlugin.apply(this, holder, stateBefore);
        }
        for (NodePlugin plugin : this.graphBuilderConfig.getPlugins().getNodePlugins()) {
            if (!plugin.handleStoreStaticField(this, resolvedField, value)) continue;
            return;
        }
        this.genStoreField(null, resolvedField, value);
    }

    private double[] switchProbability(int numberOfCases, int bci) {
        double[] prob;
        double[] dArray = prob = this.profilingInfo == null ? null : this.profilingInfo.getSwitchProbabilities(bci);
        if (prob != null) {
            assert (prob.length == numberOfCases);
        } else {
            this.debug.log("Missing probability (switch) in %s at bci %d", (Object)this.method, bci);
            prob = new double[numberOfCases];
            for (int i = 0; i < numberOfCases; ++i) {
                prob[i] = 1.0 / (double)numberOfCases;
            }
        }
        assert (BytecodeParser.allPositive(prob));
        return prob;
    }

    private ProfileData.ProfileSource getSwitchProfileSource(int bci) {
        if (this.profilingInfo == null || !this.profilingInfo.isMature()) {
            return ProfileData.ProfileSource.UNKNOWN;
        }
        double[] probabilities = this.profilingInfo.getSwitchProbabilities(bci);
        if (probabilities == null) {
            return ProfileData.ProfileSource.UNKNOWN;
        }
        for (double p : probabilities) {
            if (!(p < 0.0)) continue;
            return ProfileData.ProfileSource.UNKNOWN;
        }
        return ProfileData.ProfileSource.PROFILED;
    }

    private static boolean allPositive(double[] a) {
        for (double d : a) {
            if (!(d < 0.0)) continue;
            return false;
        }
        return true;
    }

    private void genSwitch(BytecodeSwitch bs) {
        int bci = this.bci();
        ValueNode value = this.frameState.pop(JavaKind.Int);
        int nofCases = bs.numberOfCases();
        int nofCasesPlusDefault = nofCases + 1;
        double[] keyProbabilities = this.switchProbability(nofCasesPlusDefault, bci);
        EconomicMap bciToBlockSuccessorIndex = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        for (int i = 0; i < this.currentBlock.getSuccessorCount(); ++i) {
            assert (!bciToBlockSuccessorIndex.containsKey((Object)this.currentBlock.getSuccessor((int)i).startBci));
            bciToBlockSuccessorIndex.put((Object)this.currentBlock.getSuccessor((int)i).startBci, (Object)new SuccessorInfo(i));
        }
        ArrayList<BciBlockMapping.BciBlock> actualSuccessors = new ArrayList<BciBlockMapping.BciBlock>();
        int[] keys = new int[nofCases];
        int[] keySuccessors = new int[nofCasesPlusDefault];
        int deoptSuccessorIndex = -2;
        int nextSuccessorIndex = 0;
        boolean constantValue = value.isConstant();
        for (int i = 0; i < nofCasesPlusDefault; ++i) {
            if (i < nofCases) {
                keys[i] = bs.keyAt(i);
            }
            if (!constantValue && this.isNeverExecutedCode(keyProbabilities[i])) {
                deoptSuccessorIndex = -1;
                keySuccessors[i] = -1;
                continue;
            }
            int targetBci = i < nofCases ? bs.targetAt(i) : bs.defaultTarget();
            SuccessorInfo info = (SuccessorInfo)bciToBlockSuccessorIndex.get((Object)targetBci);
            if (info.actualIndex < 0) {
                info.actualIndex = nextSuccessorIndex++;
                actualSuccessors.add(this.currentBlock.getSuccessor(info.blockIndex));
            }
            keySuccessors[i] = info.actualIndex;
        }
        if (deoptSuccessorIndex == -1) {
            int i;
            int[] connectedCases = new int[nextSuccessorIndex + 1];
            for (i = 0; i < nofCasesPlusDefault; ++i) {
                int n = keySuccessors[i] + 1;
                connectedCases[n] = connectedCases[n] + 1;
            }
            for (i = 0; i < nofCasesPlusDefault; ++i) {
                if (keySuccessors[i] != -1) continue;
                int targetBci = i < nofCases ? bs.targetAt(i) : bs.defaultTarget();
                SuccessorInfo info = (SuccessorInfo)bciToBlockSuccessorIndex.get((Object)targetBci);
                int rewiredIndex = info.actualIndex;
                if (rewiredIndex >= 0 && connectedCases[rewiredIndex + 1] > 1) {
                    keySuccessors[i] = info.actualIndex;
                    continue;
                }
                if (deoptSuccessorIndex == -1) {
                    deoptSuccessorIndex = nextSuccessorIndex++;
                    actualSuccessors.add(null);
                }
                keySuccessors[i] = deoptSuccessorIndex;
            }
        }
        ProfileData.ProfileSource profileSource = this.getSwitchProfileSource(bci);
        this.genIntegerSwitch(value, actualSuccessors, keys, keyProbabilities, keySuccessors, profileSource);
    }

    protected boolean isNeverExecutedCode(double probability) {
        return probability == 0.0 && this.optimisticOpts.removeNeverExecutedCode(this.getOptions());
    }

    private double clampProbability(double probability) {
        if (!this.optimisticOpts.removeNeverExecutedCode(this.getOptions())) {
            if (probability == 0.0) {
                return 1.0000000000287557E-6;
            }
            if (probability == 1.0) {
                return 0.999999;
            }
        }
        return probability;
    }

    private boolean assertAtIfBytecode() {
        int bytecode = this.stream.currentBC();
        switch (bytecode) {
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 198: 
            case 199: {
                return true;
            }
        }
        assert (false) : String.format("%x is not an if bytecode", bytecode);
        return true;
    }

    public final void processBytecode(int bci, int opcode) {
        switch (opcode) {
            case 0: {
                break;
            }
            case 1: {
                this.frameState.push(JavaKind.Object, this.appendConstant(JavaConstant.NULL_POINTER));
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                this.frameState.push(JavaKind.Int, this.appendConstant((JavaConstant)JavaConstant.forInt((int)(opcode - 3))));
                break;
            }
            case 9: 
            case 10: {
                this.frameState.push(JavaKind.Long, this.appendConstant((JavaConstant)JavaConstant.forLong((long)(opcode - 9))));
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                this.frameState.push(JavaKind.Float, this.appendConstant((JavaConstant)JavaConstant.forFloat((float)(opcode - 11))));
                break;
            }
            case 14: 
            case 15: {
                this.frameState.push(JavaKind.Double, this.appendConstant((JavaConstant)JavaConstant.forDouble((double)(opcode - 14))));
                break;
            }
            case 16: {
                this.frameState.push(JavaKind.Int, this.appendConstant((JavaConstant)JavaConstant.forInt((int)this.stream.readByte())));
                break;
            }
            case 17: {
                this.frameState.push(JavaKind.Int, this.appendConstant((JavaConstant)JavaConstant.forInt((int)this.stream.readShort())));
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                this.genLoadConstant(this.stream.readCPI(), opcode);
                break;
            }
            case 21: {
                this.loadLocal(this.stream.readLocalIndex(), JavaKind.Int);
                break;
            }
            case 22: {
                this.loadLocal(this.stream.readLocalIndex(), JavaKind.Long);
                break;
            }
            case 23: {
                this.loadLocal(this.stream.readLocalIndex(), JavaKind.Float);
                break;
            }
            case 24: {
                this.loadLocal(this.stream.readLocalIndex(), JavaKind.Double);
                break;
            }
            case 25: {
                this.loadLocalObject(this.stream.readLocalIndex());
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                this.loadLocal(opcode - 26, JavaKind.Int);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                this.loadLocal(opcode - 30, JavaKind.Long);
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                this.loadLocal(opcode - 34, JavaKind.Float);
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                this.loadLocal(opcode - 38, JavaKind.Double);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.loadLocalObject(opcode - 42);
                break;
            }
            case 46: {
                this.genLoadIndexed(JavaKind.Int);
                break;
            }
            case 47: {
                this.genLoadIndexed(JavaKind.Long);
                break;
            }
            case 48: {
                this.genLoadIndexed(JavaKind.Float);
                break;
            }
            case 49: {
                this.genLoadIndexed(JavaKind.Double);
                break;
            }
            case 50: {
                this.genLoadIndexed(JavaKind.Object);
                break;
            }
            case 51: {
                this.genLoadIndexed(JavaKind.Byte);
                break;
            }
            case 52: {
                this.genLoadIndexed(JavaKind.Char);
                break;
            }
            case 53: {
                this.genLoadIndexed(JavaKind.Short);
                break;
            }
            case 54: {
                this.storeLocal(JavaKind.Int, this.stream.readLocalIndex());
                break;
            }
            case 55: {
                this.storeLocal(JavaKind.Long, this.stream.readLocalIndex());
                break;
            }
            case 56: {
                this.storeLocal(JavaKind.Float, this.stream.readLocalIndex());
                break;
            }
            case 57: {
                this.storeLocal(JavaKind.Double, this.stream.readLocalIndex());
                break;
            }
            case 58: {
                this.storeLocal(JavaKind.Object, this.stream.readLocalIndex());
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                this.storeLocal(JavaKind.Int, opcode - 59);
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                this.storeLocal(JavaKind.Long, opcode - 63);
                break;
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: {
                this.storeLocal(JavaKind.Float, opcode - 67);
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                this.storeLocal(JavaKind.Double, opcode - 71);
                break;
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                this.storeLocal(JavaKind.Object, opcode - 75);
                break;
            }
            case 79: {
                this.genStoreIndexed(JavaKind.Int);
                break;
            }
            case 80: {
                this.genStoreIndexed(JavaKind.Long);
                break;
            }
            case 81: {
                this.genStoreIndexed(JavaKind.Float);
                break;
            }
            case 82: {
                this.genStoreIndexed(JavaKind.Double);
                break;
            }
            case 83: {
                this.genStoreIndexed(JavaKind.Object);
                break;
            }
            case 84: {
                this.genStoreIndexed(JavaKind.Byte);
                break;
            }
            case 85: {
                this.genStoreIndexed(JavaKind.Char);
                break;
            }
            case 86: {
                this.genStoreIndexed(JavaKind.Short);
                break;
            }
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                this.frameState.stackOp(opcode);
                break;
            }
            case 96: 
            case 100: 
            case 104: {
                this.genArithmeticOp(JavaKind.Int, opcode);
                break;
            }
            case 108: 
            case 112: {
                this.genIntegerDivOp(JavaKind.Int, opcode);
                break;
            }
            case 97: 
            case 101: 
            case 105: {
                this.genArithmeticOp(JavaKind.Long, opcode);
                break;
            }
            case 109: 
            case 113: {
                this.genIntegerDivOp(JavaKind.Long, opcode);
                break;
            }
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                this.genArithmeticOp(JavaKind.Float, opcode);
                break;
            }
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                this.genArithmeticOp(JavaKind.Double, opcode);
                break;
            }
            case 116: {
                this.genNegateOp(JavaKind.Int);
                break;
            }
            case 117: {
                this.genNegateOp(JavaKind.Long);
                break;
            }
            case 118: {
                this.genNegateOp(JavaKind.Float);
                break;
            }
            case 119: {
                this.genNegateOp(JavaKind.Double);
                break;
            }
            case 120: 
            case 122: 
            case 124: {
                this.genShiftOp(JavaKind.Int, opcode);
                break;
            }
            case 126: 
            case 128: 
            case 130: {
                this.genLogicOp(JavaKind.Int, opcode);
                break;
            }
            case 121: 
            case 123: 
            case 125: {
                this.genShiftOp(JavaKind.Long, opcode);
                break;
            }
            case 127: 
            case 129: 
            case 131: {
                this.genLogicOp(JavaKind.Long, opcode);
                break;
            }
            case 132: {
                this.genIncrement();
                break;
            }
            case 134: {
                this.genFloatConvert(FloatConvert.I2F, JavaKind.Int, JavaKind.Float);
                break;
            }
            case 135: {
                this.genFloatConvert(FloatConvert.I2D, JavaKind.Int, JavaKind.Double);
                break;
            }
            case 137: {
                this.genFloatConvert(FloatConvert.L2F, JavaKind.Long, JavaKind.Float);
                break;
            }
            case 138: {
                this.genFloatConvert(FloatConvert.L2D, JavaKind.Long, JavaKind.Double);
                break;
            }
            case 139: {
                this.genFloatConvert(FloatConvert.F2I, JavaKind.Float, JavaKind.Int);
                break;
            }
            case 140: {
                this.genFloatConvert(FloatConvert.F2L, JavaKind.Float, JavaKind.Long);
                break;
            }
            case 141: {
                this.genFloatConvert(FloatConvert.F2D, JavaKind.Float, JavaKind.Double);
                break;
            }
            case 142: {
                this.genFloatConvert(FloatConvert.D2I, JavaKind.Double, JavaKind.Int);
                break;
            }
            case 143: {
                this.genFloatConvert(FloatConvert.D2L, JavaKind.Double, JavaKind.Long);
                break;
            }
            case 144: {
                this.genFloatConvert(FloatConvert.D2F, JavaKind.Double, JavaKind.Float);
                break;
            }
            case 136: {
                this.genNarrow(JavaKind.Long, JavaKind.Int);
                break;
            }
            case 133: {
                this.genSignExtend(JavaKind.Int, JavaKind.Long);
                break;
            }
            case 145: {
                this.genSignExtend(JavaKind.Byte, JavaKind.Int);
                break;
            }
            case 147: {
                this.genSignExtend(JavaKind.Short, JavaKind.Int);
                break;
            }
            case 146: {
                this.genZeroExtend(JavaKind.Char, JavaKind.Int);
                break;
            }
            case 148: {
                this.genIntegerCompareOp(JavaKind.Long);
                break;
            }
            case 149: {
                this.genFloatCompareOp(JavaKind.Float, true);
                break;
            }
            case 150: {
                this.genFloatCompareOp(JavaKind.Float, false);
                break;
            }
            case 151: {
                this.genFloatCompareOp(JavaKind.Double, true);
                break;
            }
            case 152: {
                this.genFloatCompareOp(JavaKind.Double, false);
                break;
            }
            case 153: {
                this.genIfZero(Condition.EQ);
                break;
            }
            case 154: {
                this.genIfZero(Condition.NE);
                break;
            }
            case 155: {
                this.genIfZero(Condition.LT);
                break;
            }
            case 156: {
                this.genIfZero(Condition.GE);
                break;
            }
            case 157: {
                this.genIfZero(Condition.GT);
                break;
            }
            case 158: {
                this.genIfZero(Condition.LE);
                break;
            }
            case 159: {
                this.genIfSame(JavaKind.Int, Condition.EQ);
                break;
            }
            case 160: {
                this.genIfSame(JavaKind.Int, Condition.NE);
                break;
            }
            case 161: {
                this.genIfSame(JavaKind.Int, Condition.LT);
                break;
            }
            case 162: {
                this.genIfSame(JavaKind.Int, Condition.GE);
                break;
            }
            case 163: {
                this.genIfSame(JavaKind.Int, Condition.GT);
                break;
            }
            case 164: {
                this.genIfSame(JavaKind.Int, Condition.LE);
                break;
            }
            case 165: {
                this.genIfSame(JavaKind.Object, Condition.EQ);
                break;
            }
            case 166: {
                this.genIfSame(JavaKind.Object, Condition.NE);
                break;
            }
            case 167: {
                this.genGoto();
                break;
            }
            case 168: {
                this.genJsr(this.stream.readBranchDest());
                break;
            }
            case 169: {
                this.genRet(this.stream.readLocalIndex());
                break;
            }
            case 170: {
                this.genSwitch(new BytecodeTableSwitch(this.getStream(), this.bci()));
                break;
            }
            case 171: {
                this.genSwitch(new BytecodeLookupSwitch(this.getStream(), this.bci()));
                break;
            }
            case 172: {
                this.genReturn(this.frameState.pop(JavaKind.Int), JavaKind.Int);
                break;
            }
            case 173: {
                this.genReturn(this.frameState.pop(JavaKind.Long), JavaKind.Long);
                break;
            }
            case 174: {
                this.genReturn(this.frameState.pop(JavaKind.Float), JavaKind.Float);
                break;
            }
            case 175: {
                this.genReturn(this.frameState.pop(JavaKind.Double), JavaKind.Double);
                break;
            }
            case 176: {
                this.genReturn(this.frameState.pop(JavaKind.Object), JavaKind.Object);
                break;
            }
            case 177: {
                this.genReturn(null, JavaKind.Void);
                break;
            }
            case 178: {
                char cpi = this.stream.readCPI();
                this.genGetStatic(cpi, opcode);
                break;
            }
            case 179: {
                char cpi = this.stream.readCPI();
                this.genPutStatic(cpi, opcode);
                break;
            }
            case 180: {
                char cpi = this.stream.readCPI();
                this.genGetField(cpi, opcode);
                break;
            }
            case 181: {
                char cpi = this.stream.readCPI();
                this.genPutField(cpi, opcode);
                break;
            }
            case 182: {
                char cpi = this.stream.readCPI();
                this.genInvokeVirtual(cpi, opcode);
                break;
            }
            case 183: {
                char cpi = this.stream.readCPI();
                this.genInvokeSpecial(cpi, opcode);
                break;
            }
            case 184: {
                char cpi = this.stream.readCPI();
                this.genInvokeStatic(cpi, opcode);
                break;
            }
            case 185: {
                char cpi = this.stream.readCPI();
                this.genInvokeInterface(cpi, opcode);
                break;
            }
            case 186: {
                int cpi = this.stream.readCPI4();
                this.genInvokeDynamic(cpi, opcode);
                break;
            }
            case 187: {
                this.genNewInstance(this.stream.readCPI());
                break;
            }
            case 188: {
                this.genNewPrimitiveArray(this.stream.readLocalIndex());
                break;
            }
            case 189: {
                this.genNewObjectArray(this.stream.readCPI());
                break;
            }
            case 190: {
                this.genArrayLength();
                break;
            }
            case 191: {
                this.genThrow();
                break;
            }
            case 192: {
                this.genCheckCast(this.stream.readCPI());
                break;
            }
            case 193: {
                this.genInstanceOf(this.stream.readCPI());
                break;
            }
            case 194: {
                this.genMonitorEnter(this.frameState.pop(JavaKind.Object), this.stream.nextBCI());
                break;
            }
            case 195: {
                this.genMonitorExit(this.frameState.pop(JavaKind.Object), null, this.stream.nextBCI());
                break;
            }
            case 197: {
                this.genNewMultiArray(this.stream.readCPI());
                break;
            }
            case 198: {
                this.genIfNull(Condition.EQ);
                break;
            }
            case 199: {
                this.genIfNull(Condition.NE);
                break;
            }
            case 200: {
                this.genGoto();
                break;
            }
            case 201: {
                this.genJsr(this.stream.readBranchDest());
                break;
            }
            case 202: {
                throw new PermanentBailoutException("concurrent setting of breakpoint");
            }
            default: {
                throw new PermanentBailoutException("Unsupported opcode %d (%s) [bci=%d]", opcode, Bytecodes.nameOf(opcode), bci);
            }
        }
    }

    private void genArrayLength() {
        ValueNode array = this.frameState.pop(JavaKind.Object);
        this.frameState.push(JavaKind.Int, this.append(this.genArrayLength(array)));
    }

    @Override
    public ResolvedJavaMethod getMethod() {
        return this.method;
    }

    @Override
    public Bytecode getCode() {
        return this.code;
    }

    public FrameStateBuilder getFrameStateBuilder() {
        return this.frameState;
    }

    protected void traceInstruction(int bci, int opcode, boolean blockStart) {
        String indent = new String(new char[this.getDepth() * 2]).replace('\u0000', ' ');
        StringBuilder sb = new StringBuilder(40);
        String nl = System.lineSeparator();
        if (!this.firstTraceEmitted) {
            sb.append(indent).append(this.method.format("Parsing %H.%n(%p)%r")).append(nl);
            if (this.traceLevel >= 3) {
                sb.append(indent).append("Blocks:").append(nl);
                String bm = this.blockMap.toString().replace(nl, nl + indent + "  ");
                sb.append(indent).append("  ").append(bm).append(nl);
            }
            this.firstTraceEmitted = true;
        }
        if (this.traceLevel >= 2) {
            sb.append(indent).append(this.frameState).append(nl);
        }
        sb.append(indent);
        sb.append(blockStart ? (char)'+' : '|');
        if (bci < 10) {
            sb.append("  ");
        } else if (bci < 100) {
            sb.append(' ');
        }
        sb.append(bci).append(": ").append(Bytecodes.nameOf(opcode));
        for (int i = bci + 1; i < this.stream.nextBCI(); ++i) {
            sb.append(' ').append(this.stream.readUByte(i));
        }
        if (!this.currentBlock.getJsrScope().isEmpty()) {
            sb.append(' ').append(this.currentBlock.getJsrScope());
        }
        TTY.println("%s", sb);
    }

    @Override
    public boolean parsingIntrinsic() {
        return this.intrinsicContext != null;
    }

    @Override
    public BytecodeParser getNonIntrinsicAncestor() {
        BytecodeParser ancestor = this.parent;
        while (ancestor != null && ancestor.parsingIntrinsic()) {
            ancestor = ancestor.parent;
        }
        return ancestor;
    }

    static String nSpaces(int n) {
        return n == 0 ? "" : String.format("%" + n + "s", "");
    }

    static class SuccessorInfo {
        final int blockIndex;
        int actualIndex;

        SuccessorInfo(int blockSuccessorIndex) {
            this.blockIndex = blockSuccessorIndex;
            this.actualIndex = -1;
        }
    }

    class InvocationPluginAssertions {
        final InvocationPlugin plugin;
        final ValueNode[] args;
        final ResolvedJavaMethod targetMethod;
        final JavaKind resultType;
        final int beforeStackSize;
        final boolean needsNullCheck;
        final int nodeCount;
        final Graph.Mark mark;

        InvocationPluginAssertions(InvocationPlugin plugin, ValueNode[] args, ResolvedJavaMethod targetMethod, JavaKind resultType) {
            GraalError.guarantee(Assertions.assertionsEnabled(), "%s should only be loaded and instantiated if assertions are enabled", (Object)this.getClass().getSimpleName());
            this.plugin = plugin;
            this.targetMethod = targetMethod;
            this.args = args;
            this.resultType = resultType;
            this.beforeStackSize = BytecodeParser.this.frameState.stackSize();
            this.needsNullCheck = !targetMethod.isStatic() && args[0].getStackKind() == JavaKind.Object && !StampTool.isPointerNonNull(args[0].stamp(NodeView.DEFAULT));
            this.nodeCount = BytecodeParser.this.graph.getNodeCount();
            this.mark = BytecodeParser.this.graph.getMark();
        }

        String error(String format, Object ... a) {
            return String.format(format, a) + String.format("%n\tplugin at %s", this.plugin.getApplySourceLocation(BytecodeParser.this.getMetaAccess()));
        }

        boolean check(boolean pluginResult) {
            if (pluginResult) {
                int expectedStackSize = this.beforeStackSize + this.resultType.getSlotCount();
                assert (BytecodeParser.this.lastInstr == null || expectedStackSize == BytecodeParser.this.frameState.stackSize()) : this.error("plugin manipulated the stack incorrectly: expected=%d, actual=%d", expectedStackSize, BytecodeParser.this.frameState.stackSize());
                NodeIterable<Node> newNodes = BytecodeParser.this.graph.getNewNodes(this.mark);
                assert (!this.needsNullCheck || StampTool.isPointerNonNull(this.args[0].stamp(NodeView.DEFAULT))) : this.error("plugin needs to null check the receiver of %s: receiver=%s", this.targetMethod.format("%H.%n(%p)"), this.args[0]);
                for (Node n : newNodes) {
                    if (!(n instanceof StateSplit)) continue;
                    StateSplit stateSplit = (StateSplit)((Object)n);
                    assert (stateSplit.stateAfter() != null || !stateSplit.hasSideEffect()) : this.error("%s node added by plugin for %s need to have a non-null frame state: %s", StateSplit.class.getSimpleName(), this.targetMethod.format("%H.%n(%p)"), stateSplit);
                }
                try {
                    BytecodeParser.this.graphBuilderConfig.getPlugins().getInvocationPlugins().checkNewNodes(BytecodeParser.this, this.plugin, newNodes);
                }
                catch (Throwable t) {
                    throw new AssertionError(this.error("Error in plugin", new Object[0]), t);
                }
            } else {
                assert (this.nodeCount == BytecodeParser.this.graph.getNodeCount()) : this.error("plugin that returns false must not create new nodes", new Object[0]);
                assert (this.beforeStackSize == BytecodeParser.this.frameState.stackSize()) : this.error("plugin that returns false must not modify the stack", new Object[0]);
            }
            return true;
        }
    }

    protected static enum ExceptionEdgeAction {
        OMIT,
        INCLUDE_AND_HANDLE,
        INCLUDE_AND_DEOPTIMIZE;

    }

    static class CurrentInvoke {
        final ValueNode[] args;
        final CallTargetNode.InvokeKind kind;
        final JavaType returnType;

        CurrentInvoke(ValueNode[] args, CallTargetNode.InvokeKind kind, JavaType returnType) {
            this.args = args;
            this.kind = kind;
            this.returnType = returnType;
        }
    }

    protected static class ReturnToCallerData {
        protected final ValueNode returnValue;
        protected final FixedWithNextNode beforeReturnNode;

        protected ReturnToCallerData(ValueNode returnValue, FixedWithNextNode beforeReturnNode) {
            this.returnValue = returnValue;
            this.beforeReturnNode = beforeReturnNode;
        }

        static boolean containsReturnValue(List<ReturnToCallerData> list, ValueNode value) {
            for (ReturnToCallerData e : list) {
                if (e.returnValue != value) continue;
                return true;
            }
            return false;
        }
    }

    public static class BytecodeParserError
    extends GraalError {
        public BytecodeParserError(Throwable cause) {
            super(cause);
        }

        public BytecodeParserError(String msg, Object ... args) {
            super(msg, args);
        }
    }

    private static class Target {
        final FixedNode entry;
        final FixedNode originalEntry;
        final FrameStateBuilder state;

        Target(FixedNode entry, FrameStateBuilder state) {
            this.entry = entry;
            this.state = state;
            this.originalEntry = null;
        }

        Target(FixedNode entry, FrameStateBuilder state, FixedNode originalEntry) {
            this.entry = entry;
            this.state = state;
            this.originalEntry = originalEntry;
        }
    }

    static class IntrinsicScope
    extends InliningScope {
        ArrayList<StateSplit> invalidStateUsers;

        IntrinsicScope(BytecodeParser parser) {
            super(parser);
        }

        IntrinsicScope(BytecodeParser parser, ResolvedJavaMethod callee, ValueNode[] args) {
            super(parser, callee, args);
        }

        @Override
        public void close() {
            boolean inlinedIntrinsic;
            boolean isRootCompilation;
            IntrinsicContext intrinsic = this.parser.intrinsicContext;
            if (intrinsic != null) {
                if (intrinsic.isPostParseInlined()) {
                    return;
                }
                isRootCompilation = intrinsic.isCompilationRoot();
            } else {
                isRootCompilation = false;
            }
            this.processPlaceholderFrameStates(isRootCompilation);
            if (this.invalidStateUsers != null) {
                JavaKind returnKind = this.parser.getInvokeReturnType().getJavaKind();
                ValueNode returnValue = this.parser.frameState.pop(returnKind);
                if (this.invalidStateUsers.size() == 1 && this.invalidStateUsers.get(0) == this.parser.lastInstr) {
                    this.updateSplitFrameState(this.invalidStateUsers.get(0), returnKind, returnValue);
                } else if (this.parser.lastInstr instanceof MergeNode) {
                    ValuePhiNode returnValues = null;
                    MergeNode merge = (MergeNode)this.parser.lastInstr;
                    if (returnValue instanceof ValuePhiNode && ((ValuePhiNode)returnValue).merge() == this.parser.lastInstr) {
                        returnValues = (ValuePhiNode)returnValue;
                    }
                    if (this.invalidStateUsers.remove(merge)) {
                        this.updateSplitFrameState(merge, returnKind, returnValue);
                    }
                    for (EndNode pred : merge.cfgPredecessors()) {
                        Node lastPred = pred.predecessor();
                        if (!this.invalidStateUsers.remove(lastPred)) continue;
                        ValueNode predReturnValue = returnValue;
                        if (returnValues != null) {
                            int index = merge.phiPredecessorIndex(pred);
                            predReturnValue = ((ValuePhiNode)returnValue).valueAt(index);
                        }
                        this.updateSplitFrameState((StateSplit)((Object)lastPred), returnKind, predReturnValue);
                    }
                    if (this.invalidStateUsers.size() != 0) {
                        throw new GraalError("unexpected StateSplit above merge %s", this.invalidStateUsers);
                    }
                } else {
                    throw new GraalError("unexpected node between return StateSplit and last instruction %s", this.parser.lastInstr);
                }
                this.parser.frameState.push(returnKind, returnValue);
            }
            boolean bl = inlinedIntrinsic = this.parser.getInvokeReturnType() != null;
            if (inlinedIntrinsic) {
                for (Node n : this.parser.graph.getNewNodes(this.mark)) {
                    if (!(n instanceof FrameState)) continue;
                    GraalError.guarantee(((FrameState)n).bci != -6, "Inlined call to intrinsic (callee %s) produced invalid framestate %s. Such framestates must never be used as deoptimizing targets, thus they cannot be part of a high-tier graph, and must only be used after framestate assignment. A common error is invalid usage of foreign call nodes in method substitutions, which can be avoided by ensuring such calls are either replaced with nodes that are snippet lowered after framestate assignment (see FastNotifyNode.java for example) or by ensuring all foreign use the state after of the original call instruction.", (Object)this.callee, (Object)n);
                }
            } else assert (intrinsic == null || intrinsic.isIntrinsicEncoding() || this.verifyIntrinsicRootCompileEffects());
        }

        private boolean verifyIntrinsicRootCompileEffects() {
            int invalidBCIsInRootCompiledIntrinsic = 0;
            for (Node n : this.parser.graph.getNewNodes(this.mark)) {
                if (!(n instanceof FrameState) || ((FrameState)n).bci != -6) continue;
                ++invalidBCIsInRootCompiledIntrinsic;
            }
            if (invalidBCIsInRootCompiledIntrinsic > 1) {
                int invalidBCIsToFind = invalidBCIsInRootCompiledIntrinsic;
                List<ReturnNode> returns = this.parser.getGraph().getNodes(ReturnNode.TYPE).snapshot();
                if (returns.size() > 1) {
                    block1: for (ReturnNode ret : returns) {
                        for (FixedNode f : GraphUtil.predecessorIterable(ret)) {
                            StateSplit split;
                            if (!(f instanceof StateSplit) || !(split = (StateSplit)((Object)f)).hasSideEffect()) continue;
                            assert (((StateSplit)((Object)f)).stateAfter() != null);
                            if (split.stateAfter().bci != -6) continue;
                            --invalidBCIsToFind;
                            continue block1;
                        }
                    }
                    GraalError.guarantee(invalidBCIsToFind == 0, "Root compiled intrinsic with invalid states has more than one return. This is allowed, however one path down a sink has more than one state, this is prohibited. Intrinsic %s", (Object)this.parser.method);
                    return true;
                }
                ReturnNode ret = returns.get(0);
                MergeNode merge = null;
                int mergeCount = this.parser.graph.getNodes(MergeNode.TYPE).count();
                if (mergeCount != 1) {
                    throw new GraalError("Root compiled intrinsic with invalid states %s:Must have exactly one merge node. %d found", this.parser.method, mergeCount);
                }
                if (ret.predecessor() instanceof MergeNode) {
                    merge = (MergeNode)ret.predecessor();
                }
                if (merge == null) {
                    throw new GraalError("Root compiled intrinsic with invalid state: Unexpected node between return and merge.");
                }
                GraalError.guarantee(invalidBCIsInRootCompiledIntrinsic <= merge.phiPredecessorCount() + 1, "Root compiled intrinsic with invalid states %s must at maximum produce (0,1 or if the last instruction is a merge |merge.predCount| invalid BCI state, however %d where found.", (Object)this.parser.method, (Object)invalidBCIsInRootCompiledIntrinsic);
                if (merge.stateAfter() != null && merge.stateAfter().bci == -6) {
                    --invalidBCIsToFind;
                }
                for (EndNode pred : merge.cfgPredecessors()) {
                    Node lastPred = pred.predecessor();
                    for (FixedNode f : GraphUtil.predecessorIterable((FixedNode)lastPred)) {
                        StateSplit split;
                        if (!(f instanceof StateSplit) || !(split = (StateSplit)((Object)f)).hasSideEffect()) continue;
                        assert (((StateSplit)((Object)f)).stateAfter() != null);
                        if (split.stateAfter().bci != -6) continue;
                        --invalidBCIsToFind;
                    }
                }
                if (invalidBCIsToFind != 0) {
                    throw new GraalError("Invalid BCI state missmatch: This root compiled method substitution %s uses invalid side-effecting nodes resulting in invalid deoptimization information. Method substitutions must never have more than one state (the after state) for deoptimization. Multiple states are only allowed if they are dominated by a control-flow split, there is only a single effect per branch and a post dominating merge with the same invalid_bci state (that must only be different in its return value).", this.parser.method);
                }
            }
            return true;
        }

        private void updateSplitFrameState(StateSplit split, JavaKind returnKind, ValueNode returnValue) {
            this.parser.frameState.push(returnKind, returnValue);
            FrameState oldState = split.stateAfter();
            split.setStateAfter(this.parser.createFrameState(this.parser.stream.nextBCI(), split));
            this.parser.frameState.pop(returnKind);
            if (oldState.hasNoUsages()) {
                oldState.safeDelete();
            }
        }

        @Override
        protected void handleReturnMismatch(StructuredGraph g, FrameState fs) {
            if (this.invalidStateUsers == null) {
                this.invalidStateUsers = new ArrayList();
            }
            for (Node use : fs.usages()) {
                if (!(use instanceof StateSplit)) {
                    throw new GraalError("Expected StateSplit for return mismatch");
                }
                this.invalidStateUsers.add((StateSplit)((Object)use));
            }
        }
    }

    static class InliningScope
    implements AutoCloseable {
        final ResolvedJavaMethod callee;
        FrameState stateBefore;
        final Graph.Mark mark;
        final BytecodeParser parser;
        List<ReturnToCallerData> returnDataList;

        InliningScope(BytecodeParser parser) {
            this.parser = parser;
            assert (parser.parent == null);
            assert (parser.bci() == 0);
            this.mark = null;
            this.callee = null;
        }

        InliningScope(BytecodeParser parser, ResolvedJavaMethod callee, ValueNode[] args) {
            this.callee = callee;
            assert (!parser.parsingIntrinsic());
            this.parser = parser;
            this.mark = parser.getGraph().getMark();
            JavaKind[] argSlotKinds = callee.getSignature().toParameterKinds(!callee.isStatic());
            this.stateBefore = parser.frameState.create(parser.bci(), parser.getNonIntrinsicAncestor(), false, argSlotKinds, args);
        }

        @Override
        public void close() {
            this.processPlaceholderFrameStates(false);
        }

        protected void processPlaceholderFrameStates(boolean isCompilationRoot) {
            StructuredGraph graph = this.parser.getGraph();
            graph.getDebug().dump(4, (Object)graph, "Before processPlaceholderFrameStates in %s", this.parser.method);
            for (FrameState frameState : graph.getNewNodes(this.mark).filter(FrameState.class)) {
                if (!BytecodeFrame.isPlaceholderBci((int)frameState.bci)) continue;
                if (frameState.bci == -3) {
                    if (this.parser.getInvokeReturnType() == null) {
                        assert (isCompilationRoot);
                        FrameState newFrameState = graph.add(new FrameState(-6));
                        frameState.replaceAndDelete(newFrameState);
                        continue;
                    }
                    JavaKind returnKind = this.parser.getInvokeReturnType().getJavaKind();
                    FrameStateBuilder frameStateBuilder = this.parser.frameState;
                    assert (!frameState.rethrowException());
                    if (frameState.stackSize() != 0) {
                        ValueNode returnVal = frameState.stackAt(0);
                        if (!ReturnToCallerData.containsReturnValue(this.returnDataList, returnVal)) {
                            throw new GraalError("AFTER_BCI frame state within a sub-parse has a non-return value on the stack: %s", returnVal);
                        }
                        ValueNode tos = frameStateBuilder.pop(returnKind);
                        assert (tos.getStackKind() == returnVal.getStackKind());
                        FrameState newFrameState = frameStateBuilder.create(this.parser.stream.nextBCI(), this.parser.getNonIntrinsicAncestor(), false, new JavaKind[]{returnKind}, new ValueNode[]{returnVal});
                        frameState.replaceAndDelete(newFrameState);
                        newFrameState.setNodeSourcePosition(frameState.getNodeSourcePosition());
                        frameStateBuilder.push(returnKind, tos);
                        continue;
                    }
                    if (returnKind != JavaKind.Void) {
                        this.handleReturnMismatch(graph, frameState);
                        continue;
                    }
                    FrameState newFrameState = frameStateBuilder.create(this.parser.stream.nextBCI(), (StateSplit)null);
                    newFrameState.setNodeSourcePosition(frameState.getNodeSourcePosition());
                    frameState.replaceAndDelete(newFrameState);
                    continue;
                }
                if (frameState.bci == -2) {
                    if (this.stateBefore == null) {
                        this.stateBefore = graph.start().stateAfter();
                    }
                    if (this.stateBefore == frameState) continue;
                    frameState.replaceAndDelete(this.stateBefore);
                    continue;
                }
                if (frameState.bci == -4 || frameState.bci == -1 && !this.callee.isSynchronized()) {
                    assert (frameState.rethrowException());
                    ValueNode exceptionValue = frameState.stackAt(0);
                    ExceptionObjectNode exceptionNode = (ExceptionObjectNode)GraphUtil.unproxify(exceptionValue);
                    FrameStateBuilder dispatchState = this.parser.frameState.copy();
                    dispatchState.clearStack();
                    dispatchState.push(JavaKind.Object, exceptionValue);
                    dispatchState.setRethrowException(true);
                    if (frameState.hasExactlyOneUsage()) {
                        FrameState newFrameState = dispatchState.create(this.parser.bci(), exceptionNode);
                        newFrameState.setNodeSourcePosition(frameState.getNodeSourcePosition());
                        frameState.replaceAndDelete(newFrameState);
                    } else {
                        for (Node usage : frameState.usages().snapshot()) {
                            FrameState newFrameState = dispatchState.create(this.parser.bci(), (StateSplit)((Object)usage));
                            newFrameState.setNodeSourcePosition(frameState.getNodeSourcePosition());
                            usage.replaceAllInputs(frameState, newFrameState);
                        }
                        frameState.safeDelete();
                    }
                    this.parser.processInstruction(exceptionNode, dispatchState);
                    continue;
                }
                if (frameState.bci == -1) {
                    if (!graph.getGuardsStage().allowsFloatingGuards()) continue;
                    throw GraalError.shouldNotReachHere("Cannot handle this UNWIND_BCI");
                }
                assert (frameState.bci == -6) : frameState.bci;
            }
            graph.getDebug().dump(4, (Object)graph, "After processPlaceholderFrameStates in %s", this.parser.method);
        }

        protected void handleReturnMismatch(StructuredGraph g, FrameState fs) {
            throw GraalError.shouldNotReachHere("Unexpected return kind mismatch in " + this.parser.method + " at FS " + fs);
        }
    }
}

