/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.stubs;

import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.DeoptimizeWithExceptionInCallerNode;
import org.graalvm.compiler.hotspot.nodes.StubForeignCallNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.stubs.SnippetStub;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.nodes.CStringConstant;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

public class CreateExceptionStub
extends SnippetStub {
    private static final HotSpotForeignCallDescriptor THROW_AND_POST_JVMTI_EXCEPTION = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, LocationIdentity.any(), "throw_and_post_jvmti_exception", Integer.TYPE, Word.class, Word.class, Word.class);
    private static final HotSpotForeignCallDescriptor THROW_KLASS_EXTERNAL_NAME_EXCEPTION = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, LocationIdentity.any(), "throw_klass_external_name_exception", Integer.TYPE, Word.class, Word.class, KlassPointer.class);
    private static final HotSpotForeignCallDescriptor THROW_CLASS_CAST_EXCEPTION = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, LocationIdentity.any(), "throw_class_cast_exception", Integer.TYPE, Word.class, Word.class, KlassPointer.class, KlassPointer.class);

    protected CreateExceptionStub(String snippetMethodName, OptionValues options, HotSpotProviders providers, HotSpotForeignCallLinkage linkage) {
        super(snippetMethodName, options, providers, linkage);
    }

    @Fold
    static boolean reportsDeoptimization(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.deoptBlobUnpackWithExceptionInTLS != 0L;
    }

    @Fold
    static boolean alwayDeoptimize(@Fold.InjectedParameter OptionValues options) {
        return Options.HotSpotDeoptExplicitExceptions.getValue(options);
    }

    @Fold
    static String getInternalClassName(Class<?> cls) {
        return cls.getName().replace('.', '/');
    }

    private static Word classAsCString(Class<?> cls) {
        return CStringConstant.cstring(CreateExceptionStub.getInternalClassName(cls));
    }

    protected static Object createException(Register threadRegister, Class<? extends Throwable> exception) {
        Word message = (Word)WordFactory.zero();
        return CreateExceptionStub.createException(threadRegister, exception, message);
    }

    protected static Object createException(Register threadRegister, Class<? extends Throwable> exception, Word message) {
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        int deoptimized = CreateExceptionStub.throwAndPostJvmtiException(THROW_AND_POST_JVMTI_EXCEPTION, thread, CreateExceptionStub.classAsCString(exception), message);
        return CreateExceptionStub.handleExceptionReturn(thread, deoptimized);
    }

    protected static Object createException(Register threadRegister, Class<? extends Throwable> exception, KlassPointer klass) {
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        int deoptimized = CreateExceptionStub.throwKlassExternalNameException(THROW_KLASS_EXTERNAL_NAME_EXCEPTION, thread, CreateExceptionStub.classAsCString(exception), klass);
        return CreateExceptionStub.handleExceptionReturn(thread, deoptimized);
    }

    protected static Object createException(Register threadRegister, Class<? extends Throwable> exception, KlassPointer objKlass, KlassPointer targetKlass) {
        Word thread = HotSpotReplacementsUtil.registerAsWord(threadRegister);
        int deoptimized = CreateExceptionStub.throwClassCastException(THROW_CLASS_CAST_EXCEPTION, thread, CreateExceptionStub.classAsCString(exception), objKlass, targetKlass);
        return CreateExceptionStub.handleExceptionReturn(thread, deoptimized);
    }

    private static Object handleExceptionReturn(Word thread, int deoptimized) {
        Object clearPendingException = HotSpotReplacementsUtil.clearPendingException(thread);
        if (CreateExceptionStub.alwayDeoptimize(GraalHotSpotVMConfig.INJECTED_OPTIONVALUES) && clearPendingException != null || CreateExceptionStub.reportsDeoptimization(GraalHotSpotVMConfig.INJECTED_VMCONFIG) && deoptimized != 0) {
            DeoptimizeWithExceptionInCallerNode.deopt(clearPendingException);
        }
        return clearPendingException;
    }

    @Node.NodeIntrinsic(value=StubForeignCallNode.class)
    private static native int throwAndPostJvmtiException(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, Word var3);

    @Node.NodeIntrinsic(value=StubForeignCallNode.class)
    private static native int throwKlassExternalNameException(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, KlassPointer var3);

    @Node.NodeIntrinsic(value=StubForeignCallNode.class)
    private static native int throwClassCastException(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, KlassPointer var3, KlassPointer var4);

    public static void registerForeignCalls(GraalHotSpotVMConfig c, HotSpotForeignCallsProviderImpl foreignCalls) {
        foreignCalls.registerForeignCall(THROW_AND_POST_JVMTI_EXCEPTION, c.throwAndPostJvmtiExceptionAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
        foreignCalls.registerForeignCall(THROW_KLASS_EXTERNAL_NAME_EXCEPTION, c.throwKlassExternalNameExceptionAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
        foreignCalls.registerForeignCall(THROW_CLASS_CAST_EXCEPTION, c.throwClassCastExceptionAddress, (CallingConvention.Type)HotSpotCallingConventionType.NativeCall);
    }

    public static class Options {
        @Option(help={"Testing only option that forces deopts for exception throws"}, type=OptionType.Expert)
        public static final OptionKey<Boolean> HotSpotDeoptExplicitExceptions = new OptionKey<Boolean>(false);
    }
}

