/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements.profiling;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.aot.LoadMethodCountersNode;
import org.graalvm.compiler.hotspot.nodes.profiling.ProfileBranchNode;
import org.graalvm.compiler.hotspot.nodes.profiling.ProfileInvokeNode;
import org.graalvm.compiler.hotspot.nodes.profiling.ProfileNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.profiling.ProfileSnippets;
import org.graalvm.compiler.hotspot.word.MethodCountersPointer;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.word.LocationIdentity;

public class ProbabilisticProfileSnippets
implements Snippets {
    @Snippet
    public static boolean shouldProfile(@Snippet.ConstantParameter int probLog, int random) {
        int probabilityMask = (1 << probLog) - 1;
        return (random & probabilityMask) == 0;
    }

    @Snippet
    public static int notificationMask(int freqLog, int probLog, int stepLog) {
        int frequencyMask = (1 << freqLog) - 1;
        int stepMask = (1 << stepLog + probLog) - 1;
        return frequencyMask & ~stepMask;
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void methodInvocationEvent(@Node.ConstantNodeParameter ForeignCallDescriptor var0, MethodCountersPointer var1);

    @Snippet
    public static void profileMethodEntryWithProbability(MethodCountersPointer counters, int random, int step, int stepLog, @Snippet.ConstantParameter int freqLog, @Snippet.ConstantParameter int probLog) {
        if (BranchProbabilityNode.probability(1.0 / (double)(1 << probLog), ProbabilisticProfileSnippets.shouldProfile(probLog, random))) {
            int mask;
            int counterValue = counters.readInt(HotSpotReplacementsUtil.invocationCounterOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), ProfileSnippets.METHOD_COUNTERS) + (HotSpotReplacementsUtil.invocationCounterIncrement(GraalHotSpotVMConfig.INJECTED_VMCONFIG) * step << probLog);
            counters.writeIntSideEffectFree(HotSpotReplacementsUtil.invocationCounterOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), counterValue, ProfileSnippets.METHOD_COUNTERS);
            if (freqLog >= 0 && BranchProbabilityNode.probability(0.010000000000000009, (counterValue & (mask = ProbabilisticProfileSnippets.notificationMask(freqLog, probLog, stepLog)) << HotSpotReplacementsUtil.invocationCounterShift(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) == 0)) {
                ProbabilisticProfileSnippets.methodInvocationEvent(HotSpotBackend.INVOCATION_EVENT, counters);
            }
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void methodBackedgeEvent(@Node.ConstantNodeParameter ForeignCallDescriptor var0, MethodCountersPointer var1, int var2, int var3);

    @Snippet
    public static void profileBackedgeWithProbability(MethodCountersPointer counters, int random, int step, int stepLog, @Snippet.ConstantParameter int freqLog, @Snippet.ConstantParameter int probLog, int bci, int targetBci) {
        if (BranchProbabilityNode.probability(1.0 / (double)(1 << probLog), ProbabilisticProfileSnippets.shouldProfile(probLog, random))) {
            int counterValue = counters.readInt(HotSpotReplacementsUtil.backedgeCounterOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), ProfileSnippets.METHOD_COUNTERS) + (HotSpotReplacementsUtil.invocationCounterIncrement(GraalHotSpotVMConfig.INJECTED_VMCONFIG) * step << probLog);
            counters.writeIntSideEffectFree(HotSpotReplacementsUtil.backedgeCounterOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), counterValue, ProfileSnippets.METHOD_COUNTERS);
            int mask = ProbabilisticProfileSnippets.notificationMask(freqLog, probLog, stepLog);
            if (BranchProbabilityNode.probability(0.010000000000000009, (counterValue & mask << HotSpotReplacementsUtil.invocationCounterShift(GraalHotSpotVMConfig.INJECTED_VMCONFIG)) == 0)) {
                ProbabilisticProfileSnippets.methodBackedgeEvent(HotSpotBackend.BACKEDGE_EVENT, counters, bci, targetBci);
            }
        }
    }

    @Snippet
    public static void profileConditionalBackedgeWithProbability(MethodCountersPointer counters, int random, int step, int stepLog, @Snippet.ConstantParameter int freqLog, @Snippet.ConstantParameter int probLog, boolean branchCondition, int bci, int targetBci) {
        if (branchCondition) {
            ProbabilisticProfileSnippets.profileBackedgeWithProbability(counters, random, step, stepLog, freqLog, probLog, bci, targetBci);
        }
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo profileMethodEntryWithProbability = this.snippet(ProbabilisticProfileSnippets.class, "profileMethodEntryWithProbability", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo profileBackedgeWithProbability = this.snippet(ProbabilisticProfileSnippets.class, "profileBackedgeWithProbability", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo profileConditionalBackedgeWithProbability = this.snippet(ProbabilisticProfileSnippets.class, "profileConditionalBackedgeWithProbability", new LocationIdentity[0]);

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, HotSpotProviders providers, TargetDescription target) {
            super(options, factories, providers, providers.getSnippetReflection(), target);
        }

        public void lower(ProfileNode profileNode, LoweringTool tool) {
            assert (profileNode.getRandom() != null);
            StructuredGraph graph = profileNode.graph();
            LoadMethodCountersNode counters = graph.unique(new LoadMethodCountersNode(profileNode.getProfiledMethod()));
            ConstantNode step = ConstantNode.forInt(profileNode.getStep(), graph);
            ConstantNode stepLog = ConstantNode.forInt(CodeUtil.log2((int)profileNode.getStep()), graph);
            if (profileNode instanceof ProfileBranchNode) {
                ProfileBranchNode profileBranchNode = (ProfileBranchNode)profileNode;
                SnippetTemplate.SnippetInfo snippet = profileBranchNode.hasCondition() ? this.profileConditionalBackedgeWithProbability : this.profileBackedgeWithProbability;
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(snippet, graph.getGuardsStage(), tool.getLoweringStage());
                ConstantNode bci = ConstantNode.forInt(profileBranchNode.bci(), graph);
                ConstantNode targetBci = ConstantNode.forInt(profileBranchNode.targetBci(), graph);
                args.add("counters", counters);
                args.add("random", profileBranchNode.getRandom());
                args.add("step", step);
                args.add("stepLog", stepLog);
                args.addConst("freqLog", profileBranchNode.getNotificationFreqLog());
                args.addConst("probLog", profileBranchNode.getProbabilityLog());
                if (profileBranchNode.hasCondition()) {
                    args.add("branchCondition", profileBranchNode.branchCondition());
                }
                args.add("bci", bci);
                args.add("targetBci", targetBci);
                SnippetTemplate template = this.template(profileNode, args);
                template.instantiate(this.providers.getMetaAccess(), profileNode, SnippetTemplate.DEFAULT_REPLACER, args);
            } else if (profileNode instanceof ProfileInvokeNode) {
                ProfileInvokeNode profileInvokeNode = (ProfileInvokeNode)profileNode;
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.profileMethodEntryWithProbability, graph.getGuardsStage(), tool.getLoweringStage());
                args.add("counters", counters);
                args.add("random", profileInvokeNode.getRandom());
                args.add("step", step);
                args.add("stepLog", stepLog);
                args.addConst("freqLog", profileInvokeNode.getNotificationFreqLog());
                args.addConst("probLog", profileInvokeNode.getProbabilityLog());
                SnippetTemplate template = this.template(profileNode, args);
                template.instantiate(this.providers.getMetaAccess(), profileNode, SnippetTemplate.DEFAULT_REPLACER, args);
            } else {
                throw new GraalError("Unsupported profile node type: " + profileNode);
            }
            assert (profileNode.hasNoUsages());
            if (!profileNode.isDeleted()) {
                GraphUtil.killWithUnusedFloatingInputs(profileNode);
            }
        }
    }
}

