/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.debug.StringToBytesNode;
import org.graalvm.compiler.nodes.extended.RawStoreNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.nodes.CStringConstant;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;

public class StringToBytesSnippets
implements Snippets {
    public static final LocationIdentity CSTRING_LOCATION = NamedLocationIdentity.immutable("CString location");

    @Snippet
    public static byte[] transform(@Snippet.ConstantParameter Word cArray, @Snippet.ConstantParameter int length, @Snippet.ConstantParameter LocationIdentity locationIdentity) {
        int i = length;
        byte[] array = (byte[])NewArrayNode.newUninitializedArray(Byte.TYPE, i);
        while (i-- > 0) {
            RawStoreNode.storeByte(array, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Byte) + i, cArray.readByte(i, CSTRING_LOCATION), JavaKind.Byte, locationIdentity);
        }
        return array;
    }

    public static class Templates
    extends SnippetTemplate.AbstractTemplates {
        private final SnippetTemplate.SnippetInfo create = this.snippet(StringToBytesSnippets.class, "transform", new LocationIdentity[0]);

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, HotSpotProviders providers, TargetDescription target) {
            super(options, factories, providers, providers.getSnippetReflection(), target);
        }

        public void lower(StringToBytesNode stringToBytesNode, LoweringTool tool) {
            SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.create, stringToBytesNode.graph().getGuardsStage(), tool.getLoweringStage());
            String value = stringToBytesNode.getValue();
            args.addConst("cArray", new CStringConstant(value));
            args.addConst("length", value.length());
            args.addConst("locationIdentity", LocationIdentity.init());
            SnippetTemplate template = this.template(stringToBytesNode, args);
            template.instantiate(this.providers.getMetaAccess(), stringToBytesNode, SnippetTemplate.DEFAULT_REPLACER, args);
        }
    }
}

