/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaTypeProfile;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.api.replacements.Snippet;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugHandlersFactory;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.nodes.type.KlassPointerStamp;
import org.graalvm.compiler.hotspot.replacements.ClassGetHubNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.HotspotSnippetsOptions;
import org.graalvm.compiler.hotspot.replacements.TypeCheckSnippetUtils;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.SnippetAnchorNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.TypeCheckHints;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.java.ClassIsAssignableFromNode;
import org.graalvm.compiler.nodes.java.InstanceOfDynamicNode;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.replacements.InstanceOfSnippetsTemplates;
import org.graalvm.compiler.replacements.SnippetCounter;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.Snippets;
import org.graalvm.compiler.replacements.nodes.ExplodeLoopNode;
import org.graalvm.word.LocationIdentity;

public class InstanceOfSnippets
implements Snippets {
    @Snippet
    public static Object instanceofWithProfile(Object object, @Snippet.VarargsParameter KlassPointer[] hints, @Snippet.VarargsParameter boolean[] hintIsPositive, Object trueValue, Object falseValue, @Snippet.ConstantParameter boolean nullSeen, @Snippet.ConstantParameter TypeCheckSnippetUtils.Counters counters) {
        if (BranchProbabilityNode.probability(0.09999999999999998, object == null)) {
            counters.isNull.inc();
            if (!nullSeen) {
                DeoptimizeNode.deopt(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.OptimizedTypeCheckViolated);
            }
            return falseValue;
        }
        GuardingNode anchorNode = SnippetAnchorNode.anchor();
        KlassPointer objectHub = HotSpotReplacementsUtil.loadHubIntrinsic(PiNode.piCastNonNull(object, anchorNode));
        ExplodeLoopNode.explodeLoop();
        for (int i = 0; i < hints.length; ++i) {
            KlassPointer hintHub = hints[i];
            boolean positive = hintIsPositive[i];
            if (BranchProbabilityNode.probability(0.6, hintHub.equal(objectHub))) {
                counters.hintsHit.inc();
                return positive ? trueValue : falseValue;
            }
            counters.hintsMiss.inc();
        }
        DeoptimizeNode.deopt(DeoptimizationAction.InvalidateReprofile, DeoptimizationReason.OptimizedTypeCheckViolated);
        return falseValue;
    }

    @Snippet
    public static Object instanceofExact(Object object, KlassPointer exactHub, Object trueValue, Object falseValue, @Snippet.ConstantParameter TypeCheckSnippetUtils.Counters counters) {
        KlassPointer objectHub = HotSpotReplacementsUtil.loadHubOrNullIntrinsic(object);
        if (BranchProbabilityNode.probability(0.6, objectHub.notEqual(exactHub))) {
            counters.exactMiss.inc();
            return falseValue;
        }
        counters.exactHit.inc();
        return trueValue;
    }

    @Snippet
    public static Object instanceofPrimary(KlassPointer hub, Object object, @Snippet.ConstantParameter int superCheckOffset, Object trueValue, Object falseValue, @Snippet.ConstantParameter TypeCheckSnippetUtils.Counters counters) {
        if (BranchProbabilityNode.probability(0.09999999999999998, object == null)) {
            counters.isNull.inc();
            return falseValue;
        }
        GuardingNode anchorNode = SnippetAnchorNode.anchor();
        KlassPointer objectHub = HotSpotReplacementsUtil.loadHubIntrinsic(PiNode.piCastNonNull(object, anchorNode));
        if (BranchProbabilityNode.probability(0.4, objectHub.readKlassPointer(superCheckOffset, HotSpotReplacementsUtil.PRIMARY_SUPERS_LOCATION).notEqual(hub))) {
            counters.displayMiss.inc();
            return falseValue;
        }
        counters.displayHit.inc();
        return trueValue;
    }

    @Snippet
    public static Object instanceofSecondary(KlassPointer hub, Object object, @Snippet.VarargsParameter KlassPointer[] hints, @Snippet.VarargsParameter boolean[] hintIsPositive, Object trueValue, Object falseValue, @Snippet.ConstantParameter TypeCheckSnippetUtils.Counters counters) {
        if (BranchProbabilityNode.probability(0.09999999999999998, object == null)) {
            counters.isNull.inc();
            return falseValue;
        }
        GuardingNode anchorNode = SnippetAnchorNode.anchor();
        KlassPointer objectHub = HotSpotReplacementsUtil.loadHubIntrinsic(PiNode.piCastNonNull(object, anchorNode));
        ExplodeLoopNode.explodeLoop();
        for (int i = 0; i < hints.length; ++i) {
            KlassPointer hintHub = hints[i];
            boolean positive = hintIsPositive[i];
            if (!BranchProbabilityNode.probability(0.09999999999999998, hintHub.equal(objectHub))) continue;
            counters.hintsHit.inc();
            return positive ? trueValue : falseValue;
        }
        counters.hintsMiss.inc();
        if (!TypeCheckSnippetUtils.checkSecondarySubType(hub, objectHub, counters)) {
            return falseValue;
        }
        return trueValue;
    }

    @Snippet
    public static Object instanceofDynamic(KlassPointer hub, Object object, Object trueValue, Object falseValue, @Snippet.ConstantParameter boolean allowNull, @Snippet.ConstantParameter boolean exact, @Snippet.ConstantParameter TypeCheckSnippetUtils.Counters counters) {
        if (BranchProbabilityNode.probability(0.09999999999999998, object == null)) {
            counters.isNull.inc();
            if (allowNull) {
                return trueValue;
            }
            return falseValue;
        }
        GuardingNode anchorNode = SnippetAnchorNode.anchor();
        KlassPointer nonNullObjectHub = HotSpotReplacementsUtil.loadHubIntrinsic(PiNode.piCastNonNull(object, anchorNode));
        if (exact) {
            if (BranchProbabilityNode.probability(0.6, nonNullObjectHub.notEqual(hub))) {
                counters.exactMiss.inc();
                return falseValue;
            }
            counters.exactHit.inc();
            return trueValue;
        }
        if (BranchProbabilityNode.probability(0.99, !hub.isNull()) && TypeCheckSnippetUtils.checkUnknownSubType(hub, nonNullObjectHub, counters)) {
            return trueValue;
        }
        return falseValue;
    }

    @Snippet
    public static Object isAssignableFrom(@Snippet.NonNullParameter Class<?> thisClassNonNull, @Snippet.NonNullParameter Class<?> otherClassNonNull, Object trueValue, Object falseValue, @Snippet.ConstantParameter TypeCheckSnippetUtils.Counters counters) {
        GuardingNode guardNonNull;
        KlassPointer nonNullOtherHub;
        if (BranchProbabilityNode.probability(0.4, thisClassNonNull == otherClassNonNull)) {
            return trueValue;
        }
        KlassPointer thisHub = ClassGetHubNode.readClass(thisClassNonNull);
        KlassPointer otherHub = ClassGetHubNode.readClass(otherClassNonNull);
        if (BranchProbabilityNode.probability(0.99, !thisHub.isNull()) && BranchProbabilityNode.probability(0.99, !otherHub.isNull()) && TypeCheckSnippetUtils.checkUnknownSubType(thisHub, nonNullOtherHub = ClassGetHubNode.piCastNonNull(otherHub, guardNonNull = SnippetAnchorNode.anchor()), counters)) {
            return trueValue;
        }
        return falseValue;
    }

    public static class Templates
    extends InstanceOfSnippetsTemplates {
        private final SnippetTemplate.SnippetInfo instanceofWithProfile = this.snippet(InstanceOfSnippets.class, "instanceofWithProfile", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo instanceofExact = this.snippet(InstanceOfSnippets.class, "instanceofExact", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo instanceofPrimary = this.snippet(InstanceOfSnippets.class, "instanceofPrimary", new LocationIdentity[0]);
        private final SnippetTemplate.SnippetInfo instanceofSecondary = this.snippet(InstanceOfSnippets.class, "instanceofSecondary", HotSpotReplacementsUtil.SECONDARY_SUPER_CACHE_LOCATION);
        private final SnippetTemplate.SnippetInfo instanceofDynamic = this.snippet(InstanceOfSnippets.class, "instanceofDynamic", HotSpotReplacementsUtil.SECONDARY_SUPER_CACHE_LOCATION);
        private final SnippetTemplate.SnippetInfo isAssignableFrom = this.snippet(InstanceOfSnippets.class, "isAssignableFrom", HotSpotReplacementsUtil.SECONDARY_SUPER_CACHE_LOCATION);
        private final TypeCheckSnippetUtils.Counters counters;

        public Templates(OptionValues options, Iterable<DebugHandlersFactory> factories, SnippetCounter.Group.Factory factory, HotSpotProviders providers, TargetDescription target) {
            super(options, factories, providers, providers.getSnippetReflection(), target);
            this.counters = new TypeCheckSnippetUtils.Counters(factory);
        }

        @Override
        protected SnippetTemplate.Arguments makeArguments(InstanceOfSnippetsTemplates.InstanceOfUsageReplacer replacer, LoweringTool tool) {
            if (replacer.instanceOf instanceof InstanceOfNode) {
                SnippetTemplate.Arguments args;
                InstanceOfNode instanceOf = (InstanceOfNode)replacer.instanceOf;
                ValueNode object = instanceOf.getValue();
                Assumptions assumptions = instanceOf.graph().getAssumptions();
                OptionValues localOptions = instanceOf.getOptions();
                JavaTypeProfile profile = instanceOf.profile();
                if (GraalOptions.GeneratePIC.getValue(localOptions).booleanValue()) {
                    profile = null;
                }
                TypeCheckHints hintInfo = new TypeCheckHints(instanceOf.type(), profile, assumptions, HotspotSnippetsOptions.TypeCheckMinProfileHitProbability.getValue(localOptions), HotspotSnippetsOptions.TypeCheckMaxHints.getValue(localOptions));
                HotSpotResolvedObjectType type = (HotSpotResolvedObjectType)instanceOf.type().getType();
                ConstantNode hub = ConstantNode.forConstant(KlassPointerStamp.klassNonNull(), type.klass(), this.providers.getMetaAccess(), instanceOf.graph());
                StructuredGraph graph = instanceOf.graph();
                if (hintInfo.hintHitProbability >= 1.0 && hintInfo.exact == null) {
                    TypeCheckSnippetUtils.Hints hints = TypeCheckSnippetUtils.createHints(hintInfo, this.providers.getMetaAccess(), false, graph);
                    args = new SnippetTemplate.Arguments(this.instanceofWithProfile, graph.getGuardsStage(), tool.getLoweringStage());
                    args.add("object", object);
                    args.addVarargs("hints", KlassPointer.class, KlassPointerStamp.klassNonNull(), hints.hubs);
                    args.addVarargs("hintIsPositive", Boolean.TYPE, StampFactory.forKind(JavaKind.Boolean), hints.isPositive);
                } else if (hintInfo.exact != null) {
                    args = new SnippetTemplate.Arguments(this.instanceofExact, graph.getGuardsStage(), tool.getLoweringStage());
                    args.add("object", object);
                    args.add("exactHub", ConstantNode.forConstant(KlassPointerStamp.klassNonNull(), ((HotSpotResolvedObjectType)hintInfo.exact).klass(), this.providers.getMetaAccess(), graph));
                } else if (type.isPrimaryType()) {
                    args = new SnippetTemplate.Arguments(this.instanceofPrimary, graph.getGuardsStage(), tool.getLoweringStage());
                    args.add("hub", hub);
                    args.add("object", object);
                    args.addConst("superCheckOffset", type.superCheckOffset());
                } else {
                    TypeCheckSnippetUtils.Hints hints = TypeCheckSnippetUtils.createHints(hintInfo, this.providers.getMetaAccess(), false, graph);
                    args = new SnippetTemplate.Arguments(this.instanceofSecondary, graph.getGuardsStage(), tool.getLoweringStage());
                    args.add("hub", hub);
                    args.add("object", object);
                    args.addVarargs("hints", KlassPointer.class, KlassPointerStamp.klassNonNull(), hints.hubs);
                    args.addVarargs("hintIsPositive", Boolean.TYPE, StampFactory.forKind(JavaKind.Boolean), hints.isPositive);
                }
                args.add("trueValue", replacer.trueValue);
                args.add("falseValue", replacer.falseValue);
                if (hintInfo.hintHitProbability >= 1.0 && hintInfo.exact == null) {
                    args.addConst("nullSeen", hintInfo.profile.getNullSeen() != TriState.FALSE);
                }
                args.addConst("counters", this.counters);
                return args;
            }
            if (replacer.instanceOf instanceof InstanceOfDynamicNode) {
                InstanceOfDynamicNode instanceOf = (InstanceOfDynamicNode)replacer.instanceOf;
                ValueNode object = instanceOf.getObject();
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.instanceofDynamic, instanceOf.graph().getGuardsStage(), tool.getLoweringStage());
                args.add("hub", instanceOf.getMirrorOrHub());
                args.add("object", object);
                args.add("trueValue", replacer.trueValue);
                args.add("falseValue", replacer.falseValue);
                args.addConst("allowNull", instanceOf.allowsNull());
                args.addConst("exact", instanceOf.isExact());
                args.addConst("counters", this.counters);
                return args;
            }
            if (replacer.instanceOf instanceof ClassIsAssignableFromNode) {
                ClassIsAssignableFromNode isAssignable = (ClassIsAssignableFromNode)replacer.instanceOf;
                SnippetTemplate.Arguments args = new SnippetTemplate.Arguments(this.isAssignableFrom, isAssignable.graph().getGuardsStage(), tool.getLoweringStage());
                assert (((ObjectStamp)isAssignable.getThisClass().stamp(NodeView.DEFAULT)).nonNull());
                assert (((ObjectStamp)isAssignable.getOtherClass().stamp(NodeView.DEFAULT)).nonNull());
                args.add("thisClassNonNull", isAssignable.getThisClass());
                args.add("otherClassNonNull", isAssignable.getOtherClass());
                args.add("trueValue", replacer.trueValue);
                args.add("falseValue", replacer.falseValue);
                args.addConst("counters", this.counters);
                return args;
            }
            throw GraalError.shouldNotReachHere();
        }
    }
}

