/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.replacements.AESCryptSubstitutions;
import org.graalvm.compiler.hotspot.replacements.CipherBlockChainingSubstitutions;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.java.InstanceOfNode;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordFactory;

@ClassSubstitution(className={"com.sun.crypto.provider.CounterMode"}, optional=true)
public class CounterModeSubstitutions {
    @MethodSubstitution(isStatic=false)
    static int implCrypt(Object receiver, byte[] in, int inOff, int len, byte[] out, int outOff) {
        Object realReceiver = PiNode.piCastNonNull(receiver, HotSpotReplacementsUtil.methodHolderClass(GraalHotSpotVMConfig.INJECTED_INTRINSIC_CONTEXT));
        Object embeddedCipher = RawLoadNode.load(realReceiver, CipherBlockChainingSubstitutions.embeddedCipherOffset(GraalHotSpotVMConfig.INJECTED_INTRINSIC_CONTEXT), JavaKind.Object, LocationIdentity.any());
        if (InstanceOfNode.doInstanceof(CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfig.INJECTED_INTRINSIC_CONTEXT), embeddedCipher)) {
            Object aesCipher = PiNode.piCastNonNull(embeddedCipher, CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfig.INJECTED_INTRINSIC_CONTEXT));
            Word srcAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(in, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Byte) + inOff));
            Word dstAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(out, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Byte) + outOff));
            Word usedPtr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(realReceiver, CounterModeSubstitutions.usedOffset(GraalHotSpotVMConfig.INJECTED_INTRINSIC_CONTEXT)));
            int cntOffset = CounterModeSubstitutions.counterOffset(GraalHotSpotVMConfig.INJECTED_INTRINSIC_CONTEXT);
            int encCntOffset = CounterModeSubstitutions.encCounterOffset(GraalHotSpotVMConfig.INJECTED_INTRINSIC_CONTEXT);
            Object kObject = RawLoadNode.load(aesCipher, AESCryptSubstitutions.kOffset(GraalHotSpotVMConfig.INJECTED_INTRINSIC_CONTEXT), JavaKind.Object, LocationIdentity.any());
            Object cntObj = RawLoadNode.load(realReceiver, cntOffset, JavaKind.Object, LocationIdentity.any());
            Object encCntObj = RawLoadNode.load(realReceiver, encCntOffset, JavaKind.Object, LocationIdentity.any());
            Word kPtr = Word.objectToTrackedPointer(kObject).add(ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Int));
            Word cntPtr = Word.objectToTrackedPointer(cntObj).add(ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Byte));
            Word encCntPtr = Word.objectToTrackedPointer(encCntObj).add(ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Byte));
            return HotSpotBackend.counterModeAESCrypt(srcAddr, dstAddr, kPtr, cntPtr, len, encCntPtr, usedPtr);
        }
        return CounterModeSubstitutions.implCrypt(realReceiver, in, inOff, len, out, outOff);
    }

    static ResolvedJavaType counterModeType(IntrinsicContext context) {
        return HotSpotReplacementsUtil.getType(context, "Lcom/sun/crypto/provider/CounterMode;");
    }

    @Fold
    static int counterOffset(@Fold.InjectedParameter IntrinsicContext context) {
        return HotSpotReplacementsUtil.getFieldOffset(CounterModeSubstitutions.counterModeType(context), "counter");
    }

    @Fold
    static int encCounterOffset(@Fold.InjectedParameter IntrinsicContext context) {
        return HotSpotReplacementsUtil.getFieldOffset(CounterModeSubstitutions.counterModeType(context), "encryptedCounter");
    }

    @Fold
    static int usedOffset(@Fold.InjectedParameter IntrinsicContext context) {
        return HotSpotReplacementsUtil.getFieldOffset(CounterModeSubstitutions.counterModeType(context), "used");
    }
}

