/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;

@ClassSubstitution(className={"java.math.BigInteger"}, optional=true)
public class BigIntegerSubstitutions {
    @MethodSubstitution(isStatic=false)
    static int[] multiplyToLen(Object receiver, int[] x, int xlen, int[] y, int ylen, int[] zIn) {
        return BigIntegerSubstitutions.multiplyToLenStatic(x, xlen, y, ylen, zIn);
    }

    @MethodSubstitution(isStatic=true)
    static int[] multiplyToLenStatic(int[] x, int xlen, int[] y, int ylen, int[] zIn) {
        int zLen;
        int[] zResult = zIn;
        if (zResult == null || zResult.length < xlen + ylen) {
            zLen = xlen + ylen;
            zResult = new int[xlen + ylen];
        } else {
            zLen = zIn.length;
        }
        HotSpotBackend.multiplyToLenStub(HotSpotReplacementsUtil.arrayStart(x), xlen, HotSpotReplacementsUtil.arrayStart(y), ylen, HotSpotReplacementsUtil.arrayStart(zResult), zLen);
        return zResult;
    }
}

