/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.replacements.CipherBlockChainingSubstitutions;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.DeoptimizeNode;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.extended.BranchProbabilityNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.Pointer;
import org.graalvm.word.WordFactory;

@ClassSubstitution(className={"com.sun.crypto.provider.AESCrypt"}, optional=true)
public class AESCryptSubstitutions {
    static final int AES_BLOCK_SIZE_IN_BYTES = 16;

    @Fold
    static long kOffset(@Fold.InjectedParameter IntrinsicContext context) {
        return HotSpotReplacementsUtil.getFieldOffset(CipherBlockChainingSubstitutions.aesCryptType(context), "K");
    }

    @Fold
    static long lastKeyOffset(@Fold.InjectedParameter IntrinsicContext context) {
        return HotSpotReplacementsUtil.getFieldOffset(CipherBlockChainingSubstitutions.aesCryptType(context), "lastKey");
    }

    @MethodSubstitution(isStatic=false)
    static void encryptBlock(Object rcvr, byte[] in, int inOffset, byte[] out, int outOffset) {
        AESCryptSubstitutions.crypt(rcvr, in, inOffset, out, outOffset, true, false);
    }

    @MethodSubstitution(isStatic=false)
    static void implEncryptBlock(Object rcvr, byte[] in, int inOffset, byte[] out, int outOffset) {
        AESCryptSubstitutions.crypt(rcvr, in, inOffset, out, outOffset, true, false);
    }

    @MethodSubstitution(isStatic=false)
    static void decryptBlock(Object rcvr, byte[] in, int inOffset, byte[] out, int outOffset) {
        AESCryptSubstitutions.crypt(rcvr, in, inOffset, out, outOffset, false, false);
    }

    @MethodSubstitution(isStatic=false)
    static void implDecryptBlock(Object rcvr, byte[] in, int inOffset, byte[] out, int outOffset) {
        AESCryptSubstitutions.crypt(rcvr, in, inOffset, out, outOffset, false, false);
    }

    private static void crypt(Object rcvr, byte[] in, int inOffset, byte[] out, int outOffset, boolean encrypt, boolean withOriginalKey) {
        AESCryptSubstitutions.checkArgs(in, inOffset, out, outOffset);
        Object realReceiver = PiNode.piCastNonNull(rcvr, CipherBlockChainingSubstitutions.aesCryptType(GraalHotSpotVMConfig.INJECTED_INTRINSIC_CONTEXT));
        Object kObject = RawLoadNode.load(realReceiver, AESCryptSubstitutions.kOffset(GraalHotSpotVMConfig.INJECTED_INTRINSIC_CONTEXT), JavaKind.Object, LocationIdentity.any());
        Word kAddr = Word.objectToTrackedPointer(kObject).add(ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Int));
        Word inAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(in, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Byte) + inOffset));
        Word outAddr = (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(out, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Byte) + outOffset));
        if (encrypt) {
            AESCryptSubstitutions.encryptBlockStub(HotSpotBackend.ENCRYPT_BLOCK, inAddr, outAddr, kAddr);
        } else if (withOriginalKey) {
            Object lastKeyObject = RawLoadNode.load(realReceiver, AESCryptSubstitutions.lastKeyOffset(GraalHotSpotVMConfig.INJECTED_INTRINSIC_CONTEXT), JavaKind.Object, LocationIdentity.any());
            Word lastKeyAddr = Word.objectToTrackedPointer(lastKeyObject).add(ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Byte));
            AESCryptSubstitutions.decryptBlockWithOriginalKeyStub(HotSpotBackend.DECRYPT_BLOCK_WITH_ORIGINAL_KEY, inAddr, outAddr, kAddr, lastKeyAddr);
        } else {
            AESCryptSubstitutions.decryptBlockStub(HotSpotBackend.DECRYPT_BLOCK, inAddr, outAddr, kAddr);
        }
    }

    static void checkArgs(byte[] in, int inOffset, byte[] out, int outOffset) {
        if (BranchProbabilityNode.probability(0.0010000000000000009, inOffset < 0 || in.length - 16 < inOffset || outOffset < 0 || out.length - 16 < outOffset)) {
            DeoptimizeNode.deopt(DeoptimizationAction.None, DeoptimizationReason.RuntimeConstraint);
        }
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void encryptBlockStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, Pointer var3);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void decryptBlockStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, Pointer var3);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native void decryptBlockWithOriginalKeyStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, Word var2, Pointer var3, Pointer var4);
}

