/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.phases;

import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaField;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.hotspot.HotSpotResolvedPrimitiveType;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.nodes.HotSpotCompressionNode;
import org.graalvm.compiler.hotspot.nodes.type.HotSpotNarrowOopStamp;
import org.graalvm.compiler.hotspot.nodes.type.KlassPointerStamp;
import org.graalvm.compiler.hotspot.replacements.HubGetClassNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.FloatingReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.phases.BasePhase;

public class LoadJavaMirrorWithKlassPhase
extends BasePhase<CoreProviders> {
    private final CompressEncoding oopEncoding;

    public LoadJavaMirrorWithKlassPhase(GraalHotSpotVMConfig config) {
        this.oopEncoding = config.useCompressedOops ? config.getOopEncoding() : null;
    }

    private ValueNode getClassConstantReplacement(StructuredGraph graph, CoreProviders context, JavaConstant constant) {
        ConstantReflectionProvider constantReflection;
        ResolvedJavaType type;
        if (constant instanceof HotSpotObjectConstant && (type = (constantReflection = context.getConstantReflection()).asJavaType((Constant)constant)) != null) {
            MetaAccessProvider metaAccess = context.getMetaAccess();
            Stamp stamp = StampFactory.objectNonNull(TypeReference.createExactTrusted(metaAccess.lookupJavaType(Class.class)));
            if (type instanceof HotSpotResolvedObjectType) {
                ConstantNode klass = ConstantNode.forConstant(KlassPointerStamp.klassNonNull(), ((HotSpotResolvedObjectType)type).klass(), metaAccess, graph);
                ValueNode getClass = graph.unique(new HubGetClassNode(metaAccess, klass));
                if (((HotSpotObjectConstant)constant).isCompressed()) {
                    return HotSpotCompressionNode.compress(getClass, this.oopEncoding);
                }
                return getClass;
            }
            HotSpotResolvedPrimitiveType primitive = (HotSpotResolvedPrimitiveType)type;
            ResolvedJavaType boxingClass = metaAccess.lookupJavaType(primitive.getJavaKind().toBoxedJavaClass());
            ConstantNode clazz = ConstantNode.forConstant(context.getConstantReflection().asJavaClass(boxingClass), metaAccess, graph);
            HotSpotResolvedJavaField[] a = (HotSpotResolvedJavaField[])boxingClass.getStaticFields();
            HotSpotResolvedJavaField typeField = null;
            for (HotSpotResolvedJavaField f : a) {
                if (!f.getName().equals("TYPE")) continue;
                typeField = f;
                break;
            }
            if (typeField == null) {
                throw new GraalError("Can't find TYPE field in class");
            }
            if (this.oopEncoding != null) {
                stamp = HotSpotNarrowOopStamp.compressed(stamp, this.oopEncoding);
            }
            AddressNode address = graph.unique(new OffsetAddressNode(clazz, ConstantNode.forLong(typeField.getOffset(), graph)));
            ValueNode read = graph.unique(new FloatingReadNode(address, NamedLocationIdentity.FINAL_LOCATION, null, stamp));
            if (this.oopEncoding == null || ((HotSpotObjectConstant)constant).isCompressed()) {
                return read;
            }
            return HotSpotCompressionNode.uncompress(read, this.oopEncoding);
        }
        return null;
    }

    @Override
    protected void run(StructuredGraph graph, CoreProviders context) {
        for (ConstantNode node : ConstantNode.getConstantNodes(graph)) {
            JavaConstant constant = node.asJavaConstant();
            ValueNode freadNode = this.getClassConstantReplacement(graph, context, constant);
            if (freadNode == null) continue;
            node.replace(graph, freadNode);
        }
    }

    @Override
    public float codeSizeIncrease() {
        return 2.5f;
    }
}

