/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes.profiling;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.hotspot.nodes.profiling.ProfileNode;
import org.graalvm.compiler.hotspot.nodes.profiling.ProfileWithNotificationNode;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.StructuredGraph;

@NodeInfo
public class ProfileInvokeNode
extends ProfileWithNotificationNode {
    public static final NodeClass<ProfileInvokeNode> TYPE = NodeClass.create(ProfileInvokeNode.class);

    public ProfileInvokeNode(ResolvedJavaMethod method, int freqLog, int probabilityLog) {
        super(TYPE, method, freqLog, probabilityLog);
    }

    @Override
    protected boolean canBeMergedWith(ProfileNode p) {
        if (p instanceof ProfileInvokeNode) {
            ProfileInvokeNode that = (ProfileInvokeNode)p;
            return this.method.equals(that.method);
        }
        return false;
    }

    public static NodeIterable<ProfileInvokeNode> getProfileInvokeNodes(StructuredGraph graph) {
        return graph.getNodes().filter(ProfileInvokeNode.class);
    }
}

