/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.nodes.aot.ResolveDynamicConstantNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvokeDynamicPlugin;

public class HotSpotInvokeDynamicPlugin
implements InvokeDynamicPlugin {
    private static final Class<? extends ConstantPool> hscp;
    private static final MethodHandle isResolvedDynamicInvokeMH;
    private final DynamicTypeStore dynoStore;
    private final boolean treatAppendixAsConstant;

    private static boolean isResolvedDynamicInvoke(ConstantPool constantPool, int index, int opcode) {
        if (isResolvedDynamicInvokeMH != null) {
            if (!hscp.isInstance(constantPool)) {
                return false;
            }
            try {
                return isResolvedDynamicInvokeMH.invoke(constantPool, index, opcode);
            }
            catch (Throwable t) {
                throw GraalError.shouldNotReachHere(t);
            }
        }
        throw GraalError.shouldNotReachHere("isResolvedDynamicInvokeMH not set");
    }

    public HotSpotInvokeDynamicPlugin(DynamicTypeStore dynoStore, boolean treatAppendixAsConstant) {
        this.dynoStore = dynoStore;
        this.treatAppendixAsConstant = treatAppendixAsConstant;
    }

    public HotSpotInvokeDynamicPlugin(DynamicTypeStore dynoStore) {
        this(dynoStore, true);
    }

    public HotSpotInvokeDynamicPlugin() {
        this(null);
    }

    @Override
    public boolean isResolvedDynamicInvoke(GraphBuilderContext builder, int index, int opcode) {
        ConstantPool constantPool = builder.getCode().getConstantPool();
        if (isResolvedDynamicInvokeMH == null) {
            return true;
        }
        return HotSpotInvokeDynamicPlugin.isResolvedDynamicInvoke(constantPool, index, opcode);
    }

    @Override
    public boolean supportsDynamicInvoke(GraphBuilderContext builder, int index, int opcode) {
        return opcode == 186 || isResolvedDynamicInvokeMH != null;
    }

    public DynamicTypeStore getDynamicTypeStore() {
        return this.dynoStore;
    }

    @Override
    public void recordDynamicMethod(GraphBuilderContext builder, int index, int opcode, ResolvedJavaMethod target) {
        assert (this.supportsDynamicInvoke(builder, index, opcode));
        HotSpotResolvedJavaMethod method = (HotSpotResolvedJavaMethod)builder.getMethod();
        HotSpotResolvedObjectType methodHolder = method.getDeclaringClass();
        HotSpotResolvedJavaMethod adapter = (HotSpotResolvedJavaMethod)target;
        if (this.dynoStore != null) {
            this.dynoStore.recordAdapter(opcode, methodHolder, index, adapter);
        }
    }

    @Override
    public ValueNode genAppendixNode(GraphBuilderContext builder, int index, int opcode, JavaConstant appendixConstant, FrameState frameState) {
        JavaConstant appendix = appendixConstant;
        assert (this.supportsDynamicInvoke(builder, index, opcode));
        HotSpotResolvedJavaMethod method = (HotSpotResolvedJavaMethod)builder.getMethod();
        HotSpotResolvedObjectType methodHolder = method.getDeclaringClass();
        if (this.dynoStore != null) {
            appendix = this.dynoStore.recordAppendix(opcode, methodHolder, index, appendix);
        }
        ConstantNode appendixNode = ConstantNode.forConstant(appendix, builder.getMetaAccess(), builder.getGraph());
        Stamp appendixStamp = appendixNode.stamp(NodeView.DEFAULT);
        Stamp resolveStamp = this.treatAppendixAsConstant ? appendixStamp : appendixStamp.unrestricted();
        ResolveDynamicConstantNode resolveNode = new ResolveDynamicConstantNode(resolveStamp, appendixNode);
        ResolveDynamicConstantNode added = builder.append(resolveNode);
        assert (added == resolveNode);
        added.setStateBefore(frameState);
        return resolveNode;
    }

    static {
        MethodHandle m = null;
        Class<ConstantPool> c = null;
        try {
            c = Class.forName("jdk.vm.ci.hotspot.HotSpotConstantPool").asSubclass(ConstantPool.class);
            m = MethodHandles.lookup().findVirtual(c, "isResolvedDynamicInvoke", MethodType.methodType(Boolean.TYPE, Integer.TYPE, Integer.TYPE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        isResolvedDynamicInvokeMH = m;
        hscp = c;
    }

    public static interface DynamicTypeStore {
        public void recordAdapter(int var1, HotSpotResolvedObjectType var2, int var3, HotSpotResolvedJavaMethod var4);

        public JavaConstant recordAppendix(int var1, HotSpotResolvedObjectType var2, int var3, JavaConstant var4);
    }
}

