/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.VolatileCallSite;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.zip.CRC32;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.hotspot.VMIntrinsicMethod;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.Pair;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfigAccess;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotMarkId;
import org.graalvm.compiler.hotspot.meta.HotSpotAOTClassInitializationPlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotAOTProfilingPlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotExceptionDispatchPlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotInvocationPlugins;
import org.graalvm.compiler.hotspot.meta.HotSpotJITClassInitializationPlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotNodePlugin;
import org.graalvm.compiler.hotspot.meta.HotSpotWordOperationPlugin;
import org.graalvm.compiler.hotspot.nodes.CurrentJavaThreadNode;
import org.graalvm.compiler.hotspot.nodes.GraalHotSpotVMConfigNode;
import org.graalvm.compiler.hotspot.replacements.AESCryptSubstitutions;
import org.graalvm.compiler.hotspot.replacements.BigIntegerSubstitutions;
import org.graalvm.compiler.hotspot.replacements.CallSiteTargetNode;
import org.graalvm.compiler.hotspot.replacements.CipherBlockChainingSubstitutions;
import org.graalvm.compiler.hotspot.replacements.ClassGetHubNode;
import org.graalvm.compiler.hotspot.replacements.CounterModeSubstitutions;
import org.graalvm.compiler.hotspot.replacements.DigestBaseSubstitutions;
import org.graalvm.compiler.hotspot.replacements.FastNotifyNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotArraySubstitutions;
import org.graalvm.compiler.hotspot.replacements.HotSpotClassSubstitutions;
import org.graalvm.compiler.hotspot.replacements.HotSpotIdentityHashCodeNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReflectionGetCallerClassNode;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.replacements.ObjectCloneNode;
import org.graalvm.compiler.hotspot.replacements.ReflectionSubstitutions;
import org.graalvm.compiler.hotspot.replacements.ThreadSubstitutions;
import org.graalvm.compiler.hotspot.replacements.UnsafeCopyMemoryNode;
import org.graalvm.compiler.hotspot.word.HotSpotWordTypes;
import org.graalvm.compiler.java.BytecodeParserOptions;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FixedGuardNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.PiNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.AndNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.IsNullNode;
import org.graalvm.compiler.nodes.calc.LeftShiftNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.calc.RightShiftNode;
import org.graalvm.compiler.nodes.calc.SignExtendNode;
import org.graalvm.compiler.nodes.calc.SubNode;
import org.graalvm.compiler.nodes.calc.UnsignedRightShiftNode;
import org.graalvm.compiler.nodes.calc.XorNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.JavaReadNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.graphbuilderconf.ForeignCallPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedPluginFactory;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.nodes.java.ArrayLengthNode;
import org.graalvm.compiler.nodes.java.DynamicNewInstanceNode;
import org.graalvm.compiler.nodes.java.NewArrayNode;
import org.graalvm.compiler.nodes.java.ValidateNewInstanceClassNode;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.replacements.InlineDuringParsingPlugin;
import org.graalvm.compiler.replacements.MethodHandlePlugin;
import org.graalvm.compiler.replacements.NodeIntrinsificationProvider;
import org.graalvm.compiler.replacements.ReplacementsImpl;
import org.graalvm.compiler.replacements.StandardGraphBuilderPlugins;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyCallNode;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyForeignCalls;
import org.graalvm.compiler.replacements.arraycopy.ArrayCopyNode;
import org.graalvm.compiler.replacements.nodes.MacroNode;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.LocationIdentity;
import sun.misc.Unsafe;

public class HotSpotGraphBuilderPlugins {
    public static final String reflectionClass = JavaVersionUtil.JAVA_SPEC <= 8 ? "sun.reflect.Reflection" : "jdk.internal.reflect.Reflection";

    public static GraphBuilderConfiguration.Plugins create(final HotSpotGraalRuntimeProvider graalRuntime, CompilerConfiguration compilerConfiguration, final GraalHotSpotVMConfig config, final HotSpotWordTypes wordTypes, final MetaAccessProvider metaAccess, ConstantReflectionProvider constantReflection, final SnippetReflectionProvider snippetReflection, final HotSpotHostForeignCallsProvider foreignCalls, final ReplacementsImpl replacements, final OptionValues options, TargetDescription target) {
        final HotSpotInvocationPlugins invocationPlugins = new HotSpotInvocationPlugins(graalRuntime, config, compilerConfiguration);
        final GraphBuilderConfiguration.Plugins plugins = new GraphBuilderConfiguration.Plugins(invocationPlugins);
        plugins.appendNodePlugin(new HotSpotExceptionDispatchPlugin(config, wordTypes.getWordKind()));
        if (!Services.IS_IN_NATIVE_IMAGE) {
            HotSpotWordOperationPlugin wordOperationPlugin = new HotSpotWordOperationPlugin(snippetReflection, wordTypes);
            HotSpotNodePlugin nodePlugin = new HotSpotNodePlugin(wordOperationPlugin);
            plugins.appendTypePlugin(nodePlugin);
            plugins.appendNodePlugin(nodePlugin);
        }
        if (!GraalOptions.GeneratePIC.getValue(options).booleanValue()) {
            plugins.appendNodePlugin(new MethodHandlePlugin(constantReflection.getMethodHandleAccess(), !config.supportsMethodHandleDeoptimizationEntry()));
        }
        plugins.appendInlineInvokePlugin(replacements);
        if (BytecodeParserOptions.InlineDuringParsing.getValue(options).booleanValue()) {
            plugins.appendInlineInvokePlugin(new InlineDuringParsingPlugin());
        }
        if (GraalOptions.GeneratePIC.getValue(options).booleanValue()) {
            plugins.setClassInitializationPlugin(new HotSpotAOTClassInitializationPlugin());
            if (HotSpotAOTProfilingPlugin.Options.TieredAOT.getValue(options).booleanValue()) {
                plugins.setProfilingPlugin(new HotSpotAOTProfilingPlugin());
            }
        } else if (config.instanceKlassInitThreadOffset != -1) {
            plugins.setClassInitializationPlugin(new HotSpotJITClassInitializationPlugin());
        }
        invocationPlugins.defer(new Runnable(){

            @Override
            public void run() {
                HotSpotGraphBuilderPlugins.registerObjectPlugins(invocationPlugins, options, config, replacements);
                HotSpotGraphBuilderPlugins.registerClassPlugins(plugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerSystemPlugins(invocationPlugins);
                HotSpotGraphBuilderPlugins.registerThreadPlugins(invocationPlugins, metaAccess, wordTypes, config, replacements);
                if (!GraalOptions.GeneratePIC.getValue(options).booleanValue()) {
                    HotSpotGraphBuilderPlugins.registerCallSitePlugins(invocationPlugins);
                }
                HotSpotGraphBuilderPlugins.registerReflectionPlugins(invocationPlugins, replacements);
                HotSpotGraphBuilderPlugins.registerAESPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCRC32Plugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerCRC32CPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerBigIntegerPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerSHAPlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerGHASHPlugins(invocationPlugins, config, metaAccess);
                HotSpotGraphBuilderPlugins.registerCounterModePlugins(invocationPlugins, config, replacements);
                HotSpotGraphBuilderPlugins.registerBase64Plugins(invocationPlugins, config, metaAccess);
                HotSpotGraphBuilderPlugins.registerUnsafePlugins(invocationPlugins, config, replacements);
                StandardGraphBuilderPlugins.registerInvocationPlugins(metaAccess, snippetReflection, invocationPlugins, replacements, true, false, true, graalRuntime.getHostProviders().getLowerer());
                HotSpotGraphBuilderPlugins.registerArrayPlugins(invocationPlugins, replacements);
                HotSpotGraphBuilderPlugins.registerStringPlugins(invocationPlugins, replacements, wordTypes, foreignCalls, config);
                HotSpotGraphBuilderPlugins.registerArraysSupportPlugins(invocationPlugins, config, replacements);
            }
        });
        if (!Services.IS_IN_NATIVE_IMAGE) {
            final NodeIntrinsificationProvider nodeIntrinsificationProvider = new NodeIntrinsificationProvider(metaAccess, snippetReflection, foreignCalls, wordTypes, target);
            invocationPlugins.defer(new Runnable(){

                @Override
                public void run() {
                    for (GeneratedPluginFactory factory : GraalServices.load(GeneratedPluginFactory.class)) {
                        factory.registerPlugins(invocationPlugins, nodeIntrinsificationProvider);
                    }
                }
            });
        }
        return plugins;
    }

    private static void registerObjectPlugins(InvocationPlugins plugins, OptionValues options, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Object.class), replacements);
        if (!GraalOptions.GeneratePIC.getValue(options).booleanValue()) {
            r.register1("clone", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    ValueNode object = receiver.get();
                    b.addPush(JavaKind.Object, new ObjectCloneNode(MacroNode.MacroParams.of(b, targetMethod, object)));
                    return true;
                }

                @Override
                public boolean inlineOnly() {
                    return true;
                }
            });
        }
        r.register1("hashCode", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode object = receiver.get();
                b.addPush(JavaKind.Int, new HotSpotIdentityHashCodeNode(object, b.bci()));
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        });
        if (config.inlineNotify()) {
            r.register1("notify", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    ValueNode object = receiver.get();
                    b.add(new FastNotifyNode(object, false, b.bci()));
                    return true;
                }

                @Override
                public boolean inlineOnly() {
                    return true;
                }
            });
        }
        if (config.inlineNotifyAll()) {
            r.register1("notifyAll", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                    ValueNode object = receiver.get();
                    b.add(new FastNotifyNode(object, true, b.bci()));
                    return true;
                }

                @Override
                public boolean inlineOnly() {
                    return true;
                }
            });
        }
    }

    private static void registerClassPlugins(GraphBuilderConfiguration.Plugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), (Type)((Object)Class.class), replacements);
        r.registerMethodSubstitution(HotSpotClassSubstitutions.class, "getModifiers", new Type[]{InvocationPlugin.Receiver.class});
        r.registerMethodSubstitution(HotSpotClassSubstitutions.class, "isInterface", new Type[]{InvocationPlugin.Receiver.class});
        r.register1("isPrimitive", (Type)((Object)InvocationPlugin.Receiver.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ClassGetHubNode hub = b.add(new ClassGetHubNode(receiver.get()));
                LogicNode isNull = b.add(IsNullNode.create(hub));
                b.addPush(JavaKind.Boolean, ConditionalNode.create(isNull, b.add(ConstantNode.forBoolean(true)), b.add(ConstantNode.forBoolean(false)), NodeView.DEFAULT));
                return true;
            }
        });
        r.registerMethodSubstitution(HotSpotClassSubstitutions.class, "getSuperclass", new Type[]{InvocationPlugin.Receiver.class});
        if (config.jvmAccIsHiddenClass != 0) {
            r.registerMethodSubstitution(HotSpotClassSubstitutions.class, "isHidden", new Type[]{InvocationPlugin.Receiver.class});
        }
        if (config.getFieldOffset("ArrayKlass::_component_mirror", Integer.class, "oop", Integer.MAX_VALUE, GraalHotSpotVMConfigAccess.JDK <= 8) != Integer.MAX_VALUE) {
            r.registerMethodSubstitution(HotSpotClassSubstitutions.class, "getComponentType", new Type[]{InvocationPlugin.Receiver.class});
        }
    }

    private static void registerCallSitePlugins(InvocationPlugins plugins) {
        InvocationPlugin plugin = new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                ValueNode callSite = receiver.get();
                ConstantNode folded = CallSiteTargetNode.tryFold(GraphUtil.originalValue(callSite, true), b.getMetaAccess(), b.getAssumptions());
                if (folded != null) {
                    b.addPush(JavaKind.Object, folded);
                } else {
                    b.addPush(JavaKind.Object, new CallSiteTargetNode(MacroNode.MacroParams.of(b, targetMethod, callSite)));
                }
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        };
        plugins.register(plugin, (Type)((Object)ConstantCallSite.class), "getTarget", new Type[]{InvocationPlugin.Receiver.class});
        plugins.register(plugin, (Type)((Object)MutableCallSite.class), "getTarget", new Type[]{InvocationPlugin.Receiver.class});
        plugins.register(plugin, (Type)((Object)VolatileCallSite.class), "getTarget", new Type[]{InvocationPlugin.Receiver.class});
    }

    private static void registerReflectionPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, reflectionClass, replacements);
        r.register0("getCallerClass", new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Object, new HotSpotReflectionGetCallerClassNode(MacroNode.MacroParams.of(b, targetMethod, new ValueNode[0])));
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        });
        r.registerMethodSubstitution(ReflectionSubstitutions.class, "getClassAccessFlags", new Type[]{Class.class});
    }

    private static void registerUnsafePlugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = JavaVersionUtil.JAVA_SPEC <= 8 ? new InvocationPlugins.Registration(plugins, (Type)((Object)Unsafe.class), replacements) : new InvocationPlugins.Registration(plugins, "jdk.internal.misc.Unsafe", replacements);
        r.register6(HotSpotBackend.copyMemoryName, (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Object.class), Long.TYPE, (Type)((Object)Object.class), Long.TYPE, Long.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode srcBase, ValueNode srcOffset, ValueNode destBase, ValueNode destOffset, ValueNode bytes) {
                b.add(new UnsafeCopyMemoryNode(config.doingUnsafeAccessOffset != Integer.MAX_VALUE, receiver.get(), srcBase, srcOffset, destBase, destOffset, bytes));
                return true;
            }
        });
        r.register2("allocateInstance", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)Class.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver unsafe, ValueNode clazz) {
                unsafe.get();
                ValidateNewInstanceClassNode clazzLegal = b.add(new ValidateNewInstanceClassNode(clazz));
                b.addPush(JavaKind.Object, new DynamicNewInstanceNode(b.nullCheckedValue(clazzLegal, DeoptimizationAction.None), true));
                return true;
            }
        });
    }

    private static void registerSystemPlugins(InvocationPlugins plugins) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)System.class));
        r.register0("currentTimeMillis", new ForeignCallPlugin(HotSpotHostForeignCallsProvider.JAVA_TIME_MILLIS));
        r.register0("nanoTime", new ForeignCallPlugin(HotSpotHostForeignCallsProvider.JAVA_TIME_NANOS));
        r.register1("identityHashCode", (Type)((Object)Object.class), new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode object) {
                b.addPush(JavaKind.Int, new HotSpotIdentityHashCodeNode(object, b.bci()));
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        });
        r.register5("arraycopy", (Type)((Object)Object.class), Integer.TYPE, (Type)((Object)Object.class), Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode srcPos, ValueNode dst, ValueNode dstPos, ValueNode length) {
                b.add(new ArrayCopyNode(b.bci(), src, srcPos, dst, dstPos, length));
                return true;
            }

            @Override
            public boolean inlineOnly() {
                return true;
            }
        });
    }

    private static void registerArrayPlugins(InvocationPlugins plugins, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Array.class), replacements);
        r.setAllowOverwrite(true);
        r.registerMethodSubstitution(HotSpotArraySubstitutions.class, "newInstance", new Type[]{Class.class, Integer.TYPE});
    }

    private static void registerStringPlugins(InvocationPlugins plugins, Replacements replacements, final WordTypes wordTypes, final ArrayCopyForeignCalls foreignCalls, final GraalHotSpotVMConfig vmConfig) {
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            InvocationPlugins.Registration utf16r = new InvocationPlugins.Registration(plugins, "java.lang.StringUTF16", replacements);
            utf16r.register3("toBytes", (Type)((Object)char[].class), Integer.TYPE, Integer.TYPE, new InvocationPlugin(){
                private static final int MAX_LENGTH = 0x3FFFFFFF;

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode srcBegin, ValueNode length) {
                    PluginHelper helper = new PluginHelper(b, wordTypes);
                    helper.guard(srcBegin, Condition.LT, ConstantNode.forInt(0), DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
                    helper.guard(length, Condition.LT, ConstantNode.forInt(0), DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
                    helper.guard(length, Condition.GT, ConstantNode.forInt(0x3FFFFFFF), DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
                    ArrayLengthNode valueLength = b.add(new ArrayLengthNode(value));
                    SubNode limit = b.add(new SubNode(valueLength, length));
                    helper.guard(srcBegin, Condition.GT, limit, DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
                    NewArrayNode newArray = b.add(new NewArrayNode(b.getMetaAccess().lookupJavaType(Byte.TYPE), b.add(new LeftShiftNode(length, ConstantNode.forInt(1))), false));
                    b.addPush(JavaKind.Object, newArray);
                    b.add(new ArrayCopyCallNode(foreignCalls, wordTypes, value, srcBegin, newArray, ConstantNode.forInt(0), length, JavaKind.Char, LocationIdentity.init(), false, true, true, vmConfig.heapWordSize));
                    return true;
                }
            });
            utf16r.register5("getChars", (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, (Type)((Object)char[].class), Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode value, ValueNode srcBegin, ValueNode srcEnd, ValueNode dst, ValueNode dstBegin) {
                    PluginHelper helper = new PluginHelper(b, wordTypes);
                    ValueNode length = helper.sub(srcEnd, srcBegin);
                    helper.guard(srcBegin, Condition.LT, ConstantNode.forInt(0), DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
                    helper.guard(length, Condition.LT, ConstantNode.forInt(0), DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
                    ValueNode srcLimit = helper.sub(helper.rightShift(helper.length(value), 1), length);
                    helper.guard(srcBegin, Condition.GT, srcLimit, DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
                    ValueNode limit = helper.sub(helper.length(dst), length);
                    helper.guard(dstBegin, Condition.GT, limit, DeoptimizationAction.None, DeoptimizationReason.BoundsCheckException);
                    b.add(new ArrayCopyCallNode(foreignCalls, wordTypes, value, srcBegin, dst, dstBegin, length, JavaKind.Char, JavaKind.Byte, JavaKind.Char, false, true, true, vmConfig.heapWordSize));
                    return true;
                }
            });
        }
    }

    private static void registerThreadPlugins(InvocationPlugins plugins, final MetaAccessProvider metaAccess, final WordTypes wordTypes, final GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)Thread.class), replacements);
        r.register0("currentThread", new InvocationPlugin(){

            @Override
            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                CurrentJavaThreadNode thread = b.add(new CurrentJavaThreadNode(wordTypes.getWordKind()));
                ConstantNode offset = b.add(ConstantNode.forLong(config.threadObjectOffset));
                AddressNode address = b.add(new OffsetAddressNode(thread, offset));
                ObjectStamp stamp = StampFactory.objectNonNull(TypeReference.create(b.getAssumptions(), metaAccess.lookupJavaType(Thread.class)));
                ReadNode value = b.add(new ReadNode(address, HotSpotReplacementsUtil.JAVA_THREAD_THREAD_OBJECT_LOCATION, config.threadObjectFieldIsHandle ? StampFactory.forKind(wordTypes.getWordKind()) : stamp, OnHeapMemoryAccess.BarrierType.NONE));
                if (config.threadObjectFieldIsHandle) {
                    ConstantNode handleOffset = ConstantNode.forIntegerKind(wordTypes.getWordKind(), 0L, b.getGraph());
                    AddressNode handleAddress = b.add(new OffsetAddressNode(value, handleOffset));
                    value = b.add(new ReadNode(handleAddress, HotSpotReplacementsUtil.HOTSPOT_OOP_HANDLE_LOCATION, stamp, OnHeapMemoryAccess.BarrierType.NONE));
                }
                b.push(JavaKind.Object, value);
                return true;
            }
        });
        if (config.osThreadInterruptedOffset != Integer.MAX_VALUE) {
            assert (!config.threadObjectFieldIsHandle);
            r.registerMethodSubstitution(ThreadSubstitutions.class, "isInterrupted", new Type[]{InvocationPlugin.Receiver.class, Boolean.TYPE});
        }
    }

    public static String lookupIntrinsicName(GraalHotSpotVMConfig config, String className, String name1, String name2) {
        return (String)HotSpotGraphBuilderPlugins.selectIntrinsicName(config, className, name1, name2).getLeft();
    }

    public static Pair<String, String> selectIntrinsicName(GraalHotSpotVMConfig config, String className, String name1, String name2) {
        boolean foundName1 = false;
        boolean foundName2 = false;
        for (VMIntrinsicMethod intrinsic : config.getStore().getIntrinsics()) {
            if (!className.equals(intrinsic.declaringClass)) continue;
            if (name1.equals(intrinsic.name)) {
                foundName1 = true;
                continue;
            }
            if (!name2.equals(intrinsic.name)) continue;
            foundName2 = true;
        }
        if (foundName1 && !foundName2) {
            return Pair.create((Object)name1, (Object)name2);
        }
        if (foundName2 && !foundName1) {
            return Pair.create((Object)name2, (Object)name1);
        }
        throw GraalError.shouldNotReachHere();
    }

    public static boolean isIntrinsicName(GraalHotSpotVMConfig config, String className, String name) {
        for (VMIntrinsicMethod intrinsic : config.getStore().getIntrinsics()) {
            if (!className.equals(intrinsic.declaringClass) || !name.equals(intrinsic.name)) continue;
            return true;
        }
        return false;
    }

    private static void registerAESPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        if (config.useAESIntrinsics) {
            assert (config.aescryptEncryptBlockStub != 0L);
            assert (config.aescryptDecryptBlockStub != 0L);
            assert (config.cipherBlockChainingEncryptAESCryptStub != 0L);
            assert (config.cipherBlockChainingDecryptAESCryptStub != 0L);
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CipherBlockChaining", replacements);
            Pair<String, String> cbcEncryptName = HotSpotGraphBuilderPlugins.selectIntrinsicName(config, "com/sun/crypto/provider/CipherBlockChaining", "implEncrypt", "encrypt");
            HotSpotGraphBuilderPlugins.registerAndCheckMismatch(r, CipherBlockChainingSubstitutions.class, cbcEncryptName, new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE});
            Pair<String, String> cbcDecryptName = HotSpotGraphBuilderPlugins.selectIntrinsicName(config, "com/sun/crypto/provider/CipherBlockChaining", "implDecrypt", "decrypt");
            HotSpotGraphBuilderPlugins.registerAndCheckMismatch(r, CipherBlockChainingSubstitutions.class, cbcDecryptName, (String)cbcDecryptName.getLeft(), new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE});
            r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.AESCrypt", replacements);
            Pair<String, String> aesEncryptName = HotSpotGraphBuilderPlugins.selectIntrinsicName(config, "com/sun/crypto/provider/AESCrypt", "implEncryptBlock", "encryptBlock");
            HotSpotGraphBuilderPlugins.registerAndCheckMismatch(r, AESCryptSubstitutions.class, aesEncryptName, new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, byte[].class, Integer.TYPE});
            Pair<String, String> aesDecryptName = HotSpotGraphBuilderPlugins.selectIntrinsicName(config, "com/sun/crypto/provider/AESCrypt", "implDecryptBlock", "decryptBlock");
            HotSpotGraphBuilderPlugins.registerAndCheckMismatch(r, AESCryptSubstitutions.class, aesDecryptName, (String)aesDecryptName.getLeft(), new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, byte[].class, Integer.TYPE});
        }
    }

    private static void registerAndCheckMismatch(InvocationPlugins.Registration r, Class<?> substitutionClass, Pair<String, String> intrinsicNames, Type ... argumentTypes) {
        try {
            r.registerMethodSubstitution(substitutionClass, (String)intrinsicNames.getLeft(), argumentTypes);
        }
        catch (NoSuchMethodError e) {
            throw new GraalError(e, "Found method named '%s' instead of '%s' in class '%s'. This is most likely because the JVMCI JDK in %s was built on an incompatible base JDK.", intrinsicNames.getRight(), intrinsicNames.getLeft(), r.getDeclaringType().getTypeName(), Services.getSavedProperties().get("java.home"));
        }
    }

    private static void registerAndCheckMismatch(InvocationPlugins.Registration r, Class<?> substitutionClass, Pair<String, String> intrinsicNames, String substituteName, Type ... argumentTypes) {
        try {
            r.registerMethodSubstitution(substitutionClass, (String)intrinsicNames.getLeft(), substituteName, argumentTypes);
        }
        catch (NoSuchMethodError e) {
            throw new GraalError(e, "Found method named '%s' instead of '%s' in class '%s'. This is most likely because the JVMCI JDK in %s was built on an incompatible base JDK.", intrinsicNames.getRight(), intrinsicNames.getLeft(), r.getDeclaringType().getTypeName(), Services.getSavedProperties().get("java.home"));
        }
    }

    private static void registerAndCheckMismatch(InvocationPlugins.Registration r, Pair<String, String> intrinsicNames, Type arg1, Type arg2, Type arg3, InvocationPlugin plugin) {
        try {
            r.register3((String)intrinsicNames.getLeft(), arg1, arg2, arg3, plugin);
        }
        catch (NoSuchMethodError e) {
            throw new GraalError(e, "Found method named '%s' instead of '%s' in class '%s'. This is most likely because the JVMCI JDK in %s was built on an incompatible base JDK.", intrinsicNames.getRight(), intrinsicNames.getLeft(), r.getDeclaringType().getTypeName(), Services.getSavedProperties().get("java.home"));
        }
    }

    private static ValueNode arrayStart(GraphBuilderContext b, ValueNode array, JavaKind kind) {
        int byteArrayBaseOffset = b.getMetaAccess().getArrayBaseOffset(kind);
        return b.add(new ComputeObjectAddressNode(array, ConstantNode.forInt(byteArrayBaseOffset)));
    }

    private static ValueNode byteArrayStart(GraphBuilderContext b, ValueNode array) {
        JavaKind kind = JavaKind.Byte;
        return HotSpotGraphBuilderPlugins.arrayStart(b, array, kind);
    }

    private static void registerBigIntegerPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)BigInteger.class), replacements);
        assert (!config.useMultiplyToLenIntrinsic() || config.multiplyToLen != 0L);
        if (JavaVersionUtil.JAVA_SPEC <= 8) {
            r.registerConditionalMethodSubstitution(config.useMultiplyToLenIntrinsic(), BigIntegerSubstitutions.class, "multiplyToLen", "multiplyToLenStatic", new Type[]{int[].class, Integer.TYPE, int[].class, Integer.TYPE, int[].class});
        } else {
            r.registerConditionalMethodSubstitution(config.useMultiplyToLenIntrinsic(), BigIntegerSubstitutions.class, "implMultiplyToLen", "multiplyToLenStatic", new Type[]{int[].class, Integer.TYPE, int[].class, Integer.TYPE, int[].class});
        }
        if (config.useMulAddIntrinsic()) {
            r.register5("implMulAdd", (Type)((Object)int[].class), (Type)((Object)int[].class), Integer.TYPE, Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode out, ValueNode in, ValueNode offset, ValueNode len, ValueNode k) {
                    ValueNode outNonNull = b.nullCheckedValue(out);
                    ArrayLengthNode outNonNullLength = b.add(new ArrayLengthNode(outNonNull));
                    SubNode newOffset = new SubNode(outNonNullLength, offset);
                    ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.MUL_ADD, HotSpotGraphBuilderPlugins.byteArrayStart(b, outNonNull), HotSpotGraphBuilderPlugins.byteArrayStart(b, in), newOffset, len, k);
                    b.addPush(JavaKind.Int, call);
                    b.setStateAfter(call);
                    return true;
                }
            });
        }
        if (config.useMontgomeryMultiplyIntrinsic()) {
            r.register6("implMontgomeryMultiply", (Type)((Object)int[].class), (Type)((Object)int[].class), (Type)((Object)int[].class), Integer.TYPE, Long.TYPE, (Type)((Object)int[].class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode bObject, ValueNode n, ValueNode len, ValueNode inv, ValueNode product) {
                    ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.MONTGOMERY_MULTIPLY, HotSpotGraphBuilderPlugins.byteArrayStart(b, a), HotSpotGraphBuilderPlugins.byteArrayStart(b, bObject), HotSpotGraphBuilderPlugins.byteArrayStart(b, n), len, inv, HotSpotGraphBuilderPlugins.byteArrayStart(b, product));
                    b.add(call);
                    b.addPush(JavaKind.Object, product);
                    b.setStateAfter(call);
                    return true;
                }
            });
        }
        if (config.useMontgomerySquareIntrinsic()) {
            r.register5("implMontgomerySquare", (Type)((Object)int[].class), (Type)((Object)int[].class), Integer.TYPE, Long.TYPE, (Type)((Object)int[].class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode n, ValueNode len, ValueNode inv, ValueNode product) {
                    ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.MONTGOMERY_SQUARE, HotSpotGraphBuilderPlugins.byteArrayStart(b, a), HotSpotGraphBuilderPlugins.byteArrayStart(b, n), len, inv, HotSpotGraphBuilderPlugins.byteArrayStart(b, product));
                    b.add(call);
                    b.addPush(JavaKind.Object, product);
                    b.setStateAfter(call);
                    return true;
                }
            });
        }
        if (config.useSquareToLenIntrinsic()) {
            r.register4("implSquareToLen", (Type)((Object)int[].class), Integer.TYPE, (Type)((Object)int[].class), Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode x, ValueNode len, ValueNode z, ValueNode zlen) {
                    ForeignCallNode call = new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.SQUARE_TO_LEN, HotSpotGraphBuilderPlugins.byteArrayStart(b, x), len, HotSpotGraphBuilderPlugins.byteArrayStart(b, z), zlen);
                    b.add(call);
                    b.addPush(JavaKind.Object, z);
                    b.setStateAfter(call);
                    return true;
                }
            });
        }
    }

    private static void registerSHAPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        SHAInvocationPlugin plugin;
        InvocationPlugins.Registration r;
        boolean useSha1 = config.useSHA1Intrinsics();
        boolean useSha256 = config.useSHA256Intrinsics();
        boolean useSha512 = config.useSHA512Intrinsics();
        if (HotSpotGraphBuilderPlugins.isIntrinsicName(config, "sun/security/provider/DigestBase", "implCompressMultiBlock0") && (useSha1 || useSha256 || useSha512)) {
            InvocationPlugins.Registration r2 = new InvocationPlugins.Registration(plugins, "sun.security.provider.DigestBase", replacements);
            r2.registerMethodSubstitution(DigestBaseSubstitutions.class, "implCompressMultiBlock0", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE});
        }
        Pair<String, String> implCompressName = HotSpotGraphBuilderPlugins.selectIntrinsicName(config, "sun/security/provider/SHA", "implCompress", "implCompress0");
        if (useSha1) {
            assert (config.sha1ImplCompress != 0L);
            r = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA", replacements);
            plugin = new SHAInvocationPlugin(HotSpotBackend.SHA_IMPL_COMPRESS);
            HotSpotGraphBuilderPlugins.registerAndCheckMismatch(r, implCompressName, InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, plugin);
        }
        if (useSha256) {
            assert (config.sha256ImplCompress != 0L);
            r = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA2", replacements);
            plugin = new SHAInvocationPlugin(HotSpotBackend.SHA2_IMPL_COMPRESS);
            HotSpotGraphBuilderPlugins.registerAndCheckMismatch(r, implCompressName, InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, plugin);
        }
        if (useSha512) {
            assert (config.sha512ImplCompress != 0L);
            r = new InvocationPlugins.Registration(plugins, "sun.security.provider.SHA5", replacements);
            plugin = new SHAInvocationPlugin(HotSpotBackend.SHA5_IMPL_COMPRESS);
            HotSpotGraphBuilderPlugins.registerAndCheckMismatch(r, implCompressName, InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, plugin);
        }
    }

    private static void registerGHASHPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, final MetaAccessProvider metaAccess) {
        if (config.useGHASHIntrinsics()) {
            assert (config.ghashProcessBlocks != 0L);
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.GHASH");
            r.register5("processBlocks", (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, (Type)((Object)long[].class), (Type)((Object)long[].class), new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode data, ValueNode inOffset, ValueNode blocks, ValueNode state, ValueNode hashSubkey) {
                    int longArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Long);
                    int byteArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Byte);
                    ValueNode dataOffset = AddNode.create(ConstantNode.forInt(byteArrayBaseOffset), inOffset, NodeView.DEFAULT);
                    ComputeObjectAddressNode dataAddress = b.add(new ComputeObjectAddressNode(data, dataOffset));
                    ComputeObjectAddressNode stateAddress = b.add(new ComputeObjectAddressNode(state, ConstantNode.forInt(longArrayBaseOffset)));
                    ComputeObjectAddressNode hashSubkeyAddress = b.add(new ComputeObjectAddressNode(hashSubkey, ConstantNode.forInt(longArrayBaseOffset)));
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.GHASH_PROCESS_BLOCKS, stateAddress, hashSubkeyAddress, dataAddress, blocks));
                    return true;
                }
            });
        }
    }

    private static void registerCounterModePlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        if (HotSpotGraphBuilderPlugins.isIntrinsicName(config, "com/sun/crypto/provider/CounterMode", "implCrypt")) {
            assert (!config.useAESCTRIntrinsics || config.counterModeAESCrypt != 0L);
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "com.sun.crypto.provider.CounterMode", replacements);
            r.registerConditionalMethodSubstitution(config.useAESCTRIntrinsics, CounterModeSubstitutions.class, "implCrypt", new Type[]{InvocationPlugin.Receiver.class, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE});
        }
    }

    private static void registerBase64Plugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, final MetaAccessProvider metaAccess) {
        if (config.useBase64Intrinsics()) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.util.Base64$Encoder");
            r.register7("encodeBlock", (Type)((Object)InvocationPlugin.Receiver.class), (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, (Type)((Object)byte[].class), Integer.TYPE, Boolean.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode src, ValueNode sp, ValueNode sl, ValueNode dst, ValueNode dp, ValueNode isURL) {
                    int byteArrayBaseOffset = metaAccess.getArrayBaseOffset(JavaKind.Byte);
                    ComputeObjectAddressNode srcAddress = b.add(new ComputeObjectAddressNode(src, ConstantNode.forInt(byteArrayBaseOffset)));
                    ComputeObjectAddressNode dstAddress = b.add(new ComputeObjectAddressNode(dst, ConstantNode.forInt(byteArrayBaseOffset)));
                    b.add(new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.BASE64_ENCODE_BLOCK, srcAddress, sp, sl, dstAddress, dp, isURL));
                    return true;
                }
            });
        }
    }

    private static void registerCRC32Plugins(InvocationPlugins plugins, final GraalHotSpotVMConfig config, Replacements replacements) {
        if (config.useCRC32Intrinsics) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, (Type)((Object)CRC32.class), replacements);
            r.register2("update", Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode arg) {
                    GraalHotSpotVMConfigNode crcTableRawAddress = b.add(new GraalHotSpotVMConfigNode(config, HotSpotMarkId.CRC_TABLE_ADDRESS, JavaKind.Long));
                    XorNode c = new XorNode(crc, ConstantNode.forInt(-1));
                    AndNode index = new AndNode(new XorNode(arg, c), ConstantNode.forInt(255));
                    LeftShiftNode offset = new LeftShiftNode(index, ConstantNode.forInt(2));
                    OffsetAddressNode address = new OffsetAddressNode(crcTableRawAddress, new SignExtendNode(offset, 32, 64));
                    ValueNode result = b.add(new JavaReadNode(JavaKind.Int, (AddressNode)address, HotSpotBackend.CRC_TABLE_LOCATION, OnHeapMemoryAccess.BarrierType.NONE, false));
                    result = new XorNode(result, new UnsignedRightShiftNode(c, ConstantNode.forInt(8)));
                    b.addPush(JavaKind.Int, new XorNode(result, ConstantNode.forInt(-1)));
                    return true;
                }
            });
            String updateBytesName = JavaVersionUtil.JAVA_SPEC <= 8 ? "updateBytes" : "updateBytes0";
            r.register4(updateBytesName, Integer.TYPE, (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode buf, ValueNode off, ValueNode len) {
                    int byteArrayBaseOffset = b.getMetaAccess().getArrayBaseOffset(JavaKind.Byte);
                    ComputeObjectAddressNode bufAddr = b.add(new ComputeObjectAddressNode(buf, new AddNode(ConstantNode.forInt(byteArrayBaseOffset), off)));
                    b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32, crc, bufAddr, len));
                    return true;
                }
            });
            String updateByteBufferName = JavaVersionUtil.JAVA_SPEC <= 8 ? "updateByteBuffer" : "updateByteBuffer0";
            r.register4(updateByteBufferName, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode addr, ValueNode off, ValueNode len) {
                    AddNode bufAddr = b.add(new AddNode(addr, new SignExtendNode(off, 32, 64)));
                    b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32, crc, bufAddr, len));
                    return true;
                }
            });
        }
    }

    private static void registerCRC32CPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        if (JavaVersionUtil.JAVA_SPEC > 8 && config.useCRC32CIntrinsics) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "java.util.zip.CRC32C", replacements);
            r.register4("updateBytes", Integer.TYPE, (Type)((Object)byte[].class), Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode buf, ValueNode off, ValueNode end) {
                    int byteArrayBaseOffset = b.getMetaAccess().getArrayBaseOffset(JavaKind.Byte);
                    ComputeObjectAddressNode bufAddr = b.add(new ComputeObjectAddressNode(buf, new AddNode(ConstantNode.forInt(byteArrayBaseOffset), off)));
                    b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32C, crc, bufAddr, new SubNode(end, off)));
                    return true;
                }
            });
            r.register4("updateDirectByteBuffer", Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode crc, ValueNode addr, ValueNode off, ValueNode end) {
                    AddNode bufAddr = b.add(new AddNode(addr, new SignExtendNode(off, 32, 64)));
                    b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.UPDATE_BYTES_CRC32C, crc, bufAddr, new SubNode(end, off)));
                    return true;
                }
            });
        }
    }

    private static void registerArraysSupportPlugins(InvocationPlugins plugins, GraalHotSpotVMConfig config, Replacements replacements) {
        if (JavaVersionUtil.JAVA_SPEC > 8 && config.useVectorizedMismatchIntrinsic) {
            InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins, "jdk.internal.util.ArraysSupport", replacements);
            r.register6("vectorizedMismatch", (Type)((Object)Object.class), Long.TYPE, (Type)((Object)Object.class), Long.TYPE, Integer.TYPE, Integer.TYPE, new InvocationPlugin(){

                @Override
                public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode a, ValueNode aOffset, ValueNode bObject, ValueNode bOffset, ValueNode length, ValueNode log2ArrayIndexScale) {
                    ComputeObjectAddressNode aAddr = b.add(new ComputeObjectAddressNode(a, aOffset));
                    ComputeObjectAddressNode bAddr = b.add(new ComputeObjectAddressNode(bObject, bOffset));
                    b.addPush(JavaKind.Int, new ForeignCallNode((ForeignCallDescriptor)HotSpotBackend.VECTORIZED_MISMATCH, aAddr, bAddr, length, log2ArrayIndexScale));
                    return true;
                }
            });
        }
    }

    static class SHAInvocationPlugin
    implements InvocationPlugin {
        private final ForeignCallDescriptor descriptor;

        SHAInvocationPlugin(ForeignCallDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode buf, ValueNode ofs) {
            PiNode realReceiver = b.add(new PiNode(receiver.get(), targetMethod.getDeclaringClass(), false, true));
            JavaKind wordKind = JavaKind.Long;
            int stateOffset = HotSpotReplacementsUtil.getFieldOffset(targetMethod.getDeclaringClass(), "state");
            RawLoadNode state = b.add(new RawLoadNode(realReceiver, b.add(ConstantNode.forIntegerKind(wordKind, stateOffset)), JavaKind.Object, LocationIdentity.any()));
            int intArrayBaseOffset = b.getMetaAccess().getArrayBaseOffset(JavaKind.Int);
            int byteArrayBaseOffset = b.getMetaAccess().getArrayBaseOffset(JavaKind.Byte);
            ComputeObjectAddressNode bufAddr = b.add(new ComputeObjectAddressNode(buf, new AddNode(ConstantNode.forInt(byteArrayBaseOffset), ofs)));
            ComputeObjectAddressNode stateAddr = b.add(new ComputeObjectAddressNode(state, ConstantNode.forInt(intArrayBaseOffset)));
            b.add(new ForeignCallNode(this.descriptor, bufAddr, stateAddr));
            return true;
        }
    }

    static class PluginHelper {
        protected final GraphBuilderContext context;
        protected final WordTypes wordTypes;

        PluginHelper(GraphBuilderContext context, WordTypes wordTypes) {
            this.context = context;
            this.wordTypes = wordTypes;
        }

        ValueNode xor(ValueNode x, ValueNode y) {
            return this.context.add(new XorNode(x, y));
        }

        ValueNode add(ValueNode x, ValueNode y) {
            return this.context.add(new AddNode(x, y));
        }

        ValueNode sub(ValueNode x, ValueNode y) {
            return this.context.add(new SubNode(x, y));
        }

        ValueNode length(ValueNode x) {
            return this.context.add(new ArrayLengthNode(x));
        }

        ValueNode byteArrayStart(ValueNode array) {
            return this.arrayIndex(array, JavaKind.Byte, null);
        }

        ValueNode arrayIndex(ValueNode array, JavaKind kind, ValueNode index) {
            int arrayBaseOffset = this.context.getMetaAccess().getArrayBaseOffset(kind);
            ValueNode offset = ConstantNode.forInt(arrayBaseOffset);
            if (index != null) {
                offset = this.add(offset, this.scale(index, kind));
            }
            return this.context.add(new ComputeObjectAddressNode(array, offset));
        }

        private ValueNode scale(ValueNode index, JavaKind kind) {
            int arrayIndexScale = this.context.getMetaAccess().getArrayIndexScale(kind);
            return this.shl(this.asWord(index), arrayIndexScale);
        }

        private ValueNode shl(ValueNode node, int arrayIndexScale) {
            if (arrayIndexScale == 1) {
                return node;
            }
            return this.context.add(new LeftShiftNode(node, ConstantNode.forInt(arrayIndexScale)));
        }

        private ValueNode asWord(ValueNode index) {
            assert (index.getStackKind().isPrimitive());
            if (index.getStackKind() != this.wordTypes.getWordKind()) {
                return SignExtendNode.create(index, this.wordTypes.getWordKind().getBitCount(), NodeView.DEFAULT);
            }
            return index;
        }

        private LogicNode createCompare(CanonicalCondition cond, ValueNode a, ValueNode b) {
            assert (!a.getStackKind().isNumericFloat());
            switch (cond) {
                case EQ: {
                    if (a.getStackKind() == JavaKind.Object) {
                        return ObjectEqualsNode.create(this.getConstantReflection(), this.getMetaAccess(), b.getOptions(), a, b, NodeView.DEFAULT);
                    }
                    return IntegerEqualsNode.create(this.getConstantReflection(), this.getMetaAccess(), b.getOptions(), null, a, b, NodeView.DEFAULT);
                }
                case LT: {
                    assert (a.getStackKind() != JavaKind.Object);
                    return IntegerLessThanNode.create(this.getConstantReflection(), this.getMetaAccess(), b.getOptions(), null, a, b, NodeView.DEFAULT);
                }
            }
            throw GraalError.shouldNotReachHere("Unexpected condition: " + (Object)((Object)cond));
        }

        private ConstantReflectionProvider getConstantReflection() {
            return this.context.getConstantReflection();
        }

        private MetaAccessProvider getMetaAccess() {
            return this.context.getMetaAccess();
        }

        void guard(ValueNode x, Condition condition, ValueNode y, DeoptimizationAction action, DeoptimizationReason deoptReason) {
            Condition.CanonicalizedCondition canonicalizedCondition = condition.canonicalize();
            ValueNode a = x;
            ValueNode b = y;
            if (canonicalizedCondition.mustMirror()) {
                a = y;
                b = x;
            }
            LogicNode compare = this.createCompare(canonicalizedCondition.getCanonicalCondition(), a, b);
            this.context.add(new FixedGuardNode(compare, deoptReason, action, !canonicalizedCondition.mustNegate()));
        }

        public ValueNode leftShift(ValueNode node, int i) {
            return this.context.add(new LeftShiftNode(node, ConstantNode.forInt(i)));
        }

        public ValueNode rightShift(ValueNode node, int i) {
            return this.context.add(new RightShiftNode(node, ConstantNode.forInt(i)));
        }
    }
}

