/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.meta;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallSignature;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkageImpl;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.hotspot.stubs.ForeignCallStub;
import org.graalvm.compiler.hotspot.stubs.InvokeJavaMethodStub;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.word.Word;
import org.graalvm.compiler.word.WordTypes;
import org.graalvm.word.LocationIdentity;

public abstract class HotSpotForeignCallsProviderImpl
implements HotSpotForeignCallsProvider {
    public static final LocationIdentity[] NO_LOCATIONS = new LocationIdentity[0];
    public static final HotSpotForeignCallDescriptor OSR_MIGRATION_END = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, NO_LOCATIONS, "OSR_migration_end", Void.TYPE, Long.TYPE);
    public static final HotSpotForeignCallDescriptor IDENTITY_HASHCODE = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, HotSpotReplacementsUtil.MARK_WORD_LOCATION, "identity_hashcode", Integer.TYPE, Object.class);
    public static final HotSpotForeignCallDescriptor VERIFY_OOP = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, NO_LOCATIONS, "verify_oop", Object.class, Object.class);
    public static final HotSpotForeignCallDescriptor LOAD_AND_CLEAR_EXCEPTION = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF_NO_VZERO, HotSpotForeignCallDescriptor.Reexecutability.NOT_REEXECUTABLE, LocationIdentity.any(), "load_and_clear_exception", Object.class, Word.class);
    public static final HotSpotForeignCallDescriptor TEST_DEOPTIMIZE_CALL_INT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.SAFEPOINT, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, LocationIdentity.any(), "test_deoptimize_call_int", Integer.TYPE, Integer.TYPE);
    protected final HotSpotJVMCIRuntime jvmciRuntime;
    protected final HotSpotGraalRuntimeProvider runtime;
    protected final EconomicMap<ForeignCallSignature, HotSpotForeignCallLinkage> foreignCalls = EconomicMap.create();
    protected final EconomicMap<ForeignCallSignature, HotSpotForeignCallDescriptor> signatureMap = EconomicMap.create();
    protected final MetaAccessProvider metaAccess;
    protected final CodeCacheProvider codeCache;
    protected final WordTypes wordTypes;
    public static final boolean PREPEND_THREAD = true;
    public static final boolean DONT_PREPEND_THREAD = false;

    public HotSpotForeignCallsProviderImpl(HotSpotJVMCIRuntime jvmciRuntime, HotSpotGraalRuntimeProvider runtime, MetaAccessProvider metaAccess, CodeCacheProvider codeCache, WordTypes wordTypes) {
        this.jvmciRuntime = jvmciRuntime;
        this.runtime = runtime;
        this.metaAccess = metaAccess;
        this.codeCache = codeCache;
        this.wordTypes = wordTypes;
    }

    public HotSpotGraalRuntimeProvider getRuntime() {
        return this.runtime;
    }

    public HotSpotJVMCIRuntime getJVMCIRuntime() {
        return this.jvmciRuntime;
    }

    public HotSpotForeignCallLinkage register(HotSpotForeignCallLinkage linkage) {
        assert (!this.foreignCalls.containsKey((Object)linkage.getDescriptor().getSignature())) : "already registered linkage for " + linkage.getDescriptor();
        this.foreignCalls.put((Object)linkage.getDescriptor().getSignature(), (Object)linkage);
        return linkage;
    }

    public HotSpotForeignCallLinkage registerStubCall(HotSpotForeignCallDescriptor descriptor, HotSpotForeignCallLinkage.RegisterEffect effect) {
        return this.register(HotSpotForeignCallLinkageImpl.create(this.metaAccess, this.codeCache, this.wordTypes, this, descriptor, 0L, effect, (CallingConvention.Type)HotSpotCallingConventionType.JavaCall, (CallingConvention.Type)HotSpotCallingConventionType.JavaCallee));
    }

    public HotSpotForeignCallLinkage registerStubCall(ForeignCallSignature signature, HotSpotForeignCallDescriptor.Transition transition, HotSpotForeignCallDescriptor.Reexecutability reexecutability, HotSpotForeignCallLinkage.RegisterEffect effect, LocationIdentity ... killedLocations) {
        HotSpotForeignCallDescriptor descriptor = new HotSpotForeignCallDescriptor(signature, transition, reexecutability, killedLocations);
        this.signatureMap.put((Object)signature, (Object)descriptor);
        return this.registerStubCall(descriptor, effect);
    }

    public HotSpotForeignCallLinkage registerForeignCall(HotSpotForeignCallDescriptor descriptor, long address, CallingConvention.Type outgoingCcType) {
        if (address == 0L) {
            throw new IllegalArgumentException("address must be non-zero");
        }
        Class<?> resultType = descriptor.getResultType();
        assert (descriptor.getTransition() != HotSpotForeignCallDescriptor.Transition.SAFEPOINT || resultType.isPrimitive() || Word.class.isAssignableFrom(resultType)) : "non-leaf foreign calls must return objects in thread local storage: " + descriptor;
        return this.register(HotSpotForeignCallLinkageImpl.create(this.metaAccess, this.codeCache, this.wordTypes, this, descriptor, address, HotSpotForeignCallLinkage.RegisterEffect.DESTROYS_ALL_CALLER_SAVE_REGISTERS, outgoingCcType, null));
    }

    public void linkForeignCall(OptionValues options, HotSpotProviders providers, HotSpotForeignCallDescriptor descriptor, long address, boolean prependThread) {
        if (address == 0L) {
            throw new IllegalArgumentException("Can't link foreign call with zero address");
        }
        ForeignCallStub stub = new ForeignCallStub(options, this.jvmciRuntime, providers, address, descriptor, prependThread);
        HotSpotForeignCallLinkage linkage = stub.getLinkage();
        HotSpotForeignCallLinkage targetLinkage = stub.getTargetLinkage();
        linkage.setCompiledStub(stub);
        this.register(linkage);
        this.register(targetLinkage);
    }

    public void invokeJavaMethodStub(OptionValues options, HotSpotProviders providers, HotSpotForeignCallDescriptor descriptor, long address, ResolvedJavaMethod staticMethod) {
        if (address == 0L) {
            throw new IllegalArgumentException("Can't link foreign call with zero address");
        }
        InvokeJavaMethodStub stub = new InvokeJavaMethodStub(options, this.jvmciRuntime, providers, address, descriptor, staticMethod);
        HotSpotForeignCallLinkage linkage = stub.getLinkage();
        HotSpotForeignCallLinkage targetLinkage = stub.getTargetLinkage();
        linkage.setCompiledStub(stub);
        this.register(linkage);
        if (!this.foreignCalls.containsKey((Object)targetLinkage.getDescriptor().getSignature())) {
            this.register(targetLinkage);
        }
    }

    @Override
    public HotSpotForeignCallLinkage lookupForeignCall(ForeignCallDescriptor descriptor) {
        assert (this.foreignCalls != null) : descriptor;
        HotSpotForeignCallLinkage callTarget = (HotSpotForeignCallLinkage)this.foreignCalls.get((Object)descriptor.getSignature());
        if (callTarget == null) {
            throw GraalError.shouldNotReachHere("Missing implementation for runtime call: " + descriptor);
        }
        callTarget.finalizeAddress(this.runtime.getHostBackend());
        return callTarget;
    }

    @Override
    public HotSpotForeignCallDescriptor getDescriptor(ForeignCallSignature signature) {
        HotSpotForeignCallDescriptor descriptor = (HotSpotForeignCallDescriptor)this.signatureMap.get((Object)signature);
        assert (descriptor != null) : signature;
        return descriptor;
    }

    HotSpotForeignCallDescriptor createDescriptor(ForeignCallSignature signature, HotSpotForeignCallDescriptor.Transition transition, HotSpotForeignCallDescriptor.Reexecutability reexecutability, LocationIdentity ... killLocations) {
        assert (this.signatureMap.get((Object)signature) == null);
        HotSpotForeignCallDescriptor descriptor = new HotSpotForeignCallDescriptor(signature, transition, reexecutability, killLocations);
        this.signatureMap.put((Object)signature, (Object)descriptor);
        return descriptor;
    }

    public LIRKind getValueKind(JavaKind javaKind) {
        return LIRKind.fromJavaKind(this.codeCache.getTarget().arch, javaKind);
    }

    @Override
    public List<Stub> getStubs() {
        ArrayList<Stub> stubs = new ArrayList<Stub>();
        for (HotSpotForeignCallLinkage linkage : this.foreignCalls.getValues()) {
            if (!linkage.isCompiledStub()) continue;
            Stub stub = linkage.getStub();
            assert (stub != null);
            stubs.add(stub);
        }
        return stubs;
    }
}

