/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.hotspot.HotSpotMarkId;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64Call;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="CALL_INDIRECT")
final class AMD64IndirectCallOp
extends AMD64Call.IndirectCallOp {
    public static final LIRInstructionClass<AMD64IndirectCallOp> TYPE = LIRInstructionClass.create(AMD64IndirectCallOp.class);
    public static final Register METHOD = AMD64.rbx;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value metaspaceMethod;

    AMD64IndirectCallOp(ResolvedJavaMethod targetMethod, Value result, Value[] parameters, Value[] temps, Value metaspaceMethod, Value targetAddress, LIRFrameState state) {
        super(TYPE, targetMethod, result, parameters, temps, targetAddress, state);
        this.metaspaceMethod = metaspaceMethod;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        try (CompilationResultBuilder.CallContext callContext = crb.openCallContext(false);){
            crb.recordMark(HotSpotMarkId.INLINE_INVOKE);
            Register callReg = ValueUtil.asRegister((Value)this.targetAddress);
            assert (!callReg.equals((Object)METHOD));
            AMD64Call.indirectCall(crb, masm, callReg, (InvokeTarget)this.callTarget, this.state);
        }
    }

    @Override
    public void verify() {
        super.verify();
        assert (ValueUtil.asRegister((Value)this.metaspaceMethod).equals((Object)METHOD));
    }
}

