/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotCallingConventionType;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.amd64.AMD64NodeLIRBuilder;
import org.graalvm.compiler.core.amd64.AMD64NodeMatchRules;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.gen.DebugInfoBuilder;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotDebugInfoBuilder;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.HotSpotLockStack;
import org.graalvm.compiler.hotspot.HotSpotNodeLIRBuilder;
import org.graalvm.compiler.hotspot.amd64.AMD64ArrayCompareToStub;
import org.graalvm.compiler.hotspot.amd64.AMD64ArrayEqualsStub;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotDirectStaticCallOp;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotJumpToExceptionHandlerInCallerOp;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotPatchReturnAddressOp;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotSafepointOp;
import org.graalvm.compiler.hotspot.amd64.AMD64HotspotDirectVirtualCallOp;
import org.graalvm.compiler.hotspot.amd64.AMD64IndirectCallOp;
import org.graalvm.compiler.hotspot.nodes.HotSpotDirectCallTargetNode;
import org.graalvm.compiler.hotspot.nodes.HotSpotIndirectCallTargetNode;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.amd64.AMD64BreakpointOp;
import org.graalvm.compiler.lir.gen.LIRGeneratorTool;
import org.graalvm.compiler.nodes.BreakpointNode;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.DirectCallTargetNode;
import org.graalvm.compiler.nodes.FullInfopointNode;
import org.graalvm.compiler.nodes.IndirectCallTargetNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.SafepointNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.NodeValueMap;
import org.graalvm.compiler.replacements.nodes.ArrayCompareToNode;
import org.graalvm.compiler.replacements.nodes.ArrayEqualsNode;
import org.graalvm.compiler.replacements.nodes.ArrayRegionEqualsNode;

public class AMD64HotSpotNodeLIRBuilder
extends AMD64NodeLIRBuilder
implements HotSpotNodeLIRBuilder {
    public AMD64HotSpotNodeLIRBuilder(StructuredGraph graph, LIRGeneratorTool gen, AMD64NodeMatchRules nodeMatchRules) {
        super(graph, gen, nodeMatchRules);
        assert (gen instanceof AMD64HotSpotLIRGenerator);
        assert (this.getDebugInfoBuilder() instanceof HotSpotDebugInfoBuilder);
        ((AMD64HotSpotLIRGenerator)gen).setDebugInfoBuilder((HotSpotDebugInfoBuilder)this.getDebugInfoBuilder());
    }

    private AMD64HotSpotLIRGenerator getGen() {
        return (AMD64HotSpotLIRGenerator)this.gen;
    }

    @Override
    protected DebugInfoBuilder createDebugInfoBuilder(StructuredGraph graph, NodeValueMap nodeValueMap) {
        HotSpotLockStack lockStack = new HotSpotLockStack(this.gen.getResult().getFrameMapBuilder(), LIRKind.value((PlatformKind)AMD64Kind.QWORD));
        return new HotSpotDebugInfoBuilder(nodeValueMap, lockStack, (HotSpotLIRGenerator)((Object)this.gen));
    }

    @Override
    protected void emitPrologue(StructuredGraph graph) {
        CallingConvention incomingArguments = this.gen.getResult().getCallingConvention();
        Value[] params = new Value[incomingArguments.getArgumentCount() + 1];
        for (int i = 0; i < params.length - 1; ++i) {
            StackSlot slot;
            params[i] = incomingArguments.getArgument(i);
            if (!ValueUtil.isStackSlot((Value)params[i]) || !(slot = ValueUtil.asStackSlot((Value)params[i])).isInCallerFrame() || this.gen.getResult().getLIR().hasArgInCallerFrame()) continue;
            this.gen.getResult().getLIR().setHasArgInCallerFrame();
        }
        params[params.length - 1] = AMD64.rbp.asValue((ValueKind)LIRKind.value((PlatformKind)AMD64Kind.QWORD));
        this.gen.emitIncomingValues(params);
        this.getGen().emitSaveRbp();
        this.getGen().append(((HotSpotDebugInfoBuilder)this.getDebugInfoBuilder()).lockStack());
        for (ParameterNode param : graph.getNodes(ParameterNode.TYPE)) {
            Value paramValue = params[param.index()];
            assert (paramValue.getValueKind().equals((Object)this.getLIRGeneratorTool().getLIRKind(param.stamp(NodeView.DEFAULT)))) : paramValue.getValueKind() + " != " + (Object)((Object)this.getLIRGeneratorTool().getLIRKind(param.stamp(NodeView.DEFAULT))) + " for " + param.stamp(NodeView.DEFAULT);
            this.setResult(param, (Value)this.gen.emitMove(paramValue));
        }
    }

    @Override
    public void visitSafepointNode(SafepointNode i) {
        LIRFrameState info = this.state(i);
        Register thread = this.getGen().getProviders().getRegisters().getThreadRegister();
        this.append(new AMD64HotSpotSafepointOp(info, this.getGen().config, this, thread));
    }

    @Override
    protected void emitDirectCall(DirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
        CallTargetNode.InvokeKind invokeKind = ((HotSpotDirectCallTargetNode)callTarget).invokeKind();
        if (invokeKind.isIndirect()) {
            this.append(new AMD64HotspotDirectVirtualCallOp(callTarget.targetMethod(), result, parameters, temps, callState, invokeKind, this.getGen().config));
        } else {
            assert (invokeKind.isDirect());
            HotSpotResolvedJavaMethod resolvedMethod = (HotSpotResolvedJavaMethod)callTarget.targetMethod();
            assert (resolvedMethod.isConcrete()) : "Cannot make direct call to abstract method.";
            this.append(new AMD64HotSpotDirectStaticCallOp(callTarget.targetMethod(), result, parameters, temps, callState, invokeKind, this.getGen().config));
        }
    }

    @Override
    protected void emitIndirectCall(IndirectCallTargetNode callTarget, Value result, Value[] parameters, Value[] temps, LIRFrameState callState) {
        if (callTarget instanceof HotSpotIndirectCallTargetNode) {
            Value metaspaceMethodSrc = this.operand(((HotSpotIndirectCallTargetNode)callTarget).metaspaceMethod());
            Value targetAddressSrc = this.operand(callTarget.computedAddress());
            RegisterValue metaspaceMethodDst = AMD64.rbx.asValue(metaspaceMethodSrc.getValueKind());
            RegisterValue targetAddressDst = AMD64.rax.asValue(targetAddressSrc.getValueKind());
            this.gen.emitMove((AllocatableValue)metaspaceMethodDst, metaspaceMethodSrc);
            this.gen.emitMove((AllocatableValue)targetAddressDst, targetAddressSrc);
            this.append(new AMD64IndirectCallOp(callTarget.targetMethod(), result, parameters, temps, (Value)metaspaceMethodDst, (Value)targetAddressDst, callState));
        } else {
            super.emitIndirectCall(callTarget, result, parameters, temps, callState);
        }
    }

    @Override
    public void emitPatchReturnAddress(ValueNode address) {
        this.append(new AMD64HotSpotPatchReturnAddressOp(this.gen.load(this.operand(address))));
    }

    @Override
    public void emitJumpToExceptionHandlerInCaller(ValueNode handlerInCallerPc, ValueNode exception, ValueNode exceptionPc) {
        Variable handler = this.gen.load(this.operand(handlerInCallerPc));
        ForeignCallLinkage linkage = this.gen.getForeignCalls().lookupForeignCall(HotSpotBackend.EXCEPTION_HANDLER_IN_CALLER);
        CallingConvention outgoingCc = linkage.getOutgoingCallingConvention();
        assert (outgoingCc.getArgumentCount() == 2);
        RegisterValue exceptionFixed = (RegisterValue)outgoingCc.getArgument(0);
        RegisterValue exceptionPcFixed = (RegisterValue)outgoingCc.getArgument(1);
        this.gen.emitMove((AllocatableValue)exceptionFixed, this.operand(exception));
        this.gen.emitMove((AllocatableValue)exceptionPcFixed, this.operand(exceptionPc));
        Register thread = this.getGen().getProviders().getRegisters().getThreadRegister();
        AMD64HotSpotJumpToExceptionHandlerInCallerOp op = new AMD64HotSpotJumpToExceptionHandlerInCallerOp(handler, (AllocatableValue)exceptionFixed, (AllocatableValue)exceptionPcFixed, this.getGen().config.threadIsMethodHandleReturnOffset, thread);
        this.append(op);
    }

    @Override
    public void visitFullInfopointNode(FullInfopointNode i) {
        if (i.getState() != null && i.getState().bci == -3) {
            i.getDebug().log("Ignoring InfopointNode for AFTER_BCI");
        } else {
            super.visitFullInfopointNode(i);
        }
    }

    @Override
    public void visitBreakpointNode(BreakpointNode node) {
        JavaType[] sig = new JavaType[node.arguments().size()];
        for (int i = 0; i < sig.length; ++i) {
            sig[i] = ((ValueNode)node.arguments().get(i)).stamp(NodeView.DEFAULT).javaType(this.gen.getMetaAccess());
        }
        Value[] parameters = this.visitInvokeArguments(this.gen.getRegisterConfig().getCallingConvention((CallingConvention.Type)HotSpotCallingConventionType.JavaCall, null, sig, (ValueKindFactory)this.gen), node.arguments());
        this.append(new AMD64BreakpointOp(parameters));
    }

    private ForeignCallLinkage lookupForeignCall(ForeignCallDescriptor descriptor) {
        return this.getGen().getForeignCalls().lookupForeignCall(descriptor);
    }

    @Override
    public ForeignCallLinkage lookupGraalStub(ValueNode valueNode) {
        if (this.getGen().getResult().getStub() != null) {
            return null;
        }
        if (valueNode instanceof ArrayEqualsNode) {
            int constantLength;
            ArrayEqualsNode arrayEqualsNode = (ArrayEqualsNode)valueNode;
            JavaKind kind = arrayEqualsNode.getKind();
            ValueNode length = arrayEqualsNode.getLength();
            if (length.isConstant() && (constantLength = length.asJavaConstant().asInt()) >= 0 && constantLength * kind.getByteCount() < 2 * this.getGen().getMaxVectorSize()) {
                return null;
            }
            switch (kind) {
                case Boolean: {
                    return this.lookupForeignCall(AMD64ArrayEqualsStub.STUB_BOOLEAN_ARRAY_EQUALS);
                }
                case Byte: {
                    return this.lookupForeignCall(AMD64ArrayEqualsStub.STUB_BYTE_ARRAY_EQUALS);
                }
                case Char: {
                    return this.lookupForeignCall(AMD64ArrayEqualsStub.STUB_CHAR_ARRAY_EQUALS);
                }
                case Short: {
                    return this.lookupForeignCall(AMD64ArrayEqualsStub.STUB_SHORT_ARRAY_EQUALS);
                }
                case Int: {
                    return this.lookupForeignCall(AMD64ArrayEqualsStub.STUB_INT_ARRAY_EQUALS);
                }
                case Long: {
                    return this.lookupForeignCall(AMD64ArrayEqualsStub.STUB_LONG_ARRAY_EQUALS);
                }
                case Float: {
                    return this.lookupForeignCall(AMD64ArrayEqualsStub.STUB_FLOAT_ARRAY_EQUALS);
                }
                case Double: {
                    return this.lookupForeignCall(AMD64ArrayEqualsStub.STUB_DOUBLE_ARRAY_EQUALS);
                }
            }
            return null;
        }
        if (valueNode instanceof ArrayCompareToNode) {
            ArrayCompareToNode arrayCompareToNode = (ArrayCompareToNode)valueNode;
            JavaKind kind1 = arrayCompareToNode.getKind1();
            JavaKind kind2 = arrayCompareToNode.getKind2();
            if (kind1 == JavaKind.Byte) {
                if (kind2 == JavaKind.Byte) {
                    return this.lookupForeignCall(AMD64ArrayCompareToStub.STUB_BYTE_ARRAY_COMPARE_TO_BYTE_ARRAY);
                }
                if (kind2 == JavaKind.Char) {
                    return this.lookupForeignCall(AMD64ArrayCompareToStub.STUB_BYTE_ARRAY_COMPARE_TO_CHAR_ARRAY);
                }
            } else if (kind1 == JavaKind.Char) {
                if (kind2 == JavaKind.Byte) {
                    return this.lookupForeignCall(AMD64ArrayCompareToStub.STUB_CHAR_ARRAY_COMPARE_TO_BYTE_ARRAY);
                }
                if (kind2 == JavaKind.Char) {
                    return this.lookupForeignCall(AMD64ArrayCompareToStub.STUB_CHAR_ARRAY_COMPARE_TO_CHAR_ARRAY);
                }
            }
        } else if (valueNode instanceof ArrayRegionEqualsNode) {
            int constantLength;
            ArrayRegionEqualsNode arrayRegionEqualsNode = (ArrayRegionEqualsNode)valueNode;
            JavaKind kind1 = arrayRegionEqualsNode.getKind1();
            JavaKind kind2 = arrayRegionEqualsNode.getKind2();
            ValueNode length = arrayRegionEqualsNode.getLength();
            if (length.isConstant() && (constantLength = length.asJavaConstant().asInt()) >= 0 && constantLength * Math.max(kind1.getByteCount(), kind2.getByteCount()) < 2 * this.getGen().getMaxVectorSize()) {
                return null;
            }
            if (kind1 == kind2) {
                switch (kind1) {
                    case Byte: {
                        return this.lookupForeignCall(AMD64ArrayEqualsStub.STUB_BYTE_ARRAY_EQUALS_DIRECT);
                    }
                    case Char: {
                        return this.lookupForeignCall(AMD64ArrayEqualsStub.STUB_CHAR_ARRAY_EQUALS_DIRECT);
                    }
                }
                return null;
            }
            if (kind1 == JavaKind.Char && kind2 == JavaKind.Byte) {
                return this.lookupForeignCall(AMD64ArrayEqualsStub.STUB_CHAR_ARRAY_EQUALS_BYTE_ARRAY);
            }
        }
        return null;
    }
}

