/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotRestoreRbpOp;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.amd64.AMD64FrameMap;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

abstract class AMD64HotSpotEpilogueOp
extends AMD64LIRInstruction
implements AMD64HotSpotRestoreRbpOp {
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.ILLEGAL})
    private AllocatableValue savedRbp = Value.ILLEGAL;

    protected AMD64HotSpotEpilogueOp(LIRInstructionClass<? extends AMD64HotSpotEpilogueOp> c) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)c);
    }

    protected void leaveFrameAndRestoreRbp(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        AMD64HotSpotEpilogueOp.leaveFrameAndRestoreRbp(this.savedRbp, crb, masm);
    }

    static void leaveFrameAndRestoreRbp(AllocatableValue savedRbp, CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        if (Value.ILLEGAL.equals((Object)savedRbp)) {
            assert (((AMD64FrameMap)crb.frameMap).useStandardFrameProlog()) : "savedRbp is not initialized.";
        } else if (ValueUtil.isStackSlot((Value)savedRbp)) {
            masm.movq(AMD64.rbp, (AMD64Address)crb.asAddress((Value)savedRbp));
        } else {
            Register framePointer = ValueUtil.asRegister((Value)savedRbp);
            if (!framePointer.equals((Object)AMD64.rbp)) {
                masm.movq(AMD64.rbp, framePointer);
            }
        }
        crb.frameContext.leave(crb);
    }

    @Override
    public void setSavedRbp(AllocatableValue value) {
        this.savedRbp = value;
    }
}

