/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import java.util.ArrayList;
import java.util.EnumSet;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.ValueProcedure;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public final class AMD64HotSpotConstantRetrievalOp
extends AMD64LIRInstruction {
    public static final LIRInstructionClass<AMD64HotSpotConstantRetrievalOp> TYPE = LIRInstructionClass.create(AMD64HotSpotConstantRetrievalOp.class);
    @LIRInstruction.Def
    protected AllocatableValue result;
    protected final Constant[] constants;
    @LIRInstruction.Alive
    protected AllocatableValue[] constantDescriptions;
    @LIRInstruction.Temp
    protected AllocatableValue[] gotSlotOffsetParameters;
    @LIRInstruction.Temp
    protected AllocatableValue[] descriptionParameters;
    @LIRInstruction.Temp
    protected Value[] callTemps;
    @LIRInstruction.State
    protected LIRFrameState frameState;
    private final ForeignCallLinkage callLinkage;
    private final Object[] notes;

    public AMD64HotSpotConstantRetrievalOp(Constant[] constants, AllocatableValue[] constantDescriptions, LIRFrameState frameState, ForeignCallLinkage callLinkage, Object[] notes) {
        super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
        this.constantDescriptions = constantDescriptions;
        this.constants = constants;
        this.frameState = frameState;
        this.notes = notes;
        assert (constants.length == notes.length);
        CallingConvention callingConvention = callLinkage.getOutgoingCallingConvention();
        this.gotSlotOffsetParameters = new AllocatableValue[constants.length];
        int argIndex = 0;
        int i = 0;
        while (i < constants.length) {
            this.gotSlotOffsetParameters[i] = callingConvention.getArgument(argIndex);
            ++i;
            ++argIndex;
        }
        this.descriptionParameters = new AllocatableValue[constantDescriptions.length];
        i = 0;
        while (i < constantDescriptions.length) {
            this.descriptionParameters[i] = callingConvention.getArgument(argIndex);
            ++i;
            ++argIndex;
        }
        this.result = callingConvention.getReturn();
        this.callLinkage = callLinkage;
        this.callTemps = new Value[0];
        this.callTemps = LIRValueUtil.subtractRegisters(callLinkage.getTemporaries(), new CollectTemporaries().asArray());
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        int i;
        for (i = 0; i < this.constants.length; ++i) {
            crb.recordInlineDataInCodeWithNote(this.constants[i], this.notes[i]);
            masm.leaq(ValueUtil.asRegister((Value)this.gotSlotOffsetParameters[i]), masm.getPlaceholder(-1));
        }
        for (i = 0; i < this.constantDescriptions.length; ++i) {
            masm.movq(ValueUtil.asRegister((Value)this.descriptionParameters[i]), ValueUtil.asRegister((Value)this.constantDescriptions[i]));
        }
        int before = masm.directCall(false, crb.target.arch.getMachineCodeCallDisplacementOffset(), crb.target.wordSize);
        int after = masm.position();
        crb.recordDirectCall(before, after, this.callLinkage, this.frameState);
    }

    private class CollectTemporaries
    implements ValueProcedure {
        ArrayList<Value> values = new ArrayList();

        CollectTemporaries() {
            AMD64HotSpotConstantRetrievalOp.this.forEachTemp(this);
        }

        public Value[] asArray() {
            Value[] copy = new Value[this.values.size()];
            return this.values.toArray(copy);
        }

        @Override
        public Value doValue(Value value, LIRInstruction.OperandMode mode, EnumSet<LIRInstruction.OperandFlag> flags) {
            this.values.add(value);
            return value;
        }
    }
}

