/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.io.PrintStream;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.hotspot.HotSpotJVMCICompilerFactory;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotResolvedJavaMethod;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.runtime.JVMCIRuntime;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.debug.MethodFilter;
import org.graalvm.compiler.hotspot.CompilerConfigurationFactory;
import org.graalvm.compiler.hotspot.HotSpotGraalCompiler;
import org.graalvm.compiler.hotspot.HotSpotGraalJVMCIServiceLocator;
import org.graalvm.compiler.hotspot.HotSpotGraalOptionValues;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntime;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.hotspot.IsGraalPredicate;
import org.graalvm.compiler.hotspot.JVMCIVersionCheck;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.options.OptionsParser;

public final class HotSpotGraalCompilerFactory
extends HotSpotJVMCICompilerFactory {
    private static MethodFilter graalCompileOnlyFilter;
    private static boolean compileGraalWithC1Only;
    private IsGraalPredicate isGraalPredicate;
    private final HotSpotGraalJVMCIServiceLocator locator;
    private OptionValues options;
    private IllegalArgumentException optionsFailure;
    static final /* synthetic */ boolean $assertionsDisabled;

    HotSpotGraalCompilerFactory(HotSpotGraalJVMCIServiceLocator locator) {
        this.locator = locator;
    }

    public String getCompilerName() {
        return "graal";
    }

    public void onSelection() {
        JVMCIVersionCheck.check(Services.getSavedProperties(), false);
        if (!$assertionsDisabled && this.options != null) {
            throw new AssertionError((Object)("cannot select " + ((Object)((Object)this)).getClass() + " service more than once"));
        }
        try {
            this.options = HotSpotGraalOptionValues.defaultOptions();
        }
        catch (IllegalArgumentException e) {
            this.optionsFailure = e;
            return;
        }
        HotSpotGraalCompilerFactory.initializeGraalCompilePolicyFields(this.options);
        IsGraalPredicate isGraalPredicate = this.isGraalPredicate = compileGraalWithC1Only ? new IsGraalPredicate() : null;
        if (this.isGraalPredicate != null && this.isGraalPredicate.getCompilationLevelAdjustment() != HotSpotJVMCICompilerFactory.CompilationLevelAdjustment.None) {
            this.adjustCompilationLevelInternal(Object.class, HotSpotJVMCICompilerFactory.CompilationLevel.FullOptimization);
            this.adjustCompilationLevelInternal(Object.class, HotSpotJVMCICompilerFactory.CompilationLevel.Simple);
        }
        if (Services.IS_BUILDING_NATIVE_IMAGE) {
            Options.CompileGraalWithC1Only.getName();
        }
    }

    private static void initializeGraalCompilePolicyFields(OptionValues options) {
        compileGraalWithC1Only = Options.CompileGraalWithC1Only.getValue(options) != false && !Services.IS_IN_NATIVE_IMAGE;
        String optionValue = Options.GraalCompileOnly.getValue(options);
        if (optionValue != null) {
            MethodFilter filter = MethodFilter.parse(optionValue);
            if (filter.matchesNothing()) {
                filter = null;
            }
            graalCompileOnlyFilter = filter;
        }
    }

    public void printProperties(PrintStream out) {
        out.println("[Graal properties]");
        if (this.optionsFailure != null) {
            System.err.printf("Error parsing Graal options: %s%n", this.optionsFailure.getMessage());
            return;
        }
        this.options.printHelp(OptionsParser.getOptionsLoader(), out, "graal.");
    }

    public HotSpotGraalCompiler createCompiler(JVMCIRuntime runtime) {
        HotSpotJVMCIRuntime hsRuntime = (HotSpotJVMCIRuntime)runtime;
        if (this.optionsFailure != null) {
            System.err.printf("Error parsing Graal options: %s%nError: A fatal exception has occurred. Program will exit.%n", this.optionsFailure.getMessage());
            HotSpotGraalServices.exit(1, hsRuntime);
        }
        CompilerConfigurationFactory factory = CompilerConfigurationFactory.selectFactory(null, this.options, hsRuntime);
        if (this.isGraalPredicate != null) {
            this.isGraalPredicate.onCompilerConfigurationFactorySelection(hsRuntime, factory);
        }
        HotSpotGraalCompiler compiler = HotSpotGraalCompilerFactory.createCompiler("VM", runtime, this.options, factory);
        this.locator.onCompilerCreation(compiler);
        return compiler;
    }

    public static HotSpotGraalCompiler createCompiler(String runtimeNameQualifier, JVMCIRuntime runtime, OptionValues options, CompilerConfigurationFactory compilerConfigurationFactory) {
        HotSpotJVMCIRuntime jvmciRuntime = (HotSpotJVMCIRuntime)runtime;
        try (InitTimer t = InitTimer.timer((String)"HotSpotGraalRuntime.<init>");){
            HotSpotGraalRuntime graalRuntime = new HotSpotGraalRuntime(runtimeNameQualifier, jvmciRuntime, compilerConfigurationFactory, options);
            HotSpotGraalCompiler hotSpotGraalCompiler = new HotSpotGraalCompiler(jvmciRuntime, graalRuntime, graalRuntime.getOptions());
            return hotSpotGraalCompiler;
        }
    }

    public HotSpotJVMCICompilerFactory.CompilationLevelAdjustment getCompilationLevelAdjustment() {
        return this.isGraalPredicate != null ? this.isGraalPredicate.getCompilationLevelAdjustment() : HotSpotJVMCICompilerFactory.CompilationLevelAdjustment.None;
    }

    public HotSpotJVMCICompilerFactory.CompilationLevel adjustCompilationLevel(Object declaringClassObject, String name, String signature, boolean isOsr, HotSpotJVMCICompilerFactory.CompilationLevel level) {
        Class declaringClass = (Class)declaringClassObject;
        return this.adjustCompilationLevelInternal(declaringClass, level);
    }

    private HotSpotJVMCICompilerFactory.CompilationLevel adjustCompilationLevelInternal(Class<?> declaringClass, HotSpotJVMCICompilerFactory.CompilationLevel level) {
        if (!$assertionsDisabled && this.isGraalPredicate == null) {
            throw new AssertionError();
        }
        if (level.ordinal() > HotSpotJVMCICompilerFactory.CompilationLevel.Simple.ordinal() && this.isGraalPredicate.apply(declaringClass)) {
            return HotSpotJVMCICompilerFactory.CompilationLevel.Simple;
        }
        return level;
    }

    static boolean shouldExclude(HotSpotResolvedJavaMethod method) {
        if (graalCompileOnlyFilter != null) {
            Signature signature;
            String name;
            String javaClassName = method.getDeclaringClass().toJavaName();
            return !graalCompileOnlyFilter.matches(javaClassName, name = method.getName(), signature = method.getSignature());
        }
        return false;
    }

    static {
        boolean bl = $assertionsDisabled = !HotSpotGraalCompilerFactory.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !Services.class.getName().equals("jdk.vm.ci.services.Services")) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !HotSpotGraalCompilerFactory.class.getName().equals("org.graalvm.compiler.hotspot.HotSpotGraalCompilerFactory")) {
            throw new AssertionError();
        }
    }

    static class Options {
        @Option(help={"In tiered mode compile Graal and JVMCI using optimized first tier code."}, type=OptionType.Expert)
        public static final OptionKey<Boolean> CompileGraalWithC1Only = new OptionKey<Boolean>(true);
        @Option(help={"A filter applied to a method the VM has selected for compilation by Graal. A method not matching the filter is redirected to a lower tier compiler. The filter format is the same as for the MethodFilter option."}, type=OptionType.Expert)
        public static final OptionKey<String> GraalCompileOnly = new OptionKey<Object>(null);

        Options() {
        }
    }
}

