/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.common.InitTimer;
import jdk.vm.ci.hotspot.HotSpotCodeCacheProvider;
import jdk.vm.ci.hotspot.HotSpotConstantReflectionProvider;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.runtime.JVMCIBackend;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotGraalRuntimeProvider;
import org.graalvm.compiler.hotspot.HotSpotReplacementsImpl;
import org.graalvm.compiler.hotspot.HotSpotSnippetMetaAccessProvider;
import org.graalvm.compiler.hotspot.SnippetSignature;
import org.graalvm.compiler.hotspot.meta.HotSpotGraalConstantFieldProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotHostForeignCallsProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotLoweringProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotMetaAccessExtensionProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotPlatformConfigurationProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotSnippetReflectionProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotStampProvider;
import org.graalvm.compiler.hotspot.meta.HotSpotSuitesProvider;
import org.graalvm.compiler.hotspot.word.HotSpotWordTypes;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.loop.LoopsDataProviderImpl;
import org.graalvm.compiler.nodes.spi.LoopsDataProvider;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.tiers.CompilerConfiguration;
import org.graalvm.compiler.replacements.classfile.ClassfileBytecodeProvider;

public abstract class HotSpotBackendFactory {
    protected HotSpotGraalConstantFieldProvider createConstantFieldProvider(GraalHotSpotVMConfig config, MetaAccessProvider metaAccess) {
        return new HotSpotGraalConstantFieldProvider(config, metaAccess);
    }

    protected HotSpotWordTypes createWordTypes(MetaAccessProvider metaAccess, TargetDescription target) {
        return new HotSpotWordTypes(HotSpotReplacementsImpl.noticeTypes(metaAccess), target.wordJavaKind);
    }

    protected HotSpotStampProvider createStampProvider() {
        return new HotSpotStampProvider();
    }

    protected HotSpotPlatformConfigurationProvider createConfigInfoProvider(GraalHotSpotVMConfig config, MetaAccessProvider metaAccess) {
        return new HotSpotPlatformConfigurationProvider(config, metaAccess);
    }

    protected HotSpotMetaAccessExtensionProvider createMetaAccessExtensionProvider() {
        return new HotSpotMetaAccessExtensionProvider();
    }

    protected HotSpotReplacementsImpl createReplacements(TargetDescription target, HotSpotProviders p, HotSpotSnippetReflectionProvider snippetReflection, BytecodeProvider bytecodeProvider) {
        return new HotSpotReplacementsImpl(p, snippetReflection, bytecodeProvider, target);
    }

    protected ClassfileBytecodeProvider createBytecodeProvider(MetaAccessProvider metaAccess, HotSpotSnippetReflectionProvider snippetReflection) {
        return new ClassfileBytecodeProvider(metaAccess, snippetReflection);
    }

    protected HotSpotSnippetReflectionProvider createSnippetReflection(HotSpotGraalRuntimeProvider runtime, HotSpotConstantReflectionProvider constantReflection, HotSpotWordTypes wordTypes) {
        return new HotSpotSnippetReflectionProvider(runtime, constantReflection, wordTypes);
    }

    public abstract String getName();

    public abstract Class<? extends Architecture> getArchitecture();

    protected LoopsDataProvider createLoopsDataProvider() {
        return new LoopsDataProviderImpl();
    }

    public final HotSpotBackend createBackend(HotSpotGraalRuntimeProvider graalRuntime, CompilerConfiguration compilerConfiguration, HotSpotJVMCIRuntime jvmciRuntime, HotSpotBackend host) {
        HotSpotProviders providers;
        assert (host == null);
        OptionValues options = graalRuntime.getOptions();
        JVMCIBackend jvmci = jvmciRuntime.getHostJVMCIBackend();
        GraalHotSpotVMConfig config = graalRuntime.getVMConfig();
        if (Services.IS_BUILDING_NATIVE_IMAGE || Services.IS_IN_NATIVE_IMAGE) {
            SnippetSignature.initPrimitiveKindCache(jvmci.getMetaAccess());
        }
        HotSpotCodeCacheProvider codeCache = (HotSpotCodeCacheProvider)jvmci.getCodeCache();
        TargetDescription target = codeCache.getTarget();
        HotSpotSnippetMetaAccessProvider metaAccess = new HotSpotSnippetMetaAccessProvider(jvmci.getMetaAccess());
        HotSpotConstantReflectionProvider constantReflection = (HotSpotConstantReflectionProvider)jvmci.getConstantReflection();
        HotSpotGraalConstantFieldProvider constantFieldProvider = new HotSpotGraalConstantFieldProvider(config, metaAccess);
        try (InitTimer t = InitTimer.timer((String)"create providers");){
            HotSpotSuitesProvider suites;
            GraphBuilderConfiguration.Plugins plugins;
            HotSpotReplacementsImpl replacements;
            ClassfileBytecodeProvider bytecodeProvider;
            HotSpotSnippetReflectionProvider snippetReflection;
            LoopsDataProvider loopsDataProvider;
            HotSpotLoweringProvider lowerer;
            HotSpotStampProvider stampProvider;
            HotSpotMetaAccessExtensionProvider metaAccessExtensionProvider;
            HotSpotPlatformConfigurationProvider platformConfigurationProvider;
            HotSpotHostForeignCallsProvider foreignCalls;
            HotSpotWordTypes wordTypes;
            Value[] nativeABICallerSaveRegisters;
            HotSpotRegistersProvider registers;
            try (InitTimer rt = InitTimer.timer((String)"create HotSpotRegisters provider");){
                registers = this.createRegisters();
            }
            rt = InitTimer.timer((String)"create NativeABICallerSaveRegisters");
            var31_19 = null;
            try {
                nativeABICallerSaveRegisters = this.createNativeABICallerSaveRegisters(config, codeCache.getRegisterConfig());
            }
            catch (Throwable throwable) {
                var31_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create WordTypes");
            var31_19 = null;
            try {
                wordTypes = this.createWordTypes(metaAccess, target);
            }
            catch (Throwable throwable) {
                var31_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create ForeignCalls provider");
            var31_19 = null;
            try {
                foreignCalls = this.createForeignCalls(jvmciRuntime, graalRuntime, metaAccess, codeCache, wordTypes, nativeABICallerSaveRegisters);
            }
            catch (Throwable throwable) {
                var31_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create platform configuration provider");
            var31_19 = null;
            try {
                platformConfigurationProvider = this.createConfigInfoProvider(config, metaAccess);
            }
            catch (Throwable throwable) {
                var31_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create MetaAccessExtensionProvider");
            var31_19 = null;
            try {
                metaAccessExtensionProvider = this.createMetaAccessExtensionProvider();
            }
            catch (Throwable throwable) {
                var31_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create stamp provider");
            var31_19 = null;
            try {
                stampProvider = this.createStampProvider();
            }
            catch (Throwable throwable) {
                var31_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create Lowerer provider");
            var31_19 = null;
            try {
                lowerer = this.createLowerer(graalRuntime, metaAccess, foreignCalls, registers, constantReflection, platformConfigurationProvider, metaAccessExtensionProvider, target);
            }
            catch (Throwable throwable) {
                var31_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create loopsdata provider");
            var31_19 = null;
            try {
                loopsDataProvider = this.createLoopsDataProvider();
            }
            catch (Throwable throwable) {
                var31_19 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var31_19 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var31_19.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            HotSpotProviders p = new HotSpotProviders(metaAccess, (CodeCacheProvider)codeCache, (ConstantReflectionProvider)constantReflection, constantFieldProvider, foreignCalls, lowerer, null, stampProvider, platformConfigurationProvider, metaAccessExtensionProvider, loopsDataProvider);
            try (InitTimer rt = InitTimer.timer((String)"create SnippetReflection provider");){
                snippetReflection = this.createSnippetReflection(graalRuntime, constantReflection, wordTypes);
            }
            rt = InitTimer.timer((String)"create Bytecode provider");
            var32_26 = null;
            try {
                bytecodeProvider = this.createBytecodeProvider(metaAccess, snippetReflection);
            }
            catch (Throwable throwable) {
                var32_26 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var32_26 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var32_26.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create Replacements provider");
            var32_26 = null;
            try {
                replacements = this.createReplacements(target, p, snippetReflection, bytecodeProvider);
            }
            catch (Throwable throwable) {
                var32_26 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var32_26 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var32_26.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create GraphBuilderPhase plugins");
            var32_26 = null;
            try {
                plugins = this.createGraphBuilderPlugins(graalRuntime, compilerConfiguration, config, target, constantReflection, foreignCalls, metaAccess, snippetReflection, replacements, wordTypes, options);
                replacements.setGraphBuilderPlugins(plugins);
            }
            catch (Throwable throwable) {
                var32_26 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var32_26 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var32_26.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            rt = InitTimer.timer((String)"create Suites provider");
            var32_26 = null;
            try {
                suites = this.createSuites(config, graalRuntime, compilerConfiguration, plugins, registers, replacements, options);
            }
            catch (Throwable throwable) {
                var32_26 = throwable;
                throw throwable;
            }
            finally {
                if (rt != null) {
                    if (var32_26 != null) {
                        try {
                            rt.close();
                        }
                        catch (Throwable throwable) {
                            var32_26.addSuppressed(throwable);
                        }
                    } else {
                        rt.close();
                    }
                }
            }
            providers = new HotSpotProviders(metaAccess, codeCache, (ConstantReflectionProvider)constantReflection, constantFieldProvider, foreignCalls, lowerer, replacements, suites, registers, snippetReflection, wordTypes, plugins, platformConfigurationProvider, metaAccessExtensionProvider, loopsDataProvider, config);
            replacements.setProviders(providers);
            replacements.maybeInitializeEncoder(options);
        }
        var29_14 = null;
        try (InitTimer rt = InitTimer.timer((String)"instantiate backend");){
            HotSpotBackend hotSpotBackend = this.createBackend(config, graalRuntime, providers);
            return hotSpotBackend;
        }
        catch (Throwable throwable) {
            var29_14 = throwable;
            throw throwable;
        }
    }

    protected abstract HotSpotBackend createBackend(GraalHotSpotVMConfig var1, HotSpotGraalRuntimeProvider var2, HotSpotProviders var3);

    protected abstract Value[] createNativeABICallerSaveRegisters(GraalHotSpotVMConfig var1, RegisterConfig var2);

    protected abstract GraphBuilderConfiguration.Plugins createGraphBuilderPlugins(HotSpotGraalRuntimeProvider var1, CompilerConfiguration var2, GraalHotSpotVMConfig var3, TargetDescription var4, HotSpotConstantReflectionProvider var5, HotSpotHostForeignCallsProvider var6, MetaAccessProvider var7, HotSpotSnippetReflectionProvider var8, HotSpotReplacementsImpl var9, HotSpotWordTypes var10, OptionValues var11);

    protected abstract HotSpotSuitesProvider createSuites(GraalHotSpotVMConfig var1, HotSpotGraalRuntimeProvider var2, CompilerConfiguration var3, GraphBuilderConfiguration.Plugins var4, HotSpotRegistersProvider var5, HotSpotReplacementsImpl var6, OptionValues var7);

    protected abstract HotSpotRegistersProvider createRegisters();

    protected abstract HotSpotLoweringProvider createLowerer(HotSpotGraalRuntimeProvider var1, MetaAccessProvider var2, HotSpotHostForeignCallsProvider var3, HotSpotRegistersProvider var4, HotSpotConstantReflectionProvider var5, HotSpotPlatformConfigurationProvider var6, HotSpotMetaAccessExtensionProvider var7, TargetDescription var8);

    protected abstract HotSpotHostForeignCallsProvider createForeignCalls(HotSpotJVMCIRuntime var1, HotSpotGraalRuntimeProvider var2, MetaAccessProvider var3, HotSpotCodeCacheProvider var4, HotSpotWordTypes var5, Value[] var6);
}

