/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import java.util.Arrays;
import java.util.Iterator;
import java.util.function.BiFunction;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.MapCursor;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeIdAccessor;
import org.graalvm.compiler.graph.VerificationError;

public class NodeMap<T>
extends NodeIdAccessor
implements EconomicMap<Node, T> {
    private static final int MIN_REALLOC_SIZE = 16;
    protected Object[] values;

    public NodeMap(Graph graph) {
        super(graph);
        this.values = new Object[graph.nodeIdCount()];
    }

    public NodeMap(NodeMap<T> copyFrom) {
        super(copyFrom.graph);
        this.values = Arrays.copyOf(copyFrom.values, copyFrom.values.length);
    }

    public T get(Node node) {
        assert (this.check(node));
        return (T)this.values[this.getNodeId(node)];
    }

    public T getAndGrow(Node node) {
        this.checkAndGrow(node);
        return (T)this.values[this.getNodeId(node)];
    }

    private void checkAndGrow(Node node) {
        if (this.isNew(node)) {
            this.values = Arrays.copyOf(this.values, Math.max(16, this.graph.nodeIdCount() * 3 / 2));
        }
        assert (this.check(node));
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("isEmpty() is not supported for performance reasons");
    }

    public boolean containsKey(Node node) {
        if (node.graph() == this.graph()) {
            return this.get(node) != null;
        }
        return false;
    }

    public boolean containsValue(Object value) {
        for (Object o : this.values) {
            if (o != value) continue;
            return true;
        }
        return false;
    }

    public Graph graph() {
        return this.graph;
    }

    public void set(Node node, T value) {
        assert (this.check(node));
        if (!node.isAlive()) {
            throw new VerificationError("this node is not alive: " + node, new Object[0]);
        }
        this.values[this.getNodeId((Node)node)] = value;
    }

    public void setAndGrow(Node node, T value) {
        this.checkAndGrow(node);
        this.set(node, value);
    }

    protected Node getKey(int i) {
        return this.graph.getNode(i);
    }

    public int size() {
        throw new UnsupportedOperationException("size() is not supported for performance reasons");
    }

    public int capacity() {
        return this.values.length;
    }

    public boolean isNew(Node node) {
        return this.getNodeId(node) >= this.capacity();
    }

    private boolean check(Node node) {
        assert (node.graph() == this.graph) : String.format("%s is not part of the graph", node);
        assert (!this.isNew(node)) : "this node was added to the graph after creating the node map : " + node;
        assert (node.isAlive()) : "this node is not alive: " + node;
        return true;
    }

    public void clear() {
        Arrays.fill(this.values, null);
    }

    public Iterable<Node> getKeys() {
        return new Iterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new Iterator<Node>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        this.forward();
                        return this.i < NodeMap.this.values.length;
                    }

                    @Override
                    public Node next() {
                        int pos = this.i++;
                        Node key = NodeMap.this.getKey(pos);
                        this.forward();
                        return key;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private void forward() {
                        while (this.i < NodeMap.this.values.length && (NodeMap.this.getKey(this.i) == null || NodeMap.this.values[this.i] == null)) {
                            ++this.i;
                        }
                    }
                };
            }
        };
    }

    public MapCursor<Node, T> getEntries() {
        return new MapCursor<Node, T>(){
            int current = -1;

            public boolean advance() {
                ++this.current;
                while (this.current < NodeMap.this.values.length && (NodeMap.this.values[this.current] == null || NodeMap.this.getKey(this.current) == null)) {
                    ++this.current;
                }
                return this.current < NodeMap.this.values.length;
            }

            public Node getKey() {
                return NodeMap.this.getKey(this.current);
            }

            public T getValue() {
                return NodeMap.this.values[this.current];
            }

            public void remove() {
                assert (NodeMap.this.values[this.current] != null);
                NodeMap.this.values[this.current] = null;
            }
        };
    }

    public Iterable<T> getValues() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        this.forward();
                        return this.i < NodeMap.this.values.length;
                    }

                    @Override
                    public T next() {
                        int pos = this.i++;
                        Object value = NodeMap.this.values[pos];
                        this.forward();
                        return value;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    private void forward() {
                        while (this.i < NodeMap.this.values.length && (NodeMap.this.getKey(this.i) == null || NodeMap.this.values[this.i] == null)) {
                            ++this.i;
                        }
                    }
                };
            }
        };
    }

    public String toString() {
        MapCursor<Node, T> i = this.getEntries();
        if (!i.advance()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        while (true) {
            Node key = (Node)i.getKey();
            Object value = i.getValue();
            sb.append(key);
            sb.append('=');
            sb.append(value);
            if (!i.advance()) {
                return sb.append('}').toString();
            }
            sb.append(',').append(' ');
        }
    }

    public T put(Node key, T value) {
        T result = this.get(key);
        this.set(key, value);
        return result;
    }

    public T removeKey(Node key) {
        return this.put(key, null);
    }

    public void replaceAll(BiFunction<? super Node, ? super T, ? extends T> function) {
        for (Node n : this.getKeys()) {
            this.put(n, function.apply((Node)((Node)n), (Node)this.get(n)));
        }
    }
}

