/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.FieldIntrospection;
import org.graalvm.compiler.core.common.Fields;
import org.graalvm.compiler.core.common.FieldsScanner;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.graph.Edges;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.InputEdges;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.NodeList;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.NodeStack;
import org.graalvm.compiler.graph.NodeSuccessorList;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.graph.SuccessorEdges;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.graph.spi.Canonicalizable;
import org.graalvm.compiler.graph.spi.Simplifiable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import sun.misc.Unsafe;

public final class NodeClass<T>
extends FieldIntrospection<T> {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    private static final TimerKey Init_FieldScanning = DebugContext.timer("NodeClass.Init.FieldScanning");
    private static final TimerKey Init_FieldScanningInner = DebugContext.timer("NodeClass.Init.FieldScanning.Inner");
    private static final TimerKey Init_AnnotationParsing = DebugContext.timer("NodeClass.Init.AnnotationParsing");
    private static final TimerKey Init_Edges = DebugContext.timer("NodeClass.Init.Edges");
    private static final TimerKey Init_Data = DebugContext.timer("NodeClass.Init.Data");
    private static final TimerKey Init_AllowedUsages = DebugContext.timer("NodeClass.Init.AllowedUsages");
    private static final TimerKey Init_IterableIds = DebugContext.timer("NodeClass.Init.IterableIds");
    public static final long MAX_EDGES = 8L;
    public static final long MAX_LIST_EDGES = 6L;
    public static final long OFFSET_MASK = 252L;
    public static final long LIST_MASK = 1L;
    public static final long NEXT_EDGE = 8L;
    private static final Class<?> NODE_CLASS = Node.class;
    private static final Class<?> INPUT_LIST_CLASS = NodeInputList.class;
    private static final Class<?> SUCCESSOR_LIST_CLASS = NodeSuccessorList.class;
    private static final AtomicInteger nextIterableId = new AtomicInteger();
    private static final AtomicInteger nextLeafId = new AtomicInteger();
    private final InputEdges inputs;
    private final SuccessorEdges successors;
    private final NodeClass<? super T> superNodeClass;
    private final boolean canGVN;
    private final int startGVNNumber;
    private final String nameTemplate;
    private final int iterableId;
    private final EnumSet<InputType> allowedUsageTypes;
    private int[] iterableIds;
    private final long inputsIteration;
    private final long successorIteration;
    private static final CounterKey ITERABLE_NODE_TYPES = DebugContext.counter("IterableNodeTypes");
    private final boolean isCanonicalizable;
    private final boolean isCommutative;
    private final boolean isSimplifiable;
    private final boolean isLeafNode;
    private final int leafId;
    private final NodeCycles cycles;
    private final NodeSize size;
    private String shortName;

    private static <T extends Annotation> T getAnnotationTimed(AnnotatedElement e, Class<T> annotationClass, DebugContext debug) {
        try (DebugCloseable s = Init_AnnotationParsing.start(debug);){
            T t = e.getAnnotation(annotationClass);
            return t;
        }
    }

    public static <T> NodeClass<T> create(Class<T> c) {
        assert (NodeClass.getUnchecked(c) == null);
        Class<T> superclass = c.getSuperclass();
        NodeClass<T> nodeSuperclass = null;
        if (superclass != NODE_CLASS) {
            nodeSuperclass = NodeClass.get(superclass);
        }
        return new NodeClass<T>(c, nodeSuperclass);
    }

    private static <T> NodeClass<T> getUnchecked(Class<T> clazz) {
        try {
            Field field = clazz.getDeclaredField("TYPE");
            field.setAccessible(true);
            return (NodeClass)field.get(null);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException("Could not load Graal NodeClass TYPE field for " + clazz, e);
        }
    }

    public static <T> NodeClass<T> get(Class<T> clazz) {
        NodeClass<T> result = NodeClass.getUnchecked(clazz);
        if (result == null && clazz != NODE_CLASS) {
            throw GraalError.shouldNotReachHere("TYPE field not initialized for class " + clazz.getTypeName());
        }
        return result;
    }

    public NodeClass(Class<T> clazz, NodeClass<? super T> superNodeClass) {
        this(clazz, superNodeClass, new FieldsScanner.DefaultCalcOffset(), null, 0);
    }

    public NodeClass(Class<T> clazz, NodeClass<? super T> superNodeClass, FieldsScanner.CalcOffset calcOffset, int[] presetIterableIds, int presetIterableId) {
        super(clazz);
        DebugContext debug = DebugContext.forCurrentThread();
        this.superNodeClass = superNodeClass;
        assert (NODE_CLASS.isAssignableFrom(clazz));
        this.isCanonicalizable = Canonicalizable.class.isAssignableFrom(clazz);
        this.isCommutative = Canonicalizable.BinaryCommutative.class.isAssignableFrom(clazz);
        if (Canonicalizable.Unary.class.isAssignableFrom(clazz) || Canonicalizable.Binary.class.isAssignableFrom(clazz)) assert (Canonicalizable.Unary.class.isAssignableFrom(clazz) ^ Canonicalizable.Binary.class.isAssignableFrom(clazz)) : clazz + " should implement either Unary or Binary, not both";
        this.isSimplifiable = Simplifiable.class.isAssignableFrom(clazz);
        NodeFieldsScanner fs = new NodeFieldsScanner(calcOffset, superNodeClass, debug);
        try (DebugCloseable t = Init_FieldScanning.start(debug);){
            fs.scan(clazz, clazz.getSuperclass(), false);
        }
        var9_9 = null;
        try (DebugCloseable t1 = Init_Edges.start(debug);){
            this.successors = new SuccessorEdges(fs.directSuccessors, fs.successors);
            this.successorIteration = NodeClass.computeIterationMask(this.successors.type(), this.successors.getDirectCount(), this.successors.getOffsets());
            this.inputs = new InputEdges(fs.directInputs, fs.inputs);
            this.inputsIteration = NodeClass.computeIterationMask(this.inputs.type(), this.inputs.getDirectCount(), this.inputs.getOffsets());
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        t1 = Init_Data.start(debug);
        var9_9 = null;
        try {
            this.data = Fields.create(fs.data);
        }
        catch (Throwable throwable) {
            var9_9 = throwable;
            throw throwable;
        }
        finally {
            if (t1 != null) {
                if (var9_9 != null) {
                    try {
                        t1.close();
                    }
                    catch (Throwable throwable) {
                        var9_9.addSuppressed(throwable);
                    }
                } else {
                    t1.close();
                }
            }
        }
        this.isLeafNode = this.inputs.getCount() + this.successors.getCount() == 0;
        this.leafId = this.isLeafNode ? nextLeafId.getAndIncrement() : -1;
        this.canGVN = Node.ValueNumberable.class.isAssignableFrom(clazz);
        this.startGVNNumber = clazz.getName().hashCode();
        NodeInfo info = NodeClass.getAnnotationTimed(clazz, NodeInfo.class, debug);
        assert (info != null) : "Missing NodeInfo annotation on " + clazz;
        this.nameTemplate = !info.nameTemplate().isEmpty() ? info.nameTemplate() : (!info.shortName().isEmpty() ? info.shortName() : "");
        try (DebugCloseable t1 = Init_AllowedUsages.start(debug);){
            this.allowedUsageTypes = superNodeClass == null ? EnumSet.noneOf(InputType.class) : superNodeClass.allowedUsageTypes.clone();
            this.allowedUsageTypes.addAll(Arrays.asList(info.allowedUsageTypes()));
        }
        if (presetIterableIds != null) {
            this.iterableIds = presetIterableIds;
            this.iterableId = presetIterableId;
        } else if (IterableNodeType.class.isAssignableFrom(clazz)) {
            ITERABLE_NODE_TYPES.increment(debug);
            t1 = Init_IterableIds.start(debug);
            var10_14 = null;
            try {
                this.iterableId = nextIterableId.getAndIncrement();
                NodeClass<T> snc = superNodeClass;
                while (snc != null && IterableNodeType.class.isAssignableFrom(snc.getClazz())) {
                    super.addIterableId(this.iterableId);
                    snc = snc.superNodeClass;
                }
                this.iterableIds = new int[]{this.iterableId};
            }
            catch (Throwable snc) {
                var10_14 = snc;
                throw snc;
            }
            finally {
                if (t1 != null) {
                    if (var10_14 != null) {
                        try {
                            t1.close();
                        }
                        catch (Throwable snc) {
                            var10_14.addSuppressed(snc);
                        }
                    } else {
                        t1.close();
                    }
                }
            }
        } else {
            this.iterableId = -1;
            this.iterableIds = null;
        }
        assert (this.verifyIterableIds());
        var10_14 = null;
        try (DebugContext.Scope scope = debug.scope("NodeCosts");){
            NodeCycles c = info.cycles();
            this.cycles = c == NodeCycles.CYCLES_UNSET ? (superNodeClass != null ? superNodeClass.cycles : NodeCycles.CYCLES_UNSET) : c;
            assert (this.cycles != null);
            NodeSize s = info.size();
            this.size = s == NodeSize.SIZE_UNSET ? (superNodeClass != null ? superNodeClass.size : NodeSize.SIZE_UNSET) : s;
            assert (this.size != null);
            debug.log("Node cost for node of type __| %s |_, cycles:%s,size:%s", clazz, (Object)this.cycles, (Object)this.size);
        }
        catch (Throwable throwable) {
            var10_14 = throwable;
            throw throwable;
        }
        assert (NodeClass.verifyMemoryEdgeInvariant(fs)) : "Nodes participating in the memory graph should have at most 1 optional memory input.";
    }

    private static boolean verifyMemoryEdgeInvariant(NodeFieldsScanner fs) {
        int optionalMemoryInputs = 0;
        for (InputInfo info : fs.inputs) {
            if (!info.optional || info.inputType != InputType.Memory) continue;
            ++optionalMemoryInputs;
        }
        return optionalMemoryInputs <= 1;
    }

    public NodeCycles cycles() {
        return this.cycles;
    }

    public NodeSize size() {
        return this.size;
    }

    public static long computeIterationMask(Edges.Type type, int directCount, long[] offsets) {
        long mask = 0L;
        if ((long)offsets.length > 8L) {
            throw new GraalError("Exceeded maximum of %d edges (%s)", new Object[]{8L, type});
        }
        if ((long)(offsets.length - directCount) > 6L) {
            throw new GraalError("Exceeded maximum of %d list edges (%s)", new Object[]{6L, type});
        }
        for (int i = offsets.length - 1; i >= 0; --i) {
            long offset = offsets[i];
            assert ((offset & 0xFFL) == offset) : "field offset too large!";
            mask <<= 8;
            mask |= offset;
            if (i < directCount) continue;
            mask |= 3L;
        }
        return mask;
    }

    private synchronized void addIterableId(int newIterableId) {
        assert (!NodeClass.containsId(newIterableId, this.iterableIds));
        int[] copy = Arrays.copyOf(this.iterableIds, this.iterableIds.length + 1);
        copy[this.iterableIds.length] = newIterableId;
        this.iterableIds = copy;
    }

    private boolean verifyIterableIds() {
        NodeClass<T> snc = this.superNodeClass;
        while (snc != null && IterableNodeType.class.isAssignableFrom(snc.getClazz())) {
            assert (NodeClass.containsId(this.iterableId, snc.iterableIds));
            snc = snc.superNodeClass;
        }
        return true;
    }

    private static boolean containsId(int iterableId, int[] iterableIds) {
        for (int i : iterableIds) {
            if (i != iterableId) continue;
            return true;
        }
        return false;
    }

    public String shortName() {
        if (this.shortName == null) {
            String localShortName;
            NodeInfo info = this.getClazz().getAnnotation(NodeInfo.class);
            this.shortName = !info.shortName().isEmpty() ? info.shortName() : ((localShortName = this.getClazz().getSimpleName()).endsWith("Node") && !localShortName.equals("StartNode") && !localShortName.equals("EndNode") ? localShortName.substring(0, localShortName.length() - 4) : localShortName);
        }
        return this.shortName;
    }

    @Override
    public Fields[] getAllFields() {
        return new Fields[]{this.data, this.inputs, this.successors};
    }

    int[] iterableIds() {
        return this.iterableIds;
    }

    public int iterableId() {
        return this.iterableId;
    }

    public boolean valueNumberable() {
        return this.canGVN;
    }

    public boolean isCanonicalizable() {
        return this.isCanonicalizable;
    }

    public boolean isCommutative() {
        return this.isCommutative;
    }

    public boolean isSimplifiable() {
        return this.isSimplifiable;
    }

    static int allocatedNodeIterabledIds() {
        return nextIterableId.get();
    }

    public EnumSet<InputType> getAllowedUsageTypes() {
        return this.allowedUsageTypes;
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("NodeClass ").append(this.getClazz().getSimpleName()).append(" [");
        this.inputs.appendFields(str);
        str.append("] [");
        this.successors.appendFields(str);
        str.append("] [");
        this.data.appendFields(str);
        str.append("]");
        return str.toString();
    }

    private static int deepHashCode0(Object o) {
        if (o == null) {
            return 0;
        }
        if (!o.getClass().isArray()) {
            return o.hashCode();
        }
        if (o instanceof Object[]) {
            return Arrays.deepHashCode((Object[])o);
        }
        if (o instanceof byte[]) {
            return Arrays.hashCode((byte[])o);
        }
        if (o instanceof short[]) {
            return Arrays.hashCode((short[])o);
        }
        if (o instanceof int[]) {
            return Arrays.hashCode((int[])o);
        }
        if (o instanceof long[]) {
            return Arrays.hashCode((long[])o);
        }
        if (o instanceof char[]) {
            return Arrays.hashCode((char[])o);
        }
        if (o instanceof float[]) {
            return Arrays.hashCode((float[])o);
        }
        if (o instanceof double[]) {
            return Arrays.hashCode((double[])o);
        }
        if (o instanceof boolean[]) {
            return Arrays.hashCode((boolean[])o);
        }
        throw GraalError.shouldNotReachHere();
    }

    public int valueNumber(Node n) {
        int number = 0;
        if (this.canGVN) {
            number = this.startGVNNumber;
            for (int i = 0; i < this.data.getCount(); ++i) {
                Class<?> type = this.data.getType(i);
                if (type.isPrimitive()) {
                    if (type == Integer.TYPE) {
                        int intValue = this.data.getInt(n, i);
                        number += intValue;
                    } else if (type == Long.TYPE) {
                        long longValue = this.data.getLong(n, i);
                        number = (int)((long)number + (longValue ^ longValue >>> 32));
                    } else if (type == Boolean.TYPE) {
                        boolean booleanValue = this.data.getBoolean(n, i);
                        if (booleanValue) {
                            number += 7;
                        }
                    } else if (type == Float.TYPE) {
                        float floatValue = this.data.getFloat(n, i);
                        number += Float.floatToRawIntBits(floatValue);
                    } else if (type == Double.TYPE) {
                        double doubleValue = this.data.getDouble(n, i);
                        long longValue = Double.doubleToRawLongBits(doubleValue);
                        number = (int)((long)number + (longValue ^ longValue >>> 32));
                    } else if (type == Short.TYPE) {
                        short shortValue = this.data.getShort(n, i);
                        number += shortValue;
                    } else if (type == Character.TYPE) {
                        char charValue = this.data.getChar(n, i);
                        number += charValue;
                    } else if (type == Byte.TYPE) {
                        byte byteValue = this.data.getByte(n, i);
                        number += byteValue;
                    } else assert (false) : "unhandled property type: " + type;
                } else {
                    Object o = this.data.getObject(n, i);
                    number += NodeClass.deepHashCode0(o);
                }
                number *= 13;
            }
        }
        return number;
    }

    private static boolean deepEquals0(Object e1, Object e2) {
        if (e1 == e2) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (!e1.getClass().isArray() || e1.getClass() != e2.getClass()) {
            return e1.equals(e2);
        }
        if (e1 instanceof Object[] && e2 instanceof Object[]) {
            return NodeClass.deepEquals((Object[])e1, (Object[])e2);
        }
        if (e1 instanceof int[]) {
            return Arrays.equals((int[])e1, (int[])e2);
        }
        if (e1 instanceof long[]) {
            return Arrays.equals((long[])e1, (long[])e2);
        }
        if (e1 instanceof byte[]) {
            return Arrays.equals((byte[])e1, (byte[])e2);
        }
        if (e1 instanceof char[]) {
            return Arrays.equals((char[])e1, (char[])e2);
        }
        if (e1 instanceof short[]) {
            return Arrays.equals((short[])e1, (short[])e2);
        }
        if (e1 instanceof float[]) {
            return Arrays.equals((float[])e1, (float[])e2);
        }
        if (e1 instanceof double[]) {
            return Arrays.equals((double[])e1, (double[])e2);
        }
        if (e1 instanceof boolean[]) {
            return Arrays.equals((boolean[])e1, (boolean[])e2);
        }
        throw GraalError.shouldNotReachHere();
    }

    private static boolean deepEquals(Object[] a1, Object[] a2) {
        int length = a1.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            if (NodeClass.deepEquals0(a1[i], a2[i])) continue;
            return false;
        }
        return true;
    }

    public boolean dataEquals(Node a, Node b) {
        assert (a.getClass() == b.getClass());
        for (int i = 0; i < this.data.getCount(); ++i) {
            Class<?> type = this.data.getType(i);
            if (type.isPrimitive()) {
                if (type == Integer.TYPE) {
                    int bInt;
                    int aInt = this.data.getInt(a, i);
                    if (aInt == (bInt = this.data.getInt(b, i))) continue;
                    return false;
                }
                if (type == Boolean.TYPE) {
                    boolean bBoolean;
                    boolean aBoolean = this.data.getBoolean(a, i);
                    if (aBoolean == (bBoolean = this.data.getBoolean(b, i))) continue;
                    return false;
                }
                if (type == Long.TYPE) {
                    long bLong;
                    long aLong = this.data.getLong(a, i);
                    if (aLong == (bLong = this.data.getLong(b, i))) continue;
                    return false;
                }
                if (type == Float.TYPE) {
                    float bFloat;
                    float aFloat = this.data.getFloat(a, i);
                    if (aFloat == (bFloat = this.data.getFloat(b, i))) continue;
                    return false;
                }
                if (type == Double.TYPE) {
                    double bDouble;
                    double aDouble = this.data.getDouble(a, i);
                    if (aDouble == (bDouble = this.data.getDouble(b, i))) continue;
                    return false;
                }
                if (type == Short.TYPE) {
                    short bShort;
                    short aShort = this.data.getShort(a, i);
                    if (aShort == (bShort = this.data.getShort(b, i))) continue;
                    return false;
                }
                if (type == Character.TYPE) {
                    char bChar;
                    char aChar = this.data.getChar(a, i);
                    if (aChar == (bChar = this.data.getChar(b, i))) continue;
                    return false;
                }
                if (type == Byte.TYPE) {
                    byte bByte;
                    byte aByte = this.data.getByte(a, i);
                    if (aByte == (bByte = this.data.getByte(b, i))) continue;
                    return false;
                }
                assert (false) : "unhandled type: " + type;
                continue;
            }
            Object objectA = this.data.getObject(a, i);
            Object objectB = this.data.getObject(b, i);
            assert (!NodeClass.isLambda(objectA) || !NodeClass.isLambda(objectB)) : "lambdas are not permitted in fields of " + this.toString();
            if (objectA == objectB) continue;
            if (objectA != null && objectB != null) {
                if (NodeClass.deepEquals0(objectA, objectB)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private static boolean isLambda(Object obj) {
        return obj != null && obj.getClass().getSimpleName().contains("$$Lambda$");
    }

    public boolean isValid(Position pos, NodeClass<?> from, Edges fromEdges) {
        if (this == from) {
            return true;
        }
        Edges toEdges = this.getEdges(fromEdges.type());
        if (pos.getIndex() >= toEdges.getCount()) {
            return false;
        }
        if (pos.getIndex() >= fromEdges.getCount()) {
            return false;
        }
        return toEdges.isSame(fromEdges, pos.getIndex());
    }

    static void updateEdgesInPlace(Node node, InplaceUpdateClosure duplicationReplacement, Edges edges) {
        int index;
        Edges.Type curType = edges.type();
        int directCount = edges.getDirectCount();
        long[] curOffsets = edges.getOffsets();
        for (index = 0; index < directCount; ++index) {
            Node edge = Edges.getNode(node, curOffsets, index);
            if (edge == null) continue;
            Node newEdge = duplicationReplacement.replacement(edge, curType);
            if (curType == Edges.Type.Inputs) {
                node.updateUsages(null, newEdge);
            } else {
                node.updatePredecessor(null, newEdge);
            }
            edges.initializeNode(node, index, newEdge);
        }
        while (index < edges.getCount()) {
            NodeList<Node> list = Edges.getNodeList(node, curOffsets, index);
            if (list != null) {
                edges.initializeList(node, index, NodeClass.updateEdgeListCopy(node, list, duplicationReplacement, curType));
            }
            ++index;
        }
    }

    void updateInputSuccInPlace(Node node, InplaceUpdateClosure duplicationReplacement) {
        NodeClass.updateEdgesInPlace(node, duplicationReplacement, this.inputs);
        NodeClass.updateEdgesInPlace(node, duplicationReplacement, this.successors);
    }

    private static NodeList<Node> updateEdgeListCopy(Node node, NodeList<Node> list, InplaceUpdateClosure duplicationReplacement, Edges.Type type) {
        NodeInputList<Node> result = type == Edges.Type.Inputs ? new NodeInputList(node, list.size()) : new NodeSuccessorList(node, list.size());
        for (int i = 0; i < list.count(); ++i) {
            Object oldNode = list.get(i);
            if (oldNode == null) continue;
            Node newNode = duplicationReplacement.replacement((Node)oldNode, type);
            result.set(i, newNode);
        }
        return result;
    }

    public Edges getEdges(Edges.Type type) {
        return type == Edges.Type.Inputs ? this.inputs : this.successors;
    }

    public Edges getInputEdges() {
        return this.inputs;
    }

    public Edges getSuccessorEdges() {
        return this.successors;
    }

    public Node allocateInstance() {
        try {
            Node node = (Node)UNSAFE.allocateInstance(this.getJavaClass());
            node.init(this);
            return node;
        }
        catch (InstantiationException ex) {
            throw GraalError.shouldNotReachHere(ex);
        }
    }

    public Class<T> getJavaClass() {
        return this.getClazz();
    }

    public String getNameTemplate() {
        return this.nameTemplate;
    }

    static EconomicMap<Node, Node> addGraphDuplicate(final Graph graph, Graph oldGraph, int estimatedNodeCount, Iterable<? extends Node> nodes, final Graph.DuplicationReplacement replacements) {
        int denseThreshold = oldGraph.getNodeCount() + oldGraph.getNodesDeletedSinceLastCompression() >> 4;
        final NodeMap<Node> newNodes = estimatedNodeCount > denseThreshold ? new NodeMap<Node>(oldGraph) : EconomicMap.create((Equivalence)Equivalence.IDENTITY);
        graph.beforeNodeDuplication(oldGraph);
        NodeClass.createNodeDuplicates(graph, nodes, replacements, newNodes);
        InplaceUpdateClosure replacementClosure = new InplaceUpdateClosure(){

            @Override
            public Node replacement(Node node, Edges.Type type) {
                Node target = (Node)newNodes.get((Object)node);
                if (target == null) {
                    Node replacement = node;
                    if (replacements != null) {
                        replacement = replacements.replacement(node);
                    }
                    if (replacement != node) {
                        target = replacement;
                    } else if (node.graph() == graph && type == Edges.Type.Inputs) {
                        target = node;
                    }
                }
                return target;
            }
        };
        for (Node node : nodes) {
            Node node2 = (Node)newNodes.get(node);
            NodeClass<? extends Node> nodeClass = node2.getNodeClass();
            if (replacements == null || replacements.replacement(node) == node) {
                nodeClass.updateInputSuccInPlace(node2, replacementClosure);
                continue;
            }
            NodeClass.transferEdgesDifferentNodeClass(graph, replacements, newNodes, node, node2);
        }
        return newNodes;
    }

    private static void createNodeDuplicates(Graph graph, Iterable<? extends Node> nodes, Graph.DuplicationReplacement replacements, EconomicMap<Node, Node> newNodes) {
        for (Node node : nodes) {
            if (node == null) continue;
            assert (!node.isDeleted()) : "trying to duplicate deleted node: " + node;
            Node replacement = node;
            if (replacements != null) {
                replacement = replacements.replacement(node);
            }
            if (replacement != node) {
                assert (replacement != null);
                newNodes.put((Object)node, (Object)replacement);
                continue;
            }
            Node newNode = node.clone(graph, Node.WithAllEdges);
            assert (newNode.getNodeClass().isLeafNode() || newNode.hasNoUsages());
            assert (newNode.getClass() == node.getClass());
            newNodes.put((Object)node, (Object)newNode);
        }
    }

    private static void transferEdgesDifferentNodeClass(Graph graph, Graph.DuplicationReplacement replacements, EconomicMap<Node, Node> newNodes, Node oldNode, Node node) {
        NodeClass.transferEdges(graph, replacements, newNodes, oldNode, node, Edges.Type.Inputs);
        NodeClass.transferEdges(graph, replacements, newNodes, oldNode, node, Edges.Type.Successors);
    }

    private static void transferEdges(Graph graph, Graph.DuplicationReplacement replacements, EconomicMap<Node, Node> newNodes, Node oldNode, Node node, Edges.Type type) {
        NodeClass<? extends Node> nodeClass = node.getNodeClass();
        NodeClass<? extends Node> oldNodeClass = oldNode.getNodeClass();
        Edges oldEdges = oldNodeClass.getEdges(type);
        for (Position pos : oldEdges.getPositionsIterable(oldNode)) {
            Node oldEdge;
            if (!nodeClass.isValid(pos, oldNodeClass, oldEdges) || (oldEdge = pos.get(oldNode)) == null) continue;
            Node target = (Node)newNodes.get((Object)oldEdge);
            if (target == null) {
                Node replacement = oldEdge;
                if (replacements != null) {
                    replacement = replacements.replacement(oldEdge);
                }
                if (replacement != oldEdge) {
                    target = replacement;
                } else if (type == Edges.Type.Inputs && oldEdge.graph() == graph) {
                    target = oldEdge;
                }
            }
            pos.set(node, target);
        }
    }

    public boolean isLeafNode() {
        return this.isLeafNode;
    }

    public int getLeafId() {
        return this.leafId;
    }

    public NodeClass<? super T> getSuperNodeClass() {
        return this.superNodeClass;
    }

    public long inputsIteration() {
        return this.inputsIteration;
    }

    public NodeIterable<Node> getSuccessorIterable(final Node node) {
        final long mask = this.successorIteration;
        return new NodeIterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                if (Graph.isModificationCountsEnabled()) {
                    return new RawEdgesWithModCountIterator(node, mask);
                }
                return new RawEdgesIterator(node, mask);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                Iterator<Node> iterator = this.iterator();
                boolean first = true;
                sb.append("succs=");
                sb.append('[');
                while (iterator.hasNext()) {
                    Node input = iterator.next();
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(input);
                    first = false;
                }
                sb.append(']');
                return sb.toString();
            }
        };
    }

    public NodeIterable<Node> getInputIterable(final Node node) {
        final long mask = this.inputsIteration;
        return new NodeIterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                if (Graph.isModificationCountsEnabled()) {
                    return new RawEdgesWithModCountIterator(node, mask);
                }
                return new RawEdgesIterator(node, mask);
            }

            public String toString() {
                StringBuilder sb = new StringBuilder();
                Iterator<Node> iterator = this.iterator();
                boolean first = true;
                sb.append("inputs=");
                sb.append('[');
                while (iterator.hasNext()) {
                    Node input = iterator.next();
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append(input);
                    first = false;
                }
                sb.append(']');
                return sb.toString();
            }
        };
    }

    public boolean equalSuccessors(Node node, Node other) {
        return this.equalEdges(node, other, this.successorIteration);
    }

    public boolean equalInputs(Node node, Node other) {
        return this.equalEdges(node, other, this.inputsIteration);
    }

    private boolean equalEdges(Node node, Node other, long mask) {
        assert (other.getNodeClass() == this);
        for (long myMask = mask; myMask != 0L; myMask >>>= 8) {
            Object v2;
            Object v1;
            long offset = myMask & 0xFCL;
            if (!((myMask & 1L) == 0L ? (v1 = Edges.getNodeUnsafe(node, offset)) != (v2 = Edges.getNodeUnsafe(other, offset)) : !Objects.equals(v1 = Edges.getNodeListUnsafe(node, offset), v2 = Edges.getNodeListUnsafe(other, offset)))) continue;
            return false;
        }
        return true;
    }

    public void pushInputs(Node node, NodeStack stack) {
        for (long myMask = this.inputsIteration; myMask != 0L; myMask >>>= 8) {
            long offset = myMask & 0xFCL;
            if ((myMask & 1L) == 0L) {
                Node curNode = Edges.getNodeUnsafe(node, offset);
                if (curNode == null) continue;
                stack.push(curNode);
                continue;
            }
            NodeClass.pushAllHelper(stack, node, offset);
        }
    }

    private static void pushAllHelper(NodeStack stack, Node node, long offset) {
        NodeList<Node> list = Edges.getNodeListUnsafe(node, offset);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object curNode = list.get(i);
                if (curNode == null) continue;
                stack.push((Node)curNode);
            }
        }
    }

    public void applySuccessors(Node node, Node.EdgeVisitor consumer) {
        NodeClass.applyEdges(node, consumer, this.successorIteration);
    }

    public void applyInputs(Node node, Node.EdgeVisitor consumer) {
        NodeClass.applyEdges(node, consumer, this.inputsIteration);
    }

    private static void applyEdges(Node node, Node.EdgeVisitor consumer, long mask) {
        for (long myMask = mask; myMask != 0L; myMask >>>= 8) {
            long offset = myMask & 0xFCL;
            if ((myMask & 1L) == 0L) {
                Node newNode;
                Node curNode = Edges.getNodeUnsafe(node, offset);
                if (curNode == null || (newNode = consumer.apply(node, curNode)) == curNode) continue;
                Edges.putNodeUnsafe(node, offset, newNode);
                continue;
            }
            NodeClass.applyHelper(node, consumer, offset);
        }
    }

    private static void applyHelper(Node node, Node.EdgeVisitor consumer, long offset) {
        NodeList<Node> list = Edges.getNodeListUnsafe(node, offset);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Node newNode;
                Object curNode = list.get(i);
                if (curNode == null || (newNode = consumer.apply(node, (Node)curNode)) == curNode) continue;
                list.initialize(i, newNode);
            }
        }
    }

    public void unregisterAtSuccessorsAsPredecessor(Node node) {
        for (long myMask = this.successorIteration; myMask != 0L; myMask >>>= 8) {
            long offset = myMask & 0xFCL;
            if ((myMask & 1L) == 0L) {
                Node curNode = Edges.getNodeUnsafe(node, offset);
                if (curNode == null) continue;
                node.updatePredecessor(curNode, null);
                Edges.putNodeUnsafe(node, offset, null);
                continue;
            }
            NodeClass.unregisterAtSuccessorsAsPredecessorHelper(node, offset);
        }
    }

    private static void unregisterAtSuccessorsAsPredecessorHelper(Node node, long offset) {
        NodeList<Node> list = Edges.getNodeListUnsafe(node, offset);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object curNode = list.get(i);
                if (curNode == null) continue;
                node.updatePredecessor((Node)curNode, null);
            }
            list.clearWithoutUpdate();
        }
    }

    public void registerAtSuccessorsAsPredecessor(Node node) {
        for (long myMask = this.successorIteration; myMask != 0L; myMask >>>= 8) {
            long offset = myMask & 0xFCL;
            if ((myMask & 1L) == 0L) {
                Node curNode = Edges.getNodeUnsafe(node, offset);
                if (curNode == null) continue;
                assert (curNode.isAlive()) : "Successor not alive";
                node.updatePredecessor(null, curNode);
                continue;
            }
            NodeClass.registerAtSuccessorsAsPredecessorHelper(node, offset);
        }
    }

    private static void registerAtSuccessorsAsPredecessorHelper(Node node, long offset) {
        NodeList<Node> list = Edges.getNodeListUnsafe(node, offset);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object curNode = list.get(i);
                if (curNode == null) continue;
                assert (((Node)curNode).isAlive()) : "Successor not alive";
                node.updatePredecessor(null, (Node)curNode);
            }
        }
    }

    public boolean replaceFirstInput(Node node, Node key, Node replacement) {
        return NodeClass.replaceFirstEdge(node, key, replacement, this.inputsIteration);
    }

    public boolean replaceFirstSuccessor(Node node, Node key, Node replacement) {
        return NodeClass.replaceFirstEdge(node, key, replacement, this.successorIteration);
    }

    public static boolean replaceFirstEdge(Node node, Node key, Node replacement, long mask) {
        for (long myMask = mask; myMask != 0L; myMask >>>= 8) {
            long offset = myMask & 0xFCL;
            if ((myMask & 1L) == 0L) {
                Node curNode = Edges.getNodeUnsafe(node, offset);
                if (curNode != key) continue;
                Edges.putNodeUnsafe(node, offset, replacement);
                return true;
            }
            NodeList<Node> list = Edges.getNodeListUnsafe(node, offset);
            if (list == null || !list.replaceFirst(key, replacement)) continue;
            return true;
        }
        return false;
    }

    public void registerAtInputsAsUsage(Node node) {
        for (long myMask = this.inputsIteration; myMask != 0L; myMask >>>= 8) {
            long offset = myMask & 0xFCL;
            if ((myMask & 1L) == 0L) {
                Node curNode = Edges.getNodeUnsafe(node, offset);
                if (curNode == null) continue;
                assert (curNode.isAlive()) : "Input " + curNode + " of node " + node + " is not alive";
                curNode.addUsage(node);
                continue;
            }
            NodeClass.registerAtInputsAsUsageHelper(node, offset);
        }
    }

    private static void registerAtInputsAsUsageHelper(Node node, long offset) {
        NodeList<Node> list = Edges.getNodeListUnsafe(node, offset);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object curNode = list.get(i);
                if (curNode == null) continue;
                assert (((Node)curNode).isAlive()) : "Input not alive " + curNode;
                ((Node)curNode).addUsage(node);
            }
        }
    }

    public void unregisterAtInputsAsUsage(Node node) {
        for (long myMask = this.inputsIteration; myMask != 0L; myMask >>>= 8) {
            long offset = myMask & 0xFCL;
            if ((myMask & 1L) == 0L) {
                Node curNode = Edges.getNodeUnsafe(node, offset);
                if (curNode == null) continue;
                node.removeThisFromUsages(curNode);
                if (curNode.hasNoUsages()) {
                    node.maybeNotifyZeroUsages(curNode);
                }
                Edges.putNodeUnsafe(node, offset, null);
                continue;
            }
            NodeClass.unregisterAtInputsAsUsageHelper(node, offset);
        }
    }

    private static void unregisterAtInputsAsUsageHelper(Node node, long offset) {
        NodeList<Node> list = Edges.getNodeListUnsafe(node, offset);
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                Object curNode = list.get(i);
                if (curNode == null) continue;
                node.removeThisFromUsages((Node)curNode);
                if (!((Node)curNode).hasNoUsages()) continue;
                node.maybeNotifyZeroUsages((Node)curNode);
            }
            list.clearWithoutUpdate();
        }
    }

    private static final class RawEdgesWithModCountIterator
    extends RawEdgesIterator {
        private final int modCount;

        private RawEdgesWithModCountIterator(Node node, long mask) {
            super(node, mask);
            assert (Graph.isModificationCountsEnabled());
            this.modCount = node.modCount();
        }

        @Override
        public boolean hasNext() {
            try {
                boolean bl = super.hasNext();
                return bl;
            }
            finally {
                assert (this.modCount == this.node.modCount()) : "must not be modified";
            }
        }

        @Override
        public Node next() {
            try {
                Node node = super.next();
                return node;
            }
            finally {
                assert (this.modCount == this.node.modCount()) : "must not be modified";
            }
        }

        @Override
        public Position nextPosition() {
            try {
                Position position = super.nextPosition();
                return position;
            }
            finally {
                assert (this.modCount == this.node.modCount());
            }
        }
    }

    private static class RawEdgesIterator
    implements Iterator<Node> {
        protected final Node node;
        protected long mask;
        protected Node nextValue;

        RawEdgesIterator(Node node, long mask) {
            this.node = node;
            this.mask = mask;
        }

        @Override
        public boolean hasNext() {
            Node next = this.nextValue;
            if (next != null) {
                return true;
            }
            this.nextValue = this.forward();
            return this.nextValue != null;
        }

        private Node forward() {
            while (this.mask != 0L) {
                Node next = this.getInput();
                this.mask = this.advanceInput();
                if (next == null) continue;
                return next;
            }
            return null;
        }

        @Override
        public Node next() {
            Node next = this.nextValue;
            if (next == null) {
                next = this.forward();
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
            this.nextValue = null;
            return next;
        }

        public final long advanceInput() {
            int size;
            int state = (int)this.mask & 3;
            if (state == 0) {
                return this.mask >>> 8;
            }
            if (state == 1) {
                if ((this.mask & 0xFFFF00L) != 0L) {
                    return this.mask - 256L;
                }
                return this.mask >>> 24;
            }
            NodeList<Node> nodeList = Edges.getNodeListUnsafe(this.node, this.mask & 0xFCL);
            if (nodeList != null && (size = nodeList.size()) != 0) {
                return this.mask >>> 8 << 24 | this.mask & 0xFDL | (long)(size - 1 << 8);
            }
            return this.mask >>> 8;
        }

        public Node getInput() {
            int state = (int)this.mask & 3;
            if (state == 0) {
                return Edges.getNodeUnsafe(this.node, this.mask & 0xFCL);
            }
            if (state == 1) {
                NodeList<Node> nodeList = Edges.getNodeListUnsafe(this.node, this.mask & 0xFCL);
                return nodeList.nodes[nodeList.size() - 1 - (int)(this.mask >>> 8 & 0xFFFFL)];
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Position nextPosition() {
            return null;
        }
    }

    static interface InplaceUpdateClosure {
        public Node replacement(Node var1, Edges.Type var2);
    }

    protected static class NodeFieldsScanner
    extends FieldsScanner {
        public final ArrayList<InputInfo> inputs = new ArrayList();
        public final ArrayList<EdgeInfo> successors = new ArrayList();
        int directInputs;
        int directSuccessors;
        final DebugContext debug;

        protected NodeFieldsScanner(FieldsScanner.CalcOffset calc, NodeClass<?> superNodeClass, DebugContext debug) {
            super(calc);
            this.debug = debug;
            if (superNodeClass != null) {
                InputEdges.translateInto(((NodeClass)superNodeClass).inputs, this.inputs);
                InputEdges.translateInto(((NodeClass)superNodeClass).successors, this.successors);
                InputEdges.translateInto(((NodeClass)superNodeClass).data, this.data);
                this.directInputs = ((NodeClass)superNodeClass).inputs.getDirectCount();
                this.directSuccessors = ((NodeClass)superNodeClass).successors.getDirectCount();
            }
        }

        @Override
        protected void scanField(Field field, long offset) {
            Node.Input inputAnnotation = (Node.Input)NodeClass.getAnnotationTimed(field, Node.Input.class, this.debug);
            Node.OptionalInput optionalInputAnnotation = (Node.OptionalInput)NodeClass.getAnnotationTimed(field, Node.OptionalInput.class, this.debug);
            Node.Successor successorAnnotation = (Node.Successor)NodeClass.getAnnotationTimed(field, Node.Successor.class, this.debug);
            try (DebugCloseable s = Init_FieldScanningInner.start(this.debug);){
                Class<?> type = field.getType();
                int modifiers = field.getModifiers();
                if (inputAnnotation != null || optionalInputAnnotation != null) {
                    InputType inputType;
                    assert (successorAnnotation == null) : "field cannot be both input and successor";
                    if (INPUT_LIST_CLASS.isAssignableFrom(type)) {
                        GraalError.guarantee(!Modifier.isFinal(modifiers), "NodeInputList input field %s should not be final", (Object)field);
                        GraalError.guarantee(!Modifier.isPublic(modifiers), "NodeInputList input field %s should not be public", (Object)field);
                    } else {
                        GraalError.guarantee(NODE_CLASS.isAssignableFrom(type) || type.isInterface(), "invalid input type: %s", type);
                        GraalError.guarantee(!Modifier.isFinal(modifiers), "Node input field %s should not be final", (Object)field);
                        ++this.directInputs;
                    }
                    if (inputAnnotation != null) {
                        assert (optionalInputAnnotation == null) : "inputs can either be optional or non-optional";
                        inputType = inputAnnotation.value();
                    } else {
                        inputType = optionalInputAnnotation.value();
                    }
                    this.inputs.add(new InputInfo(offset, field.getName(), type, field.getDeclaringClass(), inputType, field.isAnnotationPresent(Node.OptionalInput.class)));
                } else if (successorAnnotation != null) {
                    if (SUCCESSOR_LIST_CLASS.isAssignableFrom(type)) {
                        GraalError.guarantee(!Modifier.isFinal(modifiers), "NodeSuccessorList successor field % should not be final", (Object)field);
                        GraalError.guarantee(!Modifier.isPublic(modifiers), "NodeSuccessorList successor field %s should not be public", (Object)field);
                    } else {
                        GraalError.guarantee(NODE_CLASS.isAssignableFrom(type), "invalid successor type: %s", type);
                        GraalError.guarantee(!Modifier.isFinal(modifiers), "Node successor field %s should not be final", (Object)field);
                        ++this.directSuccessors;
                    }
                    this.successors.add(new EdgeInfo(offset, field.getName(), type, field.getDeclaringClass()));
                } else {
                    GraalError.guarantee(!NODE_CLASS.isAssignableFrom(type) || field.getName().equals("Null"), "suspicious node field: %s", (Object)field);
                    GraalError.guarantee(!INPUT_LIST_CLASS.isAssignableFrom(type), "suspicious node input list field: %s", (Object)field);
                    GraalError.guarantee(!SUCCESSOR_LIST_CLASS.isAssignableFrom(type), "suspicious node successor list field: %s", (Object)field);
                    super.scanField(field, offset);
                }
            }
        }
    }

    protected static class InputInfo
    extends EdgeInfo {
        final InputType inputType;
        final boolean optional;

        public InputInfo(long offset, String name, Class<?> type, Class<?> declaringClass, InputType inputType, boolean optional) {
            super(offset, name, type, declaringClass);
            this.inputType = inputType;
            this.optional = optional;
        }

        @Override
        public String toString() {
            return super.toString() + "{inputType=" + (Object)((Object)this.inputType) + ", optional=" + this.optional + "}";
        }
    }

    protected static class EdgeInfo
    extends FieldsScanner.FieldInfo {
        public EdgeInfo(long offset, String name, Class<?> type, Class<?> declaringClass) {
            super(offset, name, type, declaringClass);
        }

        @Override
        public int compareTo(FieldsScanner.FieldInfo o) {
            if (NodeList.class.isAssignableFrom(o.type)) {
                if (!NodeList.class.isAssignableFrom(this.type)) {
                    return -1;
                }
            } else if (NodeList.class.isAssignableFrom(this.type)) {
                return 1;
            }
            return super.compareTo(o);
        }
    }
}

