/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Formattable;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.core.common.Fields;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.graph.Edges;
import org.graalvm.compiler.graph.GraalGraphError;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInterface;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.NodeStack;
import org.graalvm.compiler.graph.NodeUsageIterable;
import org.graalvm.compiler.graph.Position;
import org.graalvm.compiler.graph.VerificationError;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.graph.iterators.NodePredicate;
import org.graalvm.compiler.graph.spi.SimplifierTool;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.GraalUnsafeAccess;
import sun.misc.Unsafe;

@NodeInfo
public abstract class Node
implements Cloneable,
Formattable,
NodeInterface {
    private static final Unsafe UNSAFE = GraalUnsafeAccess.getUnsafe();
    public static final NodeClass<?> TYPE = null;
    public static final boolean TRACK_CREATION_POSITION = Boolean.parseBoolean((String)Services.getSavedProperties().get("debug.graal.TrackNodeCreationPosition"));
    static final int DELETED_ID_START = -1000000000;
    static final int INITIAL_ID = -1;
    static final int ALIVE_ID_START = 0;
    private Graph graph;
    int id;
    Node typeCacheNext;
    static final int INLINE_USAGE_COUNT = 2;
    private static final Node[] NO_NODES = new Node[0];
    Node usage0;
    Node usage1;
    Node[] extraUsages;
    int extraUsagesCount;
    private Node predecessor;
    private NodeClass<? extends Node> nodeClass;
    public static final int NODE_LIST = -2;
    public static final int NOT_ITERABLE = -1;
    private Object annotation;
    public static final EnumSet<Edges.Type> WithNoEdges = EnumSet.noneOf(Edges.Type.class);
    public static final EnumSet<Edges.Type> WithAllEdges = EnumSet.allOf(Edges.Type.class);
    public static final EnumSet<Edges.Type> WithOnlyInputEdges = EnumSet.of(Edges.Type.Inputs);
    public static final EnumSet<Edges.Type> WithOnlySucessorEdges = EnumSet.of(Edges.Type.Successors);

    public Node(NodeClass<? extends Node> c) {
        this.init(c);
    }

    final void init(NodeClass<? extends Node> c) {
        assert (c.getJavaClass() == this.getClass());
        this.nodeClass = c;
        this.id = -1;
        this.extraUsages = NO_NODES;
        if (TRACK_CREATION_POSITION) {
            this.setCreationPosition(new NodeCreationStackTrace());
        }
    }

    final int id() {
        return this.id;
    }

    @Override
    public Node asNode() {
        return this;
    }

    public Graph graph() {
        return this.graph;
    }

    public final OptionValues getOptions() {
        return this.graph == null ? null : this.graph.getOptions();
    }

    public final DebugContext getDebug() {
        return this.graph.getDebug();
    }

    public NodeIterable<Node> inputs() {
        return this.nodeClass.getInputIterable(this);
    }

    public Iterable<Position> inputPositions() {
        return this.nodeClass.getInputEdges().getPositionsIterable(this);
    }

    public void applyInputs(EdgeVisitor visitor) {
        this.nodeClass.applyInputs(this, visitor);
    }

    public void applySuccessors(EdgeVisitor visitor) {
        this.nodeClass.applySuccessors(this, visitor);
    }

    public NodeIterable<Node> successors() {
        assert (!this.isDeleted()) : this;
        return this.nodeClass.getSuccessorIterable(this);
    }

    public Iterable<Position> successorPositions() {
        return this.nodeClass.getSuccessorEdges().getPositionsIterable(this);
    }

    public int getUsageCount() {
        if (this.usage0 == null) {
            return 0;
        }
        if (this.usage1 == null) {
            return 1;
        }
        return 2 + this.extraUsagesCount;
    }

    public final NodeIterable<Node> usages() {
        return new NodeUsageIterable(this);
    }

    public final boolean hasNoUsages() {
        return this.usage0 == null;
    }

    public final boolean hasUsages() {
        return this.usage0 != null;
    }

    public final boolean hasMoreThanOneUsage() {
        return this.usage1 != null;
    }

    public final boolean hasExactlyOneUsage() {
        return this.hasUsages() && !this.hasMoreThanOneUsage();
    }

    public final boolean hasOnlyUsagesOfType(InputType type) {
        for (Node usage : this.usages()) {
            for (Position pos : usage.inputPositions()) {
                if (pos.get(usage) != this || pos.getInputType() == type) continue;
                return false;
            }
        }
        return true;
    }

    void addUsage(Node node) {
        this.incUsageModCount();
        if (this.usage0 == null) {
            this.usage0 = node;
        } else if (this.usage1 == null) {
            this.usage1 = node;
        } else {
            int length = this.extraUsages.length;
            if (length == 0) {
                this.extraUsages = new Node[4];
            } else if (this.extraUsagesCount == length) {
                Node[] newExtraUsages = new Node[length * 2 + 1];
                System.arraycopy(this.extraUsages, 0, newExtraUsages, 0, length);
                this.extraUsages = newExtraUsages;
            }
            this.extraUsages[this.extraUsagesCount++] = node;
        }
    }

    private void movUsageFromEndTo(int destIndex) {
        if (destIndex >= 2) {
            this.movUsageFromEndToExtraUsages(destIndex - 2);
        } else if (destIndex == 1) {
            this.movUsageFromEndToIndexOne();
        } else {
            assert (destIndex == 0);
            this.movUsageFromEndToIndexZero();
        }
    }

    private void movUsageFromEndToExtraUsages(int destExtraIndex) {
        Node n;
        --this.extraUsagesCount;
        this.extraUsages[destExtraIndex] = n = this.extraUsages[this.extraUsagesCount];
        this.extraUsages[this.extraUsagesCount] = null;
    }

    private void movUsageFromEndToIndexZero() {
        if (this.extraUsagesCount > 0) {
            --this.extraUsagesCount;
            this.usage0 = this.extraUsages[this.extraUsagesCount];
            this.extraUsages[this.extraUsagesCount] = null;
        } else if (this.usage1 != null) {
            this.usage0 = this.usage1;
            this.usage1 = null;
        } else {
            this.usage0 = null;
        }
    }

    private void movUsageFromEndToIndexOne() {
        if (this.extraUsagesCount > 0) {
            --this.extraUsagesCount;
            this.usage1 = this.extraUsages[this.extraUsagesCount];
            this.extraUsages[this.extraUsagesCount] = null;
        } else {
            assert (this.usage1 != null);
            this.usage1 = null;
        }
    }

    public boolean removeUsage(Node node) {
        assert (node != null);
        this.incUsageModCount();
        if (this.usage0 == node) {
            this.movUsageFromEndToIndexZero();
            return true;
        }
        if (this.usage1 == node) {
            this.movUsageFromEndToIndexOne();
            return true;
        }
        for (int i = this.extraUsagesCount - 1; i >= 0; --i) {
            if (this.extraUsages[i] != node) continue;
            this.movUsageFromEndToExtraUsages(i);
            return true;
        }
        return false;
    }

    public final Node predecessor() {
        return this.predecessor;
    }

    public final int modCount() {
        if (Graph.isModificationCountsEnabled() && this.graph != null) {
            return this.graph.modCount(this);
        }
        return 0;
    }

    final void incModCount() {
        if (Graph.isModificationCountsEnabled() && this.graph != null) {
            this.graph.incModCount(this);
        }
    }

    final int usageModCount() {
        if (Graph.isModificationCountsEnabled() && this.graph != null) {
            return this.graph.usageModCount(this);
        }
        return 0;
    }

    final void incUsageModCount() {
        if (Graph.isModificationCountsEnabled() && this.graph != null) {
            this.graph.incUsageModCount(this);
        }
    }

    public final boolean isDeleted() {
        return this.id <= -1000000000;
    }

    public final boolean isAlive() {
        return this.id >= 0;
    }

    public final boolean isUnregistered() {
        return this.id == -1;
    }

    protected void updateUsages(Node oldInput, Node newInput) {
        assert (this.isAlive() && (newInput == null || newInput.isAlive())) : "adding " + newInput + " to " + this + " instead of " + oldInput;
        if (oldInput != newInput) {
            if (oldInput != null) {
                boolean result = this.removeThisFromUsages(oldInput);
                assert (this.assertTrue(result, "not found in usages, old input: %s", oldInput));
            }
            this.maybeNotifyInputChanged(this);
            if (newInput != null) {
                newInput.addUsage(this);
            }
            if (oldInput != null && oldInput.hasNoUsages()) {
                this.maybeNotifyZeroUsages(oldInput);
            }
        }
    }

    protected void updateUsagesInterface(NodeInterface oldInput, NodeInterface newInput) {
        this.updateUsages(oldInput == null ? null : oldInput.asNode(), newInput == null ? null : newInput.asNode());
    }

    protected void updatePredecessor(Node oldSuccessor, Node newSuccessor) {
        assert (this.isAlive() && (newSuccessor == null || newSuccessor.isAlive()) || newSuccessor == null && !this.isAlive()) : "adding " + newSuccessor + " to " + this + " instead of " + oldSuccessor;
        assert (this.graph == null || !this.graph.isFrozen());
        if (oldSuccessor != newSuccessor) {
            if (oldSuccessor != null) {
                assert (this.assertTrue(newSuccessor == null || oldSuccessor.predecessor == this, "wrong predecessor in old successor (%s): %s, should be %s", oldSuccessor, oldSuccessor.predecessor, this));
                oldSuccessor.predecessor = null;
            }
            if (newSuccessor != null) {
                assert (this.assertTrue(newSuccessor.predecessor == null, "unexpected non-null predecessor in new successor (%s): %s, this=%s", newSuccessor, newSuccessor.predecessor, this));
                newSuccessor.predecessor = this;
            }
            this.maybeNotifyInputChanged(this);
        }
    }

    void initialize(Graph newGraph) {
        assert (this.assertTrue(this.id == -1, "unexpected id: %d", this.id));
        this.graph = newGraph;
        newGraph.register(this);
        NodeClass<? extends Node> nc = this.nodeClass;
        nc.registerAtInputsAsUsage(this);
        nc.registerAtSuccessorsAsPredecessor(this);
    }

    private <T> T getNodeInfo(Class<T> clazz) {
        assert (clazz != Object[].class);
        if (this.annotation == null) {
            return null;
        }
        if (clazz.isInstance(this.annotation)) {
            return clazz.cast(this.annotation);
        }
        if (this.annotation.getClass() == Object[].class) {
            Object[] annotations;
            for (Object ann : annotations = (Object[])this.annotation) {
                if (!clazz.isInstance(ann)) continue;
                return clazz.cast(ann);
            }
        }
        return null;
    }

    private <T> void setNodeInfo(Class<T> clazz, T value) {
        assert (clazz != Object[].class);
        if (this.annotation == null || clazz.isInstance(this.annotation)) {
            this.annotation = value;
        } else if (this.annotation.getClass() == Object[].class) {
            Object[] annotations = (Object[])this.annotation;
            for (int i = 0; i < annotations.length; ++i) {
                if (!clazz.isInstance(annotations[i])) continue;
                annotations[i] = value;
                return;
            }
            Object[] newAnnotations = Arrays.copyOf(annotations, annotations.length + 1);
            newAnnotations[annotations.length] = value;
            this.annotation = newAnnotations;
        } else {
            this.annotation = new Object[]{this.annotation, value};
        }
    }

    public NodeSourcePosition getNodeSourcePosition() {
        return this.getNodeInfo(NodeSourcePosition.class);
    }

    public void setNodeSourcePosition(NodeSourcePosition sourcePosition) {
        if (sourcePosition == null) {
            return;
        }
        this.setNodeInfo(NodeSourcePosition.class, sourcePosition);
    }

    public void clearNodeSourcePosition() {
        this.setNodeInfo(NodeSourcePosition.class, null);
    }

    public NodeCreationStackTrace getCreationPosition() {
        return this.getNodeInfo(NodeCreationStackTrace.class);
    }

    public void setCreationPosition(NodeCreationStackTrace trace) {
        this.setNodeInfo(NodeCreationStackTrace.class, trace);
    }

    public NodeInsertionStackTrace getInsertionPosition() {
        return this.getNodeInfo(NodeInsertionStackTrace.class);
    }

    public void setInsertionPosition(NodeInsertionStackTrace trace) {
        this.setNodeInfo(NodeInsertionStackTrace.class, trace);
    }

    public void updateNodeSourcePosition(Supplier<NodeSourcePosition> sourcePositionSupp) {
        if (this.getNodeSourcePosition() == null) {
            this.setNodeSourcePosition(sourcePositionSupp.get());
        }
    }

    public DebugCloseable withNodeSourcePosition() {
        return this.graph.withNodeSourcePosition(this);
    }

    public final NodeClass<? extends Node> getNodeClass() {
        return this.nodeClass;
    }

    public boolean isAllowedUsageType(InputType type) {
        if (type == InputType.Value) {
            return false;
        }
        return this.getNodeClass().getAllowedUsageTypes().contains((Object)type);
    }

    private boolean checkReplaceWith(Node other) {
        if (this.graph != null && this.graph.isFrozen()) {
            this.fail("cannot modify frozen graph", new Object[0]);
        }
        if (other == this) {
            this.fail("cannot replace a node with itself", new Object[0]);
        }
        if (this.isDeleted()) {
            this.fail("cannot replace deleted node", new Object[0]);
        }
        if (other != null && other.isDeleted()) {
            this.fail("cannot replace with deleted node %s", other);
        }
        return true;
    }

    public final void replaceAtUsages(Node other) {
        this.replaceAtAllUsages(other, null);
    }

    public final void replaceAtUsages(Node other, Predicate<Node> filter) {
        this.replaceAtUsages(other, filter, null);
    }

    public final void replaceAtUsagesAndDelete(Node other) {
        this.replaceAtUsages(other, null, this);
        this.safeDelete();
    }

    public final void replaceAtUsagesAndDelete(Node other, Predicate<Node> filter) {
        this.replaceAtUsages(other, filter, this);
        this.safeDelete();
    }

    protected void replaceAtUsages(Node other, Predicate<Node> filter, Node toBeDeleted) {
        if (filter == null) {
            this.replaceAtAllUsages(other, toBeDeleted);
        } else {
            this.replaceAtMatchingUsages(other, filter, toBeDeleted);
        }
    }

    protected void replaceAtAllUsages(Node other, Node toBeDeleted) {
        this.checkReplaceWith(other);
        if (this.usage0 == null) {
            return;
        }
        this.replaceAtUsage(other, toBeDeleted, this.usage0);
        this.usage0 = null;
        if (this.usage1 == null) {
            return;
        }
        this.replaceAtUsage(other, toBeDeleted, this.usage1);
        this.usage1 = null;
        if (this.extraUsagesCount <= 0) {
            return;
        }
        for (int i = 0; i < this.extraUsagesCount; ++i) {
            Node usage = this.extraUsages[i];
            this.replaceAtUsage(other, toBeDeleted, usage);
        }
        this.extraUsages = NO_NODES;
        this.extraUsagesCount = 0;
    }

    private void replaceAtUsage(Node other, Node toBeDeleted, Node usage) {
        boolean result = usage.getNodeClass().replaceFirstInput(usage, this, other);
        assert (this.assertTrue(result, "not found in inputs, usage: %s", usage));
        if (toBeDeleted == null || usage != toBeDeleted) {
            this.maybeNotifyInputChanged(usage);
        }
        if (other != null) {
            other.addUsage(usage);
        }
    }

    private void replaceAtMatchingUsages(Node other, Predicate<Node> filter, Node toBeDeleted) {
        if (filter == null) {
            throw this.fail("filter cannot be null", new Object[0]);
        }
        this.checkReplaceWith(other);
        int i = 0;
        int usageCount = this.getUsageCount();
        while (i < usageCount) {
            Node usage = this.getUsageAt(i);
            if (filter.test(usage)) {
                this.replaceAtUsage(other, toBeDeleted, usage);
                this.movUsageFromEndTo(i);
                --usageCount;
                continue;
            }
            ++i;
        }
    }

    private Node getUsageAt(int index) {
        if (index == 0) {
            return this.usage0;
        }
        if (index == 1) {
            return this.usage1;
        }
        return this.extraUsages[index - 2];
    }

    public Node singleUsage() {
        assert (this.hasExactlyOneUsage());
        return this.usage0;
    }

    public void replaceAtMatchingUsages(Node other, NodePredicate usagePredicate) {
        this.checkReplaceWith(other);
        this.replaceAtMatchingUsages(other, usagePredicate, null);
    }

    private void replaceAtUsagePos(Node other, Node usage, Position pos) {
        pos.initialize(usage, other);
        this.maybeNotifyInputChanged(usage);
        if (other != null) {
            other.addUsage(usage);
        }
    }

    public void replaceAtUsages(Node other, InputType type) {
        this.checkReplaceWith(other);
        int i = 0;
        int usageCount = this.getUsageCount();
        if (usageCount == 0) {
            return;
        }
        block0: while (i < usageCount) {
            Node usage = this.getUsageAt(i);
            for (Position pos : usage.inputPositions()) {
                if (pos.getInputType() != type || pos.get(usage) != this) continue;
                this.replaceAtUsagePos(other, usage, pos);
                this.movUsageFromEndTo(i);
                --usageCount;
                continue block0;
            }
            ++i;
        }
        if (this.hasNoUsages()) {
            this.maybeNotifyZeroUsages(this);
        }
    }

    public void replaceAtUsages(Node other, InputType ... inputTypes) {
        this.checkReplaceWith(other);
        int i = 0;
        int usageCount = this.getUsageCount();
        if (usageCount == 0) {
            return;
        }
        block0: while (i < usageCount) {
            Node usage = this.getUsageAt(i);
            for (Position pos : usage.inputPositions()) {
                for (InputType type : inputTypes) {
                    if (pos.getInputType() != type || pos.get(usage) != this) continue;
                    this.replaceAtUsagePos(other, usage, pos);
                    this.movUsageFromEndTo(i);
                    --usageCount;
                    continue block0;
                }
            }
            ++i;
        }
        if (this.hasNoUsages()) {
            this.maybeNotifyZeroUsages(this);
        }
    }

    private void maybeNotifyInputChanged(Node node) {
        if (this.graph != null) {
            assert (!this.graph.isFrozen());
            Graph.NodeEventListener listener = this.graph.nodeEventListener;
            if (listener != null) {
                listener.event(Graph.NodeEvent.INPUT_CHANGED, node);
            }
        }
    }

    public void maybeNotifyZeroUsages(Node node) {
        if (this.graph != null) {
            assert (!this.graph.isFrozen());
            Graph.NodeEventListener listener = this.graph.nodeEventListener;
            if (listener != null && node.isAlive()) {
                listener.event(Graph.NodeEvent.ZERO_USAGES, node);
            }
        }
    }

    public void replaceAtPredecessor(Node other) {
        this.checkReplaceWith(other);
        if (this.predecessor != null) {
            if (!this.predecessor.getNodeClass().replaceFirstSuccessor(this.predecessor, this, other)) {
                this.fail("not found in successors, predecessor: %s", this.predecessor);
            }
            this.predecessor.updatePredecessor(this, other);
        }
    }

    public void replaceAndDelete(Node other) {
        this.checkReplaceWith(other);
        if (other == null) {
            this.fail("cannot replace with null", new Object[0]);
        }
        if (this.hasUsages()) {
            this.replaceAtUsages(other);
        }
        this.replaceAtPredecessor(other);
        this.safeDelete();
    }

    public void replaceFirstSuccessor(Node oldSuccessor, Node newSuccessor) {
        if (this.nodeClass.replaceFirstSuccessor(this, oldSuccessor, newSuccessor)) {
            this.updatePredecessor(oldSuccessor, newSuccessor);
        }
    }

    public void replaceFirstInput(Node oldInput, Node newInput) {
        if (this.nodeClass.replaceFirstInput(this, oldInput, newInput)) {
            this.updateUsages(oldInput, newInput);
        }
    }

    public void replaceAllInputs(Node oldInput, Node newInput) {
        while (this.nodeClass.replaceFirstInput(this, oldInput, newInput)) {
            this.updateUsages(oldInput, newInput);
        }
    }

    public void replaceFirstInput(Node oldInput, Node newInput, InputType type) {
        for (Position pos : this.inputPositions()) {
            if (pos.getInputType() != type || pos.get(this) != oldInput) continue;
            pos.set(this, newInput);
        }
    }

    public void clearInputs() {
        assert (this.assertFalse(this.isDeleted(), "cannot clear inputs of deleted node", new Object[0]));
        this.getNodeClass().unregisterAtInputsAsUsage(this);
    }

    boolean removeThisFromUsages(Node n) {
        return n.removeUsage(this);
    }

    public void clearSuccessors() {
        assert (this.assertFalse(this.isDeleted(), "cannot clear successors of deleted node", new Object[0]));
        this.getNodeClass().unregisterAtSuccessorsAsPredecessor(this);
    }

    private boolean checkDeletion() {
        this.assertTrue(this.isAlive(), "must be alive", new Object[0]);
        this.assertTrue(this.hasNoUsages(), "cannot delete node %s because of usages: %s", this, this.usages());
        this.assertTrue(this.predecessor == null, "cannot delete node %s because of predecessor: %s", this, this.predecessor);
        return true;
    }

    public void safeDelete() {
        assert (this.checkDeletion());
        this.clearInputs();
        this.clearSuccessors();
        this.markDeleted();
    }

    public void markDeleted() {
        this.graph.unregister(this);
        this.id = -1000000000 - this.id;
        assert (this.isDeleted());
    }

    public final Node copyWithInputs() {
        return this.copyWithInputs(true);
    }

    public final Node copyWithInputs(boolean insertIntoGraph) {
        Node newNode = this.clone(insertIntoGraph ? this.graph : null, WithOnlyInputEdges);
        if (insertIntoGraph) {
            for (Node input : this.inputs()) {
                input.addUsage(newNode);
            }
        }
        return newNode;
    }

    public void simplify(SimplifierTool tool) {
        throw new UnsupportedOperationException();
    }

    private void copyOrClearEdgesForClone(Node newNode, Edges.Type type, EnumSet<Edges.Type> edgesToCopy) {
        if (edgesToCopy.contains((Object)type)) {
            this.getNodeClass().getEdges(type).copy(this, newNode);
        } else {
            this.getNodeClass().getEdges(type).initializeLists(newNode, this);
        }
    }

    final Node clone(Graph into, EnumSet<Edges.Type> edgesToCopy) {
        NodeClass<? extends Node> nodeClassTmp = this.getNodeClass();
        boolean useIntoLeafNodeCache = false;
        if (into != null && nodeClassTmp.valueNumberable() && nodeClassTmp.isLeafNode()) {
            useIntoLeafNodeCache = true;
            Node otherNode = into.findNodeInCache(this);
            if (otherNode != null) {
                return otherNode;
            }
        }
        Node newNode = null;
        try {
            newNode = (Node)UNSAFE.allocateInstance(this.getClass());
            newNode.nodeClass = nodeClassTmp;
            nodeClassTmp.getData().copy(this, newNode);
            this.copyOrClearEdgesForClone(newNode, Edges.Type.Inputs, edgesToCopy);
            this.copyOrClearEdgesForClone(newNode, Edges.Type.Successors, edgesToCopy);
        }
        catch (Exception e) {
            throw new GraalGraphError(e).addContext(this);
        }
        newNode.graph = into;
        newNode.id = -1;
        if (this.getNodeSourcePosition() != null && (into == null || into.trackNodeSourcePosition())) {
            newNode.setNodeSourcePosition(this.getNodeSourcePosition());
        }
        if (into != null) {
            into.register(newNode);
        }
        newNode.extraUsages = NO_NODES;
        if (into != null && useIntoLeafNodeCache) {
            into.putNodeIntoCache(newNode);
        }
        newNode.afterClone(this);
        return newNode;
    }

    protected void afterClone(Node other) {
    }

    protected boolean verifyInputs() {
        for (Position pos : this.inputPositions()) {
            Node input = pos.get(this);
            if (input == null) {
                this.assertTrue(pos.isInputOptional(), "non-optional input %s cannot be null in %s (fix nullness or use @OptionalInput)", pos, this);
                continue;
            }
            this.assertFalse(input.isDeleted(), "input was deleted %s", input);
            this.assertTrue(input.isAlive(), "input is not alive yet, i.e., it was not yet added to the graph", new Object[0]);
            this.assertTrue(pos.getInputType() == InputType.Unchecked || input.isAllowedUsageType(pos.getInputType()), "invalid usage type input:%s inputType:%s inputField:%s", new Object[]{input, pos.getInputType(), pos.getName()});
            Class<?> expectedType = pos.getType();
            this.assertTrue(expectedType.isAssignableFrom(input.getClass()), "Invalid input type for %s: expected a %s but was a %s", pos, expectedType, input.getClass());
        }
        return true;
    }

    public boolean verify() {
        this.assertTrue(this.isAlive(), "cannot verify inactive nodes (id=%d)", this.id);
        this.assertTrue(this.graph() != null, "null graph", new Object[0]);
        this.verifyInputs();
        if (Graph.Options.VerifyGraalGraphEdges.getValue(this.getOptions()).booleanValue()) {
            this.verifyEdges();
        }
        return true;
    }

    public boolean verifySourcePosition() {
        return true;
    }

    public boolean verifyEdges() {
        for (Node input : this.inputs()) {
            this.assertTrue(input == null || input.usages().contains(this), "missing usage of %s in input %s", this, input);
        }
        for (Node successor : this.successors()) {
            this.assertTrue(successor.predecessor() == this, "missing predecessor in %s (actual: %s)", successor, successor.predecessor());
            this.assertTrue(successor.graph() == this.graph(), "mismatching graph in successor %s", successor);
        }
        for (Node usage : this.usages()) {
            this.assertFalse(usage.isDeleted(), "usage %s must never be deleted", usage);
            this.assertTrue(usage.inputs().contains(this), "missing input in usage %s", usage);
            boolean foundThis = false;
            for (Position pos : usage.inputPositions()) {
                if (pos.get(usage) != this) continue;
                foundThis = true;
                if (pos.getInputType() == InputType.Unchecked) continue;
                this.assertTrue(this.isAllowedUsageType(pos.getInputType()), "invalid input of type %s from %s to %s (%s)", new Object[]{pos.getInputType(), usage, this, pos.getName()});
            }
            this.assertTrue(foundThis, "missing input in usage %s", usage);
        }
        if (this.predecessor != null) {
            this.assertFalse(this.predecessor.isDeleted(), "predecessor %s must never be deleted", this.predecessor);
            this.assertTrue(this.predecessor.successors().contains(this), "missing successor in predecessor %s", this.predecessor);
        }
        return true;
    }

    public boolean assertTrue(boolean condition, String message, Object ... args) {
        if (condition) {
            return true;
        }
        throw this.fail(message, args);
    }

    public boolean assertFalse(boolean condition, String message, Object ... args) {
        if (condition) {
            throw this.fail(message, args);
        }
        return true;
    }

    protected VerificationError fail(String message, Object ... args) throws GraalGraphError {
        throw new VerificationError(message, args).addContext(this);
    }

    public Iterable<? extends Node> cfgPredecessors() {
        if (this.predecessor == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.predecessor);
    }

    public Iterable<? extends Node> cfgSuccessors() {
        return this.successors();
    }

    public final int hashCode() {
        assert (!this.isUnregistered()) : "node not yet constructed";
        if (this.isDeleted()) {
            return -this.id + -1000000000;
        }
        return this.id;
    }

    public final Map<Object, Object> getDebugProperties() {
        return this.getDebugProperties(new HashMap<Object, Object>());
    }

    public Map<Object, Object> getDebugProperties(Map<Object, Object> map) {
        NodeInsertionStackTrace insertion;
        NodeCreationStackTrace creation;
        Fields properties = this.getNodeClass().getData();
        for (int i = 0; i < properties.getCount(); ++i) {
            map.put(properties.getName(i), properties.get(this, i));
        }
        NodeSourcePosition pos = this.getNodeSourcePosition();
        if (pos != null) {
            map.put("nodeSourcePosition", pos);
        }
        if ((creation = this.getCreationPosition()) != null) {
            map.put("nodeCreationPosition", creation.getStrackTraceString());
        }
        if ((insertion = this.getInsertionPosition()) != null) {
            map.put("nodeInsertionPosition", insertion.getStrackTraceString());
        }
        return map;
    }

    public final String toString() {
        return this.toString(Verbosity.Short);
    }

    public String toString(Verbosity verbosity) {
        switch (verbosity) {
            case Id: {
                return Integer.toString(this.id);
            }
            case Name: {
                return this.getNodeClass().shortName();
            }
            case Short: {
                return this.toString(Verbosity.Id) + "|" + this.toString(Verbosity.Name);
            }
            case Long: {
                return this.toString(Verbosity.Short);
            }
            case Debugger: 
            case All: {
                StringBuilder str = new StringBuilder();
                str.append(this.toString(Verbosity.Short)).append(" { ");
                for (Map.Entry<Object, Object> entry : this.getDebugProperties().entrySet()) {
                    str.append(entry.getKey()).append("=").append(entry.getValue()).append(", ");
                }
                str.append(" }");
                return str.toString();
            }
        }
        throw new RuntimeException("unknown verbosity: " + (Object)((Object)verbosity));
    }

    @Deprecated
    public int getId() {
        return this.id;
    }

    @Override
    public void formatTo(Formatter formatter, int flags, int width, int precision) {
        int neighborsFlags;
        if ((flags & 4) == 4) {
            formatter.format("%s", this.toString(Verbosity.Id));
        } else if ((flags & 2) == 2) {
            formatter.format("%s", this.toString(Verbosity.All));
        } else {
            formatter.format("%s", this.toString(Verbosity.Short));
        }
        boolean neighborsAlternate = (flags & 1) == 1;
        int n = neighborsFlags = neighborsAlternate ? 5 : 0;
        if (width > 0) {
            if (this.predecessor != null) {
                formatter.format(" pred={", new Object[0]);
                this.predecessor.formatTo(formatter, neighborsFlags, width - 1, 0);
                formatter.format("}", new Object[0]);
            }
            for (Position position : this.inputPositions()) {
                Node input = position.get(this);
                if (input == null) continue;
                formatter.format(" ", new Object[0]);
                formatter.format(position.getName(), new Object[0]);
                formatter.format("={", new Object[0]);
                input.formatTo(formatter, neighborsFlags, width - 1, 0);
                formatter.format("}", new Object[0]);
            }
        }
        if (precision > 0) {
            if (!this.hasNoUsages()) {
                formatter.format(" usages={", new Object[0]);
                int z = 0;
                for (Node usage : this.usages()) {
                    if (z != 0) {
                        formatter.format(", ", new Object[0]);
                    }
                    usage.formatTo(formatter, neighborsFlags, 0, precision - 1);
                    ++z;
                }
                formatter.format("}", new Object[0]);
            }
            for (Position position : this.successorPositions()) {
                Node successor = position.get(this);
                if (successor == null) continue;
                formatter.format(" ", new Object[0]);
                formatter.format(position.getName(), new Object[0]);
                formatter.format("={", new Object[0]);
                successor.formatTo(formatter, neighborsFlags, 0, precision - 1);
                formatter.format("}", new Object[0]);
            }
        }
    }

    public boolean valueEquals(Node other) {
        return this.getNodeClass().dataEquals(this, other);
    }

    public boolean dataFlowEquals(Node other) {
        return this == other || this.nodeClass == other.getNodeClass() && this.valueEquals(other) && this.nodeClass.equalInputs(this, other);
    }

    public final void pushInputs(NodeStack stack) {
        this.getNodeClass().pushInputs(this, stack);
    }

    public NodeSize estimatedNodeSize() {
        return this.nodeClass.size();
    }

    public NodeCycles estimatedNodeCycles() {
        return this.nodeClass.cycles();
    }

    public static abstract class EdgeVisitor {
        public abstract Node apply(Node var1, Node var2);
    }

    public static class NodeInsertionStackTrace
    extends NodeStackTrace {
    }

    static class NodeCreationStackTrace
    extends NodeStackTrace {
        NodeCreationStackTrace() {
        }
    }

    static class NodeStackTrace {
        final StackTraceElement[] stackTrace = new Throwable().getStackTrace();

        NodeStackTrace() {
        }

        private String getString(String label) {
            StringBuilder sb = new StringBuilder();
            if (label != null) {
                sb.append(label).append(": ");
            }
            for (StackTraceElement ste : this.stackTrace) {
                sb.append("at ").append(ste.toString()).append('\n');
            }
            return sb.toString();
        }

        String getStrackTraceString() {
            return this.getString(null);
        }

        public String toString() {
            return this.getString(this.getClass().getSimpleName());
        }
    }

    public static interface IndirectCanonicalization {
    }

    public static interface ValueNumberable {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface NodeIntrinsicFactory {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface NodeIntrinsic {
        public Class<?> value() default NodeIntrinsic.class;

        public boolean injectedStampIsNonNull() default false;

        public boolean hasSideEffect() default false;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface InjectedNodeParameter {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.PARAMETER})
    public static @interface ConstantNodeParameter {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Successor {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface OptionalInput {
        public InputType value() default InputType.Value;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Input {
        public InputType value() default InputType.Value;
    }
}

