/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.TimerKey;
import org.graalvm.compiler.graph.GraalGraphError;
import org.graalvm.compiler.graph.GraphNodeIterator;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeBitMap;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeFlood;
import org.graalvm.compiler.graph.NodeIdAccessor;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.graph.NodeWorkList;
import org.graalvm.compiler.graph.TypedGraphNodeIterator;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.options.OptionValues;

public class Graph {
    public final String name;
    Node[] nodes;
    NodeSourcePosition currentNodeSourcePosition;
    protected boolean trackNodeSourcePosition;
    int nodesSize;
    private int[] nodeModCounts;
    private int[] nodeUsageModCounts;
    private final ArrayList<Node> iterableNodesFirst;
    private final ArrayList<Node> iterableNodesLast;
    private int nodesDeletedSinceLastCompression;
    private int nodesDeletedBeforeLastCompression;
    int compressions;
    NodeEventListener nodeEventListener;
    private EconomicMap<Node, Node>[] cachedLeafNodes;
    private static final Equivalence NODE_VALUE_COMPARE = new Equivalence(){

        public boolean equals(Object a, Object b) {
            if (a == b) {
                return true;
            }
            assert (a.getClass() == b.getClass());
            return ((Node)a).valueEquals((Node)b);
        }

        public int hashCode(Object k) {
            return ((Node)k).getNodeClass().valueNumber((Node)k);
        }
    };
    private FreezeState freezeState = FreezeState.Unfrozen;
    private final OptionValues options;
    private DebugContext debug;
    private static final int INITIAL_NODES_SIZE = 32;
    private AddInputsFilter addInputsFilter = new AddInputsFilter();
    private static final CounterKey GraphCompressions = DebugContext.counter("GraphCompressions");
    private static final TimerKey DuplicateGraph = DebugContext.timer("DuplicateGraph");

    public NodeSourcePosition currentNodeSourcePosition() {
        return this.currentNodeSourcePosition;
    }

    public DebugCloseable withNodeSourcePosition(Node node) {
        return this.withNodeSourcePosition(node.getNodeSourcePosition());
    }

    public DebugCloseable withNodeSourcePosition(NodeSourcePosition sourcePosition) {
        return this.trackNodeSourcePosition() && sourcePosition != null ? new NodeSourcePositionScope(sourcePosition) : null;
    }

    public DebugCloseable withoutNodeSourcePosition() {
        return new NodeSourcePositionScope(null);
    }

    public boolean trackNodeSourcePosition() {
        return this.trackNodeSourcePosition;
    }

    public void setTrackNodeSourcePosition() {
        if (!this.trackNodeSourcePosition) {
            assert (this.getNodeCount() == 1) : "can't change the value after nodes have been added";
            this.trackNodeSourcePosition = true;
        }
    }

    public static boolean trackNodeSourcePositionDefault(OptionValues options, DebugContext debug) {
        return GraalOptions.TrackNodeSourcePosition.getValue(options) != false || debug.isDumpEnabledForMethod();
    }

    public void getDebugProperties(Map<Object, Object> properties) {
        properties.put("graph", this.toString());
    }

    public void beforeNodeDuplication(Graph sourceGraph) {
    }

    public Graph(OptionValues options, DebugContext debug) {
        this(null, options, debug, false);
    }

    public static boolean isModificationCountsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }

    public Graph(String name, OptionValues options, DebugContext debug, boolean trackNodeSourcePosition) {
        this.nodes = new Node[32];
        this.iterableNodesFirst = new ArrayList(NodeClass.allocatedNodeIterabledIds());
        this.iterableNodesLast = new ArrayList(NodeClass.allocatedNodeIterabledIds());
        this.name = name;
        this.options = options;
        boolean bl = this.trackNodeSourcePosition = trackNodeSourcePosition || Graph.trackNodeSourcePositionDefault(options, debug);
        assert (debug != null);
        this.debug = debug;
        if (Graph.isModificationCountsEnabled()) {
            this.nodeModCounts = new int[32];
            this.nodeUsageModCounts = new int[32];
        }
    }

    int extractOriginalNodeId(Node node) {
        int id = node.id;
        if (id <= -1000000000) {
            id = -1000000000 - id;
        }
        return id;
    }

    int modCount(Node node) {
        int id = this.extractOriginalNodeId(node);
        if (id >= 0 && id < this.nodeModCounts.length) {
            return this.nodeModCounts[id];
        }
        return 0;
    }

    void incModCount(Node node) {
        int id = this.extractOriginalNodeId(node);
        if (id >= 0) {
            if (id >= this.nodeModCounts.length) {
                this.nodeModCounts = Arrays.copyOf(this.nodeModCounts, id * 2 + 30);
            }
            int n = id;
            this.nodeModCounts[n] = this.nodeModCounts[n] + 1;
        } else assert (false);
    }

    int usageModCount(Node node) {
        int id = this.extractOriginalNodeId(node);
        if (id >= 0 && id < this.nodeUsageModCounts.length) {
            return this.nodeUsageModCounts[id];
        }
        return 0;
    }

    void incUsageModCount(Node node) {
        int id = this.extractOriginalNodeId(node);
        if (id >= 0) {
            if (id >= this.nodeUsageModCounts.length) {
                this.nodeUsageModCounts = Arrays.copyOf(this.nodeUsageModCounts, id * 2 + 30);
            }
            int n = id;
            this.nodeUsageModCounts[n] = this.nodeUsageModCounts[n] + 1;
        } else assert (false);
    }

    public final Graph copy(DebugContext debugForCopy) {
        return this.copy(this.name, null, debugForCopy);
    }

    public final Graph copy(Consumer<UnmodifiableEconomicMap<Node, Node>> duplicationMapCallback, DebugContext debugForCopy) {
        return this.copy(this.name, duplicationMapCallback, debugForCopy);
    }

    public final Graph copy(String newName, DebugContext debugForCopy) {
        return this.copy(newName, null, debugForCopy);
    }

    protected Graph copy(String newName, Consumer<UnmodifiableEconomicMap<Node, Node>> duplicationMapCallback, DebugContext debugForCopy) {
        Graph copy = new Graph(newName, this.options, debugForCopy, this.trackNodeSourcePosition());
        UnmodifiableEconomicMap<Node, Node> duplicates = copy.addDuplicates(this.getNodes(), this, this.getNodeCount(), (EconomicMap<Node, Node>)((EconomicMap)null));
        if (duplicationMapCallback != null) {
            duplicationMapCallback.accept(duplicates);
        }
        return copy;
    }

    public final OptionValues getOptions() {
        return this.options;
    }

    public DebugContext getDebug() {
        return this.debug;
    }

    public void resetDebug(DebugContext newDebug) {
        assert (newDebug == this.debug || !this.debug.inNestedScope()) : String.format("Cannot reset the debug context for %s while it has the nested scope \"%s\" open", this, this.debug.getCurrentScopeName());
        this.debug = newDebug;
    }

    public String toString() {
        return this.name == null ? super.toString() : "Graph " + this.name;
    }

    public int getNodeCount() {
        return this.nodesSize - this.getNodesDeletedSinceLastCompression();
    }

    public int getCompressions() {
        return this.compressions;
    }

    public int getNodesDeletedSinceLastCompression() {
        return this.nodesDeletedSinceLastCompression;
    }

    public int getTotalNodesDeleted() {
        return this.nodesDeletedSinceLastCompression + this.nodesDeletedBeforeLastCompression;
    }

    public <T extends Node> T add(T node) {
        if (node.getNodeClass().valueNumberable()) {
            throw new IllegalStateException("Using add for value numberable node. Consider using either unique or addWithoutUnique.");
        }
        return this.addHelper(node);
    }

    public <T extends Node> T addWithoutUnique(T node) {
        return this.addHelper(node);
    }

    public <T extends Node> T addOrUnique(T node) {
        if (node.getNodeClass().valueNumberable()) {
            return this.uniqueHelper(node);
        }
        return this.add(node);
    }

    public <T extends Node> T maybeAddOrUnique(T node) {
        if (node.isAlive()) {
            return node;
        }
        return this.addOrUnique(node);
    }

    public <T extends Node> T addOrUniqueWithInputs(T node) {
        if (node.isAlive()) {
            assert (node.graph() == this);
            return node;
        }
        assert (node.isUnregistered());
        this.addInputs(node);
        if (node.getNodeClass().valueNumberable()) {
            return this.uniqueHelper(node);
        }
        return this.add(node);
    }

    public <T extends Node> T addWithoutUniqueWithInputs(T node) {
        this.addInputs(node);
        return this.addHelper(node);
    }

    private <T extends Node> void addInputs(T node) {
        node.applyInputs(this.addInputsFilter);
    }

    private <T extends Node> T addHelper(T node) {
        node.initialize(this);
        return node;
    }

    public NodeEventScope trackNodeEvents(NodeEventListener listener) {
        return new NodeEventScope(listener);
    }

    public <T extends Node> T unique(T node) {
        return this.uniqueHelper(node);
    }

    <T extends Node> T uniqueHelper(T node) {
        assert (node.getNodeClass().valueNumberable());
        T other = this.findDuplicate(node);
        if (other != null) {
            if (other.getNodeSourcePosition() == null) {
                other.setNodeSourcePosition(node.getNodeSourcePosition());
            }
            return other;
        }
        T result = this.addHelper(node);
        if (node.getNodeClass().isLeafNode()) {
            this.putNodeIntoCache(result);
        }
        return result;
    }

    void removeNodeFromCache(Node node) {
        assert (node.graph() == this || node.graph() == null);
        assert (node.getNodeClass().valueNumberable());
        assert (node.getNodeClass().isLeafNode()) : node.getClass();
        int leafId = node.getNodeClass().getLeafId();
        if (this.cachedLeafNodes != null && this.cachedLeafNodes.length > leafId && this.cachedLeafNodes[leafId] != null) {
            this.cachedLeafNodes[leafId].removeKey((Object)node);
        }
    }

    void putNodeIntoCache(Node node) {
        assert (node.graph() == this || node.graph() == null);
        assert (node.getNodeClass().valueNumberable());
        assert (node.getNodeClass().isLeafNode()) : node.getClass();
        int leafId = node.getNodeClass().getLeafId();
        if (this.cachedLeafNodes == null || this.cachedLeafNodes.length <= leafId) {
            EconomicMap[] newLeafNodes = new EconomicMap[leafId + 1];
            if (this.cachedLeafNodes != null) {
                System.arraycopy(this.cachedLeafNodes, 0, newLeafNodes, 0, this.cachedLeafNodes.length);
            }
            this.cachedLeafNodes = newLeafNodes;
        }
        if (this.cachedLeafNodes[leafId] == null) {
            this.cachedLeafNodes[leafId] = EconomicMap.create((Equivalence)NODE_VALUE_COMPARE);
        }
        this.cachedLeafNodes[leafId].put((Object)node, (Object)node);
    }

    Node findNodeInCache(Node node) {
        int leafId = node.getNodeClass().getLeafId();
        if (this.cachedLeafNodes == null || this.cachedLeafNodes.length <= leafId || this.cachedLeafNodes[leafId] == null) {
            return null;
        }
        Node result = (Node)this.cachedLeafNodes[leafId].get((Object)node);
        if (result != null && !result.isAlive()) {
            return null;
        }
        return result;
    }

    public <T extends Node> T findDuplicate(T node) {
        NodeClass<? extends Node> nodeClass = node.getNodeClass();
        assert (nodeClass.valueNumberable());
        if (nodeClass.isLeafNode()) {
            Node cachedNode = this.findNodeInCache(node);
            if (cachedNode != null && cachedNode != node) {
                return (T)cachedNode;
            }
            return null;
        }
        int earlyExitUsageCount = node.graph() != null ? 1 : 0;
        int minCount = Integer.MAX_VALUE;
        Node minCountNode = null;
        for (Node input : node.inputs()) {
            int usageCount = input.getUsageCount();
            if (usageCount == earlyExitUsageCount) {
                return null;
            }
            if (usageCount >= minCount) continue;
            minCount = usageCount;
            minCountNode = input;
        }
        if (minCountNode != null) {
            for (Node usage : minCountNode.usages()) {
                if (usage == node || nodeClass != usage.getNodeClass() || !node.valueEquals(usage) || !nodeClass.equalInputs(node, usage) || !nodeClass.equalSuccessors(node, usage)) continue;
                return (T)usage;
            }
            return null;
        }
        return null;
    }

    public boolean isNew(Mark mark, Node node) {
        return node.id >= mark.getValue();
    }

    public Mark getMark() {
        return new Mark(this);
    }

    public NodeIterable<Node> getNewNodes(Mark mark) {
        final int index = mark == null ? 0 : mark.getValue();
        return new NodeIterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new GraphNodeIterator(Graph.this, index);
            }
        };
    }

    public NodeIterable<Node> getNodes() {
        return new NodeIterable<Node>(){

            @Override
            public Iterator<Node> iterator() {
                return new GraphNodeIterator(Graph.this);
            }

            @Override
            public int count() {
                return Graph.this.getNodeCount();
            }
        };
    }

    protected Object beforeNodeIdChange(Node node) {
        return null;
    }

    protected void afterNodeIdChange(Node node, Object value) {
    }

    public boolean maybeCompress() {
        if (this.debug.isDumpEnabledForMethod() || this.debug.isLogEnabledForMethod()) {
            return false;
        }
        int liveNodeCount = this.getNodeCount();
        int liveNodePercent = liveNodeCount * 100 / this.nodesSize;
        int compressionThreshold = Options.GraphCompressionThreshold.getValue(this.options);
        if (compressionThreshold == 0 || liveNodePercent >= compressionThreshold) {
            return false;
        }
        GraphCompressions.increment(this.debug);
        int nextId = 0;
        int i = 0;
        while (nextId < liveNodeCount) {
            Node n = this.nodes[i];
            if (n != null) {
                assert (n.id == i);
                if (i != nextId) {
                    assert (n.id > nextId);
                    Object value = this.beforeNodeIdChange(n);
                    n.id = nextId;
                    this.afterNodeIdChange(n, value);
                    this.nodes[nextId] = n;
                    this.nodes[i] = null;
                }
                ++nextId;
            }
            ++i;
        }
        if (Graph.isModificationCountsEnabled()) {
            Arrays.fill(this.nodeModCounts, 0);
            Arrays.fill(this.nodeUsageModCounts, 0);
        }
        this.nodesSize = nextId;
        ++this.compressions;
        this.nodesDeletedBeforeLastCompression += this.nodesDeletedSinceLastCompression;
        this.nodesDeletedSinceLastCompression = 0;
        return true;
    }

    public <T extends Node> NodeIterable<T> getNodes(final NodeClass<T> nodeClass) {
        return new NodeIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new TypedGraphNodeIterator(nodeClass, Graph.this);
            }
        };
    }

    public <T extends Node> boolean hasNode(NodeClass<T> type) {
        return this.getNodes(type).iterator().hasNext();
    }

    Node getIterableNodeStart(int iterableId) {
        if (this.iterableNodesFirst.size() <= iterableId) {
            return null;
        }
        Node start = this.iterableNodesFirst.get(iterableId);
        if (start == null || !start.isDeleted()) {
            return start;
        }
        return this.findFirstLiveIterable(iterableId, start);
    }

    private Node findFirstLiveIterable(int iterableId, Node node) {
        Node start = node;
        while (start != null && start.isDeleted()) {
            start = start.typeCacheNext;
        }
        this.iterableNodesFirst.set(iterableId, start);
        if (start == null) {
            this.iterableNodesLast.set(iterableId, start);
        }
        return start;
    }

    Node getIterableNodeNext(Node node) {
        if (node == null) {
            return null;
        }
        Node n = node;
        if (n == null || !n.isDeleted()) {
            return n;
        }
        return this.findNextLiveiterable(node);
    }

    private Node findNextLiveiterable(Node start) {
        Node n = start;
        while (n != null && n.isDeleted()) {
            n = n.typeCacheNext;
        }
        if (n == null) {
            start.typeCacheNext = null;
            int nodeClassId = start.getNodeClass().iterableId();
            assert (nodeClassId != -1);
            this.iterableNodesLast.set(nodeClassId, start);
        } else {
            start.typeCacheNext = n;
        }
        return n;
    }

    public NodeBitMap createNodeBitMap() {
        return new NodeBitMap(this);
    }

    public <T> NodeMap<T> createNodeMap() {
        return new NodeMap(this);
    }

    public NodeFlood createNodeFlood() {
        return new NodeFlood(this);
    }

    public NodeWorkList createNodeWorkList() {
        return new NodeWorkList.SingletonNodeWorkList(this);
    }

    public NodeWorkList createIterativeNodeWorkList(boolean fill, int iterationLimitPerNode) {
        return new NodeWorkList.IterativeNodeWorkList(this, fill, iterationLimitPerNode);
    }

    void register(Node node) {
        assert (!this.isFrozen());
        assert (node.id() == -1);
        if (this.nodes.length == this.nodesSize) {
            this.grow();
        }
        int id = this.nodesSize++;
        this.nodes[id] = node;
        node.id = id;
        if (this.currentNodeSourcePosition != null && this.trackNodeSourcePosition()) {
            node.setNodeSourcePosition(this.currentNodeSourcePosition);
        }
        if (GraalOptions.TrackNodeInsertion.getValue(this.getOptions()).booleanValue()) {
            node.setInsertionPosition(new Node.NodeInsertionStackTrace());
        }
        this.updateNodeCaches(node);
        if (this.nodeEventListener != null) {
            this.nodeEventListener.event(NodeEvent.NODE_ADDED, node);
        }
        this.afterRegister(node);
    }

    private void grow() {
        Node[] newNodes = new Node[this.nodesSize * 2 + 1];
        System.arraycopy(this.nodes, 0, newNodes, 0, this.nodesSize);
        this.nodes = newNodes;
    }

    protected void afterRegister(Node node) {
    }

    private void postDeserialization() {
        this.recomputeIterableNodeLists();
    }

    private void recomputeIterableNodeLists() {
        this.iterableNodesFirst.clear();
        this.iterableNodesLast.clear();
        for (Node node : this.nodes) {
            if (node == null || !node.isAlive()) continue;
            this.updateNodeCaches(node);
        }
    }

    private void updateNodeCaches(Node node) {
        int nodeClassId = node.getNodeClass().iterableId();
        if (nodeClassId != -1) {
            while (this.iterableNodesFirst.size() <= nodeClassId) {
                this.iterableNodesFirst.add(null);
                this.iterableNodesLast.add(null);
            }
            Node prev = this.iterableNodesLast.get(nodeClassId);
            if (prev != null) {
                prev.typeCacheNext = node;
            } else {
                this.iterableNodesFirst.set(nodeClassId, node);
            }
            this.iterableNodesLast.set(nodeClassId, node);
        }
    }

    void unregister(Node node) {
        assert (!this.isFrozen());
        assert (!node.isDeleted()) : node;
        if (node.getNodeClass().isLeafNode() && node.getNodeClass().valueNumberable()) {
            this.removeNodeFromCache(node);
        }
        this.nodes[node.id] = null;
        ++this.nodesDeletedSinceLastCompression;
        if (this.nodeEventListener != null) {
            this.nodeEventListener.event(NodeEvent.NODE_REMOVED, node);
        }
    }

    public boolean verify() {
        if (Options.VerifyGraalGraphs.getValue(this.options).booleanValue()) {
            for (Node node : this.getNodes()) {
                try {
                    try {
                        assert (node.verify());
                    }
                    catch (AssertionError t) {
                        throw new GraalError((Throwable)((Object)t));
                    }
                    catch (RuntimeException t) {
                        throw new GraalError(t);
                    }
                }
                catch (GraalError e) {
                    throw GraalGraphError.transformAndAddContext(e, node).addContext(this);
                }
            }
        }
        return true;
    }

    public boolean verifySourcePositions(boolean performConsistencyCheck) {
        if (this.trackNodeSourcePosition()) {
            ResolvedJavaMethod root = null;
            for (Node node : this.getNodes()) {
                NodeSourcePosition pos = node.getNodeSourcePosition();
                if (pos != null) {
                    if (root == null) {
                        root = pos.getRootMethod();
                    } else assert (pos.verifyRootMethod(root)) : node;
                }
                if (!performConsistencyCheck) continue;
            }
        }
        return true;
    }

    public Node getNode(int id) {
        return this.nodes[id];
    }

    public int nodeIdCount() {
        return this.nodesSize;
    }

    public UnmodifiableEconomicMap<Node, Node> addDuplicates(Iterable<? extends Node> newNodes, Graph oldGraph, int estimatedNodeCount, EconomicMap<Node, Node> replacementsMap) {
        MapReplacement replacements = replacementsMap == null ? null : new MapReplacement(replacementsMap);
        return this.addDuplicates(newNodes, oldGraph, estimatedNodeCount, replacements);
    }

    public EconomicMap<Node, Node> addDuplicates(Iterable<? extends Node> newNodes, Graph oldGraph, int estimatedNodeCount, DuplicationReplacement replacements) {
        try (DebugCloseable s = DuplicateGraph.start(this.getDebug());){
            EconomicMap<Node, Node> economicMap = NodeClass.addGraphDuplicate(this, oldGraph, estimatedNodeCount, newNodes, replacements);
            return economicMap;
        }
    }

    public boolean isFrozen() {
        return this.freezeState != FreezeState.Unfrozen;
    }

    public void freeze() {
        this.freezeState = FreezeState.DeepFreeze;
    }

    public void temporaryFreeze() {
        if (this.freezeState == FreezeState.DeepFreeze) {
            throw new GraalError("Graph was permanetly frozen.");
        }
        this.freezeState = FreezeState.TemporaryFreeze;
    }

    public void unfreeze() {
        if (this.freezeState == FreezeState.DeepFreeze) {
            throw new GraalError("Graph was permanetly frozen.");
        }
        this.freezeState = FreezeState.Unfrozen;
    }

    private static final class MapReplacement
    implements DuplicationReplacement {
        private final EconomicMap<Node, Node> map;

        MapReplacement(EconomicMap<Node, Node> map) {
            this.map = map;
        }

        @Override
        public Node replacement(Node original) {
            Node replacement = (Node)this.map.get((Object)original);
            return replacement != null ? replacement : original;
        }
    }

    public static interface DuplicationReplacement {
        public Node replacement(Node var1);
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
    static final class PlaceHolderNode
    extends Node {
        public static final NodeClass<PlaceHolderNode> TYPE = NodeClass.create(PlaceHolderNode.class);

        protected PlaceHolderNode() {
            super(TYPE);
        }
    }

    public static class Mark
    extends NodeIdAccessor {
        private final int value;

        Mark(Graph graph) {
            super(graph);
            this.value = graph.nodeIdCount();
        }

        public boolean equals(Object obj) {
            if (obj instanceof Mark) {
                Mark other = (Mark)obj;
                return other.getValue() == this.getValue() && other.getGraph() == this.getGraph();
            }
            return false;
        }

        public int hashCode() {
            return this.value ^ this.epoch + 11;
        }

        public boolean isStart() {
            return this.value == 0;
        }

        int getValue() {
            return this.value;
        }

        public boolean isCurrent() {
            return this.value == this.graph.nodeIdCount();
        }
    }

    private static class ChainedNodeEventListener
    extends NodeEventListener {
        NodeEventListener head;
        NodeEventListener next;

        ChainedNodeEventListener(NodeEventListener head, NodeEventListener next) {
            this.head = head;
            this.next = next;
        }

        @Override
        public void changed(NodeEvent e, Node node) {
            this.head.event(e, node);
            this.next.event(e, node);
        }
    }

    public final class NodeEventScope
    implements AutoCloseable {
        NodeEventScope(NodeEventListener listener) {
            Graph.this.nodeEventListener = Graph.this.nodeEventListener == null ? listener : new ChainedNodeEventListener(listener, Graph.this.nodeEventListener);
        }

        @Override
        public void close() {
            assert (Graph.this.nodeEventListener != null);
            Graph.this.nodeEventListener = Graph.this.nodeEventListener instanceof ChainedNodeEventListener ? ((ChainedNodeEventListener)Graph.this.nodeEventListener).next : null;
        }
    }

    public static abstract class NodeEventListener {
        final void event(NodeEvent e, Node node) {
            switch (e) {
                case INPUT_CHANGED: {
                    this.inputChanged(node);
                    break;
                }
                case ZERO_USAGES: {
                    this.usagesDroppedToZero(node);
                    break;
                }
                case NODE_ADDED: {
                    this.nodeAdded(node);
                    break;
                }
                case NODE_REMOVED: {
                    this.nodeRemoved(node);
                }
            }
            this.changed(e, node);
        }

        public void changed(NodeEvent e, Node node) {
        }

        public void inputChanged(Node node) {
        }

        public void usagesDroppedToZero(Node node) {
        }

        public void nodeAdded(Node node) {
        }

        public void nodeRemoved(Node node) {
        }
    }

    public static enum NodeEvent {
        INPUT_CHANGED,
        ZERO_USAGES,
        NODE_ADDED,
        NODE_REMOVED;

    }

    private final class AddInputsFilter
    extends Node.EdgeVisitor {
        private AddInputsFilter() {
        }

        @Override
        public Node apply(Node self, Node input) {
            if (!input.isAlive()) {
                assert (!input.isDeleted());
                return Graph.this.addOrUniqueWithInputs(input);
            }
            return input;
        }
    }

    private class NodeSourcePositionScope
    implements DebugCloseable {
        private final NodeSourcePosition previous;

        NodeSourcePositionScope(NodeSourcePosition sourcePosition) {
            this.previous = Graph.this.currentNodeSourcePosition;
            Graph.this.currentNodeSourcePosition = sourcePosition;
        }

        @Override
        public DebugContext getDebug() {
            return Graph.this.debug;
        }

        @Override
        public void close() {
            Graph.this.currentNodeSourcePosition = this.previous;
        }
    }

    private static enum FreezeState {
        Unfrozen,
        TemporaryFreeze,
        DeepFreeze;

    }

    public static class Options {
        @Option(help={"Verify graphs often during compilation when assertions are turned on"}, type=OptionType.Debug)
        public static final OptionKey<Boolean> VerifyGraalGraphs = new OptionKey<Boolean>(true);
        @Option(help={"Perform expensive verification of graph inputs, usages, successors and predecessors"}, type=OptionType.Debug)
        public static final OptionKey<Boolean> VerifyGraalGraphEdges = new OptionKey<Boolean>(false);
        @Option(help={"Graal graph compression is performed when percent of live nodes falls below this value"}, type=OptionType.Debug)
        public static final OptionKey<Integer> GraphCompressionThreshold = new OptionKey<Integer>(70);
    }
}

