/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public class LogStream {
    public static final LogStream SINK = new LogStream();
    private static final PrintStream SINK_PS = new PrintStream(new OutputStream(){

        @Override
        public void write(int b) throws IOException {
        }
    });
    private final Consumer<? super String> consumer;
    private final StringBuilder lineBuffer;
    private int indentationLevel;
    private char indentation = (char)32;
    private boolean indentationDisabled;
    public static final String LINE_SEPARATOR = System.lineSeparator();

    private LogStream() {
        this.consumer = null;
        this.lineBuffer = null;
    }

    public final PrintStream out() {
        if (this.consumer == null) {
            return SINK_PS;
        }
        if (this.consumer instanceof PrintStreamConsumer) {
            return ((PrintStreamConsumer)this.consumer).printStream;
        }
        return ((ForwardingConsumer)this.consumer).getPrintStream();
    }

    public LogStream(OutputStream os) {
        this.consumer = new PrintStreamConsumer(os instanceof PrintStream ? (PrintStream)os : new PrintStream(os));
        this.lineBuffer = new StringBuilder(100);
    }

    public LogStream(Consumer<? super String> sink) {
        this.consumer = new ForwardingConsumer(this, sink);
        this.lineBuffer = new StringBuilder(100);
    }

    public LogStream(LogStream log) {
        this.consumer = log.consumer;
        this.lineBuffer = new StringBuilder(100);
    }

    private void indent() {
        if (this.consumer != null && !this.indentationDisabled && this.indentationLevel != 0) {
            while (this.lineBuffer.length() < this.indentationLevel) {
                this.lineBuffer.append(this.indentation);
            }
        }
    }

    private LogStream flushLine(boolean withNewline) {
        if (this.consumer != null) {
            if (withNewline) {
                this.lineBuffer.append(LINE_SEPARATOR);
            }
            this.consumer.accept(this.lineBuffer.toString());
            this.lineBuffer.setLength(0);
        }
        return this;
    }

    public void flush() {
        if (this.consumer != null) {
            this.flushLine(false);
        }
    }

    public int position() {
        return this.lineBuffer == null ? 0 : this.lineBuffer.length();
    }

    public int indentationLevel() {
        return this.indentationLevel;
    }

    public void adjustIndentation(int delta) {
        this.indentationLevel = delta < 0 ? Math.max(0, this.indentationLevel + delta) : (this.indentationLevel += delta);
    }

    public char indentation() {
        return this.indentation;
    }

    public void disableIndentation() {
        this.indentationDisabled = true;
    }

    public void enableIndentation() {
        this.indentationDisabled = false;
    }

    public void setIndentation(char c) {
        this.indentation = c;
    }

    public LogStream fillTo(int position, char filler) {
        if (this.consumer != null) {
            this.indent();
            while (this.lineBuffer.length() < position) {
                this.lineBuffer.append(filler);
            }
        }
        return this;
    }

    public LogStream print(boolean b) {
        if (this.consumer != null) {
            this.indent();
            this.lineBuffer.append(b);
        }
        return this;
    }

    public LogStream println(boolean b) {
        if (this.consumer != null) {
            this.indent();
            this.lineBuffer.append(b);
            return this.flushLine(true);
        }
        return this;
    }

    public LogStream print(char c) {
        if (this.consumer != null) {
            this.indent();
            this.lineBuffer.append(c);
            if (c == '\n' && this.lineBuffer.indexOf(LINE_SEPARATOR, this.lineBuffer.length() - LINE_SEPARATOR.length()) != -1) {
                this.flushLine(false);
            }
        }
        return this;
    }

    public LogStream println(char c) {
        if (this.consumer != null) {
            this.indent();
            this.lineBuffer.append(c);
            this.flushLine(true);
        }
        return this;
    }

    public LogStream print(int i) {
        if (this.consumer != null) {
            this.indent();
            this.lineBuffer.append(i);
        }
        return this;
    }

    public LogStream println(int i) {
        if (this.consumer != null) {
            this.indent();
            this.lineBuffer.append(i);
            return this.flushLine(true);
        }
        return this;
    }

    public LogStream print(float f) {
        if (this.consumer != null) {
            this.indent();
            this.lineBuffer.append(f);
        }
        return this;
    }

    public LogStream println(float f) {
        if (this.consumer != null) {
            this.indent();
            this.lineBuffer.append(f);
            return this.flushLine(true);
        }
        return this;
    }

    public LogStream print(long l) {
        if (this.consumer != null) {
            this.indent();
            this.lineBuffer.append(l);
        }
        return this;
    }

    public LogStream println(long l) {
        if (this.consumer != null) {
            this.indent();
            this.lineBuffer.append(l);
            return this.flushLine(true);
        }
        return this;
    }

    public LogStream print(double d) {
        if (this.consumer != null) {
            this.indent();
            this.lineBuffer.append(d);
        }
        return this;
    }

    public LogStream println(double d) {
        if (this.consumer != null) {
            this.indent();
            this.lineBuffer.append(d);
            return this.flushLine(true);
        }
        return this;
    }

    public LogStream print(String s) {
        if (this.consumer != null) {
            if (s == null) {
                this.indent();
                this.lineBuffer.append(s);
                return this;
            }
            int index = 0;
            int next = s.indexOf(LINE_SEPARATOR, index);
            while (index < s.length()) {
                this.indent();
                if (next > index || next == 0) {
                    this.lineBuffer.append(s.substring(index, next));
                    this.flushLine(true);
                    index = next + LINE_SEPARATOR.length();
                    next = s.indexOf(LINE_SEPARATOR, index);
                    continue;
                }
                this.lineBuffer.append(s.substring(index));
                break;
            }
        }
        return this;
    }

    public LogStream println(String s) {
        if (this.consumer != null) {
            this.print(s);
            this.flushLine(true);
        }
        return this;
    }

    public LogStream printf(String format, Object ... args) {
        if (this.consumer != null) {
            this.print(String.format(format, args));
        }
        return this;
    }

    public LogStream println() {
        if (this.consumer != null) {
            this.indent();
            this.flushLine(true);
        }
        return this;
    }

    private static final class ForwardingConsumer
    implements Consumer<String> {
        private final LogStream owner;
        private final Consumer<? super String> delegate;
        private final AtomicReference<PrintStream> printStreamRef;

        ForwardingConsumer(LogStream owner, Consumer<? super String> delegate) {
            this.owner = Objects.requireNonNull(owner, "Owner must be non null.");
            this.delegate = Objects.requireNonNull(delegate, "Delegate must be non null.");
            this.printStreamRef = new AtomicReference();
        }

        @Override
        public void accept(String t) {
            this.delegate.accept(t);
        }

        PrintStream getPrintStream() {
            PrintStream res = this.printStreamRef.get();
            if (res == null && !this.printStreamRef.compareAndSet(null, res = new DelegatingPrintStream(this.owner))) {
                res = this.printStreamRef.get();
            }
            assert (res != null) : "PrintStream must exist";
            return res;
        }

        private static final class DelegatingPrintStream
        extends PrintStream {
            private final LogStream owner;

            DelegatingPrintStream(LogStream owner) {
                super(new OutputStream(){

                    @Override
                    public void write(int b) throws IOException {
                        throw new IllegalStateException("Should not reach here.");
                    }
                });
                this.owner = owner;
            }

            @Override
            public PrintStream append(CharSequence csq, int start, int end) {
                this.owner.print(csq == null ? "null" : csq.subSequence(start, end).toString());
                return this;
            }

            @Override
            public void print(Object obj) {
                this.print(String.valueOf(obj));
            }

            @Override
            public void print(String s) {
                this.owner.print(s);
            }

            @Override
            public void print(char[] s) {
                for (int i = 0; i < s.length; ++i) {
                    this.owner.print(s[i]);
                }
            }

            @Override
            public void print(double d) {
                this.owner.print(d);
            }

            @Override
            public void print(float f) {
                this.owner.print(f);
            }

            @Override
            public void print(long l) {
                this.owner.print(l);
            }

            @Override
            public void print(int i) {
                this.owner.print(i);
            }

            @Override
            public void print(char c) {
                this.owner.print(c);
            }

            @Override
            public void print(boolean b) {
                this.owner.print(b);
            }

            @Override
            public void println(char[] s) {
                this.print(s);
                this.owner.println();
            }

            @Override
            public void println(char c) {
                this.print(c);
                this.owner.println();
            }

            @Override
            public void println(Object o) {
                this.print(o);
                this.owner.println();
            }

            @Override
            public void println(String s) {
                this.print(s);
                this.owner.println();
            }

            @Override
            public void println(double s) {
                this.print(s);
                this.owner.println();
            }

            @Override
            public void println(float f) {
                this.print(f);
                this.owner.println();
            }

            @Override
            public void println(long l) {
                this.print(l);
                this.owner.println();
            }

            @Override
            public void println(int i) {
                this.print(i);
                this.owner.println();
            }

            @Override
            public void println(boolean b) {
                this.print(b);
                this.owner.println();
            }

            @Override
            public void println() {
                this.owner.println();
            }

            @Override
            public void write(byte[] buf, int off, int len) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void write(int b) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void flush() {
                this.owner.flush();
            }
        }
    }

    private static final class PrintStreamConsumer
    implements Consumer<String> {
        private final PrintStream printStream;

        PrintStreamConsumer(PrintStream printStream) {
            this.printStream = Objects.requireNonNull(printStream, "PrintStream must be non null.");
        }

        @Override
        public void accept(String t) {
            this.printStream.print(t);
            this.printStream.flush();
        }
    }
}

