/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.util;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.util.List;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.debug.TTY;

public class Util {
    public static <T> T uncheckedCast(Class<T> type, Object object) {
        return (T)object;
    }

    public static <T> T uncheckedCast(Object object) {
        return (T)object;
    }

    public static <T> void atPutGrow(List<T> list, int pos, T x, T filler) {
        if (list.size() < pos + 1) {
            while (list.size() < pos + 1) {
                list.add(filler);
            }
            assert (list.size() == pos + 1);
        }
        assert (list.size() >= pos + 1);
        list.set(pos, x);
    }

    public static String indent(String lines, String indentation) {
        if (lines.length() == 0) {
            return lines;
        }
        String newLine = "\n";
        if (lines.endsWith("\n")) {
            return indentation + lines.substring(0, lines.length() - 1).replace("\n", "\n" + indentation) + "\n";
        }
        return indentation + lines.replace("\n", "\n" + indentation);
    }

    public static JavaConstant zero(JavaKind kind) {
        switch (kind) {
            case Boolean: {
                return JavaConstant.FALSE;
            }
            case Byte: {
                return JavaConstant.forByte((byte)0);
            }
            case Char: {
                return JavaConstant.forChar((char)'\u0000');
            }
            case Double: {
                return JavaConstant.DOUBLE_0;
            }
            case Float: {
                return JavaConstant.FLOAT_0;
            }
            case Int: {
                return JavaConstant.INT_0;
            }
            case Long: {
                return JavaConstant.LONG_0;
            }
            case Short: {
                return JavaConstant.forShort((short)0);
            }
        }
        throw new IllegalArgumentException(kind.toString());
    }

    public static JavaConstant one(JavaKind kind) {
        switch (kind) {
            case Boolean: {
                return JavaConstant.TRUE;
            }
            case Byte: {
                return JavaConstant.forByte((byte)1);
            }
            case Char: {
                return JavaConstant.forChar((char)'\u0001');
            }
            case Double: {
                return JavaConstant.DOUBLE_1;
            }
            case Float: {
                return JavaConstant.FLOAT_1;
            }
            case Int: {
                return JavaConstant.INT_1;
            }
            case Long: {
                return JavaConstant.LONG_1;
            }
            case Short: {
                return JavaConstant.forShort((short)1);
            }
        }
        throw new IllegalArgumentException(kind.toString());
    }

    public static void printInlining(ResolvedJavaMethod method, int bci, int inliningDepth, boolean success, String msg, Object ... args) {
        StringBuilder sb = new StringBuilder();
        sb.append("        ");
        sb.append("     ");
        sb.append(String.format("%c%c%c%c%c ", Character.valueOf(' '), Character.valueOf(method.isSynchronized() ? (char)'s' : ' '), Character.valueOf(' '), Character.valueOf(' '), Character.valueOf(method.isNative() ? (char)'n' : ' ')));
        sb.append("     ");
        sb.append("    ");
        for (int i = 0; i < inliningDepth; ++i) {
            sb.append("  ");
        }
        sb.append(String.format("@ %d  %s   %s%s", bci, Util.methodName(method), success ? "" : "not inlining ", String.format(msg, args)));
        TTY.println(sb.toString());
    }

    private static String methodName(ResolvedJavaMethod method) {
        return method.format("%H.%n(%p):%r") + " (" + method.getCodeSize() + " bytes)";
    }

    public static void setAccessible(Field field, boolean flag) {
        field.setAccessible(flag);
    }

    public static void setAccessible(Executable executable, boolean flag) {
        executable.setAccessible(flag);
    }
}

