/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.core.common.alloc;

import java.util.ArrayList;
import org.graalvm.compiler.core.common.alloc.Trace;
import org.graalvm.compiler.core.common.alloc.TraceBuilderResult;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;

public final class TraceStatisticsPrinter {
    private static final String SEP = ";";

    public static void printTraceStatistics(DebugContext debug, TraceBuilderResult result, String compilationUnitName) {
        try (DebugContext.Scope s = debug.scope("DumpTraceStatistics");){
            if (debug.isLogEnabled(3)) {
                TraceStatisticsPrinter.print(debug, result, compilationUnitName);
            }
        }
        catch (Throwable e) {
            debug.handle(e);
        }
    }

    protected static void print(DebugContext debug, TraceBuilderResult result, String compilationUnitName) {
        ArrayList<Trace> traces = result.getTraces();
        int numTraces = traces.size();
        try (Indent indent0 = debug.logAndIndent(3, "<tracestatistics>");){
            debug.log(3, "<name>%s</name>", (Object)(compilationUnitName != null ? compilationUnitName : "null"));
            try (Indent indent1 = debug.logAndIndent(3, "<traces>");){
                TraceStatisticsPrinter.printRawLine(debug, "tracenumber", "total", "min", "max", "numBlocks");
                for (int i = 0; i < numTraces; ++i) {
                    AbstractBlockBase<?>[] t = ((Trace)traces.get(i)).getBlocks();
                    double total = 0.0;
                    double max = Double.NEGATIVE_INFINITY;
                    double min = Double.POSITIVE_INFINITY;
                    for (AbstractBlockBase<?> block : t) {
                        double frequency = block.getRelativeFrequency();
                        total += frequency;
                        if (frequency < min) {
                            min = frequency;
                        }
                        if (!(frequency > max)) continue;
                        max = frequency;
                    }
                    TraceStatisticsPrinter.printLine(debug, i, total, min, max, t.length);
                }
            }
            debug.log(3, "</traces>");
        }
        debug.log(3, "</tracestatistics>");
    }

    private static void printRawLine(DebugContext debug, Object tracenr, Object totalTime, Object minProb, Object maxProb, Object numBlocks) {
        debug.log(3, "%s", (Object)String.join((CharSequence)SEP, tracenr.toString(), totalTime.toString(), minProb.toString(), maxProb.toString(), numBlocks.toString()));
    }

    private static void printLine(DebugContext debug, int tracenr, double totalTime, double minProb, double maxProb, int numBlocks) {
        TraceStatisticsPrinter.printRawLine(debug, tracenr, totalTime, minProb, maxProb, numBlocks);
    }
}

