/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.bytecode;

import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ExceptionHandler;
import jdk.vm.ci.meta.LineNumberTable;
import jdk.vm.ci.meta.LocalVariableTable;
import jdk.vm.ci.meta.ProfilingInfo;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.bytecode.BytecodeProvider;

public interface Bytecode {
    public ResolvedJavaMethod getMethod();

    public byte[] getCode();

    public int getCodeSize();

    public int getMaxStackSize();

    public int getMaxLocals();

    public ConstantPool getConstantPool();

    public LineNumberTable getLineNumberTable();

    public LocalVariableTable getLocalVariableTable();

    public StackTraceElement asStackTraceElement(int var1);

    public ProfilingInfo getProfilingInfo();

    public ExceptionHandler[] getExceptionHandlers();

    public BytecodeProvider getOrigin();

    public static String toLocation(Bytecode bytecode, int bci) {
        return Bytecode.appendLocation(new StringBuilder(), bytecode, bci).toString();
    }

    public static StringBuilder appendLocation(StringBuilder sb, Bytecode bytecode, int bci) {
        if (bytecode != null) {
            StackTraceElement ste = bytecode.asStackTraceElement(bci);
            if (ste.getFileName() != null && ste.getLineNumber() > 0) {
                sb.append(ste);
            } else {
                sb.append(bytecode.getMethod().format("%H.%n(%p)"));
            }
        } else {
            sb.append("Null method");
        }
        return sb.append(" [bci: ").append(bci).append(']');
    }
}

