/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.asm.amd64;

import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.debug.GraalError;

public final class AVXKind {
    private AVXKind() {
    }

    public static AVXSize getRegisterSize(Value a) {
        AMD64Kind kind = (AMD64Kind)a.getPlatformKind();
        if (kind.isXMM()) {
            return AVXKind.getRegisterSize(kind);
        }
        return AVXSize.XMM;
    }

    public static AVXSize getDataSize(AMD64Kind kind) {
        assert (kind.isXMM()) : "unexpected kind " + kind;
        switch (kind.getSizeInBytes()) {
            case 4: {
                return AVXSize.DWORD;
            }
            case 8: {
                return AVXSize.QWORD;
            }
            case 16: {
                return AVXSize.XMM;
            }
            case 32: {
                return AVXSize.YMM;
            }
            case 64: {
                return AVXSize.ZMM;
            }
        }
        throw GraalError.shouldNotReachHere("unsupported kind: " + kind);
    }

    public static AVXSize getRegisterSize(AMD64Kind kind) {
        assert (kind.isXMM()) : "unexpected kind " + kind;
        int size = kind.getSizeInBytes();
        if (size > 32) {
            return AVXSize.ZMM;
        }
        if (size > 16) {
            return AVXSize.YMM;
        }
        return AVXSize.XMM;
    }

    public static AMD64Kind changeSize(AMD64Kind kind, AVXSize newSize) {
        return AVXKind.getAVXKind(kind.getScalar(), newSize);
    }

    public static AMD64Kind getMaskKind(AMD64Kind kind) {
        switch (kind.getScalar()) {
            case SINGLE: {
                return AVXKind.getAVXKind(AMD64Kind.DWORD, kind.getVectorLength());
            }
            case DOUBLE: {
                return AVXKind.getAVXKind(AMD64Kind.QWORD, kind.getVectorLength());
            }
        }
        return kind;
    }

    public static AMD64Kind getAVXKind(AMD64Kind base, AVXSize size) {
        for (AMD64Kind ret : AMD64Kind.values()) {
            if (ret.getScalar() != base || ret.getSizeInBytes() != size.getBytes()) continue;
            return ret;
        }
        throw GraalError.shouldNotReachHere(String.format("unsupported vector kind: %s x %s", new Object[]{size, base}));
    }

    public static AMD64Kind getAVXKind(AMD64Kind base, int length) {
        for (AMD64Kind ret : AMD64Kind.values()) {
            if (ret.getScalar() != base || ret.getVectorLength() != length) continue;
            return ret;
        }
        throw GraalError.shouldNotReachHere(String.format("unsupported vector kind: %d x %s", length, base));
    }

    public static enum AVXSize {
        DWORD,
        QWORD,
        XMM,
        YMM,
        ZMM;


        public int getBytes() {
            switch (this) {
                case DWORD: {
                    return 4;
                }
                case QWORD: {
                    return 8;
                }
                case XMM: {
                    return 16;
                }
                case YMM: {
                    return 32;
                }
                case ZMM: {
                    return 64;
                }
            }
            return 0;
        }
    }
}

